/*
  Copyright @ 2000 ImageMagick Studio LLC, a non-profit organization
  dedicated to making software imaging solutions freely available.

  You may not use this file except in compliance with the License.  You may
  obtain a copy of the License at

    https://imagemagick.org/script/license.php

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  MagickCore static coder registration methods.
*/
#ifndef MAGICKCORE_STATIC_H
#define MAGICKCORE_STATIC_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern MagickExport MagickBooleanType
  InvokeStaticImageFilter(const char *,Image **,const int,const char **,
    ExceptionInfo *),
  RegisterStaticModule(const char *,ExceptionInfo *exception),
  UnregisterStaticModule(const char *);

extern MagickExport void
  RegisterStaticModules(void),
  UnregisterStaticModules(void);

extern ModuleExport size_t
  RegisterAAIImage(void),
  RegisterARTImage(void),
  RegisterASHLARImage(void),
  RegisterAVSImage(void),
  RegisterBGRImage(void),
  RegisterBMPImage(void),
  RegisterBRAILLEImage(void),
  RegisterCALSImage(void),
  RegisterCAPTIONImage(void),
  RegisterCINImage(void),
  RegisterCIPImage(void),
  RegisterCLIPImage(void),
  RegisterCLIPBOARDImage(void),
  RegisterCMYKImage(void),
  RegisterCUBEImage(void),
  RegisterCUTImage(void),
  RegisterDCMImage(void),
  RegisterDDSImage(void),
  RegisterDEBUGImage(void),
  RegisterDIBImage(void),
  RegisterDJVUImage(void),
  RegisterDNGImage(void),
  RegisterDPSImage(void),
  RegisterDPXImage(void),
  RegisterEMFImage(void),
  RegisterEPTImage(void),
  RegisterEXRImage(void),
  RegisterFARBFELDImage(void),
  RegisterFAXImage(void),
  RegisterFITSImage(void),
  RegisterFL32Image(void),
  RegisterFLIFImage(void),
  RegisterFPXImage(void),
  RegisterFTXTImage(void),
  RegisterGIFImage(void),
  RegisterGRADIENTImage(void),
  RegisterGRAYImage(void),
  RegisterHALDImage(void),
  RegisterHDRImage(void),
  RegisterHEICImage(void),
  RegisterHISTOGRAMImage(void),
  RegisterHRZImage(void),
  RegisterHTMLImage(void),
  RegisterICONImage(void),
  RegisterINFOImage(void),
  RegisterINLINEImage(void),
  RegisterIPLImage(void),
  RegisterJBIGImage(void),
  RegisterJNXImage(void),
  RegisterJPEGImage(void),
  RegisterJSONImage(void),
  RegisterJP2Image(void),
  RegisterJXLImage(void),
  RegisterLABELImage(void),
  RegisterMACImage(void),
  RegisterMAGICKImage(void),
  RegisterMAPImage(void),
  RegisterMASKImage(void),
  RegisterMATImage(void),
  RegisterMATTEImage(void),
  RegisterMETAImage(void),
  RegisterMIFFImage(void),
  RegisterMONOImage(void),
  RegisterMPCImage(void),
  RegisterMPRImage(void),
  RegisterMSLImage(void),
  RegisterMTVImage(void),
  RegisterMVGImage(void),
  RegisterNULLImage(void),
  RegisterORAImage(void),
  RegisterOTBImage(void),
  RegisterPALMImage(void),
  RegisterPANGOImage(void),
  RegisterPATTERNImage(void),
  RegisterPCDImage(void),
  RegisterPCLImage(void),
  RegisterPCXImage(void),
  RegisterPDBImage(void),
  RegisterPDFImage(void),
  RegisterPESImage(void),
  RegisterPGXImage(void),
  RegisterPICTImage(void),
  RegisterPIXImage(void),
  RegisterPLASMAImage(void),
  RegisterPNGImage(void),
  RegisterPNMImage(void),
  RegisterPSImage(void),
  RegisterPS2Image(void),
  RegisterPS3Image(void),
  RegisterPSDImage(void),
  RegisterPWPImage(void),
  RegisterQOIImage(void),
  RegisterRAWImage(void),
  RegisterRGBImage(void),
  RegisterRGFImage(void),
  RegisterRLAImage(void),
  RegisterRLEImage(void),
  RegisterSCRImage(void),
  RegisterSCREENSHOTImage(void),
  RegisterSCTImage(void),
  RegisterSFWImage(void),
  RegisterSGIImage(void),
  RegisterSIXELImage(void),
  RegisterSTEGANOImage(void),
  RegisterSTRIMGImage(void),
  RegisterSUNImage(void),
  RegisterSVGImage(void),
  RegisterTGAImage(void),
  RegisterTHUMBNAILImage(void),
  RegisterTIFFImage(void),
  RegisterTILEImage(void),
  RegisterTIMImage(void),
  RegisterTIM2Image(void),
  RegisterTTFImage(void),
  RegisterTXTImage(void),
  RegisterUILImage(void),
  RegisterURLImage(void),
  RegisterUYVYImage(void),
  RegisterVICARImage(void),
  RegisterVIDImage(void),
  RegisterVIDEOImage(void),
  RegisterVIFFImage(void),
  RegisterVIPSImage(void),
  RegisterWBMPImage(void),
  RegisterWEBPImage(void),
  RegisterWMFImage(void),
  RegisterWPGImage(void),
  RegisterXImage(void),
  RegisterXBMImage(void),
  RegisterXCImage(void),
  RegisterXCFImage(void),
  RegisterXPMImage(void),
  RegisterXPSImage(void),
  RegisterXWDImage(void),
  RegisterYAMLImage(void),
  RegisterYCBCRImage(void),
  RegisterYUVImage(void);

extern ModuleExport void
  UnregisterAAIImage(void),
  UnregisterARTImage(void),
  UnregisterASHLARImage(void),
  UnregisterAVSImage(void),
  UnregisterBGRImage(void),
  UnregisterBMPImage(void),
  UnregisterBRAILLEImage(void),
  UnregisterCALSImage(void),
  UnregisterCAPTIONImage(void),
  UnregisterCINImage(void),
  UnregisterCIPImage(void),
  UnregisterCLIPImage(void),
  UnregisterCLIPBOARDImage(void),
  UnregisterCMYKImage(void),
  UnregisterCUBEImage(void),
  UnregisterCUTImage(void),
  UnregisterDCMImage(void),
  UnregisterDDSImage(void),
  UnregisterDEBUGImage(void),
  UnregisterDIBImage(void),
  UnregisterDJVUImage(void),
  UnregisterDNGImage(void),
  UnregisterDPSImage(void),
  UnregisterDPXImage(void),
  UnregisterEMFImage(void),
  UnregisterEPTImage(void),
  UnregisterEXRImage(void),
  UnregisterFARBFELDImage(void),
  UnregisterFAXImage(void),
  UnregisterFITSImage(void),
  UnregisterFL32Image(void),
  UnregisterFLIFImage(void),
  UnregisterFPXImage(void),
  UnregisterFTXTImage(void),
  UnregisterGIFImage(void),
  UnregisterGRADIENTImage(void),
  UnregisterGRAYImage(void),
  UnregisterHALDImage(void),
  UnregisterHDRImage(void),
  UnregisterHEICImage(void),
  UnregisterHISTOGRAMImage(void),
  UnregisterHRZImage(void),
  UnregisterHTMLImage(void),
  UnregisterICONImage(void),
  UnregisterINFOImage(void),
  UnregisterINLINEImage(void),
  UnregisterIPLImage(void),
  UnregisterJBIGImage(void),
  UnregisterJNXImage(void),
  UnregisterJPEGImage(void),
  UnregisterJP2Image(void),
  UnregisterJSONImage(void),
  UnregisterJXLImage(void),
  UnregisterLABELImage(void),
  UnregisterMACImage(void),
  UnregisterMAGICKImage(void),
  UnregisterMAPImage(void),
  UnregisterMASKImage(void),
  UnregisterMATImage(void),
  UnregisterMATTEImage(void),
  UnregisterMETAImage(void),
  UnregisterMIFFImage(void),
  UnregisterMONOImage(void),
  UnregisterMPCImage(void),
  UnregisterMPRImage(void),
  UnregisterMSLImage(void),
  UnregisterMTVImage(void),
  UnregisterMVGImage(void),
  UnregisterNULLImage(void),
  UnregisterORAImage(void),
  UnregisterOTBImage(void),
  UnregisterPALMImage(void),
  UnregisterPANGOImage(void),
  UnregisterPATTERNImage(void),
  UnregisterPCDImage(void),
  UnregisterPCLImage(void),
  UnregisterPCXImage(void),
  UnregisterPDBImage(void),
  UnregisterPDFImage(void),
  UnregisterPESImage(void),
  UnregisterPGXImage(void),
  UnregisterPICTImage(void),
  UnregisterPIXImage(void),
  UnregisterPLASMAImage(void),
  UnregisterPNGImage(void),
  UnregisterPNMImage(void),
  UnregisterPSImage(void),
  UnregisterPS2Image(void),
  UnregisterPS3Image(void),
  UnregisterPSDImage(void),
  UnregisterPWPImage(void),
  UnregisterQOIImage(void),
  UnregisterRAWImage(void),
  UnregisterRGBImage(void),
  UnregisterRGFImage(void),
  UnregisterRLAImage(void),
  UnregisterRLEImage(void),
  UnregisterSCRImage(void),
  UnregisterSCREENSHOTImage(void),
  UnregisterSCTImage(void),
  UnregisterSFWImage(void),
  UnregisterSGIImage(void),
  UnregisterSIXELImage(void),
  UnregisterSTEGANOImage(void),
  UnregisterSTRIMGImage(void),
  UnregisterSUNImage(void),
  UnregisterSVGImage(void),
  UnregisterTGAImage(void),
  UnregisterTHUMBNAILImage(void),
  UnregisterTIFFImage(void),
  UnregisterTILEImage(void),
  UnregisterTIMImage(void),
  UnregisterTIM2Image(void),
  UnregisterTTFImage(void),
  UnregisterTXTImage(void),
  UnregisterUILImage(void),
  UnregisterURLImage(void),
  UnregisterUYVYImage(void),
  UnregisterVICARImage(void),
  UnregisterVIDImage(void),
  UnregisterVIDEOImage(void),
  UnregisterVIFFImage(void),
  UnregisterVIPSImage(void),
  UnregisterWBMPImage(void),
  UnregisterWEBPImage(void),
  UnregisterWMFImage(void),
  UnregisterWPGImage(void),
  UnregisterXImage(void),
  UnregisterXBMImage(void),
  UnregisterXCImage(void),
  UnregisterXCFImage(void),
  UnregisterXPMImage(void),
  UnregisterXPSImage(void),
  UnregisterXWDImage(void),
  UnregisterYAMLImage(void),
  UnregisterYCBCRImage(void),
  UnregisterYUVImage(void);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
