#!/bin/sh

. "${TEST_SCRIPTS_DIR}/unit.sh"

define_test "12+4 IPs, 4 nodes, 2 -> 3 -> 4 healthy"

export CTDB_TEST_LOGLEVEL=ERR

set -e

echo "Nodes 2, 3 disconnected -> node 2 attaches"

required_result <<EOF
130.216.30.181 2
130.216.30.180 0
130.216.30.179 2
130.216.30.178 1
130.216.30.177 0
130.216.30.176 1
130.216.30.175 0
130.216.30.174 2
130.216.30.173 1
130.216.30.172 2
130.216.30.171 1
130.216.30.170 0
10.19.99.253 2
10.19.99.252 0
10.19.99.251 1
10.19.99.250 0
EOF

simple_test 0,0,0,1 <<EOF
10.19.99.253 1
10.19.99.252 0
10.19.99.251 1
10.19.99.250 0
130.216.30.181 1
130.216.30.180 0
130.216.30.179 0
130.216.30.178 1
130.216.30.177 0
130.216.30.176 1
130.216.30.175 0
130.216.30.174 1
130.216.30.173 1
130.216.30.172 0
130.216.30.171 1
130.216.30.170 0
EOF

echo "Node 3 attaches"

required_result <<EOF
130.216.30.181 2
130.216.30.180 3
130.216.30.179 3
130.216.30.178 1
130.216.30.177 0
130.216.30.176 1
130.216.30.175 0
130.216.30.174 2
130.216.30.173 3
130.216.30.172 2
130.216.30.171 1
130.216.30.170 0
10.19.99.253 2
10.19.99.252 3
10.19.99.251 1
10.19.99.250 0
EOF

simple_test 0,0,0,0 <<EOF
$_out
EOF
