/*
 * Copyright 2018 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/**************************************************************************************************
 *** This file was autogenerated from GrLinearGradientLayout.fp; do not modify.
 **************************************************************************************************/
#ifndef GrLinearGradientLayout_DEFINED
#define GrLinearGradientLayout_DEFINED
#include "SkTypes.h"

#include "SkLinearGradient.h"
#include "GrGradientShader.h"
#include "GrFragmentProcessor.h"
#include "GrCoordTransform.h"
class GrLinearGradientLayout : public GrFragmentProcessor {
public:
    const SkMatrix44& gradientMatrix() const { return fGradientMatrix; }

    static std::unique_ptr<GrFragmentProcessor> Make(const SkLinearGradient& gradient,
                                                     const GrFPArgs& args);
    GrLinearGradientLayout(const GrLinearGradientLayout& src);
    std::unique_ptr<GrFragmentProcessor> clone() const override;
    const char* name() const override { return "LinearGradientLayout"; }

private:
    GrLinearGradientLayout(SkMatrix44 gradientMatrix)
            : INHERITED(kGrLinearGradientLayout_ClassID,
                        (OptimizationFlags)kPreservesOpaqueInput_OptimizationFlag)
            , fGradientMatrix(gradientMatrix)
            , fCoordTransform0(gradientMatrix) {
        this->addCoordTransform(&fCoordTransform0);
    }
    GrGLSLFragmentProcessor* onCreateGLSLInstance() const override;
    void onGetGLSLProcessorKey(const GrShaderCaps&, GrProcessorKeyBuilder*) const override;
    bool onIsEqual(const GrFragmentProcessor&) const override;
    GR_DECLARE_FRAGMENT_PROCESSOR_TEST
    SkMatrix44 fGradientMatrix;
    GrCoordTransform fCoordTransform0;
    typedef GrFragmentProcessor INHERITED;
};
#endif
