// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// validationESEXT_autogen.h:
//   Validation functions for the OpenGL ES extension entry points.

#ifndef LIBANGLE_VALIDATION_ESEXT_AUTOGEN_H_
#define LIBANGLE_VALIDATION_ESEXT_AUTOGEN_H_

#include "common/PackedEnums.h"

namespace gl
{
class Context;

// GL_ANGLE_copy_texture_3d
bool ValidateCopyTexture3DANGLE(Context *context,
                                GLuint sourceId,
                                GLint sourceLevel,
                                TextureTarget destTargetPacked,
                                GLuint destId,
                                GLint destLevel,
                                GLint internalFormat,
                                GLenum destType,
                                GLboolean unpackFlipY,
                                GLboolean unpackPremultiplyAlpha,
                                GLboolean unpackUnmultiplyAlpha);
bool ValidateCopySubTexture3DANGLE(Context *context,
                                   GLuint sourceId,
                                   GLint sourceLevel,
                                   TextureTarget destTargetPacked,
                                   GLuint destId,
                                   GLint destLevel,
                                   GLint xoffset,
                                   GLint yoffset,
                                   GLint zoffset,
                                   GLint x,
                                   GLint y,
                                   GLint z,
                                   GLint width,
                                   GLint height,
                                   GLint depth,
                                   GLboolean unpackFlipY,
                                   GLboolean unpackPremultiplyAlpha,
                                   GLboolean unpackUnmultiplyAlpha);

// GL_ANGLE_framebuffer_blit
bool ValidateBlitFramebufferANGLE(Context *context,
                                  GLint srcX0,
                                  GLint srcY0,
                                  GLint srcX1,
                                  GLint srcY1,
                                  GLint dstX0,
                                  GLint dstY0,
                                  GLint dstX1,
                                  GLint dstY1,
                                  GLbitfield mask,
                                  GLenum filter);

// GL_ANGLE_framebuffer_multisample
bool ValidateRenderbufferStorageMultisampleANGLE(Context *context,
                                                 GLenum target,
                                                 GLsizei samples,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height);

// GL_ANGLE_instanced_arrays
bool ValidateDrawArraysInstancedANGLE(Context *context,
                                      PrimitiveMode modePacked,
                                      GLint first,
                                      GLsizei count,
                                      GLsizei primcount);
bool ValidateDrawElementsInstancedANGLE(Context *context,
                                        PrimitiveMode modePacked,
                                        GLsizei count,
                                        DrawElementsType typePacked,
                                        const void *indices,
                                        GLsizei primcount);
bool ValidateVertexAttribDivisorANGLE(Context *context, GLuint index, GLuint divisor);

// GL_ANGLE_multi_draw
bool ValidateMultiDrawArraysANGLE(Context *context,
                                  PrimitiveMode modePacked,
                                  const GLint *firsts,
                                  const GLsizei *counts,
                                  GLsizei drawcount);
bool ValidateMultiDrawArraysInstancedANGLE(Context *context,
                                           PrimitiveMode modePacked,
                                           const GLint *firsts,
                                           const GLsizei *counts,
                                           const GLsizei *instanceCounts,
                                           GLsizei drawcount);
bool ValidateMultiDrawElementsANGLE(Context *context,
                                    PrimitiveMode modePacked,
                                    const GLsizei *counts,
                                    DrawElementsType typePacked,
                                    const GLvoid *const *indices,
                                    GLsizei drawcount);
bool ValidateMultiDrawElementsInstancedANGLE(Context *context,
                                             PrimitiveMode modePacked,
                                             const GLsizei *counts,
                                             DrawElementsType typePacked,
                                             const GLvoid *const *indices,
                                             const GLsizei *instanceCounts,
                                             GLsizei drawcount);

// GL_ANGLE_provoking_vertex
bool ValidateProvokingVertexANGLE(Context *context, ProvokingVertex modePacked);

// GL_ANGLE_request_extension
bool ValidateRequestExtensionANGLE(Context *context, const GLchar *name);

// GL_ANGLE_robust_client_memory
bool ValidateGetBooleanvRobustANGLE(Context *context,
                                    GLenum pname,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLboolean *params);
bool ValidateGetBufferParameterivRobustANGLE(Context *context,
                                             BufferBinding targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *params);
bool ValidateGetFloatvRobustANGLE(Context *context,
                                  GLenum pname,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLfloat *params);
bool ValidateGetFramebufferAttachmentParameterivRobustANGLE(Context *context,
                                                            GLenum target,
                                                            GLenum attachment,
                                                            GLenum pname,
                                                            GLsizei bufSize,
                                                            GLsizei *length,
                                                            GLint *params);
bool ValidateGetIntegervRobustANGLE(Context *context,
                                    GLenum pname,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLint *data);
bool ValidateGetProgramivRobustANGLE(Context *context,
                                     GLuint program,
                                     GLenum pname,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLint *params);
bool ValidateGetRenderbufferParameterivRobustANGLE(Context *context,
                                                   GLenum target,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params);
bool ValidateGetShaderivRobustANGLE(Context *context,
                                    GLuint shader,
                                    GLenum pname,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLint *params);
bool ValidateGetTexParameterfvRobustANGLE(Context *context,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLfloat *params);
bool ValidateGetTexParameterivRobustANGLE(Context *context,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params);
bool ValidateGetUniformfvRobustANGLE(Context *context,
                                     GLuint program,
                                     GLint location,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLfloat *params);
bool ValidateGetUniformivRobustANGLE(Context *context,
                                     GLuint program,
                                     GLint location,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLint *params);
bool ValidateGetVertexAttribfvRobustANGLE(Context *context,
                                          GLuint index,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLfloat *params);
bool ValidateGetVertexAttribivRobustANGLE(Context *context,
                                          GLuint index,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params);
bool ValidateGetVertexAttribPointervRobustANGLE(Context *context,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                void **pointer);
bool ValidateReadPixelsRobustANGLE(Context *context,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLsizei *columns,
                                   GLsizei *rows,
                                   void *pixels);
bool ValidateTexImage2DRobustANGLE(Context *context,
                                   TextureTarget targetPacked,
                                   GLint level,
                                   GLint internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLint border,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   const void *pixels);
bool ValidateTexParameterfvRobustANGLE(Context *context,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       GLsizei bufSize,
                                       const GLfloat *params);
bool ValidateTexParameterivRobustANGLE(Context *context,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       GLsizei bufSize,
                                       const GLint *params);
bool ValidateTexSubImage2DRobustANGLE(Context *context,
                                      TextureTarget targetPacked,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLsizei width,
                                      GLsizei height,
                                      GLenum format,
                                      GLenum type,
                                      GLsizei bufSize,
                                      const void *pixels);
bool ValidateTexImage3DRobustANGLE(Context *context,
                                   TextureType targetPacked,
                                   GLint level,
                                   GLint internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLsizei depth,
                                   GLint border,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   const void *pixels);
bool ValidateTexSubImage3DRobustANGLE(Context *context,
                                      TextureType targetPacked,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint zoffset,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      GLenum format,
                                      GLenum type,
                                      GLsizei bufSize,
                                      const void *pixels);
bool ValidateCompressedTexImage2DRobustANGLE(Context *context,
                                             TextureTarget targetPacked,
                                             GLint level,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLint border,
                                             GLsizei imageSize,
                                             GLsizei dataSize,
                                             const GLvoid *data);
bool ValidateCompressedTexSubImage2DRobustANGLE(Context *context,
                                                TextureTarget targetPacked,
                                                GLint level,
                                                GLsizei xoffset,
                                                GLsizei yoffset,
                                                GLsizei width,
                                                GLsizei height,
                                                GLenum format,
                                                GLsizei imageSize,
                                                GLsizei dataSize,
                                                const GLvoid *data);
bool ValidateCompressedTexImage3DRobustANGLE(Context *context,
                                             TextureType targetPacked,
                                             GLint level,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             GLint border,
                                             GLsizei imageSize,
                                             GLsizei dataSize,
                                             const GLvoid *data);
bool ValidateCompressedTexSubImage3DRobustANGLE(Context *context,
                                                TextureType targetPacked,
                                                GLint level,
                                                GLint xoffset,
                                                GLint yoffset,
                                                GLint zoffset,
                                                GLsizei width,
                                                GLsizei height,
                                                GLsizei depth,
                                                GLenum format,
                                                GLsizei imageSize,
                                                GLsizei dataSize,
                                                const GLvoid *data);
bool ValidateGetQueryivRobustANGLE(Context *context,
                                   QueryType targetPacked,
                                   GLenum pname,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLint *params);
bool ValidateGetQueryObjectuivRobustANGLE(Context *context,
                                          GLuint id,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLuint *params);
bool ValidateGetBufferPointervRobustANGLE(Context *context,
                                          BufferBinding targetPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          void **params);
bool ValidateGetIntegeri_vRobustANGLE(Context *context,
                                      GLenum target,
                                      GLuint index,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLint *data);
bool ValidateGetInternalformativRobustANGLE(Context *context,
                                            GLenum target,
                                            GLenum internalformat,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params);
bool ValidateGetVertexAttribIivRobustANGLE(Context *context,
                                           GLuint index,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params);
bool ValidateGetVertexAttribIuivRobustANGLE(Context *context,
                                            GLuint index,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLuint *params);
bool ValidateGetUniformuivRobustANGLE(Context *context,
                                      GLuint program,
                                      GLint location,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLuint *params);
bool ValidateGetActiveUniformBlockivRobustANGLE(Context *context,
                                                GLuint program,
                                                GLuint uniformBlockIndex,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params);
bool ValidateGetInteger64vRobustANGLE(Context *context,
                                      GLenum pname,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLint64 *data);
bool ValidateGetInteger64i_vRobustANGLE(Context *context,
                                        GLenum target,
                                        GLuint index,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLint64 *data);
bool ValidateGetBufferParameteri64vRobustANGLE(Context *context,
                                               BufferBinding targetPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint64 *params);
bool ValidateSamplerParameterivRobustANGLE(Context *context,
                                           GLuint sampler,
                                           GLuint pname,
                                           GLsizei bufSize,
                                           const GLint *param);
bool ValidateSamplerParameterfvRobustANGLE(Context *context,
                                           GLuint sampler,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLfloat *param);
bool ValidateGetSamplerParameterivRobustANGLE(Context *context,
                                              GLuint sampler,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint *params);
bool ValidateGetSamplerParameterfvRobustANGLE(Context *context,
                                              GLuint sampler,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLfloat *params);
bool ValidateGetFramebufferParameterivRobustANGLE(Context *context,
                                                  GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params);
bool ValidateGetProgramInterfaceivRobustANGLE(Context *context,
                                              GLuint program,
                                              GLenum programInterface,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint *params);
bool ValidateGetBooleani_vRobustANGLE(Context *context,
                                      GLenum target,
                                      GLuint index,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLboolean *data);
bool ValidateGetMultisamplefvRobustANGLE(Context *context,
                                         GLenum pname,
                                         GLuint index,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLfloat *val);
bool ValidateGetTexLevelParameterivRobustANGLE(Context *context,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params);
bool ValidateGetTexLevelParameterfvRobustANGLE(Context *context,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLfloat *params);
bool ValidateGetPointervRobustANGLERobustANGLE(Context *context,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               void **params);
bool ValidateReadnPixelsRobustANGLE(Context *context,
                                    GLint x,
                                    GLint y,
                                    GLsizei width,
                                    GLsizei height,
                                    GLenum format,
                                    GLenum type,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLsizei *columns,
                                    GLsizei *rows,
                                    void *data);
bool ValidateGetnUniformfvRobustANGLE(Context *context,
                                      GLuint program,
                                      GLint location,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLfloat *params);
bool ValidateGetnUniformivRobustANGLE(Context *context,
                                      GLuint program,
                                      GLint location,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLint *params);
bool ValidateGetnUniformuivRobustANGLE(Context *context,
                                       GLuint program,
                                       GLint location,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLuint *params);
bool ValidateTexParameterIivRobustANGLE(Context *context,
                                        TextureType targetPacked,
                                        GLenum pname,
                                        GLsizei bufSize,
                                        const GLint *params);
bool ValidateTexParameterIuivRobustANGLE(Context *context,
                                         TextureType targetPacked,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         const GLuint *params);
bool ValidateGetTexParameterIivRobustANGLE(Context *context,
                                           TextureType targetPacked,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params);
bool ValidateGetTexParameterIuivRobustANGLE(Context *context,
                                            TextureType targetPacked,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLuint *params);
bool ValidateSamplerParameterIivRobustANGLE(Context *context,
                                            GLuint sampler,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            const GLint *param);
bool ValidateSamplerParameterIuivRobustANGLE(Context *context,
                                             GLuint sampler,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLuint *param);
bool ValidateGetSamplerParameterIivRobustANGLE(Context *context,
                                               GLuint sampler,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params);
bool ValidateGetSamplerParameterIuivRobustANGLE(Context *context,
                                                GLuint sampler,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params);
bool ValidateGetQueryObjectivRobustANGLE(Context *context,
                                         GLuint id,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params);
bool ValidateGetQueryObjecti64vRobustANGLE(Context *context,
                                           GLuint id,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint64 *params);
bool ValidateGetQueryObjectui64vRobustANGLE(Context *context,
                                            GLuint id,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLuint64 *params);

// GL_ANGLE_texture_multisample
bool ValidateTexStorage2DMultisampleANGLE(Context *context,
                                          TextureType targetPacked,
                                          GLsizei samples,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLboolean fixedsamplelocations);
bool ValidateGetTexLevelParameterivANGLE(Context *context,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLenum pname,
                                         GLint *params);
bool ValidateGetTexLevelParameterfvANGLE(Context *context,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLenum pname,
                                         GLfloat *params);
bool ValidateGetMultisamplefvANGLE(Context *context, GLenum pname, GLuint index, GLfloat *val);
bool ValidateSampleMaskiANGLE(Context *context, GLuint maskNumber, GLbitfield mask);

// GL_ANGLE_translated_shader_source
bool ValidateGetTranslatedShaderSourceANGLE(Context *context,
                                            GLuint shader,
                                            GLsizei bufsize,
                                            GLsizei *length,
                                            GLchar *source);

// GL_CHROMIUM_bind_uniform_location
bool ValidateBindUniformLocationCHROMIUM(Context *context,
                                         GLuint program,
                                         GLint location,
                                         const GLchar *name);

// GL_CHROMIUM_copy_compressed_texture
bool ValidateCompressedCopyTextureCHROMIUM(Context *context, GLuint sourceId, GLuint destId);

// GL_CHROMIUM_copy_texture
bool ValidateCopyTextureCHROMIUM(Context *context,
                                 GLuint sourceId,
                                 GLint sourceLevel,
                                 TextureTarget destTargetPacked,
                                 GLuint destId,
                                 GLint destLevel,
                                 GLint internalFormat,
                                 GLenum destType,
                                 GLboolean unpackFlipY,
                                 GLboolean unpackPremultiplyAlpha,
                                 GLboolean unpackUnmultiplyAlpha);
bool ValidateCopySubTextureCHROMIUM(Context *context,
                                    GLuint sourceId,
                                    GLint sourceLevel,
                                    TextureTarget destTargetPacked,
                                    GLuint destId,
                                    GLint destLevel,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint x,
                                    GLint y,
                                    GLint width,
                                    GLint height,
                                    GLboolean unpackFlipY,
                                    GLboolean unpackPremultiplyAlpha,
                                    GLboolean unpackUnmultiplyAlpha);

// GL_CHROMIUM_framebuffer_mixed_samples
bool ValidateCoverageModulationCHROMIUM(Context *context, GLenum components);
bool ValidateMatrixLoadfCHROMIUM(Context *context, GLenum matrixMode, const GLfloat *matrix);
bool ValidateMatrixLoadIdentityCHROMIUM(Context *context, GLenum matrixMode);

// GL_CHROMIUM_path_rendering
bool ValidateGenPathsCHROMIUM(Context *context, GLsizei range);
bool ValidateDeletePathsCHROMIUM(Context *context, GLuint first, GLsizei range);
bool ValidateIsPathCHROMIUM(Context *context, GLuint path);
bool ValidatePathCommandsCHROMIUM(Context *context,
                                  GLuint path,
                                  GLsizei numCommands,
                                  const GLubyte *commands,
                                  GLsizei numCoords,
                                  GLenum coordType,
                                  const void *coords);
bool ValidatePathParameterfCHROMIUM(Context *context, GLuint path, GLenum pname, GLfloat value);
bool ValidatePathParameteriCHROMIUM(Context *context, GLuint path, GLenum pname, GLint value);
bool ValidateGetPathParameterfvCHROMIUM(Context *context,
                                        GLuint path,
                                        GLenum pname,
                                        GLfloat *value);
bool ValidateGetPathParameterivCHROMIUM(Context *context, GLuint path, GLenum pname, GLint *value);
bool ValidatePathStencilFuncCHROMIUM(Context *context, GLenum func, GLint ref, GLuint mask);
bool ValidateStencilFillPathCHROMIUM(Context *context, GLuint path, GLenum fillMode, GLuint mask);
bool ValidateStencilStrokePathCHROMIUM(Context *context, GLuint path, GLint reference, GLuint mask);
bool ValidateCoverFillPathCHROMIUM(Context *context, GLuint path, GLenum coverMode);
bool ValidateCoverStrokePathCHROMIUM(Context *context, GLuint path, GLenum coverMode);
bool ValidateStencilThenCoverFillPathCHROMIUM(Context *context,
                                              GLuint path,
                                              GLenum fillMode,
                                              GLuint mask,
                                              GLenum coverMode);
bool ValidateStencilThenCoverStrokePathCHROMIUM(Context *context,
                                                GLuint path,
                                                GLint reference,
                                                GLuint mask,
                                                GLenum coverMode);
bool ValidateCoverFillPathInstancedCHROMIUM(Context *context,
                                            GLsizei numPath,
                                            GLenum pathNameType,
                                            const void *paths,
                                            GLuint pathBase,
                                            GLenum coverMode,
                                            GLenum transformType,
                                            const GLfloat *transformValues);
bool ValidateCoverStrokePathInstancedCHROMIUM(Context *context,
                                              GLsizei numPath,
                                              GLenum pathNameType,
                                              const void *paths,
                                              GLuint pathBase,
                                              GLenum coverMode,
                                              GLenum transformType,
                                              const GLfloat *transformValues);
bool ValidateStencilStrokePathInstancedCHROMIUM(Context *context,
                                                GLsizei numPath,
                                                GLenum pathNameType,
                                                const void *paths,
                                                GLuint pathBase,
                                                GLint reference,
                                                GLuint mask,
                                                GLenum transformType,
                                                const GLfloat *transformValues);
bool ValidateStencilFillPathInstancedCHROMIUM(Context *context,
                                              GLsizei numPaths,
                                              GLenum pathNameType,
                                              const void *paths,
                                              GLuint pathBase,
                                              GLenum fillMode,
                                              GLuint mask,
                                              GLenum transformType,
                                              const GLfloat *transformValues);
bool ValidateStencilThenCoverFillPathInstancedCHROMIUM(Context *context,
                                                       GLsizei numPaths,
                                                       GLenum pathNameType,
                                                       const void *paths,
                                                       GLuint pathBase,
                                                       GLenum fillMode,
                                                       GLuint mask,
                                                       GLenum coverMode,
                                                       GLenum transformType,
                                                       const GLfloat *transformValues);
bool ValidateStencilThenCoverStrokePathInstancedCHROMIUM(Context *context,
                                                         GLsizei numPaths,
                                                         GLenum pathNameType,
                                                         const void *paths,
                                                         GLuint pathBase,
                                                         GLint reference,
                                                         GLuint mask,
                                                         GLenum coverMode,
                                                         GLenum transformType,
                                                         const GLfloat *transformValues);
bool ValidateBindFragmentInputLocationCHROMIUM(Context *context,
                                               GLuint programs,
                                               GLint location,
                                               const GLchar *name);
bool ValidateProgramPathFragmentInputGenCHROMIUM(Context *context,
                                                 GLuint program,
                                                 GLint location,
                                                 GLenum genMode,
                                                 GLint components,
                                                 const GLfloat *coeffs);

// GL_EXT_blend_func_extended
bool ValidateBindFragDataLocationEXT(Context *context,
                                     GLuint program,
                                     GLuint color,
                                     const GLchar *name);
bool ValidateBindFragDataLocationIndexedEXT(Context *context,
                                            GLuint program,
                                            GLuint colorNumber,
                                            GLuint index,
                                            const GLchar *name);
bool ValidateGetFragDataIndexEXT(Context *context, GLuint program, const GLchar *name);
bool ValidateGetProgramResourceLocationIndexEXT(Context *context,
                                                GLuint program,
                                                GLenum programInterface,
                                                const GLchar *name);

// GL_EXT_debug_marker
bool ValidateInsertEventMarkerEXT(Context *context, GLsizei length, const GLchar *marker);
bool ValidatePopGroupMarkerEXT(Context *context);
bool ValidatePushGroupMarkerEXT(Context *context, GLsizei length, const GLchar *marker);

// GL_EXT_discard_framebuffer
bool ValidateDiscardFramebufferEXT(Context *context,
                                   GLenum target,
                                   GLsizei numAttachments,
                                   const GLenum *attachments);

// GL_EXT_disjoint_timer_query
bool ValidateBeginQueryEXT(Context *context, QueryType targetPacked, GLuint id);
bool ValidateDeleteQueriesEXT(Context *context, GLsizei n, const GLuint *ids);
bool ValidateEndQueryEXT(Context *context, QueryType targetPacked);
bool ValidateGenQueriesEXT(Context *context, GLsizei n, GLuint *ids);
bool ValidateGetQueryObjecti64vEXT(Context *context, GLuint id, GLenum pname, GLint64 *params);
bool ValidateGetQueryObjectivEXT(Context *context, GLuint id, GLenum pname, GLint *params);
bool ValidateGetQueryObjectui64vEXT(Context *context, GLuint id, GLenum pname, GLuint64 *params);
bool ValidateGetQueryObjectuivEXT(Context *context, GLuint id, GLenum pname, GLuint *params);
bool ValidateGetQueryivEXT(Context *context, QueryType targetPacked, GLenum pname, GLint *params);
bool ValidateIsQueryEXT(Context *context, GLuint id);
bool ValidateQueryCounterEXT(Context *context, GLuint id, QueryType targetPacked);

// GL_EXT_draw_buffers
bool ValidateDrawBuffersEXT(Context *context, GLsizei n, const GLenum *bufs);

// GL_EXT_geometry_shader
bool ValidateFramebufferTextureEXT(Context *context,
                                   GLenum target,
                                   GLenum attachment,
                                   GLuint texture,
                                   GLint level);

// GL_EXT_instanced_arrays
bool ValidateDrawArraysInstancedEXT(Context *context,
                                    PrimitiveMode modePacked,
                                    GLint start,
                                    GLsizei count,
                                    GLsizei primcount);
bool ValidateDrawElementsInstancedEXT(Context *context,
                                      PrimitiveMode modePacked,
                                      GLsizei count,
                                      DrawElementsType typePacked,
                                      const void *indices,
                                      GLsizei primcount);
bool ValidateVertexAttribDivisorEXT(Context *context, GLuint index, GLuint divisor);

// GL_EXT_map_buffer_range
bool ValidateFlushMappedBufferRangeEXT(Context *context,
                                       BufferBinding targetPacked,
                                       GLintptr offset,
                                       GLsizeiptr length);
bool ValidateMapBufferRangeEXT(Context *context,
                               BufferBinding targetPacked,
                               GLintptr offset,
                               GLsizeiptr length,
                               GLbitfield access);

// GL_EXT_occlusion_query_boolean

// GL_EXT_robustness
bool ValidateGetGraphicsResetStatusEXT(Context *context);
bool ValidateGetnUniformfvEXT(Context *context,
                              GLuint program,
                              GLint location,
                              GLsizei bufSize,
                              GLfloat *params);
bool ValidateGetnUniformivEXT(Context *context,
                              GLuint program,
                              GLint location,
                              GLsizei bufSize,
                              GLint *params);
bool ValidateReadnPixelsEXT(Context *context,
                            GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height,
                            GLenum format,
                            GLenum type,
                            GLsizei bufSize,
                            void *data);

// GL_EXT_texture_storage
bool ValidateTexStorage1DEXT(Context *context,
                             GLenum target,
                             GLsizei levels,
                             GLenum internalformat,
                             GLsizei width);
bool ValidateTexStorage2DEXT(Context *context,
                             TextureType targetPacked,
                             GLsizei levels,
                             GLenum internalformat,
                             GLsizei width,
                             GLsizei height);
bool ValidateTexStorage3DEXT(Context *context,
                             TextureType targetPacked,
                             GLsizei levels,
                             GLenum internalformat,
                             GLsizei width,
                             GLsizei height,
                             GLsizei depth);

// GL_KHR_debug
bool ValidateDebugMessageCallbackKHR(Context *context,
                                     GLDEBUGPROCKHR callback,
                                     const void *userParam);
bool ValidateDebugMessageControlKHR(Context *context,
                                    GLenum source,
                                    GLenum type,
                                    GLenum severity,
                                    GLsizei count,
                                    const GLuint *ids,
                                    GLboolean enabled);
bool ValidateDebugMessageInsertKHR(Context *context,
                                   GLenum source,
                                   GLenum type,
                                   GLuint id,
                                   GLenum severity,
                                   GLsizei length,
                                   const GLchar *buf);
bool ValidateGetDebugMessageLogKHR(Context *context,
                                   GLuint count,
                                   GLsizei bufSize,
                                   GLenum *sources,
                                   GLenum *types,
                                   GLuint *ids,
                                   GLenum *severities,
                                   GLsizei *lengths,
                                   GLchar *messageLog);
bool ValidateGetObjectLabelKHR(Context *context,
                               GLenum identifier,
                               GLuint name,
                               GLsizei bufSize,
                               GLsizei *length,
                               GLchar *label);
bool ValidateGetObjectPtrLabelKHR(Context *context,
                                  const void *ptr,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLchar *label);
bool ValidateGetPointervKHR(Context *context, GLenum pname, void **params);
bool ValidateObjectLabelKHR(Context *context,
                            GLenum identifier,
                            GLuint name,
                            GLsizei length,
                            const GLchar *label);
bool ValidateObjectPtrLabelKHR(Context *context,
                               const void *ptr,
                               GLsizei length,
                               const GLchar *label);
bool ValidatePopDebugGroupKHR(Context *context);
bool ValidatePushDebugGroupKHR(Context *context,
                               GLenum source,
                               GLuint id,
                               GLsizei length,
                               const GLchar *message);

// GL_KHR_parallel_shader_compile
bool ValidateMaxShaderCompilerThreadsKHR(Context *context, GLuint count);

// GL_NV_fence
bool ValidateDeleteFencesNV(Context *context, GLsizei n, const GLuint *fences);
bool ValidateFinishFenceNV(Context *context, GLuint fence);
bool ValidateGenFencesNV(Context *context, GLsizei n, GLuint *fences);
bool ValidateGetFenceivNV(Context *context, GLuint fence, GLenum pname, GLint *params);
bool ValidateIsFenceNV(Context *context, GLuint fence);
bool ValidateSetFenceNV(Context *context, GLuint fence, GLenum condition);
bool ValidateTestFenceNV(Context *context, GLuint fence);

// GL_OES_EGL_image
bool ValidateEGLImageTargetRenderbufferStorageOES(Context *context,
                                                  GLenum target,
                                                  GLeglImageOES image);
bool ValidateEGLImageTargetTexture2DOES(Context *context,
                                        TextureType targetPacked,
                                        GLeglImageOES image);

// GL_OES_draw_texture
bool ValidateDrawTexfOES(Context *context,
                         GLfloat x,
                         GLfloat y,
                         GLfloat z,
                         GLfloat width,
                         GLfloat height);
bool ValidateDrawTexfvOES(Context *context, const GLfloat *coords);
bool ValidateDrawTexiOES(Context *context, GLint x, GLint y, GLint z, GLint width, GLint height);
bool ValidateDrawTexivOES(Context *context, const GLint *coords);
bool ValidateDrawTexsOES(Context *context,
                         GLshort x,
                         GLshort y,
                         GLshort z,
                         GLshort width,
                         GLshort height);
bool ValidateDrawTexsvOES(Context *context, const GLshort *coords);
bool ValidateDrawTexxOES(Context *context,
                         GLfixed x,
                         GLfixed y,
                         GLfixed z,
                         GLfixed width,
                         GLfixed height);
bool ValidateDrawTexxvOES(Context *context, const GLfixed *coords);

// GL_OES_framebuffer_object
bool ValidateBindFramebufferOES(Context *context, GLenum target, GLuint framebuffer);
bool ValidateBindRenderbufferOES(Context *context, GLenum target, GLuint renderbuffer);
bool ValidateCheckFramebufferStatusOES(Context *context, GLenum target);
bool ValidateDeleteFramebuffersOES(Context *context, GLsizei n, const GLuint *framebuffers);
bool ValidateDeleteRenderbuffersOES(Context *context, GLsizei n, const GLuint *renderbuffers);
bool ValidateFramebufferRenderbufferOES(Context *context,
                                        GLenum target,
                                        GLenum attachment,
                                        GLenum renderbuffertarget,
                                        GLuint renderbuffer);
bool ValidateFramebufferTexture2DOES(Context *context,
                                     GLenum target,
                                     GLenum attachment,
                                     TextureTarget textargetPacked,
                                     GLuint texture,
                                     GLint level);
bool ValidateGenFramebuffersOES(Context *context, GLsizei n, GLuint *framebuffers);
bool ValidateGenRenderbuffersOES(Context *context, GLsizei n, GLuint *renderbuffers);
bool ValidateGenerateMipmapOES(Context *context, TextureType targetPacked);
bool ValidateGetFramebufferAttachmentParameterivOES(Context *context,
                                                    GLenum target,
                                                    GLenum attachment,
                                                    GLenum pname,
                                                    GLint *params);
bool ValidateGetRenderbufferParameterivOES(Context *context,
                                           GLenum target,
                                           GLenum pname,
                                           GLint *params);
bool ValidateIsFramebufferOES(Context *context, GLuint framebuffer);
bool ValidateIsRenderbufferOES(Context *context, GLuint renderbuffer);
bool ValidateRenderbufferStorageOES(Context *context,
                                    GLenum target,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height);

// GL_OES_get_program_binary
bool ValidateGetProgramBinaryOES(Context *context,
                                 GLuint program,
                                 GLsizei bufSize,
                                 GLsizei *length,
                                 GLenum *binaryFormat,
                                 void *binary);
bool ValidateProgramBinaryOES(Context *context,
                              GLuint program,
                              GLenum binaryFormat,
                              const void *binary,
                              GLint length);

// GL_OES_mapbuffer
bool ValidateGetBufferPointervOES(Context *context,
                                  BufferBinding targetPacked,
                                  GLenum pname,
                                  void **params);
bool ValidateMapBufferOES(Context *context, BufferBinding targetPacked, GLenum access);
bool ValidateUnmapBufferOES(Context *context, BufferBinding targetPacked);

// GL_OES_matrix_palette
bool ValidateCurrentPaletteMatrixOES(Context *context, GLuint matrixpaletteindex);
bool ValidateLoadPaletteFromModelViewMatrixOES(Context *context);
bool ValidateMatrixIndexPointerOES(Context *context,
                                   GLint size,
                                   GLenum type,
                                   GLsizei stride,
                                   const void *pointer);
bool ValidateWeightPointerOES(Context *context,
                              GLint size,
                              GLenum type,
                              GLsizei stride,
                              const void *pointer);

// GL_OES_point_size_array
bool ValidatePointSizePointerOES(Context *context,
                                 VertexAttribType typePacked,
                                 GLsizei stride,
                                 const void *pointer);

// GL_OES_query_matrix
bool ValidateQueryMatrixxOES(Context *context, GLfixed *mantissa, GLint *exponent);

// GL_OES_texture_border_clamp
bool ValidateGetSamplerParameterIivOES(Context *context,
                                       GLuint sampler,
                                       GLenum pname,
                                       GLint *params);
bool ValidateGetSamplerParameterIuivOES(Context *context,
                                        GLuint sampler,
                                        GLenum pname,
                                        GLuint *params);
bool ValidateGetTexParameterIivOES(Context *context,
                                   TextureType targetPacked,
                                   GLenum pname,
                                   GLint *params);
bool ValidateGetTexParameterIuivOES(Context *context,
                                    TextureType targetPacked,
                                    GLenum pname,
                                    GLuint *params);
bool ValidateSamplerParameterIivOES(Context *context,
                                    GLuint sampler,
                                    GLenum pname,
                                    const GLint *param);
bool ValidateSamplerParameterIuivOES(Context *context,
                                     GLuint sampler,
                                     GLenum pname,
                                     const GLuint *param);
bool ValidateTexParameterIivOES(Context *context,
                                TextureType targetPacked,
                                GLenum pname,
                                const GLint *params);
bool ValidateTexParameterIuivOES(Context *context,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 const GLuint *params);

// GL_OES_texture_cube_map
bool ValidateGetTexGenfvOES(Context *context, GLenum coord, GLenum pname, GLfloat *params);
bool ValidateGetTexGenivOES(Context *context, GLenum coord, GLenum pname, GLint *params);
bool ValidateGetTexGenxvOES(Context *context, GLenum coord, GLenum pname, GLfixed *params);
bool ValidateTexGenfOES(Context *context, GLenum coord, GLenum pname, GLfloat param);
bool ValidateTexGenfvOES(Context *context, GLenum coord, GLenum pname, const GLfloat *params);
bool ValidateTexGeniOES(Context *context, GLenum coord, GLenum pname, GLint param);
bool ValidateTexGenivOES(Context *context, GLenum coord, GLenum pname, const GLint *params);
bool ValidateTexGenxOES(Context *context, GLenum coord, GLenum pname, GLfixed param);
bool ValidateTexGenxvOES(Context *context, GLenum coord, GLenum pname, const GLfixed *params);

// GL_OES_texture_storage_multisample_2d_array
bool ValidateTexStorage3DMultisampleOES(Context *context,
                                        TextureType targetPacked,
                                        GLsizei samples,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLboolean fixedsamplelocations);

// GL_OES_vertex_array_object
bool ValidateBindVertexArrayOES(Context *context, GLuint array);
bool ValidateDeleteVertexArraysOES(Context *context, GLsizei n, const GLuint *arrays);
bool ValidateGenVertexArraysOES(Context *context, GLsizei n, GLuint *arrays);
bool ValidateIsVertexArrayOES(Context *context, GLuint array);

// GL_OVR_multiview
bool ValidateFramebufferTextureMultiviewOVR(Context *context,
                                            GLenum target,
                                            GLenum attachment,
                                            GLuint texture,
                                            GLint level,
                                            GLint baseViewIndex,
                                            GLsizei numViews);

// GL_OVR_multiview2
}  // namespace gl

#endif  // LIBANGLE_VALIDATION_ESEXT_AUTOGEN_H_
