#if 0
//
// FX Version: fx_4_0
// Child effect (requires effect pool): false
//
// 4 local buffer(s)
//
cbuffer $Globals
{
    uint    blendop;                    // Offset:    0, size:    4
}

cbuffer cb0
{
    float4  QuadDesc;                   // Offset:    0, size:   16
    float4  TexCoords;                  // Offset:   16, size:   16
    float4  MaskTexCoords;              // Offset:   32, size:   16
    float4  TextColor;                  // Offset:   48, size:   16
}

cbuffer cb1
{
    float4  BlurOffsetsH[3];            // Offset:    0, size:   48
    float4  BlurOffsetsV[3];            // Offset:   48, size:   48
    float4  BlurWeights[3];             // Offset:   96, size:   48
    float4  ShadowColor;                // Offset:  144, size:   16
}

cbuffer cb2
{
    float3x3 DeviceSpaceToUserSpace;    // Offset:    0, size:   44
    float2  dimensions;                 // Offset:   48, size:    8
    float3  diff;                       // Offset:   64, size:   12
    float2  center1;                    // Offset:   80, size:    8
    float   A;                          // Offset:   88, size:    4
    float   radius1;                    // Offset:   92, size:    4
    float   sq_radius1;                 // Offset:   96, size:    4
}

//
// 13 local object(s)
//
Texture2D tex;
Texture2D bcktex;
Texture2D mask;
SamplerState sSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = tex;
    AddressU = uint(CLAMP /* 3 */);
    AddressV = uint(CLAMP /* 3 */);
};
SamplerState sBckSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = bcktex;
    AddressU = uint(CLAMP /* 3 */);
    AddressV = uint(CLAMP /* 3 */);
};
SamplerState sWrapSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = tex;
    AddressU = uint(WRAP /* 1 */);
    AddressV = uint(WRAP /* 1 */);
};
SamplerState sMirrorSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = tex;
    AddressU = uint(MIRROR /* 2 */);
    AddressV = uint(MIRROR /* 2 */);
};
SamplerState sMaskSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = mask;
    AddressU = uint(CLAMP /* 3 */);
    AddressV = uint(CLAMP /* 3 */);
};
SamplerState sShadowSampler
{
    Filter   = uint(MIN_MAG_MIP_LINEAR /* 21 */);
    Texture  = tex;
    AddressU = uint(BORDER /* 4 */);
    AddressV = uint(BORDER /* 4 */);
    BorderColor = float4(0, 0, 0, 0);
};
RasterizerState TextureRast
{
    ScissorEnable = bool(TRUE /* 1 */);
    CullMode = uint(NONE /* 1 */);
};
BlendState ShadowBlendH
{
    BlendEnable[0] = bool(FALSE /* 0 */);
    RenderTargetWriteMask[0] = byte(0x0f);
};
BlendState ShadowBlendV
{
    BlendEnable[0] = bool(TRUE /* 1 */);
    SrcBlend[0] = uint(ONE /* 2 */);
    DestBlend[0] = uint(INV_SRC_ALPHA /* 6 */);
    BlendOp[0] = uint(ADD /* 1 */);
    SrcBlendAlpha[0] = uint(ONE /* 2 */);
    DestBlendAlpha[0] = uint(INV_SRC_ALPHA /* 6 */);
    BlendOpAlpha[0] = uint(ADD /* 1 */);
    RenderTargetWriteMask[0] = byte(0x0f);
};
BlendState bTextBlend
{
    AlphaToCoverageEnable = bool(FALSE /* 0 */);
    BlendEnable[0] = bool(TRUE /* 1 */);
    SrcBlend[0] = uint(SRC1_COLOR /* 16 */);
    DestBlend[0] = uint(INV_SRC1_COLOR /* 17 */);
    BlendOp[0] = uint(ADD /* 1 */);
    SrcBlendAlpha[0] = uint(SRC1_ALPHA /* 18 */);
    DestBlendAlpha[0] = uint(INV_SRC1_ALPHA /* 19 */);
    BlendOpAlpha[0] = uint(ADD /* 1 */);
    RenderTargetWriteMask[0] = byte(0x0f);
};

//
// 8 technique(s)
//
technique10 SampleTexture
{
    pass P0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // tex                               texture  float4          2d    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                texld r0, t0, s0
                mov oC0, r0
            
            // approximately 2 instruction slots used (1 texture, 1 arithmetic)
            ps_4_0
            dcl_sampler s0, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            sample o0.xyzw, v1.xyxx, t0.xyzw, s0
            ret 
            // Approximately 2 instruction slots used
                    
        };
    }

}

technique10 SampleTextureForSeparableBlending_1
{
    pass P0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer $Globals
            // {
            //
            //   uint blendop;                      // Offset:    0 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sBckSampler                       sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // bcktex                            texture  float4          2d    1        1
            // $Globals                          cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             0         1  (UINT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c1, -1, -2, -3, -4
                def c2, 1, 0, 0.5, -2
                def c3, -5, 0, 0, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mov r0.w, c0.x
                add r0.x, r0.w, c3.x
                mul r0.x, r0.x, r0.x
                texld r1, t0, s1
                texld r2, t0, s0
                rcp r0.y, r2.w
                mad r3.xyz, r2, r0.y, -c2.x
                mul r3.xyz, r3, r3
                mad r4.xyz, r2, -r0.y, c2.x
                rcp r3.w, r4.x
                rcp r4.w, r1.w
                mul r5.xyz, r1, r4.w
                mad r1.xyz, r1, -r4.w, c2.z
                mul r3.w, r3.w, r5.x
                min r4.w, r3.w, c2.x
                cmp r4.w, -r3.x, c2.x, r4.w
                mul r6.xyz, r5, r5
                cmp r7.x, -r6.x, c2.y, r4.w
                rcp r4.w, r4.y
                mul r4.w, r4.w, r5.y
                min r5.w, r4.w, c2.x
                cmp r4.w, -r3.y, c2.x, r5.w
                cmp r7.y, -r6.y, c2.y, r4.w
                rcp r4.w, r4.z
                mul r4.w, r4.w, r5.z
                min r5.w, r4.w, c2.x
                cmp r4.w, -r3.z, c2.x, r5.w
                cmp r7.z, -r6.z, c2.y, r4.w
                mul r3.xyz, r0.y, r2
                mad r6.xyz, r2, r0.y, r5
                mad r6.xyz, r3, -r5, r6
                max r8.xyz, r3, r5
                cmp r0.xyz, -r0.x, r8, r7
                add r7, r0.w, c1
                mul r7, r7, r7
                min r8.xyz, r5, r3
                cmp r0.xyz, -r7.w, r8, r0
                mad r8.xyz, r5, -c2.w, -c2.x
                add r8.xyz, -r8, c2.x
                mad r4.xyz, r4, -r8, c2.x
                add r8.xyz, r5, r5
                mul r5.xyz, r5, r3
                mul r8.xyz, r3, r8
                cmp r1.xyz, r1, r8, r4
                cmp r0.xyz, -r7.z, r1, r0
                cmp r0.xyz, -r7.y, r6, r0
                cmp r0.xyz, -r7.x, r5, r0
                lrp r4.xyz, r1.w, r0, r3
                mul r4.w, r1.w, r1.w
                cmp r4.w, -r4.w, c2.x, c2.y
                mul r0.xyz, r2.w, r4
                mul r0.w, r2.w, r2.w
                cmp r0.w, -r0.w, c2.x, c2.y
                add r0.w, r4.w, r0.w
                cmp r2.xyz, -r0.w, r0, r2
                mov oC0, r2
            
            // approximately 56 instruction slots used (2 texture, 54 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[1], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_temps 7
            sample r0.xyzw, v1.xyxx, t0.xyzw, s0
            sample r1.xyzw, v1.xyxx, t1.xyzw, s1
            eq r2.x, r0.w, l(0.000000)
            eq r2.y, r1.w, l(0.000000)
            or r2.x, r2.y, r2.x
            if_nz r2.x
              mov o0.xyzw, r0.xyzw
              ret 
            endif 
            div r0.xyz, r0.xyzx, r0.wwww
            div r1.xyz, r1.xyzx, r1.wwww
            ieq r2.x, cb0[0].x, l(1)
            if_nz r2.x
              mul r2.xyz, r0.xyzx, r1.xyzx
            else 
              ieq r2.w, cb0[0].x, l(2)
              if_nz r2.w
                add r3.xyz, r0.xyzx, r1.xyzx
                mad r2.xyz, -r0.xyzx, r1.xyzx, r3.xyzx
              else 
                ieq r2.w, cb0[0].x, l(3)
                if_nz r2.w
                  ge r3.xyz, l(0.500000, 0.500000, 0.500000, 0.000000), r1.xyzx
                  add r4.xyz, r1.xyzx, r1.xyzx
                  mul r4.xyz, r0.xyzx, r4.xyzx
                  mad r5.xyz, r1.xyzx, l(2.000000, 2.000000, 2.000000, 0.000000), l(-1.000000, -1.000000, -1.000000, 0.000000)
                  add r6.xyz, -r0.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                  add r5.xyz, -r5.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                  mad r5.xyz, -r6.xyzx, r5.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                  movc r2.xyz, r3.xyzx, r4.xyzx, r5.xyzx
                else 
                  ieq r2.w, cb0[0].x, l(4)
                  if_nz r2.w
                    min r2.xyz, r0.xyzx, r1.xyzx
                  else 
                    ieq r2.w, cb0[0].x, l(5)
                    if_nz r2.w
                      max r2.xyz, r0.xyzx, r1.xyzx
                    else 
                      eq r3.xyz, r1.xyzx, l(0.000000, 0.000000, 0.000000, 0.000000)
                      eq r4.xyz, r0.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                      add r5.xyz, -r0.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                      div r1.xyz, r1.xyzx, r5.xyzx
                      min r1.xyz, r1.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                      movc r1.xyz, r4.xyzx, l(1.000000,1.000000,1.000000,0), r1.xyzx
                      movc r2.xyz, r3.xyzx, l(0,0,0,0), r1.xyzx
                    endif 
                  endif 
                endif 
              endif 
            endif 
            add r1.x, -r1.w, l(1.000000)
            mul r1.yzw, r1.wwww, r2.xxyz
            mad r0.xyz, r1.xxxx, r0.xyzx, r1.yzwy
            mul o0.xyz, r0.wwww, r0.xyzx
            mov o0.w, r0.w
            ret 
            // Approximately 57 instruction slots used
                    
        };
    }

}

technique10 SampleTextureForSeparableBlending_2
{
    pass P0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer $Globals
            // {
            //
            //   uint blendop;                      // Offset:    0 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sBckSampler                       sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // bcktex                            texture  float4          2d    1        1
            // $Globals                          cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             0         1  (UINT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c1, -7, -8, -9, -10
                def c2, 1, 0, -1, 0.25
                def c3, 0.5, 2, -1, 4
                def c4, 16, -12, 2, 1
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mov r0.w, c0.x
                add r0, r0.w, c1
                mul r0, r0, r0
                texld r1, t0, s0
                texld r2, t0, s1
                rcp r3.w, r2.w
                mad r3.xy, r2.yzzw, -r3.w, c2.w
                mul r4.xyz, r2, r3.w
                mad r5.xyz, r4, c4.x, c4.y
                mad r5.xyz, r5, r4, c3.w
                mul r5.xyz, r4, r5
                rsq r4.w, r4.y
                rcp r4.w, r4.w
                cmp r4.w, r3.x, r5.y, r4.w
                mad r4.w, r2.y, -r3.w, r4.w
                rcp r3.x, r1.w
                mul r6.xyz, r1, r3.x
                mad r7.xyz, r6, c3.y, c3.z
                mad r4.w, r7.y, r4.w, r4.y
                mad r8.xyz, r1, -r3.x, c3.x
                mad r9, r2.xyzx, -r3.w, c2.xxxw
                mad r10.xyz, r6, -c4.z, c4.w
                mul r10.xyz, r4, r10
                mad r10.xyz, r10, -r9, r4
                cmp r11.y, r8.y, r10.y, r4.w
                rsq r4.w, r4.z
                rcp r4.w, r4.w
                cmp r4.w, r3.y, r5.z, r4.w
                mad r4.w, r2.z, -r3.w, r4.w
                mad r4.w, r7.z, r4.w, r4.z
                cmp r11.z, r8.z, r10.z, r4.w
                rsq r4.w, r4.x
                rcp r4.w, r4.w
                cmp r4.w, r9.w, r5.x, r4.w
                mad r4.w, r2.x, -r3.w, r4.w
                mad r2.xyz, r2, r3.w, c2.z
                mul r2.xyz, r2, r2
                mad r4.w, r7.x, r4.w, r4.x
                add r3.yzw, -r7.xxyz, c2.x
                mad r3.yzw, r9.xxyz, -r3, c2.x
                cmp r11.x, r8.x, r10.x, r4.w
                mad r5.xyz, r1, r3.x, -r4
                mad r7.xyz, r1, r3.x, r4
                abs r5.xyz, r5
                mul r10.xyz, r4, r6
                mad r7.xyz, r10, -c3.y, r7
                cmp r5.xyz, -r0.w, r5, r7
                cmp r5.xyz, -r0.z, r11, r5
                add r7.xyz, r6, r6
                mul r4.xyz, r4, r7
                cmp r3.xyz, r8, r4, r3.yzww
                cmp r0.yzw, -r0.y, r3.xxyz, r5.xxyz
                rcp r6.w, r6.x
                mad r6.w, r9.x, -r6.w, c2.x
                max r3.x, r6.w, c2.y
                mul r3.yzw, r6.xxyz, r6.xxyz
                cmp r6.w, -r3.y, c2.y, r3.x
                cmp r4.x, -r2.x, c2.x, r6.w
                rcp r4.w, r6.y
                mad r4.w, r9.y, -r4.w, c2.x
                max r6.w, r4.w, c2.y
                cmp r4.w, -r3.z, c2.y, r6.w
                cmp r4.y, -r2.y, c2.x, r4.w
                rcp r4.w, r6.z
                mad r4.w, r9.z, -r4.w, c2.x
                max r6.w, r4.w, c2.y
                cmp r4.w, -r3.w, c2.y, r6.w
                cmp r4.z, -r2.z, c2.x, r4.w
                cmp r0.xyz, -r0.x, r4, r0.yzww
                lrp r3.xyz, r2.w, r0, r6
                mul r3.w, r2.w, r2.w
                cmp r3.w, -r3.w, c2.x, c2.y
                mul r0.xyz, r1.w, r3
                mul r0.w, r1.w, r1.w
                cmp r0.w, -r0.w, c2.x, c2.y
                add r0.w, r3.w, r0.w
                cmp r1.xyz, -r0.w, r0, r1
                mov oC0, r1
            
            // approximately 78 instruction slots used (2 texture, 76 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[1], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_temps 7
            sample r0.xyzw, v1.xyxx, t0.xyzw, s0
            sample r1.xyzw, v1.xyxx, t1.xyzw, s1
            eq r2.x, r0.w, l(0.000000)
            eq r2.y, r1.w, l(0.000000)
            or r2.x, r2.y, r2.x
            if_nz r2.x
              mov o0.xyzw, r0.xyzw
              ret 
            endif 
            div r0.xyz, r0.xyzx, r0.wwww
            div r1.xyz, r1.xyzx, r1.wwww
            ieq r2.x, cb0[0].x, l(7)
            if_nz r2.x
              eq r2.xyz, r1.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
              eq r3.xyz, r0.xyzx, l(0.000000, 0.000000, 0.000000, 0.000000)
              add r4.xyz, -r1.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
              div r4.xyz, r4.xyzx, r0.xyzx
              min r4.xyz, r4.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
              add r4.xyz, -r4.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
              movc r3.xyz, r3.xyzx, l(0,0,0,0), r4.xyzx
              movc r2.xyz, r2.xyzx, l(1.000000,1.000000,1.000000,0), r3.xyzx
            else 
              ieq r2.w, cb0[0].x, l(8)
              if_nz r2.w
                ge r3.xyz, l(0.500000, 0.500000, 0.500000, 0.000000), r0.xyzx
                add r4.xyz, r0.xyzx, r0.xyzx
                mul r4.xyz, r1.xyzx, r4.xyzx
                mad r5.xyz, r0.xyzx, l(2.000000, 2.000000, 2.000000, 0.000000), l(-1.000000, -1.000000, -1.000000, 0.000000)
                add r6.xyz, -r1.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                add r5.xyz, -r5.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                mad r5.xyz, -r6.xyzx, r5.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                movc r2.xyz, r3.xyzx, r4.xyzx, r5.xyzx
              else 
                ieq r2.w, cb0[0].x, l(9)
                if_nz r2.w
                  ge r3.xyz, l(0.250000, 0.250000, 0.250000, 0.000000), r1.xyzx
                  mad r4.xyz, r1.xyzx, l(16.000000, 16.000000, 16.000000, 0.000000), l(-12.000000, -12.000000, -12.000000, 0.000000)
                  mad r4.xyz, r4.xyzx, r1.xyzx, l(4.000000, 4.000000, 4.000000, 0.000000)
                  mul r4.xyz, r1.xyzx, r4.xyzx
                  sqrt r5.xyz, r1.xyzx
                  movc r3.xyz, r3.xyzx, r4.xyzx, r5.xyzx
                  ge r4.xyz, l(0.500000, 0.500000, 0.500000, 0.000000), r0.xyzx
                  mad r5.xyz, -r0.xyzx, l(2.000000, 2.000000, 2.000000, 0.000000), l(1.000000, 1.000000, 1.000000, 0.000000)
                  mul r5.xyz, r1.xyzx, r5.xyzx
                  add r6.xyz, -r1.xyzx, l(1.000000, 1.000000, 1.000000, 0.000000)
                  mad r5.xyz, -r5.xyzx, r6.xyzx, r1.xyzx
                  mad r6.xyz, r0.xyzx, l(2.000000, 2.000000, 2.000000, 0.000000), l(-1.000000, -1.000000, -1.000000, 0.000000)
                  add r3.xyz, -r1.xyzx, r3.xyzx
                  mad r3.xyz, r6.xyzx, r3.xyzx, r1.xyzx
                  movc r2.xyz, r4.xyzx, r5.xyzx, r3.xyzx
                else 
                  ieq r2.w, cb0[0].x, l(10)
                  add r3.xyz, r0.xyzx, -r1.xyzx
                  add r4.xyz, r0.xyzx, r1.xyzx
                  mul r1.xyz, r0.xyzx, r1.xyzx
                  mad r1.xyz, -r1.xyzx, l(2.000000, 2.000000, 2.000000, 0.000000), r4.xyzx
                  movc r2.xyz, r2.wwww, |r3.xyzx|, r1.xyzx
                endif 
              endif 
            endif 
            add r1.x, -r1.w, l(1.000000)
            mul r1.yzw, r1.wwww, r2.xxyz
            mad r0.xyz, r1.xxxx, r0.xyzx, r1.yzwy
            mul o0.xyz, r0.wwww, r0.xyzx
            mov o0.w, r0.w
            ret 
            // Approximately 66 instruction slots used
                    
        };
    }

}

technique10 SampleTextureForNonSeparableBlending
{
    pass P0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer $Globals
            // {
            //
            //   uint blendop;                      // Offset:    0 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sBckSampler                       sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // bcktex                            texture  float4          2d    1        1
            // $Globals                          cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             0         1  (UINT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c1, -12, -13, -14, 0
                def c2, 1, 0, 0, 0
                def c3, 0.300000012, 0.589999974, 0.109999999, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mov r0.y, c2.y
                mov r1.y, c2.y
                mov r2.z, c2.y
                texld r3, t0, s1
                texld r4, t0, s0
                rcp r0.w, r4.w
                mul r5.xyz, r0.w, r4
                mad r6.xy, r4.yxzw, r0.w, -r5.zyzw
                cmp r7.xy, r6.x, r5.yzzw, r5.zyzw
                max r1.w, r5.x, r7.x
                min r2.w, r7.y, r5.x
                add r7.w, r1.w, -r2.w
                rcp r1.w, r3.w
                mul r8.xyz, r1.w, r3
                mad r9.xy, r3.x, r1.w, -r8.zyzw
                rcp r2.w, r9.y
                mul r2.w, r2.w, r7.w
                mad r10, r3.zyyz, r1.w, -r8.xxzy
                mul r7.y, r2.w, r10.w
                mov r9.zw, r10
                cmp r1.xz, -r9.y, r9.yyww, r7.wyyw
                rcp r2.w, r9.x
                mul r2.w, r2.w, r7.w
                mul r7.x, r2.w, r9.z
                cmp r2.xy, -r9.x, r9.xzzw, r7.wxzw
                cmp r1.xyz, r9.w, r1, r2
                rcp r5.w, r9.w
                mul r5.w, r5.w, r7.w
                mul r7.z, r5.w, r9.y
                cmp r0.xz, -r10.w, r9.yyww, r7.zyww
                cmp r0.xyz, r10.x, r0, r1
                mov r1.x, c2.y
                mov r2.x, c2.y
                mov r11.z, c2.y
                rcp r2.w, r9.z
                mul r2.w, r2.w, r7.w
                mul r7.x, r2.w, r9.x
                cmp r11.xy, -r10.z, r9.xzzw, r7.xwzw
                rcp r2.w, r10.y
                mul r2.w, r2.w, r7.w
                mul r7.y, r2.w, r10.x
                cmp r2.yz, -r10.y, r10.xyxw, r7.xwyw
                cmp r2.xyz, r10.x, r2, r11
                rcp r2.w, r10.x
                mul r2.w, r2.w, r7.w
                mul r7.z, r2.w, r10.y
                cmp r1.yz, -r10.x, r10.xyxw, r7.xzww
                cmp r1.xyz, r9.w, r1, r2
                cmp r0.xyz, r10.y, r1, r0
                cmp r1.xy, r9.z, r8.yzzw, r8.zyzw
                dp3 r5.w, r0, c3
                dp3 r1.z, r8, c3
                add r5.w, -r5.w, r1.z
                add r0.xyz, r0, r5.w
                add r5.w, -r0.y, r0.x
                cmp r2.xy, r5.w, r0.yxzw, r0
                min r5.w, r0.z, r2.x
                max r7.x, r2.y, r0.z
                dp3 r2.x, r0, c3
                add r2.y, -r5.w, r2.x
                rcp r2.y, r2.y
                add r7.yzw, r0.xxyz, -r2.x
                mul r7.yzw, r2.x, r7
                mad r2.yzw, r7, r2.y, r2.x
                cmp r0.xyz, r5.w, r0, r2.yzww
                add r2.yzw, -r2.x, r0.xxyz
                add r5.w, -r2.x, c2.x
                mul r2.yzw, r2, r5.w
                add r5.w, -r2.x, r7.x
                add r7.x, -r7.x, c2.x
                rcp r5.w, r5.w
                mad r2.xyz, r2.yzww, r5.w, r2.x
                cmp r0.xyz, r7.x, r0, r2
                dp3 r5.w, r5, c3
                add r2.x, r1.z, -r5.w
                add r5.w, -r1.z, r5.w
                mad r2.yzw, r3.xxyz, r1.w, r5.w
                mad r3.xyz, r4, r0.w, r2.x
                mad r7, r4.zyzx, r0.w, -r5.xxyz
                add r0.w, -r3.y, r3.x
                cmp r8.yz, r0.w, r3.xyxw, r3.xxyw
                min r0.w, r3.z, r8.y
                max r1.w, r8.z, r3.z
                dp3 r5.w, r3, c3
                add r2.x, -r0.w, r5.w
                rcp r2.x, r2.x
                add r8.yzw, r3.xxyz, -r5.w
                mul r8.yzw, r5.w, r8
                mad r8.yzw, r8, r2.x, r5.w
                cmp r3.xyz, r0.w, r3, r8.yzww
                add r8.yzw, -r5.w, r3.xxyz
                add r0.w, -r5.w, c2.x
                mul r8.yzw, r0.w, r8
                add r0.w, r1.w, -r5.w
                add r1.w, -r1.w, c2.x
                rcp r0.w, r0.w
                mad r8.yzw, r8, r0.w, r5.w
                cmp r3.xyz, r1.w, r3, r8.yzww
                add r0.w, -r2.z, r2.y
                cmp r8.yz, r0.w, r2.xzyw, r2
                min r0.w, r2.w, r8.y
                max r1.w, r8.z, r2.w
                dp3 r5.w, r2.yzww, c3
                add r2.x, -r0.w, r5.w
                rcp r2.x, r2.x
                add r8.yzw, r2, -r5.w
                mul r8.yzw, r5.w, r8
                mad r8.yzw, r8, r2.x, r5.w
                cmp r2.xyz, r0.w, r2.yzww, r8.yzww
                add r8.yzw, -r5.w, r2.xxyz
                add r0.w, -r5.w, c2.x
                mul r8.yzw, r0.w, r8
                add r0.w, r1.w, -r5.w
                add r1.w, -r1.w, c2.x
                rcp r0.w, r0.w
                mad r8.yzw, r8, r0.w, r5.w
                cmp r2.xyz, r1.w, r2, r8.yzww
                mov r0.w, c0.x
                add r8.yzw, r0.w, c1.xxyz
                mul r8.yzw, r8, r8
                cmp r2.xyz, -r8.w, r3, r2
                cmp r0.xyz, -r8.z, r0, r2
                mov r2.y, c2.y
                mov r3.y, c2.y
                mov r9.z, c2.y
                max r0.w, r8.x, r1.x
                min r2.w, r1.y, r8.x
                add r10.w, r0.w, -r2.w
                rcp r0.w, r7.w
                mul r0.w, r0.w, r10.w
                mul r10.x, r0.w, r6.x
                mov r6.zw, r7.xywz
                cmp r9.xy, -r7.w, r6.zxzw, r10.wxzw
                rcp r0.w, r6.y
                mul r0.w, r0.w, r10.w
                mul r10.y, r0.w, r7.z
                cmp r3.xz, -r6.y, r6.yyww, r10.wyyw
                cmp r1.xyw, r7.z, r3.xyzz, r9.xyzz
                rcp r0.w, r7.z
                mul r0.w, r0.w, r10.w
                mul r10.z, r0.w, r6.y
                cmp r2.xz, -r7.z, r6.yyww, r10.zyww
                cmp r1.xyw, r7.x, r2.xyzz, r1
                mov r2.x, c2.y
                mov r3.z, c2.y
                rcp r0.w, r6.x
                mul r0.w, r0.w, r10.w
                mul r10.x, r0.w, r7.w
                cmp r3.xy, -r6.x, r6.zxzw, r10.xwzw
                rcp r0.w, r7.y
                mul r0.w, r0.w, r10.w
                mul r10.y, r0.w, r7.x
                cmp r2.yz, -r7.y, r7.xyxw, r10.xwyw
                cmp r2.xyz, r7.x, r2, r3
                mov r3.x, c2.y
                rcp r0.w, r7.x
                mul r0.w, r0.w, r10.w
                mul r10.z, r0.w, r7.y
                cmp r3.yz, -r7.x, r7.xyxw, r10.xzww
                cmp r2.xyz, r7.z, r3, r2
                cmp r1.xyw, r7.y, r2.xyzz, r1
                dp3 r0.w, r1.xyww, c3
                add r0.w, -r0.w, r1.z
                add r1.xyz, r0.w, r1.xyww
                add r0.w, -r1.y, r1.x
                cmp r2.xy, r0.w, r1.yxzw, r1
                min r0.w, r1.z, r2.x
                max r5.w, r2.y, r1.z
                dp3 r1.w, r1, c3
                add r2.xyz, -r1.w, r1
                mul r2.xyz, r1.w, r2
                add r2.w, -r0.w, r1.w
                rcp r2.w, r2.w
                mad r2.xyz, r2, r2.w, r1.w
                cmp r1.xyz, r0.w, r1, r2
                add r2.xyz, -r1.w, r1
                add r0.w, -r1.w, c2.x
                mul r2.xyz, r0.w, r2
                add r0.w, -r1.w, r5.w
                add r2.w, -r5.w, c2.x
                rcp r0.w, r0.w
                mad r2.xyz, r2, r0.w, r1.w
                cmp r1.xyz, r2.w, r1, r2
                cmp r0.xyz, -r8.y, r1, r0
                lrp r1.xyz, r3.w, r0, r5
                mul r1.w, r3.w, r3.w
                cmp r1.w, -r1.w, c2.x, c2.y
                mul r0.xyz, r4.w, r1
                mul r0.w, r4.w, r4.w
                cmp r0.w, -r0.w, c2.x, c2.y
                add r0.w, r1.w, r0.w
                cmp r4.xyz, -r0.w, r0, r4
                mov oC0, r4
            
            // approximately 193 instruction slots used (2 texture, 191 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[1], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_temps 9
            sample r0.xyzw, v1.xyxx, t0.xyzw, s0
            sample r1.xyzw, v1.xyxx, t1.xyzw, s1
            eq r2.x, r0.w, l(0.000000)
            eq r2.y, r1.w, l(0.000000)
            or r2.x, r2.y, r2.x
            if_nz r2.x
              mov o0.xyzw, r0.xyzw
              ret 
            endif 
            div r0.xyz, r0.xyzx, r0.wwww
            div r1.xyz, r1.xyzx, r1.wwww
            ieq r2.x, cb0[0].x, l(12)
            if_nz r2.x
              max r2.x, r1.z, r1.y
              max r2.x, r1.x, r2.x
              min r2.y, r1.z, r1.y
              min r2.y, r1.x, r2.y
              add r2.w, -r2.y, r2.x
              ge r3.x, r0.y, r0.x
              if_nz r3.x
                add r3.xyzw, -r0.xxzz, r0.yzxy
                lt r4.xyz, l(0.000000, 0.000000, 0.000000, 0.000000), r3.yxwy
                div r5.xyz, r2.wwww, r3.yxwy
                mul r2.xyz, r3.xyzx, r5.xyzx
                movc r5.yz, r4.xxxx, r2.xxwx, r3.xxyx
                ge r4.xw, r0.zzzz, r0.yyyx
                movc r6.yz, r4.yyyy, r2.wwyw, r3.xxyx
                movc r3.xy, r4.zzzz, r2.zwzz, r3.zwzz
                mov r6.x, l(0)
                mov r3.z, l(0)
                movc r3.xyz, r4.wwww, r6.xyzx, r3.xyzx
                mov r5.x, l(0)
                movc r3.xyz, r4.xxxx, r5.xyzx, r3.xyzx
              else 
                add r4.xyzw, -r0.yyzz, r0.xzyx
                lt r5.xyz, l(0.000000, 0.000000, 0.000000, 0.000000), r4.yxwy
                div r6.xyz, r2.wwww, r4.yxwy
                mul r2.xyz, r4.xyzx, r6.xyzx
                movc r6.xz, r5.xxxx, r2.xxwx, r4.xxyx
                ge r5.xw, r0.zzzz, r0.xxxy
                movc r7.xz, r5.yyyy, r2.wwyw, r4.xxyx
                movc r2.xy, r5.zzzz, r2.wzww, r4.wzww
                mov r7.y, l(0)
                mov r2.z, l(0)
                movc r2.xyz, r5.wwww, r7.xyzx, r2.xyzx
                mov r6.y, l(0)
                movc r3.xyz, r5.xxxx, r6.xyzx, r2.xyzx
              endif 
              dp3 r2.x, r1.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
              dp3 r2.y, r3.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
              add r2.x, -r2.y, r2.x
              add r2.xyz, r2.xxxx, r3.xyzx
              dp3 r2.w, r2.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
              min r3.x, r2.y, r2.x
              min r3.x, r2.z, r3.x
              max r3.y, r2.y, r2.x
              max r3.y, r2.z, r3.y
              lt r3.z, r3.x, l(0.000000)
              add r4.xyz, -r2.wwww, r2.xyzx
              mul r4.xyz, r2.wwww, r4.xyzx
              add r3.x, r2.w, -r3.x
              div r4.xyz, r4.xyzx, r3.xxxx
              add r4.xyz, r2.wwww, r4.xyzx
              movc r2.xyz, r3.zzzz, r4.xyzx, r2.xyzx
              lt r3.x, l(1.000000), r3.y
              add r4.xyz, -r2.wwww, r2.xyzx
              add r3.z, -r2.w, l(1.000000)
              mul r4.xyz, r3.zzzz, r4.xyzx
              add r3.y, -r2.w, r3.y
              div r3.yzw, r4.xxyz, r3.yyyy
              add r3.yzw, r2.wwww, r3.yyzw
              movc r2.xyz, r3.xxxx, r3.yzwy, r2.xyzx
            else 
              ieq r2.w, cb0[0].x, l(13)
              if_nz r2.w
                max r2.w, r0.z, r0.y
                max r2.w, r0.x, r2.w
                min r3.x, r0.z, r0.y
                min r3.x, r0.x, r3.x
                add r3.w, r2.w, -r3.x
                ge r2.w, r1.y, r1.x
                if_nz r2.w
                  add r4.xyzw, -r1.xxzz, r1.yzxy
                  lt r5.xyz, l(0.000000, 0.000000, 0.000000, 0.000000), r4.yxwy
                  div r6.xyz, r3.wwww, r4.yxwy
                  mul r3.xyz, r4.xyzx, r6.xyzx
                  movc r6.yz, r5.xxxx, r3.xxwx, r4.xxyx
                  ge r5.xw, r1.zzzz, r1.yyyx
                  movc r7.yz, r5.yyyy, r3.wwyw, r4.xxyx
                  movc r4.xy, r5.zzzz, r3.zwzz, r4.zwzz
                  mov r7.x, l(0)
                  mov r4.z, l(0)
                  movc r4.xyz, r5.wwww, r7.xyzx, r4.xyzx
                  mov r6.x, l(0)
                  movc r4.xyz, r5.xxxx, r6.xyzx, r4.xyzx
                else 
                  add r5.xyzw, -r1.yyzz, r1.xzyx
                  lt r6.xyz, l(0.000000, 0.000000, 0.000000, 0.000000), r5.yxwy
                  div r7.xyz, r3.wwww, r5.yxwy
                  mul r3.xyz, r5.xyzx, r7.xyzx
                  movc r7.xz, r6.xxxx, r3.xxwx, r5.xxyx
                  ge r6.xw, r1.zzzz, r1.xxxy
                  movc r8.xz, r6.yyyy, r3.wwyw, r5.xxyx
                  movc r3.xy, r6.zzzz, r3.wzww, r5.wzww
                  mov r8.y, l(0)
                  mov r3.z, l(0)
                  movc r3.xyz, r6.wwww, r8.xyzx, r3.xyzx
                  mov r7.y, l(0)
                  movc r4.xyz, r6.xxxx, r7.xyzx, r3.xyzx
                endif 
                dp3 r2.w, r1.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                dp3 r3.x, r4.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                add r2.w, r2.w, -r3.x
                add r3.xyz, r2.wwww, r4.xyzx
                dp3 r2.w, r3.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                min r3.w, r3.y, r3.x
                min r3.w, r3.z, r3.w
                max r4.x, r3.y, r3.x
                max r4.x, r3.z, r4.x
                lt r4.y, r3.w, l(0.000000)
                add r5.xyz, -r2.wwww, r3.xyzx
                mul r5.xyz, r2.wwww, r5.xyzx
                add r3.w, r2.w, -r3.w
                div r5.xyz, r5.xyzx, r3.wwww
                add r5.xyz, r2.wwww, r5.xyzx
                movc r3.xyz, r4.yyyy, r5.xyzx, r3.xyzx
                lt r3.w, l(1.000000), r4.x
                add r4.yzw, -r2.wwww, r3.xxyz
                add r5.x, -r2.w, l(1.000000)
                mul r4.yzw, r4.yyzw, r5.xxxx
                add r4.x, -r2.w, r4.x
                div r4.xyz, r4.yzwy, r4.xxxx
                add r4.xyz, r2.wwww, r4.xyzx
                movc r2.xyz, r3.wwww, r4.xyzx, r3.xyzx
              else 
                ieq r2.w, cb0[0].x, l(14)
                if_nz r2.w
                  dp3 r2.w, r1.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                  dp3 r3.x, r0.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                  add r2.w, r2.w, -r3.x
                  add r3.xyz, r0.xyzx, r2.wwww
                  dp3 r2.w, r3.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                  min r3.w, r3.y, r3.x
                  min r3.w, r3.z, r3.w
                  max r4.x, r3.y, r3.x
                  max r4.x, r3.z, r4.x
                  lt r4.y, r3.w, l(0.000000)
                  add r5.xyz, -r2.wwww, r3.xyzx
                  mul r5.xyz, r2.wwww, r5.xyzx
                  add r3.w, r2.w, -r3.w
                  div r5.xyz, r5.xyzx, r3.wwww
                  add r5.xyz, r2.wwww, r5.xyzx
                  movc r3.xyz, r4.yyyy, r5.xyzx, r3.xyzx
                  lt r3.w, l(1.000000), r4.x
                  add r4.yzw, -r2.wwww, r3.xxyz
                  add r5.x, -r2.w, l(1.000000)
                  mul r4.yzw, r4.yyzw, r5.xxxx
                  add r4.x, -r2.w, r4.x
                  div r4.xyz, r4.yzwy, r4.xxxx
                  add r4.xyz, r2.wwww, r4.xyzx
                  movc r2.xyz, r3.wwww, r4.xyzx, r3.xyzx
                else 
                  dp3 r2.w, r0.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                  dp3 r3.x, r1.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                  add r2.w, r2.w, -r3.x
                  add r1.xyz, r1.xyzx, r2.wwww
                  dp3 r2.w, r1.xyzx, l(0.300000, 0.590000, 0.110000, 0.000000)
                  min r3.x, r1.y, r1.x
                  min r3.x, r1.z, r3.x
                  max r3.y, r1.y, r1.x
                  max r3.y, r1.z, r3.y
                  lt r3.z, r3.x, l(0.000000)
                  add r4.xyz, r1.xyzx, -r2.wwww
                  mul r4.xyz, r2.wwww, r4.xyzx
                  add r3.x, r2.w, -r3.x
                  div r4.xyz, r4.xyzx, r3.xxxx
                  add r4.xyz, r2.wwww, r4.xyzx
                  movc r1.xyz, r3.zzzz, r4.xyzx, r1.xyzx
                  lt r3.x, l(1.000000), r3.y
                  add r4.xyz, -r2.wwww, r1.xyzx
                  add r3.z, -r2.w, l(1.000000)
                  mul r4.xyz, r3.zzzz, r4.xyzx
                  add r3.y, -r2.w, r3.y
                  div r3.yzw, r4.xxyz, r3.yyyy
                  add r3.yzw, r2.wwww, r3.yyzw
                  movc r2.xyz, r3.xxxx, r3.yzwy, r1.xyzx
                endif 
              endif 
            endif 
            add r1.x, -r1.w, l(1.000000)
            mul r1.yzw, r1.wwww, r2.xxyz
            mad r0.xyz, r1.xxxx, r0.xyzx, r1.yzwy
            mul o0.xyz, r0.wwww, r0.xyzx
            mov o0.w, r0.w
            ret 
            // Approximately 195 instruction slots used
                    
        };
    }

}

technique10 SampleRadialGradient
{
    pass APos
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c3, 0.5, 0, 0, 0
                def c4, 1, -1, 0, -0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -c2.x
                mul r0.w, r0.w, c1.z
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                mad r0.y, r0.x, r0.x, -r0.w
                abs r0.z, r0.y
                rsq r0.z, r0.z
                rcp r1.x, r0.z
                mov r1.yz, -r1.x
                add r0.xzw, r0.x, r1.xyyz
                rcp r1.x, c1.z
                mul r0.xzw, r0, r1.x
                mov r1.w, c1.w
                mad r1.xyz, r0.xzww, c0.z, r1.w
                cmp r2.x, r1.x, r0.x, r0.w
                cmp r0.xzw, r1.xyyz, c4.xyxy, c4.zyzw
                mov r2.y, c3.x
                texld r1, t0, s1
                texld r2, r2, s0
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                add r0.w, r0.w, r0.x
                cmp r0.x, r0.w, r0.x, r0.z
                cmp r1, -r0.x, c4.z, r1
                cmp r0, r0.y, r1, c4.z
                mov oC0, r0
            
            // approximately 28 instruction slots used (2 texture, 26 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[7], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 3
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            add r0.x, r0.x, -cb0[6].x
            mul r0.x, r0.x, cb0[5].z
            mad r0.x, r0.z, r0.z, -r0.x
            lt r0.y, r0.x, l(0.000000)
            sqrt r1.x, |r0.x|
            mov r1.y, -r1.x
            add r0.xz, r0.zzzz, r1.xxyx
            div r0.xz, r0.xxzx, cb0[5].zzzz
            mul r1.xy, r0.xzxx, cb0[4].zzzz
            ge r1.xy, r1.xyxx, -cb0[5].wwww
            and r1.xy, r1.xyxx, l(0x3f800000, 0x3f800000, 0, 0)
            add r0.x, -r0.z, r0.x
            mad r2.x, r1.x, r0.x, r0.z
            mov r2.y, l(0.500000)
            sample r2.xyzw, r2.xyxx, t0.xyzw, s0
            if_nz r0.y
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            max r0.x, r1.y, r1.x
            ge r0.x, l(0.000000), r0.x
            if_nz r0.x
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r2.xyz, r2.wwww, r2.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r2.xyzw
            ret 
            // Approximately 33 instruction slots used
                    
        };
    }

    pass A0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         2  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c2, 0.5, 0, 0, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mul r0.w, c1.w, c1.w
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -r0.w
                mul r0.w, r0.w, c2.x
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                rcp r0.x, r0.x
                mul r0.x, r0.x, r0.w
                mov r0.y, c2.x
                texld r1, t0, s1
                texld r2, r0, s0
                mov r0.w, c1.w
                mad r0.x, r0.x, -c0.z, -r0.w
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                cmp r0, r0.x, c2.y, r1
                mov oC0, r0
            
            // approximately 18 instruction slots used (2 texture, 16 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[6], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 2
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            mad r0.x, -cb0[5].w, cb0[5].w, r0.x
            mul r0.x, r0.x, l(0.500000)
            div r0.x, r0.x, r0.z
            mul r0.z, r0.x, cb0[4].z
            ge r0.z, -cb0[5].w, r0.z
            mov r0.y, l(0.500000)
            sample r1.xyzw, r0.xyxx, t0.xyzw, s0
            if_nz r0.z
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r1.xyz, r1.wwww, r1.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r1.xyzw
            ret 
            // Approximately 19 instruction slots used
                    
        };
    }

    pass APosWrap
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sWrapSampler                      sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c3, 0.5, 0, 0, 0
                def c4, 1, -1, 0, -0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -c2.x
                mul r0.w, r0.w, c1.z
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                mad r0.y, r0.x, r0.x, -r0.w
                abs r0.z, r0.y
                rsq r0.z, r0.z
                rcp r1.x, r0.z
                mov r1.yz, -r1.x
                add r0.xzw, r0.x, r1.xyyz
                rcp r1.x, c1.z
                mul r0.xzw, r0, r1.x
                mov r1.w, c1.w
                mad r1.xyz, r0.xzww, c0.z, r1.w
                cmp r2.x, r1.x, r0.x, r0.w
                cmp r0.xzw, r1.xyyz, c4.xyxy, c4.zyzw
                mov r2.y, c3.x
                texld r1, t0, s1
                texld r2, r2, s0
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                add r0.w, r0.w, r0.x
                cmp r0.x, r0.w, r0.x, r0.z
                cmp r1, -r0.x, c4.z, r1
                cmp r0, r0.y, r1, c4.z
                mov oC0, r0
            
            // approximately 28 instruction slots used (2 texture, 26 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[7], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 3
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            add r0.x, r0.x, -cb0[6].x
            mul r0.x, r0.x, cb0[5].z
            mad r0.x, r0.z, r0.z, -r0.x
            lt r0.y, r0.x, l(0.000000)
            sqrt r1.x, |r0.x|
            mov r1.y, -r1.x
            add r0.xz, r0.zzzz, r1.xxyx
            div r0.xz, r0.xxzx, cb0[5].zzzz
            mul r1.xy, r0.xzxx, cb0[4].zzzz
            ge r1.xy, r1.xyxx, -cb0[5].wwww
            and r1.xy, r1.xyxx, l(0x3f800000, 0x3f800000, 0, 0)
            add r0.x, -r0.z, r0.x
            mad r2.x, r1.x, r0.x, r0.z
            mov r2.y, l(0.500000)
            sample r2.xyzw, r2.xyxx, t0.xyzw, s0
            if_nz r0.y
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            max r0.x, r1.y, r1.x
            ge r0.x, l(0.000000), r0.x
            if_nz r0.x
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r2.xyz, r2.wwww, r2.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r2.xyzw
            ret 
            // Approximately 33 instruction slots used
                    
        };
    }

    pass A0Wrap
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sWrapSampler                      sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         2  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c2, 0.5, 0, 0, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mul r0.w, c1.w, c1.w
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -r0.w
                mul r0.w, r0.w, c2.x
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                rcp r0.x, r0.x
                mul r0.x, r0.x, r0.w
                mov r0.y, c2.x
                texld r1, t0, s1
                texld r2, r0, s0
                mov r0.w, c1.w
                mad r0.x, r0.x, -c0.z, -r0.w
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                cmp r0, r0.x, c2.y, r1
                mov oC0, r0
            
            // approximately 18 instruction slots used (2 texture, 16 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[6], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 2
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            mad r0.x, -cb0[5].w, cb0[5].w, r0.x
            mul r0.x, r0.x, l(0.500000)
            div r0.x, r0.x, r0.z
            mul r0.z, r0.x, cb0[4].z
            ge r0.z, -cb0[5].w, r0.z
            mov r0.y, l(0.500000)
            sample r1.xyzw, r0.xyxx, t0.xyzw, s0
            if_nz r0.z
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r1.xyz, r1.wwww, r1.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r1.xyzw
            ret 
            // Approximately 19 instruction slots used
                    
        };
    }

    pass APosMirror
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sMirrorSampler                    sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c3, 0.5, 0, 0, 0
                def c4, 1, -1, 0, -0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -c2.x
                mul r0.w, r0.w, c1.z
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                mad r0.y, r0.x, r0.x, -r0.w
                abs r0.z, r0.y
                rsq r0.z, r0.z
                rcp r1.x, r0.z
                mov r1.yz, -r1.x
                add r0.xzw, r0.x, r1.xyyz
                rcp r1.x, c1.z
                mul r0.xzw, r0, r1.x
                mov r1.w, c1.w
                mad r1.xyz, r0.xzww, c0.z, r1.w
                cmp r2.x, r1.x, r0.x, r0.w
                cmp r0.xzw, r1.xyyz, c4.xyxy, c4.zyzw
                mov r2.y, c3.x
                texld r1, t0, s1
                texld r2, r2, s0
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                add r0.w, r0.w, r0.x
                cmp r0.x, r0.w, r0.x, r0.z
                cmp r1, -r0.x, c4.z, r1
                cmp r0, r0.y, r1, c4.z
                mov oC0, r0
            
            // approximately 28 instruction slots used (2 texture, 26 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[7], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 3
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            add r0.x, r0.x, -cb0[6].x
            mul r0.x, r0.x, cb0[5].z
            mad r0.x, r0.z, r0.z, -r0.x
            lt r0.y, r0.x, l(0.000000)
            sqrt r1.x, |r0.x|
            mov r1.y, -r1.x
            add r0.xz, r0.zzzz, r1.xxyx
            div r0.xz, r0.xxzx, cb0[5].zzzz
            mul r1.xy, r0.xzxx, cb0[4].zzzz
            ge r1.xy, r1.xyxx, -cb0[5].wwww
            and r1.xy, r1.xyxx, l(0x3f800000, 0x3f800000, 0, 0)
            add r0.x, -r0.z, r0.x
            mad r2.x, r1.x, r0.x, r0.z
            mov r2.y, l(0.500000)
            sample r2.xyzw, r2.xyxx, t0.xyzw, s0
            if_nz r0.y
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            max r0.x, r1.y, r1.x
            ge r0.x, l(0.000000), r0.x
            if_nz r0.x
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r2.xyz, r2.wwww, r2.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r2.xyzw
            ret 
            // Approximately 33 instruction slots used
                    
        };
    }

    pass A0Mirror
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44
            //   float2 dimensions;                 // Offset:   48 Size:     8
            //   float3 diff;                       // Offset:   64 Size:    12 [unused]
            //   float2 center1;                    // Offset:   80 Size:     8 [unused]
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4 [unused]
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            // cb2                               cbuffer      NA          NA    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         1  ( FLT, FLT, FLT, FLT)
            // c2         cb0             2         1  ( FLT, FLT, FLT, FLT)
            // c3         cb1             0         2  ( FLT, FLT, FLT, FLT)
            // c5         cb1             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c6, 1, 0.5, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad r0.xy, v0, c1.zwzw, c1
                add r0.z, r0.x, c6.x
                mul r0.z, r0.z, c5.x
                mul r1.x, r0.z, c6.y
                add r0.z, -r0.y, c6.x
                add oPos.xy, r0, c0
                mul r0.x, r0.z, c5.y
                mul r1.y, r0.x, c6.y
                mov r1.z, c6.x
                dp3 oT0.w, r1, c3
                dp3 oT0.z, r1, c4
                mov oPos.zw, c6.xyzx
            
            // approximately 13 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_constantbuffer cb1[4], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            dcl_temps 2
            mov o0.zw, l(0,0,0,1.000000)
            mad r0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.xy, r0.xyxx
            add r0.x, r0.x, l(1.000000)
            add r0.y, -r0.y, l(1.000000)
            mul r0.xy, r0.xyxx, cb1[3].xyxx
            mul r1.xy, r0.xyxx, l(0.500000, 0.500000, 0.000000, 0.000000)
            mov r1.z, l(1.000000)
            dp3 o1.z, r1.xyzx, cb1[0].xyzx
            dp3 o1.w, r1.xyzx, cb1[1].xyzx
            mad o1.xy, v0.xyxx, cb0[2].zwzz, cb0[2].xyxx
            ret 
            // Approximately 12 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb2
            // {
            //
            //   float3x3 DeviceSpaceToUserSpace;   // Offset:    0 Size:    44 [unused]
            //   float2 dimensions;                 // Offset:   48 Size:     8 [unused]
            //   float3 diff;                       // Offset:   64 Size:    12
            //   float2 center1;                    // Offset:   80 Size:     8
            //   float A;                           // Offset:   88 Size:     4 [unused]
            //   float radius1;                     // Offset:   92 Size:     4
            //   float sq_radius1;                  // Offset:   96 Size:     4 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sMirrorSampler                    sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb2                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             4         2  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c2, 0.5, 0, 0, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mul r0.w, c1.w, c1.w
                add r0.xy, t0.wzzw, -c1
                dp2add r0.w, r0, r0, -r0.w
                mul r0.w, r0.w, c2.x
                mov r0.z, c1.w
                dp3 r0.x, r0, c0
                rcp r0.x, r0.x
                mul r0.x, r0.x, r0.w
                mov r0.y, c2.x
                texld r1, t0, s1
                texld r2, r0, s0
                mov r0.w, c1.w
                mad r0.x, r0.x, -c0.z, -r0.w
                mul r2.xyz, r2.w, r2
                mul r1, r1.w, r2
                cmp r0, r0.x, c2.y, r1
                mov oC0, r0
            
            // approximately 18 instruction slots used (2 texture, 16 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[6], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 2
            add r0.xy, v1.zwzz, -cb0[5].xyxx
            mov r0.z, cb0[5].w
            dp3 r0.z, r0.xyzx, cb0[4].xyzx
            dp2 r0.x, r0.xyxx, r0.xyxx
            mad r0.x, -cb0[5].w, cb0[5].w, r0.x
            mul r0.x, r0.x, l(0.500000)
            div r0.x, r0.x, r0.z
            mul r0.z, r0.x, cb0[4].z
            ge r0.z, -cb0[5].w, r0.z
            mov r0.y, l(0.500000)
            sample r1.xyzw, r0.xyxx, t0.xyzw, s0
            if_nz r0.z
              mov o0.xyzw, l(0,0,0,0)
              ret 
            endif 
            mul r1.xyz, r1.wwww, r1.xyzx
            sample r0.xyzw, v1.xyxx, t1.xyzw, s1
            mul o0.xyzw, r0.wwww, r1.xyzw
            ret 
            // Approximately 19 instruction slots used
                    
        };
    }

}

technique10 SampleMaskedTexture
{
    pass P0
    {
        RasterizerState = TextureRast;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mov r0.xy, t0.wzzw
                texld r1, t0, s0
                texld r0, r0, s1
                mul r0, r0.w, r1
                mov oC0, r0
            
            // approximately 5 instruction slots used (2 texture, 3 arithmetic)
            ps_4_0
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 2
            sample r0.xyzw, v1.xyxx, t0.xyzw, s0
            sample r1.xyzw, v1.zwzz, t1.xyzw, s1
            mul o0.xyzw, r0.xyzw, r1.wwww
            ret 
            // Approximately 4 instruction slots used
                    
        };
    }

}

technique10 SampleTextureWithShadow
{
    pass P0
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(1, 1, 1, 1);
        AB_SampleMask = uint(0xffffffff);
        BlendState = ShadowBlendH;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb1
            // {
            //
            //   float4 BlurOffsetsH[3];            // Offset:    0 Size:    48
            //   float4 BlurOffsetsV[3];            // Offset:   48 Size:    48 [unused]
            //   float4 BlurWeights[3];             // Offset:   96 Size:    48
            //   float4 ShadowColor;                // Offset:  144 Size:    16
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sShadowSampler                    sampler      NA          NA    0        1
            // tex                               texture  float4          2d    0        1
            // cb1                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             0         3  ( FLT, FLT, FLT, FLT)
            // c3         cb0             6         4  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                add r0.x, t0.x, c0.y
                mov r0.y, t0.y
                add r1.x, t0.x, c0.x
                mov r1.y, t0.y
                texld r0, r0, s0
                texld r1, r1, s0
                mul r0.x, r0.w, c3.y
                mad r0.x, c3.x, r1.w, r0.x
                add r1.x, t0.x, c0.z
                mov r1.y, t0.y
                add r2.x, t0.x, c0.w
                mov r2.y, t0.y
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0.x, c3.z, r1.w, r0.x
                mad r0.x, c3.w, r2.w, r0.x
                add r1.x, t0.x, c1.x
                mov r1.y, t0.y
                add r2.x, t0.x, c1.y
                mov r2.y, t0.y
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0.x, c4.x, r1.w, r0.x
                mad r0.x, c4.y, r2.w, r0.x
                add r1.x, t0.x, c1.z
                mov r1.y, t0.y
                add r2.x, t0.x, c1.w
                mov r2.y, t0.y
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0.x, c4.z, r1.w, r0.x
                mad r0.x, c4.w, r2.w, r0.x
                add r1.x, t0.x, c2.x
                mov r1.y, t0.y
                texld r1, r1, s0
                mad r0.x, c5.x, r1.w, r0.x
                mul r0, r0.x, c6
                mov oC0, r0
            
            // approximately 38 instruction slots used (9 texture, 29 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[10], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_temps 4
            add r0.xyzw, v1.xxxx, cb0[0].zxwy
            mov r1.xz, r0.yywy
            mov r1.yw, v1.yyyy
            sample r2.xyzw, r1.zwzz, t0.xyzw, s0
            sample r1.xyzw, r1.xyxx, t0.xyzw, s0
            mul r1.x, r2.w, cb0[6].y
            mad r1.x, cb0[6].x, r1.w, r1.x
            mov r0.yw, v1.yyyy
            sample r2.xyzw, r0.xyxx, t0.xyzw, s0
            sample r0.xyzw, r0.zwzz, t0.xyzw, s0
            mad r0.x, cb0[6].z, r2.w, r1.x
            mad r0.x, cb0[6].w, r0.w, r0.x
            add r1.xyzw, v1.xxxx, cb0[1].zxwy
            mov r2.xz, r1.yywy
            mov r2.yw, v1.yyyy
            sample r3.xyzw, r2.xyxx, t0.xyzw, s0
            sample r2.xyzw, r2.zwzz, t0.xyzw, s0
            mad r0.x, cb0[7].x, r3.w, r0.x
            mad r0.x, cb0[7].y, r2.w, r0.x
            mov r1.yw, v1.yyyy
            sample r2.xyzw, r1.xyxx, t0.xyzw, s0
            sample r1.xyzw, r1.zwzz, t0.xyzw, s0
            mad r0.x, cb0[7].z, r2.w, r0.x
            mad r0.x, cb0[7].w, r1.w, r0.x
            add r1.x, v1.x, cb0[2].x
            mov r1.y, v1.y
            sample r1.xyzw, r1.xyxx, t0.xyzw, s0
            mad r0.x, cb0[8].x, r1.w, r0.x
            mul o0.xyzw, r0.xxxx, cb0[9].xyzw
            ret 
            // Approximately 30 instruction slots used
                    
        };
    }

    pass P1
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(1, 1, 1, 1);
        AB_SampleMask = uint(0xffffffff);
        BlendState = ShadowBlendV;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb1
            // {
            //
            //   float4 BlurOffsetsH[3];            // Offset:    0 Size:    48 [unused]
            //   float4 BlurOffsetsV[3];            // Offset:   48 Size:    48
            //   float4 BlurWeights[3];             // Offset:   96 Size:    48
            //   float4 ShadowColor;                // Offset:  144 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sShadowSampler                    sampler      NA          NA    0        1
            // tex                               texture  float4          2d    0        1
            // cb1                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             3         6  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                add r0.y, t0.y, c0.y
                mov r0.x, t0.x
                add r1.y, t0.y, c0.x
                mov r1.x, t0.x
                texld r0, r0, s0
                texld r1, r1, s0
                mul r0, r0, c3.y
                mad r0, c3.x, r1, r0
                add r1.y, t0.y, c0.z
                mov r1.x, t0.x
                add r2.y, t0.y, c0.w
                mov r2.x, t0.x
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0, c3.z, r1, r0
                mad r0, c3.w, r2, r0
                add r1.y, t0.y, c1.x
                mov r1.x, t0.x
                add r2.y, t0.y, c1.y
                mov r2.x, t0.x
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0, c4.x, r1, r0
                mad r0, c4.y, r2, r0
                add r1.y, t0.y, c1.z
                mov r1.x, t0.x
                add r2.y, t0.y, c1.w
                mov r2.x, t0.x
                texld r1, r1, s0
                texld r2, r2, s0
                mad r0, c4.z, r1, r0
                mad r0, c4.w, r2, r0
                add r1.y, t0.y, c2.x
                mov r1.x, t0.x
                texld r1, r1, s0
                mad r0, c5.x, r1, r0
                mov oC0, r0
            
            // approximately 37 instruction slots used (9 texture, 28 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[9], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_temps 4
            mov r0.xz, v1.xxxx
            add r1.xyzw, v1.yyyy, cb0[3].xzyw
            mov r0.yw, r1.xxxz
            sample r2.xyzw, r0.zwzz, t0.xyzw, s0
            sample r0.xyzw, r0.xyxx, t0.xyzw, s0
            mul r2.xyzw, r2.xyzw, cb0[6].yyyy
            mad r0.xyzw, cb0[6].xxxx, r0.xyzw, r2.xyzw
            mov r1.xz, v1.xxxx
            sample r2.xyzw, r1.xyxx, t0.xyzw, s0
            sample r1.xyzw, r1.zwzz, t0.xyzw, s0
            mad r0.xyzw, cb0[6].zzzz, r2.xyzw, r0.xyzw
            mad r0.xyzw, cb0[6].wwww, r1.xyzw, r0.xyzw
            mov r1.xz, v1.xxxx
            add r2.xyzw, v1.yyyy, cb0[4].xzyw
            mov r1.yw, r2.xxxz
            sample r3.xyzw, r1.xyxx, t0.xyzw, s0
            sample r1.xyzw, r1.zwzz, t0.xyzw, s0
            mad r0.xyzw, cb0[7].xxxx, r3.xyzw, r0.xyzw
            mad r0.xyzw, cb0[7].yyyy, r1.xyzw, r0.xyzw
            mov r2.xz, v1.xxxx
            sample r1.xyzw, r2.xyxx, t0.xyzw, s0
            sample r2.xyzw, r2.zwzz, t0.xyzw, s0
            mad r0.xyzw, cb0[7].zzzz, r1.xyzw, r0.xyzw
            mad r0.xyzw, cb0[7].wwww, r2.xyzw, r0.xyzw
            add r1.y, v1.y, cb0[5].x
            mov r1.x, v1.x
            sample r1.xyzw, r1.xyxx, t0.xyzw, s0
            mad o0.xyzw, cb0[8].xxxx, r1.xyzw, r0.xyzw
            ret 
            // Approximately 29 instruction slots used
                    
        };
    }

    pass P2
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(1, 1, 1, 1);
        AB_SampleMask = uint(0xffffffff);
        BlendState = ShadowBlendV;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb1
            // {
            //
            //   float4 BlurOffsetsH[3];            // Offset:    0 Size:    48 [unused]
            //   float4 BlurOffsetsV[3];            // Offset:   48 Size:    48
            //   float4 BlurWeights[3];             // Offset:   96 Size:    48
            //   float4 ShadowColor;                // Offset:  144 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sMaskSampler                      sampler      NA          NA    0        1
            // sShadowSampler                    sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb1                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             3         6  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t1               
            // s1             s1              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                dcl t0
                dcl_2d s0
                dcl_2d s1
                add r0.y, t0.y, c0.y
                mov r0.x, t0.x
                add r1.y, t0.y, c0.x
                mov r1.x, t0.x
                texld r0, r0, s1
                texld r1, r1, s1
                mul r0, r0, c3.y
                mad r0, c3.x, r1, r0
                add r1.y, t0.y, c0.z
                mov r1.x, t0.x
                add r2.y, t0.y, c0.w
                mov r2.x, t0.x
                texld r1, r1, s1
                texld r2, r2, s1
                mad r0, c3.z, r1, r0
                mad r0, c3.w, r2, r0
                add r1.y, t0.y, c1.x
                mov r1.x, t0.x
                add r2.y, t0.y, c1.y
                mov r2.x, t0.x
                texld r1, r1, s1
                texld r2, r2, s1
                mad r0, c4.x, r1, r0
                mad r0, c4.y, r2, r0
                add r1.y, t0.y, c1.z
                mov r1.x, t0.x
                add r2.y, t0.y, c1.w
                mov r2.x, t0.x
                texld r1, r1, s1
                texld r2, r2, s1
                mad r0, c4.z, r1, r0
                mad r0, c4.w, r2, r0
                add r1.y, t0.y, c2.x
                mov r1.x, t0.x
                mov r2.xy, t0.wzzw
                texld r1, r1, s1
                texld r2, r2, s0
                mad r0, c5.x, r1, r0
                mul r0, r2.w, r0
                mov oC0, r0
            
            // approximately 40 instruction slots used (10 texture, 30 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[9], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_temps 4
            mov r0.xz, v1.xxxx
            add r1.xyzw, v1.yyyy, cb0[3].xzyw
            mov r0.yw, r1.xxxz
            sample r2.xyzw, r0.zwzz, t0.xyzw, s1
            sample r0.xyzw, r0.xyxx, t0.xyzw, s1
            mul r2.xyzw, r2.xyzw, cb0[6].yyyy
            mad r0.xyzw, cb0[6].xxxx, r0.xyzw, r2.xyzw
            mov r1.xz, v1.xxxx
            sample r2.xyzw, r1.xyxx, t0.xyzw, s1
            sample r1.xyzw, r1.zwzz, t0.xyzw, s1
            mad r0.xyzw, cb0[6].zzzz, r2.xyzw, r0.xyzw
            mad r0.xyzw, cb0[6].wwww, r1.xyzw, r0.xyzw
            mov r1.xz, v1.xxxx
            add r2.xyzw, v1.yyyy, cb0[4].xzyw
            mov r1.yw, r2.xxxz
            sample r3.xyzw, r1.xyxx, t0.xyzw, s1
            sample r1.xyzw, r1.zwzz, t0.xyzw, s1
            mad r0.xyzw, cb0[7].xxxx, r3.xyzw, r0.xyzw
            mad r0.xyzw, cb0[7].yyyy, r1.xyzw, r0.xyzw
            mov r2.xz, v1.xxxx
            sample r1.xyzw, r2.xyxx, t0.xyzw, s1
            sample r2.xyzw, r2.zwzz, t0.xyzw, s1
            mad r0.xyzw, cb0[7].zzzz, r1.xyzw, r0.xyzw
            mad r0.xyzw, cb0[7].wwww, r2.xyzw, r0.xyzw
            add r1.y, v1.y, cb0[5].x
            mov r1.x, v1.x
            sample r1.xyzw, r1.xyxx, t0.xyzw, s1
            mad r0.xyzw, cb0[8].xxxx, r1.xyzw, r0.xyzw
            sample r1.xyzw, v1.zwzz, t1.xyzw, s0
            mul o0.xyzw, r0.xyzw, r1.wwww
            ret 
            // Approximately 31 instruction slots used
                    
        };
    }

}

technique10 SampleTextTexture
{
    pass Unmasked
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(0, 0, 0, 0);
        AB_SampleMask = uint(0xffffffff);
        BlendState = bTextBlend;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16 [unused]
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16 [unused]
            //   float4 TextColor;                  // Offset:   48 Size:    16
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // tex                               texture  float4          2d    0        1
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float       
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            // SV_Target                1   xyzw        1   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c1, 1, 0, 0, 0
                dcl t0
                dcl_2d s0
                mov r0.xyz, c0
                mad r0, r0.xyzx, c1.xxxy, c1.yyyx
                mov oC0, r0
                texld r0, t0, s0
                mul r0, r0.zyxy, c0.w
                mov oC1, r0
            
            // approximately 6 instruction slots used (1 texture, 5 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[4], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_input_ps linear v1.xy
            dcl_output o0.xyzw
            dcl_output o1.xyzw
            dcl_temps 1
            mov o0.xyz, cb0[3].xyzx
            mov o0.w, l(1.000000)
            sample r0.xyzw, v1.xyxx, t0.xyzw, s0
            mul o1.xyzw, r0.zyxy, cb0[3].wwww
            ret 
            // Approximately 5 instruction slots used
                    
        };
    }

    pass Masked
    {
        RasterizerState = TextureRast;
        AB_BlendFactor = float4(0, 0, 0, 0);
        AB_SampleMask = uint(0xffffffff);
        BlendState = bTextBlend;
        VertexShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16
            //   float4 TexCoords;                  // Offset:   16 Size:    16
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16
            //   float4 TextColor;                  // Offset:   48 Size:    16 [unused]
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // POSITION                 0   xyz         0     NONE   float   xy  
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float   xyzw
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c1         cb0             0         3  ( FLT, FLT, FLT, FLT)
            //
            //
            // Runtime generated constant mappings:
            //
            // Target Reg                               Constant Description
            // ---------- --------------------------------------------------
            // c0                              Vertex Shader position offset
            //
            //
            // Level9 shader bytecode:
            //
                vs_2_x
                def c4, 0, 1, 0, 0
                dcl_texcoord v0
                mad oT0.xy, v0, c2.zwzw, c2
                mad oT0.zw, v0.xyyx, c3.xywz, c3.xyyx
                mad r0.xy, v0, c1.zwzw, c1
                add oPos.xy, r0, c0
                mov oPos.zw, c4.xyxy
            
            // approximately 5 instruction slots used
            vs_4_0
            dcl_constantbuffer cb0[3], immediateIndexed
            dcl_input v0.xy
            dcl_output_siv o0.xyzw, position
            dcl_output o1.xy
            dcl_output o1.zw
            mad o0.xy, v0.xyxx, cb0[0].zwzz, cb0[0].xyxx
            mov o0.zw, l(0,0,0,1.000000)
            mad o1.xy, v0.xyxx, cb0[1].zwzz, cb0[1].xyxx
            mad o1.zw, v0.xxxy, cb0[2].zzzw, cb0[2].xxxy
            ret 
            // Approximately 5 instruction slots used
                    
        };
        GeometryShader = NULL;
        PixelShader = asm {
            //
            // Generated by Microsoft (R) HLSL Shader Compiler 6.3.9600.16384
            //
            //
            // Buffer Definitions: 
            //
            // cbuffer cb0
            // {
            //
            //   float4 QuadDesc;                   // Offset:    0 Size:    16 [unused]
            //   float4 TexCoords;                  // Offset:   16 Size:    16 [unused]
            //   float4 MaskTexCoords;              // Offset:   32 Size:    16 [unused]
            //   float4 TextColor;                  // Offset:   48 Size:    16
            //
            // }
            //
            //
            // Resource Bindings:
            //
            // Name                                 Type  Format         Dim Slot Elements
            // ------------------------------ ---------- ------- ----------- ---- --------
            // sSampler                          sampler      NA          NA    0        1
            // sMaskSampler                      sampler      NA          NA    1        1
            // tex                               texture  float4          2d    0        1
            // mask                              texture  float4          2d    1        1
            // cb0                               cbuffer      NA          NA    0        1
            //
            //
            //
            // Input signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Position              0   xyzw        0      POS   float       
            // TEXCOORD                 0   xy          1     NONE   float   xy  
            // TEXCOORD                 1     zw        1     NONE   float     zw
            //
            //
            // Output signature:
            //
            // Name                 Index   Mask Register SysValue  Format   Used
            // -------------------- ----- ------ -------- -------- ------- ------
            // SV_Target                0   xyzw        0   TARGET   float   xyzw
            // SV_Target                1   xyzw        1   TARGET   float   xyzw
            //
            //
            // Constant buffer to DX9 shader constant mappings:
            //
            // Target Reg Buffer  Start Reg # of Regs        Data Conversion
            // ---------- ------- --------- --------- ----------------------
            // c0         cb0             3         1  ( FLT, FLT, FLT, FLT)
            //
            //
            // Sampler/Resource to DX9 shader sampler mappings:
            //
            // Target Sampler Source Sampler  Source Resource
            // -------------- --------------- ----------------
            // s0             s0              t0               
            // s1             s1              t1               
            //
            //
            // Level9 shader bytecode:
            //
                ps_2_x
                def c1, 1, 0, 0, 0
                dcl t0
                dcl_2d s0
                dcl_2d s1
                mov r0.xyz, c0
                mad r0, r0.xyzx, c1.xxxy, c1.yyyx
                mov oC0, r0
                mov r0.xy, t0.wzzw
                texld r1, t0, s0
                texld r0, r0, s1
                mul r1, r1.zyxy, c0.w
                mul r0, r0.w, r1
                mov oC1, r0
            
            // approximately 9 instruction slots used (2 texture, 7 arithmetic)
            ps_4_0
            dcl_constantbuffer cb0[4], immediateIndexed
            dcl_sampler s0, mode_default
            dcl_sampler s1, mode_default
            dcl_resource_texture2d (float,float,float,float) t0
            dcl_resource_texture2d (float,float,float,float) t1
            dcl_input_ps linear v1.xy
            dcl_input_ps linear v1.zw
            dcl_output o0.xyzw
            dcl_output o1.xyzw
            dcl_temps 2
            mov o0.xyz, cb0[3].xyzx
            mov o0.w, l(1.000000)
            sample r0.xyzw, v1.xyxx, t0.xyzw, s0
            mul r0.xyzw, r0.zyxy, cb0[3].wwww
            sample r1.xyzw, v1.zwzz, t1.xyzw, s1
            mul o1.xyzw, r0.xyzw, r1.wwww
            ret 
            // Approximately 7 instruction slots used
                    
        };
    }

}

#endif

const BYTE d2deffect[] = {
    // clang-format off
     68,  88,  66,  67, 116, 210, 
    237,  43,  26, 169, 147,  99, 
     62,  90, 128, 241, 238, 193, 
    236, 181,   1,   0,   0,   0, 
    242,  19,   1,   0,   1,   0, 
      0,   0,  36,   0,   0,   0, 
     70,  88,  49,  48, 198,  19, 
      1,   0,   1,  16, 255, 254, 
      4,   0,   0,   0,  16,   0, 
      0,   0,  13,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      8,   0,   0,   0,  62,   7, 
      1,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  32,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,  36,  71, 
    108, 111,  98,  97, 108, 115, 
      0, 117, 105, 110, 116,   0, 
     13,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,  16,   0, 
      0,   0,   4,   0,   0,   0, 
     25,   9,   0,   0,  98, 108, 
    101, 110, 100, 111, 112,   0, 
     99,  98,  48,   0, 102, 108, 
    111,  97, 116,  52,   0,  58, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,  16,   0,   0, 
      0,  16,   0,   0,   0,  10, 
     33,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0,  99,  98, 
     49,   0,  58,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,  48,   0,   0,   0, 
     16,   0,   0,   0,  48,   0, 
      0,   0,  10,  33,   0,   0, 
     66, 108, 117, 114,  79, 102, 
    102, 115, 101, 116, 115,  72, 
      0,  66, 108, 117, 114,  79, 
    102, 102, 115, 101, 116, 115, 
     86,   0,  66, 108, 117, 114, 
     87, 101, 105, 103, 104, 116, 
    115,   0,  83, 104,  97, 100, 
    111, 119,  67, 111, 108, 111, 
    114,   0,  99,  98,  50,   0, 
    102, 108, 111,  97, 116,  51, 
    120,  51,   0, 222,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  44,   0,   0, 
      0,  48,   0,   0,   0,  36, 
      0,   0,   0,  11,  91,   0, 
      0,  68, 101, 118, 105,  99, 
    101,  83, 112,  97,  99, 101, 
     84, 111,  85, 115, 101, 114, 
     83, 112,  97,  99, 101,   0, 
    102, 108, 111,  97, 116,  50, 
      0,  26,   1,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   8,   0,   0,   0,  16, 
      0,   0,   0,   8,   0,   0, 
      0,  10,  17,   0,   0, 100, 
    105, 109, 101, 110, 115, 105, 
    111, 110, 115,   0, 102, 108, 
    111,  97, 116,  51,   0,  72, 
      1,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  12, 
      0,   0,   0,  16,   0,   0, 
      0,  12,   0,   0,   0,  10, 
     25,   0,   0, 100, 105, 102, 
    102,   0,  99, 101, 110, 116, 
    101, 114,  49,   0, 102, 108, 
    111,  97, 116,   0, 120,   1, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  16,   0,   0,   0, 
      4,   0,   0,   0,   9,   9, 
      0,   0,  65,   0, 114,  97, 
    100, 105, 117, 115,  49,   0, 
    115, 113,  95, 114,  97, 100, 
    105, 117, 115,  49,   0,  84, 
    101, 120, 116, 117, 114, 101, 
     50,  68,   0, 175,   1,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  12,   0,   0, 
      0, 116, 101, 120,   0,  98, 
     99, 107, 116, 101, 120,   0, 
    109,  97, 115, 107,   0,  83, 
     97, 109, 112, 108, 101, 114, 
     83, 116,  97, 116, 101,   0, 
    229,   1,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     21,   0,   0,   0, 115,  83, 
     97, 109, 112, 108, 101, 114, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,  21,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   3,   0,   0, 
      0, 115,  66,  99, 107,  83, 
     97, 109, 112, 108, 101, 114, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,  21,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   3,   0,   0, 
      0, 115,  87, 114,  97, 112, 
     83,  97, 109, 112, 108, 101, 
    114,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,  21,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   1,   0, 
      0,   0, 115,  77, 105, 114, 
    114, 111, 114,  83,  97, 109, 
    112, 108, 101, 114,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,  21,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   2,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   2,   0,   0,   0, 115, 
     77,  97, 115, 107,  83,  97, 
    109, 112, 108, 101, 114,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,  21,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   3,   0,   0,   0, 
    115,  83, 104,  97, 100, 111, 
    119,  83,  97, 109, 112, 108, 
    101, 114,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,  21, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   4, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   4, 
      0,   0,   0,   4,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  82,  97, 115, 
    116, 101, 114, 105, 122, 101, 
    114,  83, 116,  97, 116, 101, 
      0,  87,   3,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,  84, 
    101, 120, 116, 117, 114, 101, 
     82,  97, 115, 116,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   1,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   1,   0,   0,   0,  66, 
    108, 101, 110, 100,  83, 116, 
     97, 116, 101,   0, 167,   3, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  83, 104,  97, 100, 
    111, 119,  66, 108, 101, 110, 
    100,  72,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,  15, 
      0,   0,   0,  83, 104,  97, 
    100, 111, 119,  66, 108, 101, 
    110, 100,  86,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      2,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      6,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      2,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      6,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
     15,   0,   0,   0,  98,  84, 
    101, 120, 116,  66, 108, 101, 
    110, 100,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,  17, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,  18, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,  19, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   0,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,  15, 
      0,   0,   0,  83,  97, 109, 
    112, 108, 101,  84, 101, 120, 
    116, 117, 114, 101,   0,  80, 
     48,   0,  68,   4,   0,   0, 
     68,  88,  66,  67,  77,  85, 
    167, 240,  56,  56, 155,  78, 
    125,  96,  49, 253, 103, 100, 
     22,  62,   1,   0,   0,   0, 
     68,   4,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    248,   0,   0,   0, 244,   1, 
      0,   0, 112,   2,   0,   0, 
    160,   3,   0,   0, 212,   3, 
      0,   0,  65, 111, 110,  57, 
    184,   0,   0,   0, 184,   0, 
      0,   0,   0,   2, 254, 255, 
    132,   0,   0,   0,  52,   0, 
      0,   0,   1,   0,  36,   0, 
      0,   0,  48,   0,   0,   0, 
     48,   0,   0,   0,  36,   0, 
      1,   0,  48,   0,   0,   0, 
      0,   0,   3,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 254, 255, 
     81,   0,   0,   5,   4,   0, 
     15, 160,   0,   0,   0,   0, 
      0,   0, 128,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     31,   0,   0,   2,   5,   0, 
      0, 128,   0,   0,  15, 144, 
      4,   0,   0,   4,   0,   0, 
      3, 224,   0,   0, 228, 144, 
      2,   0, 238, 160,   2,   0, 
    228, 160,   4,   0,   0,   4, 
      0,   0,  12, 224,   0,   0, 
     20, 144,   3,   0, 180, 160, 
      3,   0,  20, 160,   4,   0, 
      0,   4,   0,   0,   3, 128, 
      0,   0, 228, 144,   1,   0, 
    238, 160,   1,   0, 228, 160, 
      2,   0,   0,   3,   0,   0, 
      3, 192,   0,   0, 228, 128, 
      0,   0, 228, 160,   1,   0, 
      0,   2,   0,   0,  12, 192, 
      4,   0,  68, 160, 255, 255, 
      0,   0,  83,  72,  68,  82, 
    244,   0,   0,   0,  64,   0, 
      1,   0,  61,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  95,   0, 
      0,   3,  50,  16,  16,   0, 
      0,   0,   0,   0, 103,   0, 
      0,   4, 242,  32,  16,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
     50,  32,  16,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
    194,  32,  16,   0,   1,   0, 
      0,   0,  50,   0,   0,  11, 
     50,  32,  16,   0,   0,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   8, 194,  32,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 128,  63, 
     50,   0,   0,  11,  50,  32, 
     16,   0,   1,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  50,   0,   0,  11, 
    194,  32,  16,   0,   1,   0, 
      0,   0,   6,  20,  16,   0, 
      0,   0,   0,   0, 166, 142, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   6, 132, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,   5,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70,  40,   1, 
      0,   0,   1,   0,   0,   0, 
     64,   0,   0,   0,   1,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 254, 255,   0,   1, 
      0,   0, 246,   0,   0,   0, 
     60,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  99,  98,  48,   0, 
     60,   0,   0,   0,   4,   0, 
      0,   0,  88,   0,   0,   0, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    184,   0,   0,   0,   0,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    212,   0,   0,   0,  16,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    222,   0,   0,   0,  32,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    236,   0,   0,   0,  48,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
     81, 117,  97, 100,  68, 101, 
    115,  99,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  77,  97, 115, 107, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  84, 101, 
    120, 116,  67, 111, 108, 111, 
    114,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0,  73,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   7,   3, 
      0,   0,  80,  79,  83,  73, 
     84,  73,  79,  78,   0, 171, 
    171, 171,  79,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,  12,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,   3,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
    232,   4,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0, 212,   2,   0,   0, 
     68,  88,  66,  67,  17, 106, 
     69, 218, 119,  68,  79,  85, 
    211, 176,  27, 183,  77, 210, 
    131,  41,   1,   0,   0,   0, 
    212,   2,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    164,   0,   0,   0,  16,   1, 
      0,   0, 140,   1,   0,   0, 
     48,   2,   0,   0, 160,   2, 
      0,   0,  65, 111, 110,  57, 
    100,   0,   0,   0, 100,   0, 
      0,   0,   0,   2, 255, 255, 
     60,   0,   0,   0,  40,   0, 
      0,   0,   0,   0,  40,   0, 
      0,   0,  40,   0,   0,   0, 
     40,   0,   1,   0,  36,   0, 
      0,   0,  40,   0,   0,   0, 
      0,   0,   1,   2, 255, 255, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
     66,   0,   0,   3,   0,   0, 
     15, 128,   0,   0, 228, 176, 
      0,   8, 228, 160,   1,   0, 
      0,   2,   0,   8,  15, 128, 
      0,   0, 228, 128, 255, 255, 
      0,   0,  83,  72,  68,  82, 
    100,   0,   0,   0,  64,   0, 
      0,   0,  25,   0,   0,   0, 
     90,   0,   0,   3,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   0,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0,  69,   0, 
      0,   9, 242,  32,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      0,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70, 156,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 255, 255,   0,   1, 
      0,   0, 105,   0,   0,   0, 
     92,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 101,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 115,  83, 
     97, 109, 112, 108, 101, 114, 
      0, 116, 101, 120,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  54,  46, 
     51,  46,  57,  54,  48,  48, 
     46,  49,  54,  51,  56,  52, 
      0, 171,  73,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,   3,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
     79,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  83,  86, 
     95,  84,  97, 114, 103, 101, 
    116,   0, 171, 171,  68,   9, 
      0,   0,   0,   0,   0,   0, 
     83,  97, 109, 112, 108, 101, 
     84, 101, 120, 116, 117, 114, 
    101,  70, 111, 114,  83, 101, 
    112,  97, 114,  97,  98, 108, 
    101,  66, 108, 101, 110, 100, 
    105, 110, 103,  95,  49,   0, 
     68,   4,   0,   0,  68,  88, 
     66,  67,  77,  85, 167, 240, 
     56,  56, 155,  78, 125,  96, 
     49, 253, 103, 100,  22,  62, 
      1,   0,   0,   0,  68,   4, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 248,   0, 
      0,   0, 244,   1,   0,   0, 
    112,   2,   0,   0, 160,   3, 
      0,   0, 212,   3,   0,   0, 
     65, 111, 110,  57, 184,   0, 
      0,   0, 184,   0,   0,   0, 
      0,   2, 254, 255, 132,   0, 
      0,   0,  52,   0,   0,   0, 
      1,   0,  36,   0,   0,   0, 
     48,   0,   0,   0,  48,   0, 
      0,   0,  36,   0,   1,   0, 
     48,   0,   0,   0,   0,   0, 
      3,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   2, 254, 255,  81,   0, 
      0,   5,   4,   0,  15, 160, 
      0,   0,   0,   0,   0,   0, 
    128,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,  31,   0, 
      0,   2,   5,   0,   0, 128, 
      0,   0,  15, 144,   4,   0, 
      0,   4,   0,   0,   3, 224, 
      0,   0, 228, 144,   2,   0, 
    238, 160,   2,   0, 228, 160, 
      4,   0,   0,   4,   0,   0, 
     12, 224,   0,   0,  20, 144, 
      3,   0, 180, 160,   3,   0, 
     20, 160,   4,   0,   0,   4, 
      0,   0,   3, 128,   0,   0, 
    228, 144,   1,   0, 238, 160, 
      1,   0, 228, 160,   2,   0, 
      0,   3,   0,   0,   3, 192, 
      0,   0, 228, 128,   0,   0, 
    228, 160,   1,   0,   0,   2, 
      0,   0,  12, 192,   4,   0, 
     68, 160, 255, 255,   0,   0, 
     83,  72,  68,  82, 244,   0, 
      0,   0,  64,   0,   1,   0, 
     61,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,  95,   0,   0,   3, 
     50,  16,  16,   0,   0,   0, 
      0,   0, 103,   0,   0,   4, 
    242,  32,  16,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    101,   0,   0,   3,  50,  32, 
     16,   0,   1,   0,   0,   0, 
    101,   0,   0,   3, 194,  32, 
     16,   0,   1,   0,   0,   0, 
     50,   0,   0,  11,  50,  32, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   8, 
    194,  32,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 128,  63,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      1,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     50,   0,   0,  11, 194,  32, 
     16,   0,   1,   0,   0,   0, 
      6,  20,  16,   0,   0,   0, 
      0,   0, 166, 142,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   6, 132,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,   5,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70,  40,   1,   0,   0, 
      1,   0,   0,   0,  64,   0, 
      0,   0,   1,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    254, 255,   0,   1,   0,   0, 
    246,   0,   0,   0,  60,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     99,  98,  48,   0,  60,   0, 
      0,   0,   4,   0,   0,   0, 
     88,   0,   0,   0,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 184,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 212,   0, 
      0,   0,  16,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 222,   0, 
      0,   0,  32,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 236,   0, 
      0,   0,  48,   0,   0,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0,  81, 117, 
     97, 100,  68, 101, 115,  99, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     77,  97, 115, 107,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  84, 101, 120, 116, 
     67, 111, 108, 111, 114,   0, 
     77, 105,  99, 114, 111, 115, 
    111, 102, 116,  32,  40,  82, 
     41,  32,  72,  76,  83,  76, 
     32,  83, 104,  97, 100, 101, 
    114,  32,  67, 111, 109, 112, 
    105, 108, 101, 114,  32,  54, 
     46,  51,  46,  57,  54,  48, 
     48,  46,  49,  54,  51,  56, 
     52,   0,  73,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   7,   3,   0,   0, 
     80,  79,  83,  73,  84,  73, 
     79,  78,   0, 171, 171, 171, 
     79,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,  12,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   3,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  72,  12, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
     72,  13,   0,   0,  68,  88, 
     66,  67, 193,  65, 249,  15, 
    188, 209,  36, 123, 179, 111, 
      3,  63,  40,  10,   7,  98, 
      1,   0,   0,   0,  72,  13, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 172,   4, 
      0,   0, 188,  10,   0,   0, 
     56,  11,   0,   0, 164,  12, 
      0,   0,  20,  13,   0,   0, 
     65, 111, 110,  57, 108,   4, 
      0,   0, 108,   4,   0,   0, 
      0,   2, 255, 255,  52,   4, 
      0,   0,  56,   0,   0,   0, 
      1,   0,  44,   0,   0,   0, 
     56,   0,   0,   0,  56,   0, 
      2,   0,  36,   0,   0,   0, 
     56,   0,   0,   0,   0,   0, 
      1,   1,   1,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   1,   2, 
    255, 255,  81,   0,   0,   5, 
      1,   0,  15, 160,   0,   0, 
    128, 191,   0,   0,   0, 192, 
      0,   0,  64, 192,   0,   0, 
    128, 192,  81,   0,   0,   5, 
      2,   0,  15, 160,   0,   0, 
    128,  63,   0,   0,   0,   0, 
      0,   0,   0,  63,   0,   0, 
      0, 192,  81,   0,   0,   5, 
      3,   0,  15, 160,   0,   0, 
    160, 192,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      0,   0,   0, 128,   0,   0, 
     15, 176,  31,   0,   0,   2, 
      0,   0,   0, 144,   0,   8, 
     15, 160,  31,   0,   0,   2, 
      0,   0,   0, 144,   1,   8, 
     15, 160,   1,   0,   0,   2, 
      0,   0,   8, 128,   0,   0, 
      0, 160,   2,   0,   0,   3, 
      0,   0,   1, 128,   0,   0, 
    255, 128,   3,   0,   0, 160, 
      5,   0,   0,   3,   0,   0, 
      1, 128,   0,   0,   0, 128, 
      0,   0,   0, 128,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      0,   0, 228, 176,   1,   8, 
    228, 160,  66,   0,   0,   3, 
      2,   0,  15, 128,   0,   0, 
    228, 176,   0,   8, 228, 160, 
      6,   0,   0,   2,   0,   0, 
      2, 128,   2,   0, 255, 128, 
      4,   0,   0,   4,   3,   0, 
      7, 128,   2,   0, 228, 128, 
      0,   0,  85, 128,   2,   0, 
      0, 161,   5,   0,   0,   3, 
      3,   0,   7, 128,   3,   0, 
    228, 128,   3,   0, 228, 128, 
      4,   0,   0,   4,   4,   0, 
      7, 128,   2,   0, 228, 128, 
      0,   0,  85, 129,   2,   0, 
      0, 160,   6,   0,   0,   2, 
      3,   0,   8, 128,   4,   0, 
      0, 128,   6,   0,   0,   2, 
      4,   0,   8, 128,   1,   0, 
    255, 128,   5,   0,   0,   3, 
      5,   0,   7, 128,   1,   0, 
    228, 128,   4,   0, 255, 128, 
      4,   0,   0,   4,   1,   0, 
      7, 128,   1,   0, 228, 128, 
      4,   0, 255, 129,   2,   0, 
    170, 160,   5,   0,   0,   3, 
      3,   0,   8, 128,   3,   0, 
    255, 128,   5,   0,   0, 128, 
     10,   0,   0,   3,   4,   0, 
      8, 128,   3,   0, 255, 128, 
      2,   0,   0, 160,  88,   0, 
      0,   4,   4,   0,   8, 128, 
      3,   0,   0, 129,   2,   0, 
      0, 160,   4,   0, 255, 128, 
      5,   0,   0,   3,   6,   0, 
      7, 128,   5,   0, 228, 128, 
      5,   0, 228, 128,  88,   0, 
      0,   4,   7,   0,   1, 128, 
      6,   0,   0, 129,   2,   0, 
     85, 160,   4,   0, 255, 128, 
      6,   0,   0,   2,   4,   0, 
      8, 128,   4,   0,  85, 128, 
      5,   0,   0,   3,   4,   0, 
      8, 128,   4,   0, 255, 128, 
      5,   0,  85, 128,  10,   0, 
      0,   3,   5,   0,   8, 128, 
      4,   0, 255, 128,   2,   0, 
      0, 160,  88,   0,   0,   4, 
      4,   0,   8, 128,   3,   0, 
     85, 129,   2,   0,   0, 160, 
      5,   0, 255, 128,  88,   0, 
      0,   4,   7,   0,   2, 128, 
      6,   0,  85, 129,   2,   0, 
     85, 160,   4,   0, 255, 128, 
      6,   0,   0,   2,   4,   0, 
      8, 128,   4,   0, 170, 128, 
      5,   0,   0,   3,   4,   0, 
      8, 128,   4,   0, 255, 128, 
      5,   0, 170, 128,  10,   0, 
      0,   3,   5,   0,   8, 128, 
      4,   0, 255, 128,   2,   0, 
      0, 160,  88,   0,   0,   4, 
      4,   0,   8, 128,   3,   0, 
    170, 129,   2,   0,   0, 160, 
      5,   0, 255, 128,  88,   0, 
      0,   4,   7,   0,   4, 128, 
      6,   0, 170, 129,   2,   0, 
     85, 160,   4,   0, 255, 128, 
      5,   0,   0,   3,   3,   0, 
      7, 128,   0,   0,  85, 128, 
      2,   0, 228, 128,   4,   0, 
      0,   4,   6,   0,   7, 128, 
      2,   0, 228, 128,   0,   0, 
     85, 128,   5,   0, 228, 128, 
      4,   0,   0,   4,   6,   0, 
      7, 128,   3,   0, 228, 128, 
      5,   0, 228, 129,   6,   0, 
    228, 128,  11,   0,   0,   3, 
      8,   0,   7, 128,   3,   0, 
    228, 128,   5,   0, 228, 128, 
     88,   0,   0,   4,   0,   0, 
      7, 128,   0,   0,   0, 129, 
      8,   0, 228, 128,   7,   0, 
    228, 128,   2,   0,   0,   3, 
      7,   0,  15, 128,   0,   0, 
    255, 128,   1,   0, 228, 160, 
      5,   0,   0,   3,   7,   0, 
     15, 128,   7,   0, 228, 128, 
      7,   0, 228, 128,  10,   0, 
      0,   3,   8,   0,   7, 128, 
      5,   0, 228, 128,   3,   0, 
    228, 128,  88,   0,   0,   4, 
      0,   0,   7, 128,   7,   0, 
    255, 129,   8,   0, 228, 128, 
      0,   0, 228, 128,   4,   0, 
      0,   4,   8,   0,   7, 128, 
      5,   0, 228, 128,   2,   0, 
    255, 161,   2,   0,   0, 161, 
      2,   0,   0,   3,   8,   0, 
      7, 128,   8,   0, 228, 129, 
      2,   0,   0, 160,   4,   0, 
      0,   4,   4,   0,   7, 128, 
      4,   0, 228, 128,   8,   0, 
    228, 129,   2,   0,   0, 160, 
      2,   0,   0,   3,   8,   0, 
      7, 128,   5,   0, 228, 128, 
      5,   0, 228, 128,   5,   0, 
      0,   3,   5,   0,   7, 128, 
      5,   0, 228, 128,   3,   0, 
    228, 128,   5,   0,   0,   3, 
      8,   0,   7, 128,   3,   0, 
    228, 128,   8,   0, 228, 128, 
     88,   0,   0,   4,   1,   0, 
      7, 128,   1,   0, 228, 128, 
      8,   0, 228, 128,   4,   0, 
    228, 128,  88,   0,   0,   4, 
      0,   0,   7, 128,   7,   0, 
    170, 129,   1,   0, 228, 128, 
      0,   0, 228, 128,  88,   0, 
      0,   4,   0,   0,   7, 128, 
      7,   0,  85, 129,   6,   0, 
    228, 128,   0,   0, 228, 128, 
     88,   0,   0,   4,   0,   0, 
      7, 128,   7,   0,   0, 129, 
      5,   0, 228, 128,   0,   0, 
    228, 128,  18,   0,   0,   4, 
      4,   0,   7, 128,   1,   0, 
    255, 128,   0,   0, 228, 128, 
      3,   0, 228, 128,   5,   0, 
      0,   3,   4,   0,   8, 128, 
      1,   0, 255, 128,   1,   0, 
    255, 128,  88,   0,   0,   4, 
      4,   0,   8, 128,   4,   0, 
    255, 129,   2,   0,   0, 160, 
      2,   0,  85, 160,   5,   0, 
      0,   3,   0,   0,   7, 128, 
      2,   0, 255, 128,   4,   0, 
    228, 128,   5,   0,   0,   3, 
      0,   0,   8, 128,   2,   0, 
    255, 128,   2,   0, 255, 128, 
     88,   0,   0,   4,   0,   0, 
      8, 128,   0,   0, 255, 129, 
      2,   0,   0, 160,   2,   0, 
     85, 160,   2,   0,   0,   3, 
      0,   0,   8, 128,   4,   0, 
    255, 128,   0,   0, 255, 128, 
     88,   0,   0,   4,   2,   0, 
      7, 128,   0,   0, 255, 129, 
      0,   0, 228, 128,   2,   0, 
    228, 128,   1,   0,   0,   2, 
      0,   8,  15, 128,   2,   0, 
    228, 128, 255, 255,   0,   0, 
     83,  72,  68,  82,   8,   6, 
      0,   0,  64,   0,   0,   0, 
    130,   1,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 104,   0, 
      0,   2,   7,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
     70,  16,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      1,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     24,   0,   0,   7,  18,   0, 
     16,   0,   2,   0,   0,   0, 
     58,   0,  16,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0,   0,   0,  24,   0, 
      0,   7,  34,   0,  16,   0, 
      2,   0,   0,   0,  58,   0, 
     16,   0,   1,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,  60,   0,   0,   7, 
     18,   0,  16,   0,   2,   0, 
      0,   0,  26,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   2,   0,   0,   0, 
     31,   0,   4,   3,  10,   0, 
     16,   0,   2,   0,   0,   0, 
     54,   0,   0,   5, 242,  32, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,  62,   0,   0,   1, 
     21,   0,   0,   1,  14,   0, 
      0,   7, 114,   0,  16,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
    246,  15,  16,   0,   0,   0, 
      0,   0,  14,   0,   0,   7, 
    114,   0,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0, 246,  15, 
     16,   0,   1,   0,   0,   0, 
     32,   0,   0,   8,  18,   0, 
     16,   0,   2,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   1,   0, 
      0,   0,  31,   0,   4,   3, 
     10,   0,  16,   0,   2,   0, 
      0,   0,  56,   0,   0,   7, 
    114,   0,  16,   0,   2,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     18,   0,   0,   1,  32,   0, 
      0,   8, 130,   0,  16,   0, 
      2,   0,   0,   0,  10, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   2,   0,   0,   0, 
     31,   0,   4,   3,  58,   0, 
     16,   0,   2,   0,   0,   0, 
      0,   0,   0,   7, 114,   0, 
     16,   0,   3,   0,   0,   0, 
     70,   2,  16,   0,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  10, 114,   0,  16,   0, 
      2,   0,   0,   0,  70,   2, 
     16, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   3,   0, 
      0,   0,  18,   0,   0,   1, 
     32,   0,   0,   8, 130,   0, 
     16,   0,   2,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   3,   0, 
      0,   0,  31,   0,   4,   3, 
     58,   0,  16,   0,   2,   0, 
      0,   0,  29,   0,   0,  10, 
    114,   0,  16,   0,   3,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,  63,   0,   0, 
      0,  63,   0,   0,   0,  63, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
      0,   0,   0,   7, 114,   0, 
     16,   0,   4,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  56,   0, 
      0,   7, 114,   0,  16,   0, 
      4,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
     70,   2,  16,   0,   4,   0, 
      0,   0,  50,   0,   0,  15, 
    114,   0,  16,   0,   5,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,  64, 
      0,   0,   0,  64,   0,   0, 
      0,  64,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128, 191,   0,   0, 128, 191, 
      0,   0, 128, 191,   0,   0, 
      0,   0,   0,   0,   0,  11, 
    114,   0,  16,   0,   6,   0, 
      0,   0,  70,   2,  16, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0,   0,   0,   0,   0, 
      0,  11, 114,   0,  16,   0, 
      5,   0,   0,   0,  70,   2, 
     16, 128,  65,   0,   0,   0, 
      5,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0,   0,   0, 
     50,   0,   0,  13, 114,   0, 
     16,   0,   5,   0,   0,   0, 
     70,   2,  16, 128,  65,   0, 
      0,   0,   6,   0,   0,   0, 
     70,   2,  16,   0,   5,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0,   0,   0,  55,   0, 
      0,   9, 114,   0,  16,   0, 
      2,   0,   0,   0,  70,   2, 
     16,   0,   3,   0,   0,   0, 
     70,   2,  16,   0,   4,   0, 
      0,   0,  70,   2,  16,   0, 
      5,   0,   0,   0,  18,   0, 
      0,   1,  32,   0,   0,   8, 
    130,   0,  16,   0,   2,   0, 
      0,   0,  10, 128,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      4,   0,   0,   0,  31,   0, 
      4,   3,  58,   0,  16,   0, 
      2,   0,   0,   0,  51,   0, 
      0,   7, 114,   0,  16,   0, 
      2,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  18,   0,   0,   1, 
     32,   0,   0,   8, 130,   0, 
     16,   0,   2,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   5,   0, 
      0,   0,  31,   0,   4,   3, 
     58,   0,  16,   0,   2,   0, 
      0,   0,  52,   0,   0,   7, 
    114,   0,  16,   0,   2,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     18,   0,   0,   1,  24,   0, 
      0,  10, 114,   0,  16,   0, 
      3,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  24,   0,   0,  10, 
    114,   0,  16,   0,   4,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0,   0,   0, 
      0,   0,   0,  11, 114,   0, 
     16,   0,   5,   0,   0,   0, 
     70,   2,  16, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
      0,   0,  14,   0,   0,   7, 
    114,   0,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   5,   0,   0,   0, 
     51,   0,   0,  10, 114,   0, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0,   0,   0,  55,   0, 
      0,  12, 114,   0,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   4,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  55,   0, 
      0,  12, 114,   0,  16,   0, 
      2,   0,   0,   0,  70,   2, 
     16,   0,   3,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  21,   0, 
      0,   1,  21,   0,   0,   1, 
     21,   0,   0,   1,  21,   0, 
      0,   1,  21,   0,   0,   1, 
      0,   0,   0,   8,  18,   0, 
     16,   0,   1,   0,   0,   0, 
     58,   0,  16, 128,  65,   0, 
      0,   0,   1,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,  56,   0,   0,   7, 
    226,   0,  16,   0,   1,   0, 
      0,   0, 246,  15,  16,   0, 
      1,   0,   0,   0,   6,   9, 
     16,   0,   2,   0,   0,   0, 
     50,   0,   0,   9, 114,   0, 
     16,   0,   0,   0,   0,   0, 
      6,   0,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0, 150,   7, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   7, 114,  32, 
     16,   0,   0,   0,   0,   0, 
    246,  15,  16,   0,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5, 130,  32,  16,   0, 
      0,   0,   0,   0,  58,   0, 
     16,   0,   0,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
     57,   0,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  25,   0, 
      0,   0,   5,   0,   0,   0, 
      1,   0,   0,   0,   7,   0, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
    100,   1,   0,   0,   1,   0, 
      0,   0, 232,   0,   0,   0, 
      5,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 255, 255, 
      0,   1,   0,   0,  48,   1, 
      0,   0, 188,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 197,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    209,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 213,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   1,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 220,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    115,  83,  97, 109, 112, 108, 
    101, 114,   0, 115,  66,  99, 
    107,  83,  97, 109, 112, 108, 
    101, 114,   0, 116, 101, 120, 
      0,  98,  99, 107, 116, 101, 
    120,   0,  36,  71, 108, 111, 
     98,  97, 108, 115,   0, 171, 
    171, 171, 220,   0,   0,   0, 
      1,   0,   0,   0,   0,   1, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  24,   1,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   2,   0,   0,   0, 
     32,   1,   0,   0,   0,   0, 
      0,   0,  98, 108, 101, 110, 
    100, 111, 112,   0,   0,   0, 
     19,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0, 171, 171, 
     73,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   3,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  79,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  83,  86,  95,  84, 
     97, 114, 103, 101, 116,   0, 
    171, 171, 164,  16,   0,   0, 
      0,   0,   0,   0,  83,  97, 
    109, 112, 108, 101,  84, 101, 
    120, 116, 117, 114, 101,  70, 
    111, 114,  83, 101, 112,  97, 
    114,  97,  98, 108, 101,  66, 
    108, 101, 110, 100, 105, 110, 
    103,  95,  50,   0,  68,   4, 
      0,   0,  68,  88,  66,  67, 
     77,  85, 167, 240,  56,  56, 
    155,  78, 125,  96,  49, 253, 
    103, 100,  22,  62,   1,   0, 
      0,   0,  68,   4,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 248,   0,   0,   0, 
    244,   1,   0,   0, 112,   2, 
      0,   0, 160,   3,   0,   0, 
    212,   3,   0,   0,  65, 111, 
    110,  57, 184,   0,   0,   0, 
    184,   0,   0,   0,   0,   2, 
    254, 255, 132,   0,   0,   0, 
     52,   0,   0,   0,   1,   0, 
     36,   0,   0,   0,  48,   0, 
      0,   0,  48,   0,   0,   0, 
     36,   0,   1,   0,  48,   0, 
      0,   0,   0,   0,   3,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    254, 255,  81,   0,   0,   5, 
      4,   0,  15, 160,   0,   0, 
      0,   0,   0,   0, 128,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      5,   0,   0, 128,   0,   0, 
     15, 144,   4,   0,   0,   4, 
      0,   0,   3, 224,   0,   0, 
    228, 144,   2,   0, 238, 160, 
      2,   0, 228, 160,   4,   0, 
      0,   4,   0,   0,  12, 224, 
      0,   0,  20, 144,   3,   0, 
    180, 160,   3,   0,  20, 160, 
      4,   0,   0,   4,   0,   0, 
      3, 128,   0,   0, 228, 144, 
      1,   0, 238, 160,   1,   0, 
    228, 160,   2,   0,   0,   3, 
      0,   0,   3, 192,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      1,   0,   0,   2,   0,   0, 
     12, 192,   4,   0,  68, 160, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 244,   0,   0,   0, 
     64,   0,   1,   0,  61,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     95,   0,   0,   3,  50,  16, 
     16,   0,   0,   0,   0,   0, 
    103,   0,   0,   4, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3,  50,  32,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 194,  32,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   8, 194,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  63,  50,   0,   0,  11, 
     50,  32,  16,   0,   1,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11, 194,  32,  16,   0, 
      1,   0,   0,   0,   6,  20, 
     16,   0,   0,   0,   0,   0, 
    166, 142,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      6, 132,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
      5,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
     40,   1,   0,   0,   1,   0, 
      0,   0,  64,   0,   0,   0, 
      1,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 254, 255, 
      0,   1,   0,   0, 246,   0, 
      0,   0,  60,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  99,  98, 
     48,   0,  60,   0,   0,   0, 
      4,   0,   0,   0,  88,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 184,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 212,   0,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 222,   0,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 236,   0,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  54,  46,  51, 
     46,  57,  54,  48,  48,  46, 
     49,  54,  51,  56,  52,   0, 
     73,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   3,   0,   0,  80,  79, 
     83,  73,  84,  73,  79,  78, 
      0, 171, 171, 171,  79,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,  12, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,   3, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,  28,  30,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,  88,  17, 
      0,   0,  68,  88,  66,  67, 
     62, 116,  36, 238,  73,  63, 
    158,  95, 222, 192,  91, 113, 
    112,  55,  55, 145,   1,   0, 
      0,   0,  88,  17,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0,  88,   6,   0,   0, 
    204,  14,   0,   0,  72,  15, 
      0,   0, 180,  16,   0,   0, 
     36,  17,   0,   0,  65, 111, 
    110,  57,  24,   6,   0,   0, 
     24,   6,   0,   0,   0,   2, 
    255, 255, 224,   5,   0,   0, 
     56,   0,   0,   0,   1,   0, 
     44,   0,   0,   0,  56,   0, 
      0,   0,  56,   0,   2,   0, 
     36,   0,   0,   0,  56,   0, 
      0,   0,   0,   0,   1,   1, 
      1,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   1,   2, 255, 255, 
     81,   0,   0,   5,   1,   0, 
     15, 160,   0,   0, 224, 192, 
      0,   0,   0, 193,   0,   0, 
     16, 193,   0,   0,  32, 193, 
     81,   0,   0,   5,   2,   0, 
     15, 160,   0,   0, 128,  63, 
      0,   0,   0,   0,   0,   0, 
    128, 191,   0,   0, 128,  62, 
     81,   0,   0,   5,   3,   0, 
     15, 160,   0,   0,   0,  63, 
      0,   0,   0,  64,   0,   0, 
    128, 191,   0,   0, 128,  64, 
     81,   0,   0,   5,   4,   0, 
     15, 160,   0,   0, 128,  65, 
      0,   0,  64, 193,   0,   0, 
      0,  64,   0,   0, 128,  63, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   1,   8,  15, 160, 
      1,   0,   0,   2,   0,   0, 
      8, 128,   0,   0,   0, 160, 
      2,   0,   0,   3,   0,   0, 
     15, 128,   0,   0, 255, 128, 
      1,   0, 228, 160,   5,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 228, 128,   0,   0, 
    228, 128,  66,   0,   0,   3, 
      1,   0,  15, 128,   0,   0, 
    228, 176,   0,   8, 228, 160, 
     66,   0,   0,   3,   2,   0, 
     15, 128,   0,   0, 228, 176, 
      1,   8, 228, 160,   6,   0, 
      0,   2,   3,   0,   8, 128, 
      2,   0, 255, 128,   4,   0, 
      0,   4,   3,   0,   3, 128, 
      2,   0, 233, 128,   3,   0, 
    255, 129,   2,   0, 255, 160, 
      5,   0,   0,   3,   4,   0, 
      7, 128,   2,   0, 228, 128, 
      3,   0, 255, 128,   4,   0, 
      0,   4,   5,   0,   7, 128, 
      4,   0, 228, 128,   4,   0, 
      0, 160,   4,   0,  85, 160, 
      4,   0,   0,   4,   5,   0, 
      7, 128,   5,   0, 228, 128, 
      4,   0, 228, 128,   3,   0, 
    255, 160,   5,   0,   0,   3, 
      5,   0,   7, 128,   4,   0, 
    228, 128,   5,   0, 228, 128, 
      7,   0,   0,   2,   4,   0, 
      8, 128,   4,   0,  85, 128, 
      6,   0,   0,   2,   4,   0, 
      8, 128,   4,   0, 255, 128, 
     88,   0,   0,   4,   4,   0, 
      8, 128,   3,   0,   0, 128, 
      5,   0,  85, 128,   4,   0, 
    255, 128,   4,   0,   0,   4, 
      4,   0,   8, 128,   2,   0, 
     85, 128,   3,   0, 255, 129, 
      4,   0, 255, 128,   6,   0, 
      0,   2,   3,   0,   1, 128, 
      1,   0, 255, 128,   5,   0, 
      0,   3,   6,   0,   7, 128, 
      1,   0, 228, 128,   3,   0, 
      0, 128,   4,   0,   0,   4, 
      7,   0,   7, 128,   6,   0, 
    228, 128,   3,   0,  85, 160, 
      3,   0, 170, 160,   4,   0, 
      0,   4,   4,   0,   8, 128, 
      7,   0,  85, 128,   4,   0, 
    255, 128,   4,   0,  85, 128, 
      4,   0,   0,   4,   8,   0, 
      7, 128,   1,   0, 228, 128, 
      3,   0,   0, 129,   3,   0, 
      0, 160,   4,   0,   0,   4, 
      9,   0,  15, 128,   2,   0, 
     36, 128,   3,   0, 255, 129, 
      2,   0, 192, 160,   4,   0, 
      0,   4,  10,   0,   7, 128, 
      6,   0, 228, 128,   4,   0, 
    170, 161,   4,   0, 255, 160, 
      5,   0,   0,   3,  10,   0, 
      7, 128,   4,   0, 228, 128, 
     10,   0, 228, 128,   4,   0, 
      0,   4,  10,   0,   7, 128, 
     10,   0, 228, 128,   9,   0, 
    228, 129,   4,   0, 228, 128, 
     88,   0,   0,   4,  11,   0, 
      2, 128,   8,   0,  85, 128, 
     10,   0,  85, 128,   4,   0, 
    255, 128,   7,   0,   0,   2, 
      4,   0,   8, 128,   4,   0, 
    170, 128,   6,   0,   0,   2, 
      4,   0,   8, 128,   4,   0, 
    255, 128,  88,   0,   0,   4, 
      4,   0,   8, 128,   3,   0, 
     85, 128,   5,   0, 170, 128, 
      4,   0, 255, 128,   4,   0, 
      0,   4,   4,   0,   8, 128, 
      2,   0, 170, 128,   3,   0, 
    255, 129,   4,   0, 255, 128, 
      4,   0,   0,   4,   4,   0, 
      8, 128,   7,   0, 170, 128, 
      4,   0, 255, 128,   4,   0, 
    170, 128,  88,   0,   0,   4, 
     11,   0,   4, 128,   8,   0, 
    170, 128,  10,   0, 170, 128, 
      4,   0, 255, 128,   7,   0, 
      0,   2,   4,   0,   8, 128, 
      4,   0,   0, 128,   6,   0, 
      0,   2,   4,   0,   8, 128, 
      4,   0, 255, 128,  88,   0, 
      0,   4,   4,   0,   8, 128, 
      9,   0, 255, 128,   5,   0, 
      0, 128,   4,   0, 255, 128, 
      4,   0,   0,   4,   4,   0, 
      8, 128,   2,   0,   0, 128, 
      3,   0, 255, 129,   4,   0, 
    255, 128,   4,   0,   0,   4, 
      2,   0,   7, 128,   2,   0, 
    228, 128,   3,   0, 255, 128, 
      2,   0, 170, 160,   5,   0, 
      0,   3,   2,   0,   7, 128, 
      2,   0, 228, 128,   2,   0, 
    228, 128,   4,   0,   0,   4, 
      4,   0,   8, 128,   7,   0, 
      0, 128,   4,   0, 255, 128, 
      4,   0,   0, 128,   2,   0, 
      0,   3,   3,   0,  14, 128, 
      7,   0, 144, 129,   2,   0, 
      0, 160,   4,   0,   0,   4, 
      3,   0,  14, 128,   9,   0, 
    144, 128,   3,   0, 228, 129, 
      2,   0,   0, 160,  88,   0, 
      0,   4,  11,   0,   1, 128, 
      8,   0,   0, 128,  10,   0, 
      0, 128,   4,   0, 255, 128, 
      4,   0,   0,   4,   5,   0, 
      7, 128,   1,   0, 228, 128, 
      3,   0,   0, 128,   4,   0, 
    228, 129,   4,   0,   0,   4, 
      7,   0,   7, 128,   1,   0, 
    228, 128,   3,   0,   0, 128, 
      4,   0, 228, 128,  35,   0, 
      0,   2,   5,   0,   7, 128, 
      5,   0, 228, 128,   5,   0, 
      0,   3,  10,   0,   7, 128, 
      4,   0, 228, 128,   6,   0, 
    228, 128,   4,   0,   0,   4, 
      7,   0,   7, 128,  10,   0, 
    228, 128,   3,   0,  85, 161, 
      7,   0, 228, 128,  88,   0, 
      0,   4,   5,   0,   7, 128, 
      0,   0, 255, 129,   5,   0, 
    228, 128,   7,   0, 228, 128, 
     88,   0,   0,   4,   5,   0, 
      7, 128,   0,   0, 170, 129, 
     11,   0, 228, 128,   5,   0, 
    228, 128,   2,   0,   0,   3, 
      7,   0,   7, 128,   6,   0, 
    228, 128,   6,   0, 228, 128, 
      5,   0,   0,   3,   4,   0, 
      7, 128,   4,   0, 228, 128, 
      7,   0, 228, 128,  88,   0, 
      0,   4,   3,   0,   7, 128, 
      8,   0, 228, 128,   4,   0, 
    228, 128,   3,   0, 249, 128, 
     88,   0,   0,   4,   0,   0, 
     14, 128,   0,   0,  85, 129, 
      3,   0, 144, 128,   5,   0, 
    144, 128,   6,   0,   0,   2, 
      6,   0,   8, 128,   6,   0, 
      0, 128,   4,   0,   0,   4, 
      6,   0,   8, 128,   9,   0, 
      0, 128,   6,   0, 255, 129, 
      2,   0,   0, 160,  11,   0, 
      0,   3,   3,   0,   1, 128, 
      6,   0, 255, 128,   2,   0, 
     85, 160,   5,   0,   0,   3, 
      3,   0,  14, 128,   6,   0, 
    144, 128,   6,   0, 144, 128, 
     88,   0,   0,   4,   6,   0, 
      8, 128,   3,   0,  85, 129, 
      2,   0,  85, 160,   3,   0, 
      0, 128,  88,   0,   0,   4, 
      4,   0,   1, 128,   2,   0, 
      0, 129,   2,   0,   0, 160, 
      6,   0, 255, 128,   6,   0, 
      0,   2,   4,   0,   8, 128, 
      6,   0,  85, 128,   4,   0, 
      0,   4,   4,   0,   8, 128, 
      9,   0,  85, 128,   4,   0, 
    255, 129,   2,   0,   0, 160, 
     11,   0,   0,   3,   6,   0, 
      8, 128,   4,   0, 255, 128, 
      2,   0,  85, 160,  88,   0, 
      0,   4,   4,   0,   8, 128, 
      3,   0, 170, 129,   2,   0, 
     85, 160,   6,   0, 255, 128, 
     88,   0,   0,   4,   4,   0, 
      2, 128,   2,   0,  85, 129, 
      2,   0,   0, 160,   4,   0, 
    255, 128,   6,   0,   0,   2, 
      4,   0,   8, 128,   6,   0, 
    170, 128,   4,   0,   0,   4, 
      4,   0,   8, 128,   9,   0, 
    170, 128,   4,   0, 255, 129, 
      2,   0,   0, 160,  11,   0, 
      0,   3,   6,   0,   8, 128, 
      4,   0, 255, 128,   2,   0, 
     85, 160,  88,   0,   0,   4, 
      4,   0,   8, 128,   3,   0, 
    255, 129,   2,   0,  85, 160, 
      6,   0, 255, 128,  88,   0, 
      0,   4,   4,   0,   4, 128, 
      2,   0, 170, 129,   2,   0, 
      0, 160,   4,   0, 255, 128, 
     88,   0,   0,   4,   0,   0, 
      7, 128,   0,   0,   0, 129, 
      4,   0, 228, 128,   0,   0, 
    249, 128,  18,   0,   0,   4, 
      3,   0,   7, 128,   2,   0, 
    255, 128,   0,   0, 228, 128, 
      6,   0, 228, 128,   5,   0, 
      0,   3,   3,   0,   8, 128, 
      2,   0, 255, 128,   2,   0, 
    255, 128,  88,   0,   0,   4, 
      3,   0,   8, 128,   3,   0, 
    255, 129,   2,   0,   0, 160, 
      2,   0,  85, 160,   5,   0, 
      0,   3,   0,   0,   7, 128, 
      1,   0, 255, 128,   3,   0, 
    228, 128,   5,   0,   0,   3, 
      0,   0,   8, 128,   1,   0, 
    255, 128,   1,   0, 255, 128, 
     88,   0,   0,   4,   0,   0, 
      8, 128,   0,   0, 255, 129, 
      2,   0,   0, 160,   2,   0, 
     85, 160,   2,   0,   0,   3, 
      0,   0,   8, 128,   3,   0, 
    255, 128,   0,   0, 255, 128, 
     88,   0,   0,   4,   1,   0, 
      7, 128,   0,   0, 255, 129, 
      0,   0, 228, 128,   1,   0, 
    228, 128,   1,   0,   0,   2, 
      0,   8,  15, 128,   1,   0, 
    228, 128, 255, 255,   0,   0, 
     83,  72,  68,  82, 108,   8, 
      0,   0,  64,   0,   0,   0, 
     27,   2,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 104,   0, 
      0,   2,   7,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
     70,  16,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      1,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     24,   0,   0,   7,  18,   0, 
     16,   0,   2,   0,   0,   0, 
     58,   0,  16,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0,   0,   0,  24,   0, 
      0,   7,  34,   0,  16,   0, 
      2,   0,   0,   0,  58,   0, 
     16,   0,   1,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,  60,   0,   0,   7, 
     18,   0,  16,   0,   2,   0, 
      0,   0,  26,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   2,   0,   0,   0, 
     31,   0,   4,   3,  10,   0, 
     16,   0,   2,   0,   0,   0, 
     54,   0,   0,   5, 242,  32, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,  62,   0,   0,   1, 
     21,   0,   0,   1,  14,   0, 
      0,   7, 114,   0,  16,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
    246,  15,  16,   0,   0,   0, 
      0,   0,  14,   0,   0,   7, 
    114,   0,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0, 246,  15, 
     16,   0,   1,   0,   0,   0, 
     32,   0,   0,   8,  18,   0, 
     16,   0,   2,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   7,   0, 
      0,   0,  31,   0,   4,   3, 
     10,   0,  16,   0,   2,   0, 
      0,   0,  24,   0,   0,  10, 
    114,   0,  16,   0,   2,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0,   0,   0, 
     24,   0,   0,  10, 114,   0, 
     16,   0,   3,   0,   0,   0, 
     70,   2,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  11, 114,   0,  16,   0, 
      4,   0,   0,   0,  70,   2, 
     16, 128,  65,   0,   0,   0, 
      1,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0,   0,   0, 
     14,   0,   0,   7, 114,   0, 
     16,   0,   4,   0,   0,   0, 
     70,   2,  16,   0,   4,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  51,   0, 
      0,  10, 114,   0,  16,   0, 
      4,   0,   0,   0,  70,   2, 
     16,   0,   4,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
      0,   0,   0,   0,   0,  11, 
    114,   0,  16,   0,   4,   0, 
      0,   0,  70,   2,  16, 128, 
     65,   0,   0,   0,   4,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0,   0,   0,  55,   0, 
      0,  12, 114,   0,  16,   0, 
      3,   0,   0,   0,  70,   2, 
     16,   0,   3,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      4,   0,   0,   0,  55,   0, 
      0,  12, 114,   0,  16,   0, 
      2,   0,   0,   0,  70,   2, 
     16,   0,   2,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      3,   0,   0,   0,  18,   0, 
      0,   1,  32,   0,   0,   8, 
    130,   0,  16,   0,   2,   0, 
      0,   0,  10, 128,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      8,   0,   0,   0,  31,   0, 
      4,   3,  58,   0,  16,   0, 
      2,   0,   0,   0,  29,   0, 
      0,  10, 114,   0,  16,   0, 
      3,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,  63, 
      0,   0,   0,  63,   0,   0, 
      0,  63,   0,   0,   0,   0, 
     70,   2,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   7, 
    114,   0,  16,   0,   4,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,   7, 114,   0, 
     16,   0,   4,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      4,   0,   0,   0,  50,   0, 
      0,  15, 114,   0,  16,   0, 
      5,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,  64,   0,   0,   0,  64, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128, 191,   0,   0, 
    128, 191,   0,   0, 128, 191, 
      0,   0,   0,   0,   0,   0, 
      0,  11, 114,   0,  16,   0, 
      6,   0,   0,   0,  70,   2, 
     16, 128,  65,   0,   0,   0, 
      1,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0,   0,   0, 
      0,   0,   0,  11, 114,   0, 
     16,   0,   5,   0,   0,   0, 
     70,   2,  16, 128,  65,   0, 
      0,   0,   5,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  63,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
      0,   0,  50,   0,   0,  13, 
    114,   0,  16,   0,   5,   0, 
      0,   0,  70,   2,  16, 128, 
     65,   0,   0,   0,   6,   0, 
      0,   0,  70,   2,  16,   0, 
      5,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0,   0,   0, 
     55,   0,   0,   9, 114,   0, 
     16,   0,   2,   0,   0,   0, 
     70,   2,  16,   0,   3,   0, 
      0,   0,  70,   2,  16,   0, 
      4,   0,   0,   0,  70,   2, 
     16,   0,   5,   0,   0,   0, 
     18,   0,   0,   1,  32,   0, 
      0,   8, 130,   0,  16,   0, 
      2,   0,   0,   0,  10, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   9,   0,   0,   0, 
     31,   0,   4,   3,  58,   0, 
     16,   0,   2,   0,   0,   0, 
     29,   0,   0,  10, 114,   0, 
     16,   0,   3,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  62,   0,   0, 128,  62, 
      0,   0, 128,  62,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  15, 114,   0,  16,   0, 
      4,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  65,   0,   0, 128,  65, 
      0,   0, 128,  65,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,  64, 193,   0,   0, 
     64, 193,   0,   0,  64, 193, 
      0,   0,   0,   0,  50,   0, 
      0,  12, 114,   0,  16,   0, 
      4,   0,   0,   0,  70,   2, 
     16,   0,   4,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128,  64,   0,   0, 
    128,  64,   0,   0, 128,  64, 
      0,   0,   0,   0,  56,   0, 
      0,   7, 114,   0,  16,   0, 
      4,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   4,   0, 
      0,   0,  75,   0,   0,   5, 
    114,   0,  16,   0,   5,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  55,   0, 
      0,   9, 114,   0,  16,   0, 
      3,   0,   0,   0,  70,   2, 
     16,   0,   3,   0,   0,   0, 
     70,   2,  16,   0,   4,   0, 
      0,   0,  70,   2,  16,   0, 
      5,   0,   0,   0,  29,   0, 
      0,  10, 114,   0,  16,   0, 
      4,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,  63, 
      0,   0,   0,  63,   0,   0, 
      0,  63,   0,   0,   0,   0, 
     70,   2,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  16, 
    114,   0,  16,   0,   5,   0, 
      0,   0,  70,   2,  16, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,  64,   0,   0, 
      0,  64,   0,   0,   0,  64, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0,   0,   0, 
     56,   0,   0,   7, 114,   0, 
     16,   0,   5,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      5,   0,   0,   0,   0,   0, 
      0,  11, 114,   0,  16,   0, 
      6,   0,   0,   0,  70,   2, 
     16, 128,  65,   0,   0,   0, 
      1,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0, 128,  63,   0,   0, 
    128,  63,   0,   0,   0,   0, 
     50,   0,   0,  10, 114,   0, 
     16,   0,   5,   0,   0,   0, 
     70,   2,  16, 128,  65,   0, 
      0,   0,   5,   0,   0,   0, 
     70,   2,  16,   0,   6,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  15, 114,   0,  16,   0, 
      6,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,  64,   0,   0,   0,  64, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128, 191,   0,   0, 
    128, 191,   0,   0, 128, 191, 
      0,   0,   0,   0,   0,   0, 
      0,   8, 114,   0,  16,   0, 
      3,   0,   0,   0,  70,   2, 
     16, 128,  65,   0,   0,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   3,   0,   0,   0, 
     50,   0,   0,   9, 114,   0, 
     16,   0,   3,   0,   0,   0, 
     70,   2,  16,   0,   6,   0, 
      0,   0,  70,   2,  16,   0, 
      3,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     55,   0,   0,   9, 114,   0, 
     16,   0,   2,   0,   0,   0, 
     70,   2,  16,   0,   4,   0, 
      0,   0,  70,   2,  16,   0, 
      5,   0,   0,   0,  70,   2, 
     16,   0,   3,   0,   0,   0, 
     18,   0,   0,   1,  32,   0, 
      0,   8, 130,   0,  16,   0, 
      2,   0,   0,   0,  10, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,  10,   0,   0,   0, 
      0,   0,   0,   8, 114,   0, 
     16,   0,   3,   0,   0,   0, 
     70,   2,  16,   0,   0,   0, 
      0,   0,  70,   2,  16, 128, 
     65,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   7, 
    114,   0,  16,   0,   4,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   7, 114,   0, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  13, 114,   0,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16, 128,  65,   0,   0,   0, 
      1,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,  64, 
      0,   0,   0,  64,   0,   0, 
      0,  64,   0,   0,   0,   0, 
     70,   2,  16,   0,   4,   0, 
      0,   0,  55,   0,   0,  10, 
    114,   0,  16,   0,   2,   0, 
      0,   0, 246,  15,  16,   0, 
      2,   0,   0,   0,  70,   2, 
     16, 128, 129,   0,   0,   0, 
      3,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     21,   0,   0,   1,  21,   0, 
      0,   1,  21,   0,   0,   1, 
      0,   0,   0,   8,  18,   0, 
     16,   0,   1,   0,   0,   0, 
     58,   0,  16, 128,  65,   0, 
      0,   0,   1,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,  56,   0,   0,   7, 
    226,   0,  16,   0,   1,   0, 
      0,   0, 246,  15,  16,   0, 
      1,   0,   0,   0,   6,   9, 
     16,   0,   2,   0,   0,   0, 
     50,   0,   0,   9, 114,   0, 
     16,   0,   0,   0,   0,   0, 
      6,   0,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0, 150,   7, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   7, 114,  32, 
     16,   0,   0,   0,   0,   0, 
    246,  15,  16,   0,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5, 130,  32,  16,   0, 
      0,   0,   0,   0,  58,   0, 
     16,   0,   0,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
     66,   0,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  38,   0, 
      0,   0,   4,   0,   0,   0, 
      1,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
    100,   1,   0,   0,   1,   0, 
      0,   0, 232,   0,   0,   0, 
      5,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 255, 255, 
      0,   1,   0,   0,  48,   1, 
      0,   0, 188,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 197,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    209,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 213,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   1,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 220,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    115,  83,  97, 109, 112, 108, 
    101, 114,   0, 115,  66,  99, 
    107,  83,  97, 109, 112, 108, 
    101, 114,   0, 116, 101, 120, 
      0,  98,  99, 107, 116, 101, 
    120,   0,  36,  71, 108, 111, 
     98,  97, 108, 115,   0, 171, 
    171, 171, 220,   0,   0,   0, 
      1,   0,   0,   0,   0,   1, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  24,   1,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   2,   0,   0,   0, 
     32,   1,   0,   0,   0,   0, 
      0,   0,  98, 108, 101, 110, 
    100, 111, 112,   0,   0,   0, 
     19,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0, 171, 171, 
     73,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   3,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  79,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  83,  86,  95,  84, 
     97, 114, 103, 101, 116,   0, 
    171, 171, 120,  34,   0,   0, 
      0,   0,   0,   0,  83,  97, 
    109, 112, 108, 101,  84, 101, 
    120, 116, 117, 114, 101,  70, 
    111, 114,  78, 111, 110,  83, 
    101, 112,  97, 114,  97,  98, 
    108, 101,  66, 108, 101, 110, 
    100, 105, 110, 103,   0,  68, 
      4,   0,   0,  68,  88,  66, 
     67,  77,  85, 167, 240,  56, 
     56, 155,  78, 125,  96,  49, 
    253, 103, 100,  22,  62,   1, 
      0,   0,   0,  68,   4,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 248,   0,   0, 
      0, 244,   1,   0,   0, 112, 
      2,   0,   0, 160,   3,   0, 
      0, 212,   3,   0,   0,  65, 
    111, 110,  57, 184,   0,   0, 
      0, 184,   0,   0,   0,   0, 
      2, 254, 255, 132,   0,   0, 
      0,  52,   0,   0,   0,   1, 
      0,  36,   0,   0,   0,  48, 
      0,   0,   0,  48,   0,   0, 
      0,  36,   0,   1,   0,  48, 
      0,   0,   0,   0,   0,   3, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 254, 255,  81,   0,   0, 
      5,   4,   0,  15, 160,   0, 
      0,   0,   0,   0,   0, 128, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,  31,   0,   0, 
      2,   5,   0,   0, 128,   0, 
      0,  15, 144,   4,   0,   0, 
      4,   0,   0,   3, 224,   0, 
      0, 228, 144,   2,   0, 238, 
    160,   2,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,  12, 
    224,   0,   0,  20, 144,   3, 
      0, 180, 160,   3,   0,  20, 
    160,   4,   0,   0,   4,   0, 
      0,   3, 128,   0,   0, 228, 
    144,   1,   0, 238, 160,   1, 
      0, 228, 160,   2,   0,   0, 
      3,   0,   0,   3, 192,   0, 
      0, 228, 128,   0,   0, 228, 
    160,   1,   0,   0,   2,   0, 
      0,  12, 192,   4,   0,  68, 
    160, 255, 255,   0,   0,  83, 
     72,  68,  82, 244,   0,   0, 
      0,  64,   0,   1,   0,  61, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  95,   0,   0,   3,  50, 
     16,  16,   0,   0,   0,   0, 
      0, 103,   0,   0,   4, 242, 
     32,  16,   0,   0,   0,   0, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3,  50,  32,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 194,  32,  16, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   0,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   8, 194, 
     32,  16,   0,   0,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 128,  63,  50,   0,   0, 
     11,  50,  32,  16,   0,   1, 
      0,   0,   0,  70,  16,  16, 
      0,   0,   0,   0,   0, 230, 
    138,  32,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,  70, 
    128,  32,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11, 194,  32,  16, 
      0,   1,   0,   0,   0,   6, 
     20,  16,   0,   0,   0,   0, 
      0, 166, 142,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,   6, 132,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,   5,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70,  40,   1,   0,   0,   1, 
      0,   0,   0,  64,   0,   0, 
      0,   1,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 254, 
    255,   0,   1,   0,   0, 246, 
      0,   0,   0,  60,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  99, 
     98,  48,   0,  60,   0,   0, 
      0,   4,   0,   0,   0,  88, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 184,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 212,   0,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 222,   0,   0, 
      0,  32,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 236,   0,   0, 
      0,  48,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  77, 
     97, 115, 107,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  84, 101, 120, 116,  67, 
    111, 108, 111, 114,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  54,  46, 
     51,  46,  57,  54,  48,  48, 
     46,  49,  54,  51,  56,  52, 
      0,  73,  83,  71,  78,  44, 
      0,   0,   0,   1,   0,   0, 
      0,   8,   0,   0,   0,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   7,   3,   0,   0,  80, 
     79,  83,  73,  84,  73,  79, 
     78,   0, 171, 171, 171,  79, 
     83,  71,  78, 104,   0,   0, 
      0,   3,   0,   0,   0,   8, 
      0,   0,   0,  80,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   3, 
     12,   0,   0,  92,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      3,   0,   0,  83,  86,  95, 
     80, 111, 115, 105, 116, 105, 
    111, 110,   0,  84,  69,  88, 
     67,  79,  79,  82,  68,   0, 
    171, 171, 171,   1,  52,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   0,   0,   0, 216, 
     37,   0,   0,  68,  88,  66, 
     67, 205, 124, 125, 227, 208, 
    119, 203, 250, 120,  38, 135, 
    194, 158, 189,  85, 176,   1, 
      0,   0,   0, 216,  37,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0,  72,  13,   0, 
      0,  76,  35,   0,   0, 200, 
     35,   0,   0,  52,  37,   0, 
      0, 164,  37,   0,   0,  65, 
    111, 110,  57,   8,  13,   0, 
      0,   8,  13,   0,   0,   0, 
      2, 255, 255, 208,  12,   0, 
      0,  56,   0,   0,   0,   1, 
      0,  44,   0,   0,   0,  56, 
      0,   0,   0,  56,   0,   2, 
      0,  36,   0,   0,   0,  56, 
      0,   0,   0,   0,   0,   1, 
      1,   1,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   1,   2, 255, 
    255,  81,   0,   0,   5,   1, 
      0,  15, 160,   0,   0,  64, 
    193,   0,   0,  80, 193,   0, 
      0,  96, 193,   0,   0,   0, 
      0,  81,   0,   0,   5,   2, 
      0,  15, 160,   0,   0, 128, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  81,   0,   0,   5,   3, 
      0,  15, 160, 154, 153, 153, 
     62,  61,  10,  23,  63, 174, 
     71, 225,  61,   0,   0,   0, 
      0,  31,   0,   0,   2,   0, 
      0,   0, 128,   0,   0,  15, 
    176,  31,   0,   0,   2,   0, 
      0,   0, 144,   0,   8,  15, 
    160,  31,   0,   0,   2,   0, 
      0,   0, 144,   1,   8,  15, 
    160,   1,   0,   0,   2,   0, 
      0,   2, 128,   2,   0,  85, 
    160,   1,   0,   0,   2,   1, 
      0,   2, 128,   2,   0,  85, 
    160,   1,   0,   0,   2,   2, 
      0,   4, 128,   2,   0,  85, 
    160,  66,   0,   0,   3,   3, 
      0,  15, 128,   0,   0, 228, 
    176,   1,   8, 228, 160,  66, 
      0,   0,   3,   4,   0,  15, 
    128,   0,   0, 228, 176,   0, 
      8, 228, 160,   6,   0,   0, 
      2,   0,   0,   8, 128,   4, 
      0, 255, 128,   5,   0,   0, 
      3,   5,   0,   7, 128,   0, 
      0, 255, 128,   4,   0, 228, 
    128,   4,   0,   0,   4,   6, 
      0,   3, 128,   4,   0, 225, 
    128,   0,   0, 255, 128,   5, 
      0, 230, 129,  88,   0,   0, 
      4,   7,   0,   3, 128,   6, 
      0,   0, 128,   5,   0, 233, 
    128,   5,   0, 230, 128,  11, 
      0,   0,   3,   1,   0,   8, 
    128,   5,   0,   0, 128,   7, 
      0,   0, 128,  10,   0,   0, 
      3,   2,   0,   8, 128,   7, 
      0,  85, 128,   5,   0,   0, 
    128,   2,   0,   0,   3,   7, 
      0,   8, 128,   1,   0, 255, 
    128,   2,   0, 255, 129,   6, 
      0,   0,   2,   1,   0,   8, 
    128,   3,   0, 255, 128,   5, 
      0,   0,   3,   8,   0,   7, 
    128,   1,   0, 255, 128,   3, 
      0, 228, 128,   4,   0,   0, 
      4,   9,   0,   3, 128,   3, 
      0,   0, 128,   1,   0, 255, 
    128,   8,   0, 230, 129,   6, 
      0,   0,   2,   2,   0,   8, 
    128,   9,   0,  85, 128,   5, 
      0,   0,   3,   2,   0,   8, 
    128,   2,   0, 255, 128,   7, 
      0, 255, 128,   4,   0,   0, 
      4,  10,   0,  15, 128,   3, 
      0, 150, 128,   1,   0, 255, 
    128,   8,   0,  96, 129,   5, 
      0,   0,   3,   7,   0,   2, 
    128,   2,   0, 255, 128,  10, 
      0, 255, 128,   1,   0,   0, 
      2,   9,   0,  12, 128,  10, 
      0, 228, 128,  88,   0,   0, 
      4,   1,   0,   5, 128,   9, 
      0,  85, 129,   9,   0, 245, 
    128,   7,   0, 215, 128,   6, 
      0,   0,   2,   2,   0,   8, 
    128,   9,   0,   0, 128,   5, 
      0,   0,   3,   2,   0,   8, 
    128,   2,   0, 255, 128,   7, 
      0, 255, 128,   5,   0,   0, 
      3,   7,   0,   1, 128,   2, 
      0, 255, 128,   9,   0, 170, 
    128,  88,   0,   0,   4,   2, 
      0,   3, 128,   9,   0,   0, 
    129,   9,   0, 232, 128,   7, 
      0, 227, 128,  88,   0,   0, 
      4,   1,   0,   7, 128,   9, 
      0, 255, 128,   1,   0, 228, 
    128,   2,   0, 228, 128,   6, 
      0,   0,   2,   5,   0,   8, 
    128,   9,   0, 255, 128,   5, 
      0,   0,   3,   5,   0,   8, 
    128,   5,   0, 255, 128,   7, 
      0, 255, 128,   5,   0,   0, 
      3,   7,   0,   4, 128,   5, 
      0, 255, 128,   9,   0,  85, 
    128,  88,   0,   0,   4,   0, 
      0,   5, 128,  10,   0, 255, 
    129,   9,   0, 245, 128,   7, 
      0, 246, 128,  88,   0,   0, 
      4,   0,   0,   7, 128,  10, 
      0,   0, 128,   0,   0, 228, 
    128,   1,   0, 228, 128,   1, 
      0,   0,   2,   1,   0,   1, 
    128,   2,   0,  85, 160,   1, 
      0,   0,   2,   2,   0,   1, 
    128,   2,   0,  85, 160,   1, 
      0,   0,   2,  11,   0,   4, 
    128,   2,   0,  85, 160,   6, 
      0,   0,   2,   2,   0,   8, 
    128,   9,   0, 170, 128,   5, 
      0,   0,   3,   2,   0,   8, 
    128,   2,   0, 255, 128,   7, 
      0, 255, 128,   5,   0,   0, 
      3,   7,   0,   1, 128,   2, 
      0, 255, 128,   9,   0,   0, 
    128,  88,   0,   0,   4,  11, 
      0,   3, 128,  10,   0, 170, 
    129,   9,   0, 232, 128,   7, 
      0, 236, 128,   6,   0,   0, 
      2,   2,   0,   8, 128,  10, 
      0,  85, 128,   5,   0,   0, 
      3,   2,   0,   8, 128,   2, 
      0, 255, 128,   7,   0, 255, 
    128,   5,   0,   0,   3,   7, 
      0,   2, 128,   2,   0, 255, 
    128,  10,   0,   0, 128,  88, 
      0,   0,   4,   2,   0,   6, 
    128,  10,   0,  85, 129,  10, 
      0, 196, 128,   7,   0, 220, 
    128,  88,   0,   0,   4,   2, 
      0,   7, 128,  10,   0,   0, 
    128,   2,   0, 228, 128,  11, 
      0, 228, 128,   6,   0,   0, 
      2,   2,   0,   8, 128,  10, 
      0,   0, 128,   5,   0,   0, 
      3,   2,   0,   8, 128,   2, 
      0, 255, 128,   7,   0, 255, 
    128,   5,   0,   0,   3,   7, 
      0,   4, 128,   2,   0, 255, 
    128,  10,   0,  85, 128,  88, 
      0,   0,   4,   1,   0,   6, 
    128,  10,   0,   0, 129,  10, 
      0, 196, 128,   7,   0, 248, 
    128,  88,   0,   0,   4,   1, 
      0,   7, 128,   9,   0, 255, 
    128,   1,   0, 228, 128,   2, 
      0, 228, 128,  88,   0,   0, 
      4,   0,   0,   7, 128,  10, 
      0,  85, 128,   1,   0, 228, 
    128,   0,   0, 228, 128,  88, 
      0,   0,   4,   1,   0,   3, 
    128,   9,   0, 170, 128,   8, 
      0, 233, 128,   8,   0, 230, 
    128,   8,   0,   0,   3,   5, 
      0,   8, 128,   0,   0, 228, 
    128,   3,   0, 228, 160,   8, 
      0,   0,   3,   1,   0,   4, 
    128,   8,   0, 228, 128,   3, 
      0, 228, 160,   2,   0,   0, 
      3,   5,   0,   8, 128,   5, 
      0, 255, 129,   1,   0, 170, 
    128,   2,   0,   0,   3,   0, 
      0,   7, 128,   0,   0, 228, 
    128,   5,   0, 255, 128,   2, 
      0,   0,   3,   5,   0,   8, 
    128,   0,   0,  85, 129,   0, 
      0,   0, 128,  88,   0,   0, 
      4,   2,   0,   3, 128,   5, 
      0, 255, 128,   0,   0, 225, 
    128,   0,   0, 228, 128,  10, 
      0,   0,   3,   5,   0,   8, 
    128,   0,   0, 170, 128,   2, 
      0,   0, 128,  11,   0,   0, 
      3,   7,   0,   1, 128,   2, 
      0,  85, 128,   0,   0, 170, 
    128,   8,   0,   0,   3,   2, 
      0,   1, 128,   0,   0, 228, 
    128,   3,   0, 228, 160,   2, 
      0,   0,   3,   2,   0,   2, 
    128,   5,   0, 255, 129,   2, 
      0,   0, 128,   6,   0,   0, 
      2,   2,   0,   2, 128,   2, 
      0,  85, 128,   2,   0,   0, 
      3,   7,   0,  14, 128,   0, 
      0, 144, 128,   2,   0,   0, 
    129,   5,   0,   0,   3,   7, 
      0,  14, 128,   2,   0,   0, 
    128,   7,   0, 228, 128,   4, 
      0,   0,   4,   2,   0,  14, 
    128,   7,   0, 228, 128,   2, 
      0,  85, 128,   2,   0,   0, 
    128,  88,   0,   0,   4,   0, 
      0,   7, 128,   5,   0, 255, 
    128,   0,   0, 228, 128,   2, 
      0, 249, 128,   2,   0,   0, 
      3,   2,   0,  14, 128,   2, 
      0,   0, 129,   0,   0, 144, 
    128,   2,   0,   0,   3,   5, 
      0,   8, 128,   2,   0,   0, 
    129,   2,   0,   0, 160,   5, 
      0,   0,   3,   2,   0,  14, 
    128,   2,   0, 228, 128,   5, 
      0, 255, 128,   2,   0,   0, 
      3,   5,   0,   8, 128,   2, 
      0,   0, 129,   7,   0,   0, 
    128,   2,   0,   0,   3,   7, 
      0,   1, 128,   7,   0,   0, 
    129,   2,   0,   0, 160,   6, 
      0,   0,   2,   5,   0,   8, 
    128,   5,   0, 255, 128,   4, 
      0,   0,   4,   2,   0,   7, 
    128,   2,   0, 249, 128,   5, 
      0, 255, 128,   2,   0,   0, 
    128,  88,   0,   0,   4,   0, 
      0,   7, 128,   7,   0,   0, 
    128,   0,   0, 228, 128,   2, 
      0, 228, 128,   8,   0,   0, 
      3,   5,   0,   8, 128,   5, 
      0, 228, 128,   3,   0, 228, 
    160,   2,   0,   0,   3,   2, 
      0,   1, 128,   1,   0, 170, 
    128,   5,   0, 255, 129,   2, 
      0,   0,   3,   5,   0,   8, 
    128,   1,   0, 170, 129,   5, 
      0, 255, 128,   4,   0,   0, 
      4,   2,   0,  14, 128,   3, 
      0, 144, 128,   1,   0, 255, 
    128,   5,   0, 255, 128,   4, 
      0,   0,   4,   3,   0,   7, 
    128,   4,   0, 228, 128,   0, 
      0, 255, 128,   2,   0,   0, 
    128,   4,   0,   0,   4,   7, 
      0,  15, 128,   4,   0,  38, 
    128,   0,   0, 255, 128,   5, 
      0, 144, 129,   2,   0,   0, 
      3,   0,   0,   8, 128,   3, 
      0,  85, 129,   3,   0,   0, 
    128,  88,   0,   0,   4,   8, 
      0,   6, 128,   0,   0, 255, 
    128,   3,   0, 196, 128,   3, 
      0, 208, 128,  10,   0,   0, 
      3,   0,   0,   8, 128,   3, 
      0, 170, 128,   8,   0,  85, 
    128,  11,   0,   0,   3,   1, 
      0,   8, 128,   8,   0, 170, 
    128,   3,   0, 170, 128,   8, 
      0,   0,   3,   5,   0,   8, 
    128,   3,   0, 228, 128,   3, 
      0, 228, 160,   2,   0,   0, 
      3,   2,   0,   1, 128,   0, 
      0, 255, 129,   5,   0, 255, 
    128,   6,   0,   0,   2,   2, 
      0,   1, 128,   2,   0,   0, 
    128,   2,   0,   0,   3,   8, 
      0,  14, 128,   3,   0, 144, 
    128,   5,   0, 255, 129,   5, 
      0,   0,   3,   8,   0,  14, 
    128,   5,   0, 255, 128,   8, 
      0, 228, 128,   4,   0,   0, 
      4,   8,   0,  14, 128,   8, 
      0, 228, 128,   2,   0,   0, 
    128,   5,   0, 255, 128,  88, 
      0,   0,   4,   3,   0,   7, 
    128,   0,   0, 255, 128,   3, 
      0, 228, 128,   8,   0, 249, 
    128,   2,   0,   0,   3,   8, 
      0,  14, 128,   5,   0, 255, 
    129,   3,   0, 144, 128,   2, 
      0,   0,   3,   0,   0,   8, 
    128,   5,   0, 255, 129,   2, 
      0,   0, 160,   5,   0,   0, 
      3,   8,   0,  14, 128,   0, 
      0, 255, 128,   8,   0, 228, 
    128,   2,   0,   0,   3,   0, 
      0,   8, 128,   1,   0, 255, 
    128,   5,   0, 255, 129,   2, 
      0,   0,   3,   1,   0,   8, 
    128,   1,   0, 255, 129,   2, 
      0,   0, 160,   6,   0,   0, 
      2,   0,   0,   8, 128,   0, 
      0, 255, 128,   4,   0,   0, 
      4,   8,   0,  14, 128,   8, 
      0, 228, 128,   0,   0, 255, 
    128,   5,   0, 255, 128,  88, 
      0,   0,   4,   3,   0,   7, 
    128,   1,   0, 255, 128,   3, 
      0, 228, 128,   8,   0, 249, 
    128,   2,   0,   0,   3,   0, 
      0,   8, 128,   2,   0, 170, 
    129,   2,   0,  85, 128,  88, 
      0,   0,   4,   8,   0,   6, 
    128,   0,   0, 255, 128,   2, 
      0, 216, 128,   2,   0, 228, 
    128,  10,   0,   0,   3,   0, 
      0,   8, 128,   2,   0, 255, 
    128,   8,   0,  85, 128,  11, 
      0,   0,   3,   1,   0,   8, 
    128,   8,   0, 170, 128,   2, 
      0, 255, 128,   8,   0,   0, 
      3,   5,   0,   8, 128,   2, 
      0, 249, 128,   3,   0, 228, 
    160,   2,   0,   0,   3,   2, 
      0,   1, 128,   0,   0, 255, 
    129,   5,   0, 255, 128,   6, 
      0,   0,   2,   2,   0,   1, 
    128,   2,   0,   0, 128,   2, 
      0,   0,   3,   8,   0,  14, 
    128,   2,   0, 228, 128,   5, 
      0, 255, 129,   5,   0,   0, 
      3,   8,   0,  14, 128,   5, 
      0, 255, 128,   8,   0, 228, 
    128,   4,   0,   0,   4,   8, 
      0,  14, 128,   8,   0, 228, 
    128,   2,   0,   0, 128,   5, 
      0, 255, 128,  88,   0,   0, 
      4,   2,   0,   7, 128,   0, 
      0, 255, 128,   2,   0, 249, 
    128,   8,   0, 249, 128,   2, 
      0,   0,   3,   8,   0,  14, 
    128,   5,   0, 255, 129,   2, 
      0, 144, 128,   2,   0,   0, 
      3,   0,   0,   8, 128,   5, 
      0, 255, 129,   2,   0,   0, 
    160,   5,   0,   0,   3,   8, 
      0,  14, 128,   0,   0, 255, 
    128,   8,   0, 228, 128,   2, 
      0,   0,   3,   0,   0,   8, 
    128,   1,   0, 255, 128,   5, 
      0, 255, 129,   2,   0,   0, 
      3,   1,   0,   8, 128,   1, 
      0, 255, 129,   2,   0,   0, 
    160,   6,   0,   0,   2,   0, 
      0,   8, 128,   0,   0, 255, 
    128,   4,   0,   0,   4,   8, 
      0,  14, 128,   8,   0, 228, 
    128,   0,   0, 255, 128,   5, 
      0, 255, 128,  88,   0,   0, 
      4,   2,   0,   7, 128,   1, 
      0, 255, 128,   2,   0, 228, 
    128,   8,   0, 249, 128,   1, 
      0,   0,   2,   0,   0,   8, 
    128,   0,   0,   0, 160,   2, 
      0,   0,   3,   8,   0,  14, 
    128,   0,   0, 255, 128,   1, 
      0, 144, 160,   5,   0,   0, 
      3,   8,   0,  14, 128,   8, 
      0, 228, 128,   8,   0, 228, 
    128,  88,   0,   0,   4,   2, 
      0,   7, 128,   8,   0, 255, 
    129,   3,   0, 228, 128,   2, 
      0, 228, 128,  88,   0,   0, 
      4,   0,   0,   7, 128,   8, 
      0, 170, 129,   0,   0, 228, 
    128,   2,   0, 228, 128,   1, 
      0,   0,   2,   2,   0,   2, 
    128,   2,   0,  85, 160,   1, 
      0,   0,   2,   3,   0,   2, 
    128,   2,   0,  85, 160,   1, 
      0,   0,   2,   9,   0,   4, 
    128,   2,   0,  85, 160,  11, 
      0,   0,   3,   0,   0,   8, 
    128,   8,   0,   0, 128,   1, 
      0,   0, 128,  10,   0,   0, 
      3,   2,   0,   8, 128,   1, 
      0,  85, 128,   8,   0,   0, 
    128,   2,   0,   0,   3,  10, 
      0,   8, 128,   0,   0, 255, 
    128,   2,   0, 255, 129,   6, 
      0,   0,   2,   0,   0,   8, 
    128,   7,   0, 255, 128,   5, 
      0,   0,   3,   0,   0,   8, 
    128,   0,   0, 255, 128,  10, 
      0, 255, 128,   5,   0,   0, 
      3,  10,   0,   1, 128,   0, 
      0, 255, 128,   6,   0,   0, 
    128,   1,   0,   0,   2,   6, 
      0,  12, 128,   7,   0, 180, 
    128,  88,   0,   0,   4,   9, 
      0,   3, 128,   7,   0, 255, 
    129,   6,   0, 226, 128,  10, 
      0, 227, 128,   6,   0,   0, 
      2,   0,   0,   8, 128,   6, 
      0,  85, 128,   5,   0,   0, 
      3,   0,   0,   8, 128,   0, 
      0, 255, 128,  10,   0, 255, 
    128,   5,   0,   0,   3,  10, 
      0,   2, 128,   0,   0, 255, 
    128,   7,   0, 170, 128,  88, 
      0,   0,   4,   3,   0,   5, 
    128,   6,   0,  85, 129,   6, 
      0, 245, 128,  10,   0, 215, 
    128,  88,   0,   0,   4,   1, 
      0,  11, 128,   7,   0, 170, 
    128,   3,   0, 164, 128,   9, 
      0, 164, 128,   6,   0,   0, 
      2,   0,   0,   8, 128,   7, 
      0, 170, 128,   5,   0,   0, 
      3,   0,   0,   8, 128,   0, 
      0, 255, 128,  10,   0, 255, 
    128,   5,   0,   0,   3,  10, 
      0,   4, 128,   0,   0, 255, 
    128,   6,   0,  85, 128,  88, 
      0,   0,   4,   2,   0,   5, 
    128,   7,   0, 170, 129,   6, 
      0, 245, 128,  10,   0, 246, 
    128,  88,   0,   0,   4,   1, 
      0,  11, 128,   7,   0,   0, 
    128,   2,   0, 164, 128,   1, 
      0, 228, 128,   1,   0,   0, 
      2,   2,   0,   1, 128,   2, 
      0,  85, 160,   1,   0,   0, 
      2,   3,   0,   4, 128,   2, 
      0,  85, 160,   6,   0,   0, 
      2,   0,   0,   8, 128,   6, 
      0,   0, 128,   5,   0,   0, 
      3,   0,   0,   8, 128,   0, 
      0, 255, 128,  10,   0, 255, 
    128,   5,   0,   0,   3,  10, 
      0,   1, 128,   0,   0, 255, 
    128,   7,   0, 255, 128,  88, 
      0,   0,   4,   3,   0,   3, 
    128,   6,   0,   0, 129,   6, 
      0, 226, 128,  10,   0, 236, 
    128,   6,   0,   0,   2,   0, 
      0,   8, 128,   7,   0,  85, 
    128,   5,   0,   0,   3,   0, 
      0,   8, 128,   0,   0, 255, 
    128,  10,   0, 255, 128,   5, 
      0,   0,   3,  10,   0,   2, 
    128,   0,   0, 255, 128,   7, 
      0,   0, 128,  88,   0,   0, 
      4,   2,   0,   6, 128,   7, 
      0,  85, 129,   7,   0, 196, 
    128,  10,   0, 220, 128,  88, 
      0,   0,   4,   2,   0,   7, 
    128,   7,   0,   0, 128,   2, 
      0, 228, 128,   3,   0, 228, 
    128,   1,   0,   0,   2,   3, 
      0,   1, 128,   2,   0,  85, 
    160,   6,   0,   0,   2,   0, 
      0,   8, 128,   7,   0,   0, 
    128,   5,   0,   0,   3,   0, 
      0,   8, 128,   0,   0, 255, 
    128,  10,   0, 255, 128,   5, 
      0,   0,   3,  10,   0,   4, 
    128,   0,   0, 255, 128,   7, 
      0,  85, 128,  88,   0,   0, 
      4,   3,   0,   6, 128,   7, 
      0,   0, 129,   7,   0, 196, 
    128,  10,   0, 248, 128,  88, 
      0,   0,   4,   2,   0,   7, 
    128,   7,   0, 170, 128,   3, 
      0, 228, 128,   2,   0, 228, 
    128,  88,   0,   0,   4,   1, 
      0,  11, 128,   7,   0,  85, 
    128,   2,   0, 164, 128,   1, 
      0, 228, 128,   8,   0,   0, 
      3,   0,   0,   8, 128,   1, 
      0, 244, 128,   3,   0, 228, 
    160,   2,   0,   0,   3,   0, 
      0,   8, 128,   0,   0, 255, 
    129,   1,   0, 170, 128,   2, 
      0,   0,   3,   1,   0,   7, 
    128,   0,   0, 255, 128,   1, 
      0, 244, 128,   2,   0,   0, 
      3,   0,   0,   8, 128,   1, 
      0,  85, 129,   1,   0,   0, 
    128,  88,   0,   0,   4,   2, 
      0,   3, 128,   0,   0, 255, 
    128,   1,   0, 225, 128,   1, 
      0, 228, 128,  10,   0,   0, 
      3,   0,   0,   8, 128,   1, 
      0, 170, 128,   2,   0,   0, 
    128,  11,   0,   0,   3,   5, 
      0,   8, 128,   2,   0,  85, 
    128,   1,   0, 170, 128,   8, 
      0,   0,   3,   1,   0,   8, 
    128,   1,   0, 228, 128,   3, 
      0, 228, 160,   2,   0,   0, 
      3,   2,   0,   7, 128,   1, 
      0, 255, 129,   1,   0, 228, 
    128,   5,   0,   0,   3,   2, 
      0,   7, 128,   1,   0, 255, 
    128,   2,   0, 228, 128,   2, 
      0,   0,   3,   2,   0,   8, 
    128,   0,   0, 255, 129,   1, 
      0, 255, 128,   6,   0,   0, 
      2,   2,   0,   8, 128,   2, 
      0, 255, 128,   4,   0,   0, 
      4,   2,   0,   7, 128,   2, 
      0, 228, 128,   2,   0, 255, 
    128,   1,   0, 255, 128,  88, 
      0,   0,   4,   1,   0,   7, 
    128,   0,   0, 255, 128,   1, 
      0, 228, 128,   2,   0, 228, 
    128,   2,   0,   0,   3,   2, 
      0,   7, 128,   1,   0, 255, 
    129,   1,   0, 228, 128,   2, 
      0,   0,   3,   0,   0,   8, 
    128,   1,   0, 255, 129,   2, 
      0,   0, 160,   5,   0,   0, 
      3,   2,   0,   7, 128,   0, 
      0, 255, 128,   2,   0, 228, 
    128,   2,   0,   0,   3,   0, 
      0,   8, 128,   1,   0, 255, 
    129,   5,   0, 255, 128,   2, 
      0,   0,   3,   2,   0,   8, 
    128,   5,   0, 255, 129,   2, 
      0,   0, 160,   6,   0,   0, 
      2,   0,   0,   8, 128,   0, 
      0, 255, 128,   4,   0,   0, 
      4,   2,   0,   7, 128,   2, 
      0, 228, 128,   0,   0, 255, 
    128,   1,   0, 255, 128,  88, 
      0,   0,   4,   1,   0,   7, 
    128,   2,   0, 255, 128,   1, 
      0, 228, 128,   2,   0, 228, 
    128,  88,   0,   0,   4,   0, 
      0,   7, 128,   8,   0,  85, 
    129,   1,   0, 228, 128,   0, 
      0, 228, 128,  18,   0,   0, 
      4,   1,   0,   7, 128,   3, 
      0, 255, 128,   0,   0, 228, 
    128,   5,   0, 228, 128,   5, 
      0,   0,   3,   1,   0,   8, 
    128,   3,   0, 255, 128,   3, 
      0, 255, 128,  88,   0,   0, 
      4,   1,   0,   8, 128,   1, 
      0, 255, 129,   2,   0,   0, 
    160,   2,   0,  85, 160,   5, 
      0,   0,   3,   0,   0,   7, 
    128,   4,   0, 255, 128,   1, 
      0, 228, 128,   5,   0,   0, 
      3,   0,   0,   8, 128,   4, 
      0, 255, 128,   4,   0, 255, 
    128,  88,   0,   0,   4,   0, 
      0,   8, 128,   0,   0, 255, 
    129,   2,   0,   0, 160,   2, 
      0,  85, 160,   2,   0,   0, 
      3,   0,   0,   8, 128,   1, 
      0, 255, 128,   0,   0, 255, 
    128,  88,   0,   0,   4,   4, 
      0,   7, 128,   0,   0, 255, 
    129,   0,   0, 228, 128,   4, 
      0, 228, 128,   1,   0,   0, 
      2,   0,   8,  15, 128,   4, 
      0, 228, 128, 255, 255,   0, 
      0,  83,  72,  68,  82, 252, 
     21,   0,   0,  64,   0,   0, 
      0, 127,   5,   0,   0,  89, 
      0,   0,   4,  70, 142,  32, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,  90,   0,   0, 
      3,   0,  96,  16,   0,   0, 
      0,   0,   0,  90,   0,   0, 
      3,   0,  96,  16,   0,   1, 
      0,   0,   0,  88,  24,   0, 
      4,   0, 112,  16,   0,   0, 
      0,   0,   0,  85,  85,   0, 
      0,  88,  24,   0,   4,   0, 
    112,  16,   0,   1,   0,   0, 
      0,  85,  85,   0,   0,  98, 
     16,   0,   3,  50,  16,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 242,  32,  16, 
      0,   0,   0,   0,   0, 104, 
      0,   0,   2,   9,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   0,   0,   0,   0,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   1,   0,   0, 
      0,  70,  16,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   1,   0,   0,   0,   0, 
     96,  16,   0,   1,   0,   0, 
      0,  24,   0,   0,   7,  18, 
      0,  16,   0,   2,   0,   0, 
      0,  58,   0,  16,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,  24, 
      0,   0,   7,  34,   0,  16, 
      0,   2,   0,   0,   0,  58, 
      0,  16,   0,   1,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  60,   0,   0, 
      7,  18,   0,  16,   0,   2, 
      0,   0,   0,  26,   0,  16, 
      0,   2,   0,   0,   0,  10, 
      0,  16,   0,   2,   0,   0, 
      0,  31,   0,   4,   3,  10, 
      0,  16,   0,   2,   0,   0, 
      0,  54,   0,   0,   5, 242, 
     32,  16,   0,   0,   0,   0, 
      0,  70,  14,  16,   0,   0, 
      0,   0,   0,  62,   0,   0, 
      1,  21,   0,   0,   1,  14, 
      0,   0,   7, 114,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      2,  16,   0,   0,   0,   0, 
      0, 246,  15,  16,   0,   0, 
      0,   0,   0,  14,   0,   0, 
      7, 114,   0,  16,   0,   1, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0, 246, 
     15,  16,   0,   1,   0,   0, 
      0,  32,   0,   0,   8,  18, 
      0,  16,   0,   2,   0,   0, 
      0,  10, 128,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,  12, 
      0,   0,   0,  31,   0,   4, 
      3,  10,   0,  16,   0,   2, 
      0,   0,   0,  52,   0,   0, 
      7,  18,   0,  16,   0,   2, 
      0,   0,   0,  42,   0,  16, 
      0,   1,   0,   0,   0,  26, 
      0,  16,   0,   1,   0,   0, 
      0,  52,   0,   0,   7,  18, 
      0,  16,   0,   2,   0,   0, 
      0,  10,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
      0,   2,   0,   0,   0,  51, 
      0,   0,   7,  34,   0,  16, 
      0,   2,   0,   0,   0,  42, 
      0,  16,   0,   1,   0,   0, 
      0,  26,   0,  16,   0,   1, 
      0,   0,   0,  51,   0,   0, 
      7,  34,   0,  16,   0,   2, 
      0,   0,   0,  10,   0,  16, 
      0,   1,   0,   0,   0,  26, 
      0,  16,   0,   2,   0,   0, 
      0,   0,   0,   0,   8, 130, 
      0,  16,   0,   2,   0,   0, 
      0,  26,   0,  16, 128,  65, 
      0,   0,   0,   2,   0,   0, 
      0,  10,   0,  16,   0,   2, 
      0,   0,   0,  29,   0,   0, 
      7,  18,   0,  16,   0,   3, 
      0,   0,   0,  26,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  31,   0,   4,   3,  10, 
      0,  16,   0,   3,   0,   0, 
      0,   0,   0,   0,   8, 242, 
      0,  16,   0,   3,   0,   0, 
      0,   6,  10,  16, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0, 150,   4,  16,   0,   0, 
      0,   0,   0,  49,   0,   0, 
     10, 114,   0,  16,   0,   4, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  22, 
      7,  16,   0,   3,   0,   0, 
      0,  14,   0,   0,   7, 114, 
      0,  16,   0,   5,   0,   0, 
      0, 246,  15,  16,   0,   2, 
      0,   0,   0,  22,   7,  16, 
      0,   3,   0,   0,   0,  56, 
      0,   0,   7, 114,   0,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   3,   0,   0, 
      0,  70,   2,  16,   0,   5, 
      0,   0,   0,  55,   0,   0, 
      9,  98,   0,  16,   0,   5, 
      0,   0,   0,   6,   0,  16, 
      0,   4,   0,   0,   0,   6, 
      3,  16,   0,   2,   0,   0, 
      0,   6,   1,  16,   0,   3, 
      0,   0,   0,  29,   0,   0, 
      7, 146,   0,  16,   0,   4, 
      0,   0,   0, 166,  10,  16, 
      0,   0,   0,   0,   0,  86, 
      1,  16,   0,   0,   0,   0, 
      0,  55,   0,   0,   9,  98, 
      0,  16,   0,   6,   0,   0, 
      0,  86,   5,  16,   0,   4, 
      0,   0,   0, 246,  13,  16, 
      0,   2,   0,   0,   0,   6, 
      1,  16,   0,   3,   0,   0, 
      0,  55,   0,   0,   9,  50, 
      0,  16,   0,   3,   0,   0, 
      0, 166,  10,  16,   0,   4, 
      0,   0,   0, 230,  10,  16, 
      0,   2,   0,   0,   0, 230, 
     10,  16,   0,   3,   0,   0, 
      0,  54,   0,   0,   5,  18, 
      0,  16,   0,   6,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  66,   0,  16,   0,   3, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,  55, 
      0,   0,   9, 114,   0,  16, 
      0,   3,   0,   0,   0, 246, 
     15,  16,   0,   4,   0,   0, 
      0,  70,   2,  16,   0,   6, 
      0,   0,   0,  70,   2,  16, 
      0,   3,   0,   0,   0,  54, 
      0,   0,   5,  18,   0,  16, 
      0,   5,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  55,   0,   0,   9, 114, 
      0,  16,   0,   3,   0,   0, 
      0,   6,   0,  16,   0,   4, 
      0,   0,   0,  70,   2,  16, 
      0,   5,   0,   0,   0,  70, 
      2,  16,   0,   3,   0,   0, 
      0,  18,   0,   0,   1,   0, 
      0,   0,   8, 242,   0,  16, 
      0,   4,   0,   0,   0,  86, 
     10,  16, 128,  65,   0,   0, 
      0,   0,   0,   0,   0, 134, 
      1,  16,   0,   0,   0,   0, 
      0,  49,   0,   0,  10, 114, 
      0,  16,   0,   5,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  22,   7,  16, 
      0,   4,   0,   0,   0,  14, 
      0,   0,   7, 114,   0,  16, 
      0,   6,   0,   0,   0, 246, 
     15,  16,   0,   2,   0,   0, 
      0,  22,   7,  16,   0,   4, 
      0,   0,   0,  56,   0,   0, 
      7, 114,   0,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   4,   0,   0,   0,  70, 
      2,  16,   0,   6,   0,   0, 
      0,  55,   0,   0,   9,  82, 
      0,  16,   0,   6,   0,   0, 
      0,   6,   0,  16,   0,   5, 
      0,   0,   0,   6,   3,  16, 
      0,   2,   0,   0,   0,   6, 
      1,  16,   0,   4,   0,   0, 
      0,  29,   0,   0,   7, 146, 
      0,  16,   0,   5,   0,   0, 
      0, 166,  10,  16,   0,   0, 
      0,   0,   0,   6,   4,  16, 
      0,   0,   0,   0,   0,  55, 
      0,   0,   9,  82,   0,  16, 
      0,   7,   0,   0,   0,  86, 
      5,  16,   0,   5,   0,   0, 
      0, 246,  13,  16,   0,   2, 
      0,   0,   0,   6,   1,  16, 
      0,   4,   0,   0,   0,  55, 
      0,   0,   9,  50,   0,  16, 
      0,   2,   0,   0,   0, 166, 
     10,  16,   0,   5,   0,   0, 
      0, 182,  15,  16,   0,   2, 
      0,   0,   0, 182,  15,  16, 
      0,   4,   0,   0,   0,  54, 
      0,   0,   5,  34,   0,  16, 
      0,   7,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   5,  66, 
      0,  16,   0,   2,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  55,   0,   0, 
      9, 114,   0,  16,   0,   2, 
      0,   0,   0, 246,  15,  16, 
      0,   5,   0,   0,   0,  70, 
      2,  16,   0,   7,   0,   0, 
      0,  70,   2,  16,   0,   2, 
      0,   0,   0,  54,   0,   0, 
      5,  34,   0,  16,   0,   6, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,  55, 
      0,   0,   9, 114,   0,  16, 
      0,   3,   0,   0,   0,   6, 
      0,  16,   0,   5,   0,   0, 
      0,  70,   2,  16,   0,   6, 
      0,   0,   0,  70,   2,  16, 
      0,   2,   0,   0,   0,  21, 
      0,   0,   1,  16,   0,   0, 
     10,  18,   0,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,   2, 
     64,   0,   0, 154, 153, 153, 
     62,  61,  10,  23,  63, 174, 
     71, 225,  61,   0,   0,   0, 
      0,  16,   0,   0,  10,  34, 
      0,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   3, 
      0,   0,   0,   2,  64,   0, 
      0, 154, 153, 153,  62,  61, 
     10,  23,  63, 174,  71, 225, 
     61,   0,   0,   0,   0,   0, 
      0,   0,   8,  18,   0,  16, 
      0,   2,   0,   0,   0,  26, 
      0,  16, 128,  65,   0,   0, 
      0,   2,   0,   0,   0,  10, 
      0,  16,   0,   2,   0,   0, 
      0,   0,   0,   0,   7, 114, 
      0,  16,   0,   2,   0,   0, 
      0,   6,   0,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   3,   0,   0,   0,  16, 
      0,   0,  10, 130,   0,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   2,   0,   0, 
      0,   2,  64,   0,   0, 154, 
    153, 153,  62,  61,  10,  23, 
     63, 174,  71, 225,  61,   0, 
      0,   0,   0,  51,   0,   0, 
      7,  18,   0,  16,   0,   3, 
      0,   0,   0,  26,   0,  16, 
      0,   2,   0,   0,   0,  10, 
      0,  16,   0,   2,   0,   0, 
      0,  51,   0,   0,   7,  18, 
      0,  16,   0,   3,   0,   0, 
      0,  42,   0,  16,   0,   2, 
      0,   0,   0,  10,   0,  16, 
      0,   3,   0,   0,   0,  52, 
      0,   0,   7,  34,   0,  16, 
      0,   3,   0,   0,   0,  26, 
      0,  16,   0,   2,   0,   0, 
      0,  10,   0,  16,   0,   2, 
      0,   0,   0,  52,   0,   0, 
      7,  34,   0,  16,   0,   3, 
      0,   0,   0,  42,   0,  16, 
      0,   2,   0,   0,   0,  26, 
      0,  16,   0,   3,   0,   0, 
      0,  49,   0,   0,   7,  66, 
      0,  16,   0,   3,   0,   0, 
      0,  10,   0,  16,   0,   3, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   8, 114,   0,  16, 
      0,   4,   0,   0,   0, 246, 
     15,  16, 128,  65,   0,   0, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   2,   0,   0, 
      0,  56,   0,   0,   7, 114, 
      0,  16,   0,   4,   0,   0, 
      0, 246,  15,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   8,  18,   0,  16, 
      0,   3,   0,   0,   0,  58, 
      0,  16,   0,   2,   0,   0, 
      0,  10,   0,  16, 128,  65, 
      0,   0,   0,   3,   0,   0, 
      0,  14,   0,   0,   7, 114, 
      0,  16,   0,   4,   0,   0, 
      0,  70,   2,  16,   0,   4, 
      0,   0,   0,   6,   0,  16, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   7, 114,   0,  16, 
      0,   4,   0,   0,   0, 246, 
     15,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   4, 
      0,   0,   0,  55,   0,   0, 
      9, 114,   0,  16,   0,   2, 
      0,   0,   0, 166,  10,  16, 
      0,   3,   0,   0,   0,  70, 
      2,  16,   0,   4,   0,   0, 
      0,  70,   2,  16,   0,   2, 
      0,   0,   0,  49,   0,   0, 
      7,  18,   0,  16,   0,   3, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0, 128,  63,  26, 
      0,  16,   0,   3,   0,   0, 
      0,   0,   0,   0,   8, 114, 
      0,  16,   0,   4,   0,   0, 
      0, 246,  15,  16, 128,  65, 
      0,   0,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      8,  66,   0,  16,   0,   3, 
      0,   0,   0,  58,   0,  16, 
    128,  65,   0,   0,   0,   2, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0, 128,  63,  56, 
      0,   0,   7, 114,   0,  16, 
      0,   4,   0,   0,   0, 166, 
     10,  16,   0,   3,   0,   0, 
      0,  70,   2,  16,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      8,  34,   0,  16,   0,   3, 
      0,   0,   0,  58,   0,  16, 
    128,  65,   0,   0,   0,   2, 
      0,   0,   0,  26,   0,  16, 
      0,   3,   0,   0,   0,  14, 
      0,   0,   7, 226,   0,  16, 
      0,   3,   0,   0,   0,   6, 
      9,  16,   0,   4,   0,   0, 
      0,  86,   5,  16,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      7, 226,   0,  16,   0,   3, 
      0,   0,   0, 246,  15,  16, 
      0,   2,   0,   0,   0,  86, 
     14,  16,   0,   3,   0,   0, 
      0,  55,   0,   0,   9, 114, 
      0,  16,   0,   2,   0,   0, 
      0,   6,   0,  16,   0,   3, 
      0,   0,   0, 150,   7,  16, 
      0,   3,   0,   0,   0,  70, 
      2,  16,   0,   2,   0,   0, 
      0,  18,   0,   0,   1,  32, 
      0,   0,   8, 130,   0,  16, 
      0,   2,   0,   0,   0,  10, 
    128,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
     64,   0,   0,  13,   0,   0, 
      0,  31,   0,   4,   3,  58, 
      0,  16,   0,   2,   0,   0, 
      0,  52,   0,   0,   7, 130, 
      0,  16,   0,   2,   0,   0, 
      0,  42,   0,  16,   0,   0, 
      0,   0,   0,  26,   0,  16, 
      0,   0,   0,   0,   0,  52, 
      0,   0,   7, 130,   0,  16, 
      0,   2,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  58,   0,  16,   0,   2, 
      0,   0,   0,  51,   0,   0, 
      7,  18,   0,  16,   0,   3, 
      0,   0,   0,  42,   0,  16, 
      0,   0,   0,   0,   0,  26, 
      0,  16,   0,   0,   0,   0, 
      0,  51,   0,   0,   7,  18, 
      0,  16,   0,   3,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   8, 130,   0,  16, 
      0,   3,   0,   0,   0,  58, 
      0,  16,   0,   2,   0,   0, 
      0,  10,   0,  16, 128,  65, 
      0,   0,   0,   3,   0,   0, 
      0,  29,   0,   0,   7, 130, 
      0,  16,   0,   2,   0,   0, 
      0,  26,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
      0,   1,   0,   0,   0,  31, 
      0,   4,   3,  58,   0,  16, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   8, 242,   0,  16, 
      0,   4,   0,   0,   0,   6, 
     10,  16, 128,  65,   0,   0, 
      0,   1,   0,   0,   0, 150, 
      4,  16,   0,   1,   0,   0, 
      0,  49,   0,   0,  10, 114, 
      0,  16,   0,   5,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  22,   7,  16, 
      0,   4,   0,   0,   0,  14, 
      0,   0,   7, 114,   0,  16, 
      0,   6,   0,   0,   0, 246, 
     15,  16,   0,   3,   0,   0, 
      0,  22,   7,  16,   0,   4, 
      0,   0,   0,  56,   0,   0, 
      7, 114,   0,  16,   0,   3, 
      0,   0,   0,  70,   2,  16, 
      0,   4,   0,   0,   0,  70, 
      2,  16,   0,   6,   0,   0, 
      0,  55,   0,   0,   9,  98, 
      0,  16,   0,   6,   0,   0, 
      0,   6,   0,  16,   0,   5, 
      0,   0,   0,   6,   3,  16, 
      0,   3,   0,   0,   0,   6, 
      1,  16,   0,   4,   0,   0, 
      0,  29,   0,   0,   7, 146, 
      0,  16,   0,   5,   0,   0, 
      0, 166,  10,  16,   0,   1, 
      0,   0,   0,  86,   1,  16, 
      0,   1,   0,   0,   0,  55, 
      0,   0,   9,  98,   0,  16, 
      0,   7,   0,   0,   0,  86, 
      5,  16,   0,   5,   0,   0, 
      0, 246,  13,  16,   0,   3, 
      0,   0,   0,   6,   1,  16, 
      0,   4,   0,   0,   0,  55, 
      0,   0,   9,  50,   0,  16, 
      0,   4,   0,   0,   0, 166, 
     10,  16,   0,   5,   0,   0, 
      0, 230,  10,  16,   0,   3, 
      0,   0,   0, 230,  10,  16, 
      0,   4,   0,   0,   0,  54, 
      0,   0,   5,  18,   0,  16, 
      0,   7,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   5,  66, 
      0,  16,   0,   4,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  55,   0,   0, 
      9, 114,   0,  16,   0,   4, 
      0,   0,   0, 246,  15,  16, 
      0,   5,   0,   0,   0,  70, 
      2,  16,   0,   7,   0,   0, 
      0,  70,   2,  16,   0,   4, 
      0,   0,   0,  54,   0,   0, 
      5,  18,   0,  16,   0,   6, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,  55, 
      0,   0,   9, 114,   0,  16, 
      0,   4,   0,   0,   0,   6, 
      0,  16,   0,   5,   0,   0, 
      0,  70,   2,  16,   0,   6, 
      0,   0,   0,  70,   2,  16, 
      0,   4,   0,   0,   0,  18, 
      0,   0,   1,   0,   0,   0, 
      8, 242,   0,  16,   0,   5, 
      0,   0,   0,  86,  10,  16, 
    128,  65,   0,   0,   0,   1, 
      0,   0,   0, 134,   1,  16, 
      0,   1,   0,   0,   0,  49, 
      0,   0,  10, 114,   0,  16, 
      0,   6,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  22,   7,  16,   0,   5, 
      0,   0,   0,  14,   0,   0, 
      7, 114,   0,  16,   0,   7, 
      0,   0,   0, 246,  15,  16, 
      0,   3,   0,   0,   0,  22, 
      7,  16,   0,   5,   0,   0, 
      0,  56,   0,   0,   7, 114, 
      0,  16,   0,   3,   0,   0, 
      0,  70,   2,  16,   0,   5, 
      0,   0,   0,  70,   2,  16, 
      0,   7,   0,   0,   0,  55, 
      0,   0,   9,  82,   0,  16, 
      0,   7,   0,   0,   0,   6, 
      0,  16,   0,   6,   0,   0, 
      0,   6,   3,  16,   0,   3, 
      0,   0,   0,   6,   1,  16, 
      0,   5,   0,   0,   0,  29, 
      0,   0,   7, 146,   0,  16, 
      0,   6,   0,   0,   0, 166, 
     10,  16,   0,   1,   0,   0, 
      0,   6,   4,  16,   0,   1, 
      0,   0,   0,  55,   0,   0, 
      9,  82,   0,  16,   0,   8, 
      0,   0,   0,  86,   5,  16, 
      0,   6,   0,   0,   0, 246, 
     13,  16,   0,   3,   0,   0, 
      0,   6,   1,  16,   0,   5, 
      0,   0,   0,  55,   0,   0, 
      9,  50,   0,  16,   0,   3, 
      0,   0,   0, 166,  10,  16, 
      0,   6,   0,   0,   0, 182, 
     15,  16,   0,   3,   0,   0, 
      0, 182,  15,  16,   0,   5, 
      0,   0,   0,  54,   0,   0, 
      5,  34,   0,  16,   0,   8, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  66,   0,  16, 
      0,   3,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  55,   0,   0,   9, 114, 
      0,  16,   0,   3,   0,   0, 
      0, 246,  15,  16,   0,   6, 
      0,   0,   0,  70,   2,  16, 
      0,   8,   0,   0,   0,  70, 
      2,  16,   0,   3,   0,   0, 
      0,  54,   0,   0,   5,  34, 
      0,  16,   0,   7,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  55,   0,   0, 
      9, 114,   0,  16,   0,   4, 
      0,   0,   0,   6,   0,  16, 
      0,   6,   0,   0,   0,  70, 
      2,  16,   0,   7,   0,   0, 
      0,  70,   2,  16,   0,   3, 
      0,   0,   0,  21,   0,   0, 
      1,  16,   0,   0,  10, 130, 
      0,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   1, 
      0,   0,   0,   2,  64,   0, 
      0, 154, 153, 153,  62,  61, 
     10,  23,  63, 174,  71, 225, 
     61,   0,   0,   0,   0,  16, 
      0,   0,  10,  18,   0,  16, 
      0,   3,   0,   0,   0,  70, 
      2,  16,   0,   4,   0,   0, 
      0,   2,  64,   0,   0, 154, 
    153, 153,  62,  61,  10,  23, 
     63, 174,  71, 225,  61,   0, 
      0,   0,   0,   0,   0,   0, 
      8, 130,   0,  16,   0,   2, 
      0,   0,   0,  58,   0,  16, 
      0,   2,   0,   0,   0,  10, 
      0,  16, 128,  65,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   7, 114,   0,  16, 
      0,   3,   0,   0,   0, 246, 
     15,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   4, 
      0,   0,   0,  16,   0,   0, 
     10, 130,   0,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   3,   0,   0,   0,   2, 
     64,   0,   0, 154, 153, 153, 
     62,  61,  10,  23,  63, 174, 
     71, 225,  61,   0,   0,   0, 
      0,  51,   0,   0,   7, 130, 
      0,  16,   0,   3,   0,   0, 
      0,  26,   0,  16,   0,   3, 
      0,   0,   0,  10,   0,  16, 
      0,   3,   0,   0,   0,  51, 
      0,   0,   7, 130,   0,  16, 
      0,   3,   0,   0,   0,  42, 
      0,  16,   0,   3,   0,   0, 
      0,  58,   0,  16,   0,   3, 
      0,   0,   0,  52,   0,   0, 
      7,  18,   0,  16,   0,   4, 
      0,   0,   0,  26,   0,  16, 
      0,   3,   0,   0,   0,  10, 
      0,  16,   0,   3,   0,   0, 
      0,  52,   0,   0,   7,  18, 
      0,  16,   0,   4,   0,   0, 
      0,  42,   0,  16,   0,   3, 
      0,   0,   0,  10,   0,  16, 
      0,   4,   0,   0,   0,  49, 
      0,   0,   7,  34,   0,  16, 
      0,   4,   0,   0,   0,  58, 
      0,  16,   0,   3,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      8, 114,   0,  16,   0,   5, 
      0,   0,   0, 246,  15,  16, 
    128,  65,   0,   0,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   3,   0,   0,   0,  56, 
      0,   0,   7, 114,   0,  16, 
      0,   5,   0,   0,   0, 246, 
     15,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   5, 
      0,   0,   0,   0,   0,   0, 
      8, 130,   0,  16,   0,   3, 
      0,   0,   0,  58,   0,  16, 
      0,   2,   0,   0,   0,  58, 
      0,  16, 128,  65,   0,   0, 
      0,   3,   0,   0,   0,  14, 
      0,   0,   7, 114,   0,  16, 
      0,   5,   0,   0,   0,  70, 
      2,  16,   0,   5,   0,   0, 
      0, 246,  15,  16,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      7, 114,   0,  16,   0,   5, 
      0,   0,   0, 246,  15,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   5,   0,   0, 
      0,  55,   0,   0,   9, 114, 
      0,  16,   0,   3,   0,   0, 
      0,  86,   5,  16,   0,   4, 
      0,   0,   0,  70,   2,  16, 
      0,   5,   0,   0,   0,  70, 
      2,  16,   0,   3,   0,   0, 
      0,  49,   0,   0,   7, 130, 
      0,  16,   0,   3,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,  10,   0,  16, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   8, 226,   0,  16, 
      0,   4,   0,   0,   0, 246, 
     15,  16, 128,  65,   0,   0, 
      0,   2,   0,   0,   0,   6, 
      9,  16,   0,   3,   0,   0, 
      0,   0,   0,   0,   8,  18, 
      0,  16,   0,   5,   0,   0, 
      0,  58,   0,  16, 128,  65, 
      0,   0,   0,   2,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,  56,   0,   0, 
      7, 226,   0,  16,   0,   4, 
      0,   0,   0,  86,  14,  16, 
      0,   4,   0,   0,   0,   6, 
      0,  16,   0,   5,   0,   0, 
      0,   0,   0,   0,   8,  18, 
      0,  16,   0,   4,   0,   0, 
      0,  58,   0,  16, 128,  65, 
      0,   0,   0,   2,   0,   0, 
      0,  10,   0,  16,   0,   4, 
      0,   0,   0,  14,   0,   0, 
      7, 114,   0,  16,   0,   4, 
      0,   0,   0, 150,   7,  16, 
      0,   4,   0,   0,   0,   6, 
      0,  16,   0,   4,   0,   0, 
      0,   0,   0,   0,   7, 114, 
      0,  16,   0,   4,   0,   0, 
      0, 246,  15,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   4,   0,   0,   0,  55, 
      0,   0,   9, 114,   0,  16, 
      0,   2,   0,   0,   0, 246, 
     15,  16,   0,   3,   0,   0, 
      0,  70,   2,  16,   0,   4, 
      0,   0,   0,  70,   2,  16, 
      0,   3,   0,   0,   0,  18, 
      0,   0,   1,  32,   0,   0, 
      8, 130,   0,  16,   0,   2, 
      0,   0,   0,  10, 128,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,  14,   0,   0,   0,  31, 
      0,   4,   3,  58,   0,  16, 
      0,   2,   0,   0,   0,  16, 
      0,   0,  10, 130,   0,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   1,   0,   0, 
      0,   2,  64,   0,   0, 154, 
    153, 153,  62,  61,  10,  23, 
     63, 174,  71, 225,  61,   0, 
      0,   0,   0,  16,   0,   0, 
     10,  18,   0,  16,   0,   3, 
      0,   0,   0,  70,   2,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0, 154, 153, 153, 
     62,  61,  10,  23,  63, 174, 
     71, 225,  61,   0,   0,   0, 
      0,   0,   0,   0,   8, 130, 
      0,  16,   0,   2,   0,   0, 
      0,  58,   0,  16,   0,   2, 
      0,   0,   0,  10,   0,  16, 
    128,  65,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      7, 114,   0,  16,   0,   3, 
      0,   0,   0,  70,   2,  16, 
      0,   0,   0,   0,   0, 246, 
     15,  16,   0,   2,   0,   0, 
      0,  16,   0,   0,  10, 130, 
      0,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   3, 
      0,   0,   0,   2,  64,   0, 
      0, 154, 153, 153,  62,  61, 
     10,  23,  63, 174,  71, 225, 
     61,   0,   0,   0,   0,  51, 
      0,   0,   7, 130,   0,  16, 
      0,   3,   0,   0,   0,  26, 
      0,  16,   0,   3,   0,   0, 
      0,  10,   0,  16,   0,   3, 
      0,   0,   0,  51,   0,   0, 
      7, 130,   0,  16,   0,   3, 
      0,   0,   0,  42,   0,  16, 
      0,   3,   0,   0,   0,  58, 
      0,  16,   0,   3,   0,   0, 
      0,  52,   0,   0,   7,  18, 
      0,  16,   0,   4,   0,   0, 
      0,  26,   0,  16,   0,   3, 
      0,   0,   0,  10,   0,  16, 
      0,   3,   0,   0,   0,  52, 
      0,   0,   7,  18,   0,  16, 
      0,   4,   0,   0,   0,  42, 
      0,  16,   0,   3,   0,   0, 
      0,  10,   0,  16,   0,   4, 
      0,   0,   0,  49,   0,   0, 
      7,  34,   0,  16,   0,   4, 
      0,   0,   0,  58,   0,  16, 
      0,   3,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   8, 114, 
      0,  16,   0,   5,   0,   0, 
      0, 246,  15,  16, 128,  65, 
      0,   0,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   3, 
      0,   0,   0,  56,   0,   0, 
      7, 114,   0,  16,   0,   5, 
      0,   0,   0, 246,  15,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   5,   0,   0, 
      0,   0,   0,   0,   8, 130, 
      0,  16,   0,   3,   0,   0, 
      0,  58,   0,  16,   0,   2, 
      0,   0,   0,  58,   0,  16, 
    128,  65,   0,   0,   0,   3, 
      0,   0,   0,  14,   0,   0, 
      7, 114,   0,  16,   0,   5, 
      0,   0,   0,  70,   2,  16, 
      0,   5,   0,   0,   0, 246, 
     15,  16,   0,   3,   0,   0, 
      0,   0,   0,   0,   7, 114, 
      0,  16,   0,   5,   0,   0, 
      0, 246,  15,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   5,   0,   0,   0,  55, 
      0,   0,   9, 114,   0,  16, 
      0,   3,   0,   0,   0,  86, 
      5,  16,   0,   4,   0,   0, 
      0,  70,   2,  16,   0,   5, 
      0,   0,   0,  70,   2,  16, 
      0,   3,   0,   0,   0,  49, 
      0,   0,   7, 130,   0,  16, 
      0,   3,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  10,   0,  16,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      8, 226,   0,  16,   0,   4, 
      0,   0,   0, 246,  15,  16, 
    128,  65,   0,   0,   0,   2, 
      0,   0,   0,   6,   9,  16, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   8,  18,   0,  16, 
      0,   5,   0,   0,   0,  58, 
      0,  16, 128,  65,   0,   0, 
      0,   2,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  56,   0,   0,   7, 226, 
      0,  16,   0,   4,   0,   0, 
      0,  86,  14,  16,   0,   4, 
      0,   0,   0,   6,   0,  16, 
      0,   5,   0,   0,   0,   0, 
      0,   0,   8,  18,   0,  16, 
      0,   4,   0,   0,   0,  58, 
      0,  16, 128,  65,   0,   0, 
      0,   2,   0,   0,   0,  10, 
      0,  16,   0,   4,   0,   0, 
      0,  14,   0,   0,   7, 114, 
      0,  16,   0,   4,   0,   0, 
      0, 150,   7,  16,   0,   4, 
      0,   0,   0,   6,   0,  16, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   7, 114,   0,  16, 
      0,   4,   0,   0,   0, 246, 
     15,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   4, 
      0,   0,   0,  55,   0,   0, 
      9, 114,   0,  16,   0,   2, 
      0,   0,   0, 246,  15,  16, 
      0,   3,   0,   0,   0,  70, 
      2,  16,   0,   4,   0,   0, 
      0,  70,   2,  16,   0,   3, 
      0,   0,   0,  18,   0,   0, 
      1,  16,   0,   0,  10, 130, 
      0,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0, 154, 153, 153,  62,  61, 
     10,  23,  63, 174,  71, 225, 
     61,   0,   0,   0,   0,  16, 
      0,   0,  10,  18,   0,  16, 
      0,   3,   0,   0,   0,  70, 
      2,  16,   0,   1,   0,   0, 
      0,   2,  64,   0,   0, 154, 
    153, 153,  62,  61,  10,  23, 
     63, 174,  71, 225,  61,   0, 
      0,   0,   0,   0,   0,   0, 
      8, 130,   0,  16,   0,   2, 
      0,   0,   0,  58,   0,  16, 
      0,   2,   0,   0,   0,  10, 
      0,  16, 128,  65,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   7, 114,   0,  16, 
      0,   1,   0,   0,   0,  70, 
      2,  16,   0,   1,   0,   0, 
      0, 246,  15,  16,   0,   2, 
      0,   0,   0,  16,   0,   0, 
     10, 130,   0,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,   2, 
     64,   0,   0, 154, 153, 153, 
     62,  61,  10,  23,  63, 174, 
     71, 225,  61,   0,   0,   0, 
      0,  51,   0,   0,   7,  18, 
      0,  16,   0,   3,   0,   0, 
      0,  26,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
      0,   1,   0,   0,   0,  51, 
      0,   0,   7,  18,   0,  16, 
      0,   3,   0,   0,   0,  42, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16,   0,   3, 
      0,   0,   0,  52,   0,   0, 
      7,  34,   0,  16,   0,   3, 
      0,   0,   0,  26,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16,   0,   1,   0,   0, 
      0,  52,   0,   0,   7,  34, 
      0,  16,   0,   3,   0,   0, 
      0,  42,   0,  16,   0,   1, 
      0,   0,   0,  26,   0,  16, 
      0,   3,   0,   0,   0,  49, 
      0,   0,   7,  66,   0,  16, 
      0,   3,   0,   0,   0,  10, 
      0,  16,   0,   3,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      8, 114,   0,  16,   0,   4, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0, 246, 
     15,  16, 128,  65,   0,   0, 
      0,   2,   0,   0,   0,  56, 
      0,   0,   7, 114,   0,  16, 
      0,   4,   0,   0,   0, 246, 
     15,  16,   0,   2,   0,   0, 
      0,  70,   2,  16,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      8,  18,   0,  16,   0,   3, 
      0,   0,   0,  58,   0,  16, 
      0,   2,   0,   0,   0,  10, 
      0,  16, 128,  65,   0,   0, 
      0,   3,   0,   0,   0,  14, 
      0,   0,   7, 114,   0,  16, 
      0,   4,   0,   0,   0,  70, 
      2,  16,   0,   4,   0,   0, 
      0,   6,   0,  16,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      7, 114,   0,  16,   0,   4, 
      0,   0,   0, 246,  15,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   4,   0,   0, 
      0,  55,   0,   0,   9, 114, 
      0,  16,   0,   1,   0,   0, 
      0, 166,  10,  16,   0,   3, 
      0,   0,   0,  70,   2,  16, 
      0,   4,   0,   0,   0,  70, 
      2,  16,   0,   1,   0,   0, 
      0,  49,   0,   0,   7,  18, 
      0,  16,   0,   3,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,  26,   0,  16, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   8, 114,   0,  16, 
      0,   4,   0,   0,   0, 246, 
     15,  16, 128,  65,   0,   0, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   1,   0,   0, 
      0,   0,   0,   0,   8,  66, 
      0,  16,   0,   3,   0,   0, 
      0,  58,   0,  16, 128,  65, 
      0,   0,   0,   2,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,  56,   0,   0, 
      7, 114,   0,  16,   0,   4, 
      0,   0,   0, 166,  10,  16, 
      0,   3,   0,   0,   0,  70, 
      2,  16,   0,   4,   0,   0, 
      0,   0,   0,   0,   8,  34, 
      0,  16,   0,   3,   0,   0, 
      0,  58,   0,  16, 128,  65, 
      0,   0,   0,   2,   0,   0, 
      0,  26,   0,  16,   0,   3, 
      0,   0,   0,  14,   0,   0, 
      7, 226,   0,  16,   0,   3, 
      0,   0,   0,   6,   9,  16, 
      0,   4,   0,   0,   0,  86, 
      5,  16,   0,   3,   0,   0, 
      0,   0,   0,   0,   7, 226, 
      0,  16,   0,   3,   0,   0, 
      0, 246,  15,  16,   0,   2, 
      0,   0,   0,  86,  14,  16, 
      0,   3,   0,   0,   0,  55, 
      0,   0,   9, 114,   0,  16, 
      0,   2,   0,   0,   0,   6, 
      0,  16,   0,   3,   0,   0, 
      0, 150,   7,  16,   0,   3, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,  21, 
      0,   0,   1,  21,   0,   0, 
      1,  21,   0,   0,   1,   0, 
      0,   0,   8,  18,   0,  16, 
      0,   1,   0,   0,   0,  58, 
      0,  16, 128,  65,   0,   0, 
      0,   1,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  56,   0,   0,   7, 226, 
      0,  16,   0,   1,   0,   0, 
      0, 246,  15,  16,   0,   1, 
      0,   0,   0,   6,   9,  16, 
      0,   2,   0,   0,   0,  50, 
      0,   0,   9, 114,   0,  16, 
      0,   0,   0,   0,   0,   6, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   2,  16,   0,   0, 
      0,   0,   0, 150,   7,  16, 
      0,   1,   0,   0,   0,  56, 
      0,   0,   7, 114,  32,  16, 
      0,   0,   0,   0,   0, 246, 
     15,  16,   0,   0,   0,   0, 
      0,  70,   2,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5, 130,  32,  16,   0,   0, 
      0,   0,   0,  58,   0,  16, 
      0,   0,   0,   0,   0,  62, 
      0,   0,   1,  83,  84,  65, 
     84, 116,   0,   0,   0, 195, 
      0,   0,   0,   9,   0,   0, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0, 128,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,   7,   0,   0, 
      0,   6,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  14,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  82,  68,  69,  70, 100, 
      1,   0,   0,   1,   0,   0, 
      0, 232,   0,   0,   0,   5, 
      0,   0,   0,  28,   0,   0, 
      0,   0,   4, 255, 255,   0, 
      1,   0,   0,  48,   1,   0, 
      0, 188,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 197,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 209, 
      0,   0,   0,   2,   0,   0, 
      0,   5,   0,   0,   0,   4, 
      0,   0,   0, 255, 255, 255, 
    255,   0,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0, 213,   0,   0,   0,   2, 
      0,   0,   0,   5,   0,   0, 
      0,   4,   0,   0,   0, 255, 
    255, 255, 255,   1,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0, 220,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 115, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 115,  66,  99, 107, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 116, 101, 120,   0, 
     98,  99, 107, 116, 101, 120, 
      0,  36,  71, 108, 111,  98, 
     97, 108, 115,   0, 171, 171, 
    171, 220,   0,   0,   0,   1, 
      0,   0,   0,   0,   1,   0, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  24,   1,   0,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  32, 
      1,   0,   0,   0,   0,   0, 
      0,  98, 108, 101, 110, 100, 
    111, 112,   0,   0,   0,  19, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  77, 105,  99, 114, 111, 
    115, 111, 102, 116,  32,  40, 
     82,  41,  32,  72,  76,  83, 
     76,  32,  83, 104,  97, 100, 
    101, 114,  32,  67, 111, 109, 
    112, 105, 108, 101, 114,  32, 
     54,  46,  51,  46,  57,  54, 
     48,  48,  46,  49,  54,  51, 
     56,  52,   0, 171, 171,  73, 
     83,  71,  78, 104,   0,   0, 
      0,   3,   0,   0,   0,   8, 
      0,   0,   0,  80,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      3,   0,   0,  92,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0,  83,  86,  95, 
     80, 111, 115, 105, 116, 105, 
    111, 110,   0,  84,  69,  88, 
     67,  79,  79,  82,  68,   0, 
    171, 171, 171,  79,  83,  71, 
     78,  44,   0,   0,   0,   1, 
      0,   0,   0,   8,   0,   0, 
      0,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  15,   0,   0, 
      0,  83,  86,  95,  84,  97, 
    114, 103, 101, 116,   0, 171, 
    171,  93,  56,   0,   0,   0, 
      0,   0,   0,  83,  97, 109, 
    112, 108, 101,  82,  97, 100, 
    105,  97, 108,  71, 114,  97, 
    100, 105, 101, 110, 116,   0, 
     65,  80, 111, 115,   0,  44, 
      7,   0,   0,  68,  88,  66, 
     67, 172,  27, 205, 113, 176, 
    254,  27,  44,  22, 107, 179, 
    112, 127,  38, 148, 161,   1, 
      0,   0,   0,  44,   7,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 148,   1,   0, 
      0, 104,   3,   0,   0, 228, 
      3,   0,   0, 136,   6,   0, 
      0, 188,   6,   0,   0,  65, 
    111, 110,  57,  84,   1,   0, 
      0,  84,   1,   0,   0,   0, 
      2, 254, 255, 252,   0,   0, 
      0,  88,   0,   0,   0,   4, 
      0,  36,   0,   0,   0,  84, 
      0,   0,   0,  84,   0,   0, 
      0,  36,   0,   1,   0,  84, 
      0,   0,   0,   0,   0,   1, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   2,   0,   1, 
      0,   2,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   3,   0,   0,   0,   0, 
      0,   1,   0,   3,   0,   1, 
      0,   5,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 254, 255,  81,   0,   0, 
      5,   6,   0,  15, 160,   0, 
      0, 128,  63,   0,   0,   0, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,  31,   0,   0, 
      2,   5,   0,   0, 128,   0, 
      0,  15, 144,   4,   0,   0, 
      4,   0,   0,   3, 224,   0, 
      0, 228, 144,   2,   0, 238, 
    160,   2,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,   3, 
    128,   0,   0, 228, 144,   1, 
      0, 238, 160,   1,   0, 228, 
    160,   2,   0,   0,   3,   0, 
      0,   4, 128,   0,   0,   0, 
    128,   6,   0,   0, 160,   5, 
      0,   0,   3,   0,   0,   4, 
    128,   0,   0, 170, 128,   5, 
      0,   0, 160,   5,   0,   0, 
      3,   1,   0,   1, 128,   0, 
      0, 170, 128,   6,   0,  85, 
    160,   2,   0,   0,   3,   0, 
      0,   4, 128,   0,   0,  85, 
    129,   6,   0,   0, 160,   2, 
      0,   0,   3,   0,   0,   3, 
    192,   0,   0, 228, 128,   0, 
      0, 228, 160,   5,   0,   0, 
      3,   0,   0,   1, 128,   0, 
      0, 170, 128,   5,   0,  85, 
    160,   5,   0,   0,   3,   1, 
      0,   2, 128,   0,   0,   0, 
    128,   6,   0,  85, 160,   1, 
      0,   0,   2,   1,   0,   4, 
    128,   6,   0,   0, 160,   8, 
      0,   0,   3,   0,   0,   8, 
    224,   1,   0, 228, 128,   3, 
      0, 228, 160,   8,   0,   0, 
      3,   0,   0,   4, 224,   1, 
      0, 228, 128,   4,   0, 228, 
    160,   1,   0,   0,   2,   0, 
      0,  12, 192,   6,   0,  36, 
    160, 255, 255,   0,   0,  83, 
     72,  68,  82, 204,   1,   0, 
      0,  64,   0,   1,   0, 115, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  89,   0,   0,   4,  70, 
    142,  32,   0,   1,   0,   0, 
      0,   4,   0,   0,   0,  95, 
      0,   0,   3,  50,  16,  16, 
      0,   0,   0,   0,   0, 103, 
      0,   0,   4, 242,  32,  16, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3,  50,  32,  16,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3, 194,  32,  16,   0,   1, 
      0,   0,   0, 104,   0,   0, 
      2,   2,   0,   0,   0,  54, 
      0,   0,   8, 194,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 128, 
     63,  50,   0,   0,  11,  50, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  50,  32,  16,   0,   0, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,   0,   0,   0, 
      8,  34,   0,  16,   0,   0, 
      0,   0,   0,  26,   0,  16, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0, 128,  63,  56, 
      0,   0,   8,  50,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,  70, 128,  32,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,  56,   0,   0,  10,  50, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,  63,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  66,   0,  16, 
      0,   1,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  16,   0,   0,   8,  66, 
     32,  16,   0,   1,   0,   0, 
      0,  70,   2,  16,   0,   1, 
      0,   0,   0,  70, 130,  32, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  16,   0,   0, 
      8, 130,  32,  16,   0,   1, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,  70, 
    130,  32,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   1,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,  12,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   8, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70, 156,   2,   0,   0,   2, 
      0,   0,   0, 100,   0,   0, 
      0,   2,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 254, 
    255,   0,   1,   0,   0, 103, 
      2,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  96, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  99,  98,  48,   0,  99, 
     98,  50,   0,  92,   0,   0, 
      0,   4,   0,   0,   0, 148, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  96,   0,   0, 
      0,   7,   0,   0,   0,  52, 
      1,   0,   0, 112,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 244,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  16,   1,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  26,   1,   0, 
      0,  32,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  40,   1,   0, 
      0,  48,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  77, 
     97, 115, 107,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  84, 101, 120, 116,  67, 
    111, 108, 111, 114,   0, 171, 
    171, 220,   1,   0,   0,   0, 
      0,   0,   0,  44,   0,   0, 
      0,   2,   0,   0,   0, 244, 
      1,   0,   0,   0,   0,   0, 
      0,   4,   2,   0,   0,  48, 
      0,   0,   0,   8,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  32,   2,   0,   0,  64, 
      0,   0,   0,  12,   0,   0, 
      0,   0,   0,   0,   0,  40, 
      2,   0,   0,   0,   0,   0, 
      0,  56,   2,   0,   0,  80, 
      0,   0,   0,   8,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  64,   2,   0,   0,  88, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  84,   2,   0,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  92,   2,   0,   0,  96, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  68, 101, 118, 105,  99, 
    101,  83, 112,  97,  99, 101, 
     84, 111,  85, 115, 101, 114, 
     83, 112,  97,  99, 101,   0, 
    171,   3,   0,   3,   0,   3, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 109, 101, 110, 115, 105, 
    111, 110, 115,   0, 171,   1, 
      0,   3,   0,   1,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 102, 
    102,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  99, 101, 110, 
    116, 101, 114,  49,   0,  65, 
      0, 171, 171,   0,   0,   3, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 114,  97, 100, 105, 117, 
    115,  49,   0, 115, 113,  95, 
    114,  97, 100, 105, 117, 115, 
     49,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0, 171, 171, 
    171,  73,  83,  71,  78,  44, 
      0,   0,   0,   1,   0,   0, 
      0,   8,   0,   0,   0,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   7,   3,   0,   0,  80, 
     79,  83,  73,  84,  73,  79, 
     78,   0, 171, 171, 171,  79, 
     83,  71,  78, 104,   0,   0, 
      0,   3,   0,   0,   0,   8, 
      0,   0,   0,  80,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   3, 
     12,   0,   0,  92,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      3,   0,   0,  83,  86,  95, 
     80, 111, 115, 105, 116, 105, 
    111, 110,   0,  84,  69,  88, 
     67,  79,  79,  82,  68,   0, 
    171, 171, 171,  91,  94,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   0,   0,   0, 224, 
      9,   0,   0,  68,  88,  66, 
     67,  76, 106,  34, 250, 169, 
     50, 124,  43, 130, 255, 198, 
    178, 126, 127,  40, 188,   1, 
      0,   0,   0, 224,   9,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 128,   2,   0, 
      0,  88,   6,   0,   0, 212, 
      6,   0,   0,  60,   9,   0, 
      0, 172,   9,   0,   0,  65, 
    111, 110,  57,  64,   2,   0, 
      0,  64,   2,   0,   0,   0, 
      2, 255, 255,   8,   2,   0, 
      0,  56,   0,   0,   0,   1, 
      0,  44,   0,   0,   0,  56, 
      0,   0,   0,  56,   0,   2, 
      0,  36,   0,   0,   0,  56, 
      0,   0,   0,   0,   0,   1, 
      1,   1,   0,   0,   0,   4, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   1,   2, 255, 
    255,  81,   0,   0,   5,   3, 
      0,  15, 160,   0,   0,   0, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  81,   0,   0,   5,   4, 
      0,  15, 160,   0,   0, 128, 
     63,   0,   0, 128, 191,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  31,   0,   0,   2,   0, 
      0,   0, 128,   0,   0,  15, 
    176,  31,   0,   0,   2,   0, 
      0,   0, 144,   0,   8,  15, 
    160,  31,   0,   0,   2,   0, 
      0,   0, 144,   1,   8,  15, 
    160,   2,   0,   0,   3,   0, 
      0,   3, 128,   0,   0, 235, 
    176,   1,   0, 228, 161,  90, 
      0,   0,   4,   0,   0,   8, 
    128,   0,   0, 228, 128,   0, 
      0, 228, 128,   2,   0,   0, 
    161,   5,   0,   0,   3,   0, 
      0,   8, 128,   0,   0, 255, 
    128,   1,   0, 170, 160,   1, 
      0,   0,   2,   0,   0,   4, 
    128,   1,   0, 255, 160,   8, 
      0,   0,   3,   0,   0,   1, 
    128,   0,   0, 228, 128,   0, 
      0, 228, 160,   4,   0,   0, 
      4,   0,   0,   2, 128,   0, 
      0,   0, 128,   0,   0,   0, 
    128,   0,   0, 255, 129,  35, 
      0,   0,   2,   0,   0,   4, 
    128,   0,   0,  85, 128,   7, 
      0,   0,   2,   0,   0,   4, 
    128,   0,   0, 170, 128,   6, 
      0,   0,   2,   1,   0,   1, 
    128,   0,   0, 170, 128,   1, 
      0,   0,   2,   1,   0,   6, 
    128,   1,   0,   0, 129,   2, 
      0,   0,   3,   0,   0,  13, 
    128,   0,   0,   0, 128,   1, 
      0, 148, 128,   6,   0,   0, 
      2,   1,   0,   1, 128,   1, 
      0, 170, 160,   5,   0,   0, 
      3,   0,   0,  13, 128,   0, 
      0, 228, 128,   1,   0,   0, 
    128,   1,   0,   0,   2,   1, 
      0,   8, 128,   1,   0, 255, 
    160,   4,   0,   0,   4,   1, 
      0,   7, 128,   0,   0, 248, 
    128,   0,   0, 170, 160,   1, 
      0, 255, 128,  88,   0,   0, 
      4,   2,   0,   1, 128,   1, 
      0,   0, 128,   0,   0,   0, 
    128,   0,   0, 255, 128,  88, 
      0,   0,   4,   0,   0,  13, 
    128,   1,   0, 148, 128,   4, 
      0,  68, 160,   4,   0, 230, 
    160,   1,   0,   0,   2,   2, 
      0,   2, 128,   3,   0,   0, 
    160,  66,   0,   0,   3,   1, 
      0,  15, 128,   0,   0, 228, 
    176,   1,   8, 228, 160,  66, 
      0,   0,   3,   2,   0,  15, 
    128,   2,   0, 228, 128,   0, 
      8, 228, 160,   5,   0,   0, 
      3,   2,   0,   7, 128,   2, 
      0, 255, 128,   2,   0, 228, 
    128,   5,   0,   0,   3,   1, 
      0,  15, 128,   1,   0, 255, 
    128,   2,   0, 228, 128,   2, 
      0,   0,   3,   0,   0,   8, 
    128,   0,   0, 255, 128,   0, 
      0,   0, 128,  88,   0,   0, 
      4,   0,   0,   1, 128,   0, 
      0, 255, 128,   0,   0,   0, 
    128,   0,   0, 170, 128,  88, 
      0,   0,   4,   1,   0,  15, 
    128,   0,   0,   0, 129,   4, 
      0, 170, 160,   1,   0, 228, 
    128,  88,   0,   0,   4,   0, 
      0,  15, 128,   0,   0,  85, 
    128,   1,   0, 228, 128,   4, 
      0, 170, 160,   1,   0,   0, 
      2,   0,   8,  15, 128,   0, 
      0, 228, 128, 255, 255,   0, 
      0,  83,  72,  68,  82, 208, 
      3,   0,   0,  64,   0,   0, 
      0, 244,   0,   0,   0,  89, 
      0,   0,   4,  70, 142,  32, 
      0,   0,   0,   0,   0,   7, 
      0,   0,   0,  90,   0,   0, 
      3,   0,  96,  16,   0,   0, 
      0,   0,   0,  90,   0,   0, 
      3,   0,  96,  16,   0,   1, 
      0,   0,   0,  88,  24,   0, 
      4,   0, 112,  16,   0,   0, 
      0,   0,   0,  85,  85,   0, 
      0,  88,  24,   0,   4,   0, 
    112,  16,   0,   1,   0,   0, 
      0,  85,  85,   0,   0,  98, 
     16,   0,   3,  50,  16,  16, 
      0,   1,   0,   0,   0,  98, 
     16,   0,   3, 194,  16,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 242,  32,  16, 
      0,   0,   0,   0,   0, 104, 
      0,   0,   2,   3,   0,   0, 
      0,   0,   0,   0,   9,  50, 
      0,  16,   0,   0,   0,   0, 
      0, 230,  26,  16,   0,   1, 
      0,   0,   0,  70, 128,  32, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  54,   0,   0,   6,  66, 
      0,  16,   0,   0,   0,   0, 
      0,  58, 128,  32,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  16,   0,   0,   8,  66, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   2,  16,   0,   0, 
      0,   0,   0,  70, 130,  32, 
      0,   0,   0,   0,   0,   4, 
      0,   0,   0,  15,   0,   0, 
      7,  18,   0,  16,   0,   0, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   9,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  10, 128,  32, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   8,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  42, 128,  32, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  50,   0,   0, 
     10,  18,   0,  16,   0,   0, 
      0,   0,   0,  42,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0,  49,   0,   0,   7,  34, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,  75, 
      0,   0,   6,  18,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16, 128, 129,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   6,  34,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16, 128,  65,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   7,  82,   0,  16, 
      0,   0,   0,   0,   0, 166, 
     10,  16,   0,   0,   0,   0, 
      0,   6,   1,  16,   0,   1, 
      0,   0,   0,  14,   0,   0, 
      8,  82,   0,  16,   0,   0, 
      0,   0,   0,   6,   2,  16, 
      0,   0,   0,   0,   0, 166, 
    138,  32,   0,   0,   0,   0, 
      0,   5,   0,   0,   0,  56, 
      0,   0,   8,  50,   0,  16, 
      0,   1,   0,   0,   0, 134, 
      0,  16,   0,   0,   0,   0, 
      0, 166, 138,  32,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,  29,   0,   0,   9,  50, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   0,  16,   0,   1, 
      0,   0,   0, 246, 143,  32, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,   1,   0,   0,  10,  50, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   0,  16,   0,   1, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0, 128,  63,   0, 
      0, 128,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   8,  18,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  50,   0,   0,   9,  18, 
      0,  16,   0,   2,   0,   0, 
      0,  10,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16,   0,   0,   0,   0, 
      0,  54,   0,   0,   5,  34, 
      0,  16,   0,   2,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,  63,  69,   0,   0, 
      9, 242,   0,  16,   0,   2, 
      0,   0,   0,  70,   0,  16, 
      0,   2,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  31,   0,   4, 
      3,  26,   0,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      8, 242,  32,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  62, 
      0,   0,   1,  21,   0,   0, 
      1,  52,   0,   0,   7,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  26,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
      0,   1,   0,   0,   0,  29, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  31,   0,   4, 
      3,  10,   0,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      8, 242,  32,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  62, 
      0,   0,   1,  21,   0,   0, 
      1,  56,   0,   0,   7, 114, 
      0,  16,   0,   2,   0,   0, 
      0, 246,  15,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   2,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   0,   0,   0,   0,  70, 
     16,  16,   0,   1,   0,   0, 
      0,  70, 126,  16,   0,   1, 
      0,   0,   0,   0,  96,  16, 
      0,   1,   0,   0,   0,  56, 
      0,   0,   7, 242,  32,  16, 
      0,   0,   0,   0,   0, 246, 
     15,  16,   0,   0,   0,   0, 
      0,  70,  14,  16,   0,   2, 
      0,   0,   0,  62,   0,   0, 
      1,  83,  84,  65,  84, 116, 
      0,   0,   0,  33,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  19,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  82, 
     68,  69,  70,  96,   2,   0, 
      0,   1,   0,   0,   0, 224, 
      0,   0,   0,   5,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      4, 255, 255,   0,   1,   0, 
      0,  43,   2,   0,   0, 188, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0, 197,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 210,   0,   0, 
      0,   2,   0,   0,   0,   5, 
      0,   0,   0,   4,   0,   0, 
      0, 255, 255, 255, 255,   0, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   0,   0,   0, 214, 
      0,   0,   0,   2,   0,   0, 
      0,   5,   0,   0,   0,   4, 
      0,   0,   0, 255, 255, 255, 
    255,   1,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0, 219,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 115,  83,  97, 
    109, 112, 108, 101, 114,   0, 
    115,  77,  97, 115, 107,  83, 
     97, 109, 112, 108, 101, 114, 
      0, 116, 101, 120,   0, 109, 
     97, 115, 107,   0,  99,  98, 
     50,   0, 171, 219,   0,   0, 
      0,   7,   0,   0,   0, 248, 
      0,   0,   0, 112,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 160,   1,   0, 
      0,   0,   0,   0,   0,  44, 
      0,   0,   0,   0,   0,   0, 
      0, 184,   1,   0,   0,   0, 
      0,   0,   0, 200,   1,   0, 
      0,  48,   0,   0,   0,   8, 
      0,   0,   0,   0,   0,   0, 
      0, 212,   1,   0,   0,   0, 
      0,   0,   0, 228,   1,   0, 
      0,  64,   0,   0,   0,  12, 
      0,   0,   0,   2,   0,   0, 
      0, 236,   1,   0,   0,   0, 
      0,   0,   0, 252,   1,   0, 
      0,  80,   0,   0,   0,   8, 
      0,   0,   0,   2,   0,   0, 
      0, 212,   1,   0,   0,   0, 
      0,   0,   0,   4,   2,   0, 
      0,  88,   0,   0,   0,   4, 
      0,   0,   0,   2,   0,   0, 
      0,   8,   2,   0,   0,   0, 
      0,   0,   0,  24,   2,   0, 
      0,  92,   0,   0,   0,   4, 
      0,   0,   0,   2,   0,   0, 
      0,   8,   2,   0,   0,   0, 
      0,   0,   0,  32,   2,   0, 
      0,  96,   0,   0,   0,   4, 
      0,   0,   0,   2,   0,   0, 
      0,   8,   2,   0,   0,   0, 
      0,   0,   0,  68, 101, 118, 
    105,  99, 101,  83, 112,  97, 
     99, 101,  84, 111,  85, 115, 
    101, 114,  83, 112,  97,  99, 
    101,   0, 171,   3,   0,   3, 
      0,   3,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 100, 105, 109, 101, 110, 
    115, 105, 111, 110, 115,   0, 
    171,   1,   0,   3,   0,   1, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 102, 102,   0, 171, 171, 
    171,   1,   0,   3,   0,   1, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  99, 
    101, 110, 116, 101, 114,  49, 
      0,  65,   0, 171, 171,   0, 
      0,   3,   0,   1,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 114,  97, 100, 
    105, 117, 115,  49,   0, 115, 
    113,  95, 114,  97, 100, 105, 
    117, 115,  49,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  54,  46,  51, 
     46,  57,  54,  48,  48,  46, 
     49,  54,  51,  56,  52,   0, 
    171, 171, 171,  73,  83,  71, 
     78, 104,   0,   0,   0,   3, 
      0,   0,   0,   8,   0,   0, 
      0,  80,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,  15,   0,   0, 
      0,  92,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,   3,   3,   0, 
      0,  92,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   1, 
      0,   0,   0,  12,  12,   0, 
      0,  83,  86,  95,  80, 111, 
    115, 105, 116, 105, 111, 110, 
      0,  84,  69,  88,  67,  79, 
     79,  82,  68,   0, 171, 171, 
    171,  79,  83,  71,  78,  44, 
      0,   0,   0,   1,   0,   0, 
      0,   8,   0,   0,   0,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  83, 
     86,  95,  84,  97, 114, 103, 
    101, 116,   0, 171, 171, 159, 
    101,   0,   0,   0,   0,   0, 
      0,  65,  48,   0,  44,   7, 
      0,   0,  68,  88,  66,  67, 
    172,  27, 205, 113, 176, 254, 
     27,  44,  22, 107, 179, 112, 
    127,  38, 148, 161,   1,   0, 
      0,   0,  44,   7,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 148,   1,   0,   0, 
    104,   3,   0,   0, 228,   3, 
      0,   0, 136,   6,   0,   0, 
    188,   6,   0,   0,  65, 111, 
    110,  57,  84,   1,   0,   0, 
     84,   1,   0,   0,   0,   2, 
    254, 255, 252,   0,   0,   0, 
     88,   0,   0,   0,   4,   0, 
     36,   0,   0,   0,  84,   0, 
      0,   0,  84,   0,   0,   0, 
     36,   0,   1,   0,  84,   0, 
      0,   0,   0,   0,   1,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   1,   0, 
      2,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      3,   0,   0,   0,   0,   0, 
      1,   0,   3,   0,   1,   0, 
      5,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    254, 255,  81,   0,   0,   5, 
      6,   0,  15, 160,   0,   0, 
    128,  63,   0,   0,   0,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      5,   0,   0, 128,   0,   0, 
     15, 144,   4,   0,   0,   4, 
      0,   0,   3, 224,   0,   0, 
    228, 144,   2,   0, 238, 160, 
      2,   0, 228, 160,   4,   0, 
      0,   4,   0,   0,   3, 128, 
      0,   0, 228, 144,   1,   0, 
    238, 160,   1,   0, 228, 160, 
      2,   0,   0,   3,   0,   0, 
      4, 128,   0,   0,   0, 128, 
      6,   0,   0, 160,   5,   0, 
      0,   3,   0,   0,   4, 128, 
      0,   0, 170, 128,   5,   0, 
      0, 160,   5,   0,   0,   3, 
      1,   0,   1, 128,   0,   0, 
    170, 128,   6,   0,  85, 160, 
      2,   0,   0,   3,   0,   0, 
      4, 128,   0,   0,  85, 129, 
      6,   0,   0, 160,   2,   0, 
      0,   3,   0,   0,   3, 192, 
      0,   0, 228, 128,   0,   0, 
    228, 160,   5,   0,   0,   3, 
      0,   0,   1, 128,   0,   0, 
    170, 128,   5,   0,  85, 160, 
      5,   0,   0,   3,   1,   0, 
      2, 128,   0,   0,   0, 128, 
      6,   0,  85, 160,   1,   0, 
      0,   2,   1,   0,   4, 128, 
      6,   0,   0, 160,   8,   0, 
      0,   3,   0,   0,   8, 224, 
      1,   0, 228, 128,   3,   0, 
    228, 160,   8,   0,   0,   3, 
      0,   0,   4, 224,   1,   0, 
    228, 128,   4,   0, 228, 160, 
      1,   0,   0,   2,   0,   0, 
     12, 192,   6,   0,  36, 160, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 204,   1,   0,   0, 
     64,   0,   1,   0, 115,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   1,   0,   0,   0, 
      4,   0,   0,   0,  95,   0, 
      0,   3,  50,  16,  16,   0, 
      0,   0,   0,   0, 103,   0, 
      0,   4, 242,  32,  16,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
     50,  32,  16,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
    194,  32,  16,   0,   1,   0, 
      0,   0, 104,   0,   0,   2, 
      2,   0,   0,   0,  54,   0, 
      0,   8, 194,  32,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 128,  63, 
     50,   0,   0,  11,  50,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
     50,  32,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   7,  18,   0,  16,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,   0,   0,   0,   8, 
     34,   0,  16,   0,   0,   0, 
      0,   0,  26,   0,  16, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0, 128,  63,  56,   0, 
      0,   8,  50,   0,  16,   0, 
      0,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
     56,   0,   0,  10,  50,   0, 
     16,   0,   1,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,  63,   0,   0, 
      0,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5,  66,   0,  16,   0, 
      1,   0,   0,   0,   1,  64, 
      0,   0,   0,   0, 128,  63, 
     16,   0,   0,   8,  66,  32, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  70, 130,  32,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  16,   0,   0,   8, 
    130,  32,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  70, 130, 
     32,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      1,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
     12,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
    156,   2,   0,   0,   2,   0, 
      0,   0, 100,   0,   0,   0, 
      2,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 254, 255, 
      0,   1,   0,   0, 103,   2, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  96,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     99,  98,  48,   0,  99,  98, 
     50,   0,  92,   0,   0,   0, 
      4,   0,   0,   0, 148,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  96,   0,   0,   0, 
      7,   0,   0,   0,  52,   1, 
      0,   0, 112,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 244,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,  16,   1,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,  26,   1,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,  40,   1,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0, 171, 171, 
    220,   1,   0,   0,   0,   0, 
      0,   0,  44,   0,   0,   0, 
      2,   0,   0,   0, 244,   1, 
      0,   0,   0,   0,   0,   0, 
      4,   2,   0,   0,  48,   0, 
      0,   0,   8,   0,   0,   0, 
      2,   0,   0,   0,  16,   2, 
      0,   0,   0,   0,   0,   0, 
     32,   2,   0,   0,  64,   0, 
      0,   0,  12,   0,   0,   0, 
      0,   0,   0,   0,  40,   2, 
      0,   0,   0,   0,   0,   0, 
     56,   2,   0,   0,  80,   0, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,  16,   2, 
      0,   0,   0,   0,   0,   0, 
     64,   2,   0,   0,  88,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,  68,   2, 
      0,   0,   0,   0,   0,   0, 
     84,   2,   0,   0,  92,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,  68,   2, 
      0,   0,   0,   0,   0,   0, 
     92,   2,   0,   0,  96,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,  68,   2, 
      0,   0,   0,   0,   0,   0, 
     68, 101, 118, 105,  99, 101, 
     83, 112,  97,  99, 101,  84, 
    111,  85, 115, 101, 114,  83, 
    112,  97,  99, 101,   0, 171, 
      3,   0,   3,   0,   3,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 100, 105, 
    109, 101, 110, 115, 105, 111, 
    110, 115,   0, 171,   1,   0, 
      3,   0,   1,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 102, 102, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  99, 101, 110, 116, 
    101, 114,  49,   0,  65,   0, 
    171, 171,   0,   0,   3,   0, 
      1,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    114,  97, 100, 105, 117, 115, 
     49,   0, 115, 113,  95, 114, 
     97, 100, 105, 117, 115,  49, 
      0,  77, 105,  99, 114, 111, 
    115, 111, 102, 116,  32,  40, 
     82,  41,  32,  72,  76,  83, 
     76,  32,  83, 104,  97, 100, 
    101, 114,  32,  67, 111, 109, 
    112, 105, 108, 101, 114,  32, 
     54,  46,  51,  46,  57,  54, 
     48,  48,  46,  49,  54,  51, 
     56,  52,   0, 171, 171, 171, 
     73,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   3,   0,   0,  80,  79, 
     83,  73,  84,  73,  79,  78, 
      0, 171, 171, 171,  79,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,  12, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,   3, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171, 142, 111,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0, 192,   7, 
      0,   0,  68,  88,  66,  67, 
     73, 174, 125,  52, 147, 212, 
    172, 159, 223,  39,   1, 144, 
    137,  10, 201, 206,   1,   0, 
      0,   0, 192,   7,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 196,   1,   0,   0, 
     56,   4,   0,   0, 180,   4, 
      0,   0,  28,   7,   0,   0, 
    140,   7,   0,   0,  65, 111, 
    110,  57, 132,   1,   0,   0, 
    132,   1,   0,   0,   0,   2, 
    255, 255,  76,   1,   0,   0, 
     56,   0,   0,   0,   1,   0, 
     44,   0,   0,   0,  56,   0, 
      0,   0,  56,   0,   2,   0, 
     36,   0,   0,   0,  56,   0, 
      0,   0,   0,   0,   1,   1, 
      1,   0,   0,   0,   4,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 255, 255, 
     81,   0,   0,   5,   2,   0, 
     15, 160,   0,   0,   0,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   1,   8,  15, 160, 
      5,   0,   0,   3,   0,   0, 
      8, 128,   1,   0, 255, 160, 
      1,   0, 255, 160,   2,   0, 
      0,   3,   0,   0,   3, 128, 
      0,   0, 235, 176,   1,   0, 
    228, 161,  90,   0,   0,   4, 
      0,   0,   8, 128,   0,   0, 
    228, 128,   0,   0, 228, 128, 
      0,   0, 255, 129,   5,   0, 
      0,   3,   0,   0,   8, 128, 
      0,   0, 255, 128,   2,   0, 
      0, 160,   1,   0,   0,   2, 
      0,   0,   4, 128,   1,   0, 
    255, 160,   8,   0,   0,   3, 
      0,   0,   1, 128,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      6,   0,   0,   2,   0,   0, 
      1, 128,   0,   0,   0, 128, 
      5,   0,   0,   3,   0,   0, 
      1, 128,   0,   0,   0, 128, 
      0,   0, 255, 128,   1,   0, 
      0,   2,   0,   0,   2, 128, 
      2,   0,   0, 160,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      0,   0, 228, 176,   1,   8, 
    228, 160,  66,   0,   0,   3, 
      2,   0,  15, 128,   0,   0, 
    228, 128,   0,   8, 228, 160, 
      1,   0,   0,   2,   0,   0, 
      8, 128,   1,   0, 255, 160, 
      4,   0,   0,   4,   0,   0, 
      1, 128,   0,   0,   0, 128, 
      0,   0, 170, 161,   0,   0, 
    255, 129,   5,   0,   0,   3, 
      2,   0,   7, 128,   2,   0, 
    255, 128,   2,   0, 228, 128, 
      5,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 255, 128, 
      2,   0, 228, 128,  88,   0, 
      0,   4,   0,   0,  15, 128, 
      0,   0,   0, 128,   2,   0, 
     85, 160,   1,   0, 228, 128, 
      1,   0,   0,   2,   0,   8, 
     15, 128,   0,   0, 228, 128, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 108,   2,   0,   0, 
     64,   0,   0,   0, 155,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   6,   0,   0,   0, 
     90,   0,   0,   3,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     90,   0,   0,   3,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   0,   0,   0,   0, 
     85,  85,   0,   0,  88,  24, 
      0,   4,   0, 112,  16,   0, 
      1,   0,   0,   0,  85,  85, 
      0,   0,  98,  16,   0,   3, 
     50,  16,  16,   0,   1,   0, 
      0,   0,  98,  16,   0,   3, 
    194,  16,  16,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
    242,  32,  16,   0,   0,   0, 
      0,   0, 104,   0,   0,   2, 
      2,   0,   0,   0,   0,   0, 
      0,   9,  50,   0,  16,   0, 
      0,   0,   0,   0, 230,  26, 
     16,   0,   1,   0,   0,   0, 
     70, 128,  32, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  54,   0, 
      0,   6,  66,   0,  16,   0, 
      0,   0,   0,   0,  58, 128, 
     32,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  16,   0, 
      0,   8,  66,   0,  16,   0, 
      0,   0,   0,   0,  70,   2, 
     16,   0,   0,   0,   0,   0, 
     70, 130,  32,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
     15,   0,   0,   7,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  50,   0, 
      0,  12,  18,   0,  16,   0, 
      0,   0,   0,   0,  58, 128, 
     32, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  58, 128,  32,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  56,   0, 
      0,   7,  18,   0,  16,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,  63,  14,   0,   0,   7, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  42,   0, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,   8,  66,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,  42, 128,  32,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  29,   0,   0,   9, 
     66,   0,  16,   0,   0,   0, 
      0,   0,  58, 128,  32, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     42,   0,  16,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
     34,   0,  16,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0,   0,  63,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      1,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      0,   0,   0,   0,  31,   0, 
      4,   3,  42,   0,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   8, 242,  32,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     62,   0,   0,   1,  21,   0, 
      0,   1,  56,   0,   0,   7, 
    114,   0,  16,   0,   1,   0, 
      0,   0, 246,  15,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      1,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   7, 242,  32, 
     16,   0,   0,   0,   0,   0, 
    246,  15,  16,   0,   0,   0, 
      0,   0,  70,  14,  16,   0, 
      1,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,  19,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,  10,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70,  96,   2, 
      0,   0,   1,   0,   0,   0, 
    224,   0,   0,   0,   5,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 255, 255,   0,   1, 
      0,   0,  43,   2,   0,   0, 
    188,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 197,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 210,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    214,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   1,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 219,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 115,  83, 
     97, 109, 112, 108, 101, 114, 
      0, 115,  77,  97, 115, 107, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 116, 101, 120,   0, 
    109,  97, 115, 107,   0,  99, 
     98,  50,   0, 171, 219,   0, 
      0,   0,   7,   0,   0,   0, 
    248,   0,   0,   0, 112,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 160,   1, 
      0,   0,   0,   0,   0,   0, 
     44,   0,   0,   0,   0,   0, 
      0,   0, 184,   1,   0,   0, 
      0,   0,   0,   0, 200,   1, 
      0,   0,  48,   0,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0, 212,   1,   0,   0, 
      0,   0,   0,   0, 228,   1, 
      0,   0,  64,   0,   0,   0, 
     12,   0,   0,   0,   2,   0, 
      0,   0, 236,   1,   0,   0, 
      0,   0,   0,   0, 252,   1, 
      0,   0,  80,   0,   0,   0, 
      8,   0,   0,   0,   2,   0, 
      0,   0, 212,   1,   0,   0, 
      0,   0,   0,   0,   4,   2, 
      0,   0,  88,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   8,   2,   0,   0, 
      0,   0,   0,   0,  24,   2, 
      0,   0,  92,   0,   0,   0, 
      4,   0,   0,   0,   2,   0, 
      0,   0,   8,   2,   0,   0, 
      0,   0,   0,   0,  32,   2, 
      0,   0,  96,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   8,   2,   0,   0, 
      0,   0,   0,   0,  68, 101, 
    118, 105,  99, 101,  83, 112, 
     97,  99, 101,  84, 111,  85, 
    115, 101, 114,  83, 112,  97, 
     99, 101,   0, 171,   3,   0, 
      3,   0,   3,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 109, 101, 
    110, 115, 105, 111, 110, 115, 
      0, 171,   1,   0,   3,   0, 
      1,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 102, 102,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     99, 101, 110, 116, 101, 114, 
     49,   0,  65,   0, 171, 171, 
      0,   0,   3,   0,   1,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 114,  97, 
    100, 105, 117, 115,  49,   0, 
    115, 113,  95, 114,  97, 100, 
    105, 117, 115,  49,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  54,  46, 
     51,  46,  57,  54,  48,  48, 
     46,  49,  54,  51,  56,  52, 
      0, 171, 171, 171,  73,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,   3, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,  12, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,  79,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     83,  86,  95,  84,  97, 114, 
    103, 101, 116,   0, 171, 171, 
    210, 118,   0,   0,   0,   0, 
      0,   0,  65,  80, 111, 115, 
     87, 114,  97, 112,   0,  44, 
      7,   0,   0,  68,  88,  66, 
     67, 172,  27, 205, 113, 176, 
    254,  27,  44,  22, 107, 179, 
    112, 127,  38, 148, 161,   1, 
      0,   0,   0,  44,   7,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 148,   1,   0, 
      0, 104,   3,   0,   0, 228, 
      3,   0,   0, 136,   6,   0, 
      0, 188,   6,   0,   0,  65, 
    111, 110,  57,  84,   1,   0, 
      0,  84,   1,   0,   0,   0, 
      2, 254, 255, 252,   0,   0, 
      0,  88,   0,   0,   0,   4, 
      0,  36,   0,   0,   0,  84, 
      0,   0,   0,  84,   0,   0, 
      0,  36,   0,   1,   0,  84, 
      0,   0,   0,   0,   0,   1, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   2,   0,   1, 
      0,   2,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   3,   0,   0,   0,   0, 
      0,   1,   0,   3,   0,   1, 
      0,   5,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 254, 255,  81,   0,   0, 
      5,   6,   0,  15, 160,   0, 
      0, 128,  63,   0,   0,   0, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,  31,   0,   0, 
      2,   5,   0,   0, 128,   0, 
      0,  15, 144,   4,   0,   0, 
      4,   0,   0,   3, 224,   0, 
      0, 228, 144,   2,   0, 238, 
    160,   2,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,   3, 
    128,   0,   0, 228, 144,   1, 
      0, 238, 160,   1,   0, 228, 
    160,   2,   0,   0,   3,   0, 
      0,   4, 128,   0,   0,   0, 
    128,   6,   0,   0, 160,   5, 
      0,   0,   3,   0,   0,   4, 
    128,   0,   0, 170, 128,   5, 
      0,   0, 160,   5,   0,   0, 
      3,   1,   0,   1, 128,   0, 
      0, 170, 128,   6,   0,  85, 
    160,   2,   0,   0,   3,   0, 
      0,   4, 128,   0,   0,  85, 
    129,   6,   0,   0, 160,   2, 
      0,   0,   3,   0,   0,   3, 
    192,   0,   0, 228, 128,   0, 
      0, 228, 160,   5,   0,   0, 
      3,   0,   0,   1, 128,   0, 
      0, 170, 128,   5,   0,  85, 
    160,   5,   0,   0,   3,   1, 
      0,   2, 128,   0,   0,   0, 
    128,   6,   0,  85, 160,   1, 
      0,   0,   2,   1,   0,   4, 
    128,   6,   0,   0, 160,   8, 
      0,   0,   3,   0,   0,   8, 
    224,   1,   0, 228, 128,   3, 
      0, 228, 160,   8,   0,   0, 
      3,   0,   0,   4, 224,   1, 
      0, 228, 128,   4,   0, 228, 
    160,   1,   0,   0,   2,   0, 
      0,  12, 192,   6,   0,  36, 
    160, 255, 255,   0,   0,  83, 
     72,  68,  82, 204,   1,   0, 
      0,  64,   0,   1,   0, 115, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  89,   0,   0,   4,  70, 
    142,  32,   0,   1,   0,   0, 
      0,   4,   0,   0,   0,  95, 
      0,   0,   3,  50,  16,  16, 
      0,   0,   0,   0,   0, 103, 
      0,   0,   4, 242,  32,  16, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3,  50,  32,  16,   0,   1, 
      0,   0,   0, 101,   0,   0, 
      3, 194,  32,  16,   0,   1, 
      0,   0,   0, 104,   0,   0, 
      2,   2,   0,   0,   0,  54, 
      0,   0,   8, 194,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 128, 
     63,  50,   0,   0,  11,  50, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  50,  32,  16,   0,   0, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,   0,   0,   0, 
      8,  34,   0,  16,   0,   0, 
      0,   0,   0,  26,   0,  16, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0, 128,  63,  56, 
      0,   0,   8,  50,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,  70, 128,  32,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,  56,   0,   0,  10,  50, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,  63,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  66,   0,  16, 
      0,   1,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  16,   0,   0,   8,  66, 
     32,  16,   0,   1,   0,   0, 
      0,  70,   2,  16,   0,   1, 
      0,   0,   0,  70, 130,  32, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  16,   0,   0, 
      8, 130,  32,  16,   0,   1, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,  70, 
    130,  32,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   1,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,  12,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   8, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70, 156,   2,   0,   0,   2, 
      0,   0,   0, 100,   0,   0, 
      0,   2,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 254, 
    255,   0,   1,   0,   0, 103, 
      2,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  96, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  99,  98,  48,   0,  99, 
     98,  50,   0,  92,   0,   0, 
      0,   4,   0,   0,   0, 148, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  96,   0,   0, 
      0,   7,   0,   0,   0,  52, 
      1,   0,   0, 112,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 244,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  16,   1,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  26,   1,   0, 
      0,  32,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  40,   1,   0, 
      0,  48,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  77, 
     97, 115, 107,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  84, 101, 120, 116,  67, 
    111, 108, 111, 114,   0, 171, 
    171, 220,   1,   0,   0,   0, 
      0,   0,   0,  44,   0,   0, 
      0,   2,   0,   0,   0, 244, 
      1,   0,   0,   0,   0,   0, 
      0,   4,   2,   0,   0,  48, 
      0,   0,   0,   8,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  32,   2,   0,   0,  64, 
      0,   0,   0,  12,   0,   0, 
      0,   0,   0,   0,   0,  40, 
      2,   0,   0,   0,   0,   0, 
      0,  56,   2,   0,   0,  80, 
      0,   0,   0,   8,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  64,   2,   0,   0,  88, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  84,   2,   0,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  92,   2,   0,   0,  96, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,  68, 
      2,   0,   0,   0,   0,   0, 
      0,  68, 101, 118, 105,  99, 
    101,  83, 112,  97,  99, 101, 
     84, 111,  85, 115, 101, 114, 
     83, 112,  97,  99, 101,   0, 
    171,   3,   0,   3,   0,   3, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 109, 101, 110, 115, 105, 
    111, 110, 115,   0, 171,   1, 
      0,   3,   0,   1,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 102, 
    102,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  99, 101, 110, 
    116, 101, 114,  49,   0,  65, 
      0, 171, 171,   0,   0,   3, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 114,  97, 100, 105, 117, 
    115,  49,   0, 115, 113,  95, 
    114,  97, 100, 105, 117, 115, 
     49,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0, 171, 171, 
    171,  73,  83,  71,  78,  44, 
      0,   0,   0,   1,   0,   0, 
      0,   8,   0,   0,   0,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   7,   3,   0,   0,  80, 
     79,  83,  73,  84,  73,  79, 
     78,   0, 171, 171, 171,  79, 
     83,  71,  78, 104,   0,   0, 
      0,   3,   0,   0,   0,   8, 
      0,   0,   0,  80,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   3, 
     12,   0,   0,  92,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      3,   0,   0,  83,  86,  95, 
     80, 111, 115, 105, 116, 105, 
    111, 110,   0,  84,  69,  88, 
     67,  79,  79,  82,  68,   0, 
    171, 171, 171, 167, 126,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   0,   0,   0, 228, 
      9,   0,   0,  68,  88,  66, 
     67, 193,  68,  83,   4, 120, 
    206, 206,  65, 213,  56, 189, 
    186, 120,  85, 235,  59,   1, 
      0,   0,   0, 228,   9,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 128,   2,   0, 
      0,  88,   6,   0,   0, 212, 
      6,   0,   0,  64,   9,   0, 
      0, 176,   9,   0,   0,  65, 
    111, 110,  57,  64,   2,   0, 
      0,  64,   2,   0,   0,   0, 
      2, 255, 255,   8,   2,   0, 
      0,  56,   0,   0,   0,   1, 
      0,  44,   0,   0,   0,  56, 
      0,   0,   0,  56,   0,   2, 
      0,  36,   0,   0,   0,  56, 
      0,   0,   0,   0,   0,   1, 
      1,   1,   0,   0,   0,   4, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   1,   2, 255, 
    255,  81,   0,   0,   5,   3, 
      0,  15, 160,   0,   0,   0, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  81,   0,   0,   5,   4, 
      0,  15, 160,   0,   0, 128, 
     63,   0,   0, 128, 191,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  31,   0,   0,   2,   0, 
      0,   0, 128,   0,   0,  15, 
    176,  31,   0,   0,   2,   0, 
      0,   0, 144,   0,   8,  15, 
    160,  31,   0,   0,   2,   0, 
      0,   0, 144,   1,   8,  15, 
    160,   2,   0,   0,   3,   0, 
      0,   3, 128,   0,   0, 235, 
    176,   1,   0, 228, 161,  90, 
      0,   0,   4,   0,   0,   8, 
    128,   0,   0, 228, 128,   0, 
      0, 228, 128,   2,   0,   0, 
    161,   5,   0,   0,   3,   0, 
      0,   8, 128,   0,   0, 255, 
    128,   1,   0, 170, 160,   1, 
      0,   0,   2,   0,   0,   4, 
    128,   1,   0, 255, 160,   8, 
      0,   0,   3,   0,   0,   1, 
    128,   0,   0, 228, 128,   0, 
      0, 228, 160,   4,   0,   0, 
      4,   0,   0,   2, 128,   0, 
      0,   0, 128,   0,   0,   0, 
    128,   0,   0, 255, 129,  35, 
      0,   0,   2,   0,   0,   4, 
    128,   0,   0,  85, 128,   7, 
      0,   0,   2,   0,   0,   4, 
    128,   0,   0, 170, 128,   6, 
      0,   0,   2,   1,   0,   1, 
    128,   0,   0, 170, 128,   1, 
      0,   0,   2,   1,   0,   6, 
    128,   1,   0,   0, 129,   2, 
      0,   0,   3,   0,   0,  13, 
    128,   0,   0,   0, 128,   1, 
      0, 148, 128,   6,   0,   0, 
      2,   1,   0,   1, 128,   1, 
      0, 170, 160,   5,   0,   0, 
      3,   0,   0,  13, 128,   0, 
      0, 228, 128,   1,   0,   0, 
    128,   1,   0,   0,   2,   1, 
      0,   8, 128,   1,   0, 255, 
    160,   4,   0,   0,   4,   1, 
      0,   7, 128,   0,   0, 248, 
    128,   0,   0, 170, 160,   1, 
      0, 255, 128,  88,   0,   0, 
      4,   2,   0,   1, 128,   1, 
      0,   0, 128,   0,   0,   0, 
    128,   0,   0, 255, 128,  88, 
      0,   0,   4,   0,   0,  13, 
    128,   1,   0, 148, 128,   4, 
      0,  68, 160,   4,   0, 230, 
    160,   1,   0,   0,   2,   2, 
      0,   2, 128,   3,   0,   0, 
    160,  66,   0,   0,   3,   1, 
      0,  15, 128,   0,   0, 228, 
    176,   1,   8, 228, 160,  66, 
      0,   0,   3,   2,   0,  15, 
    128,   2,   0, 228, 128,   0, 
      8, 228, 160,   5,   0,   0, 
      3,   2,   0,   7, 128,   2, 
      0, 255, 128,   2,   0, 228, 
    128,   5,   0,   0,   3,   1, 
      0,  15, 128,   1,   0, 255, 
    128,   2,   0, 228, 128,   2, 
      0,   0,   3,   0,   0,   8, 
    128,   0,   0, 255, 128,   0, 
      0,   0, 128,  88,   0,   0, 
      4,   0,   0,   1, 128,   0, 
      0, 255, 128,   0,   0,   0, 
    128,   0,   0, 170, 128,  88, 
      0,   0,   4,   1,   0,  15, 
    128,   0,   0,   0, 129,   4, 
      0, 170, 160,   1,   0, 228, 
    128,  88,   0,   0,   4,   0, 
      0,  15, 128,   0,   0,  85, 
    128,   1,   0, 228, 128,   4, 
      0, 170, 160,   1,   0,   0, 
      2,   0,   8,  15, 128,   0, 
      0, 228, 128, 255, 255,   0, 
      0,  83,  72,  68,  82, 208, 
      3,   0,   0,  64,   0,   0, 
      0, 244,   0,   0,   0,  89, 
      0,   0,   4,  70, 142,  32, 
      0,   0,   0,   0,   0,   7, 
      0,   0,   0,  90,   0,   0, 
      3,   0,  96,  16,   0,   0, 
      0,   0,   0,  90,   0,   0, 
      3,   0,  96,  16,   0,   1, 
      0,   0,   0,  88,  24,   0, 
      4,   0, 112,  16,   0,   0, 
      0,   0,   0,  85,  85,   0, 
      0,  88,  24,   0,   4,   0, 
    112,  16,   0,   1,   0,   0, 
      0,  85,  85,   0,   0,  98, 
     16,   0,   3,  50,  16,  16, 
      0,   1,   0,   0,   0,  98, 
     16,   0,   3, 194,  16,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 242,  32,  16, 
      0,   0,   0,   0,   0, 104, 
      0,   0,   2,   3,   0,   0, 
      0,   0,   0,   0,   9,  50, 
      0,  16,   0,   0,   0,   0, 
      0, 230,  26,  16,   0,   1, 
      0,   0,   0,  70, 128,  32, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  54,   0,   0,   6,  66, 
      0,  16,   0,   0,   0,   0, 
      0,  58, 128,  32,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  16,   0,   0,   8,  66, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   2,  16,   0,   0, 
      0,   0,   0,  70, 130,  32, 
      0,   0,   0,   0,   0,   4, 
      0,   0,   0,  15,   0,   0, 
      7,  18,   0,  16,   0,   0, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   9,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  10, 128,  32, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   8,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  42, 128,  32, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  50,   0,   0, 
     10,  18,   0,  16,   0,   0, 
      0,   0,   0,  42,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0,  49,   0,   0,   7,  34, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,   0,  75, 
      0,   0,   6,  18,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16, 128, 129,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   6,  34,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16, 128,  65,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   7,  82,   0,  16, 
      0,   0,   0,   0,   0, 166, 
     10,  16,   0,   0,   0,   0, 
      0,   6,   1,  16,   0,   1, 
      0,   0,   0,  14,   0,   0, 
      8,  82,   0,  16,   0,   0, 
      0,   0,   0,   6,   2,  16, 
      0,   0,   0,   0,   0, 166, 
    138,  32,   0,   0,   0,   0, 
      0,   5,   0,   0,   0,  56, 
      0,   0,   8,  50,   0,  16, 
      0,   1,   0,   0,   0, 134, 
      0,  16,   0,   0,   0,   0, 
      0, 166, 138,  32,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,  29,   0,   0,   9,  50, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   0,  16,   0,   1, 
      0,   0,   0, 246, 143,  32, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,   1,   0,   0,  10,  50, 
      0,  16,   0,   1,   0,   0, 
      0,  70,   0,  16,   0,   1, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0, 128,  63,   0, 
      0, 128,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   8,  18,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  50,   0,   0,   9,  18, 
      0,  16,   0,   2,   0,   0, 
      0,  10,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16,   0,   0,   0,   0, 
      0,  54,   0,   0,   5,  34, 
      0,  16,   0,   2,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,  63,  69,   0,   0, 
      9, 242,   0,  16,   0,   2, 
      0,   0,   0,  70,   0,  16, 
      0,   2,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  31,   0,   4, 
      3,  26,   0,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      8, 242,  32,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  62, 
      0,   0,   1,  21,   0,   0, 
      1,  52,   0,   0,   7,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  26,   0,  16,   0,   1, 
      0,   0,   0,  10,   0,  16, 
      0,   1,   0,   0,   0,  29, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  31,   0,   4, 
      3,  10,   0,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      8, 242,  32,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  62, 
      0,   0,   1,  21,   0,   0, 
      1,  56,   0,   0,   7, 114, 
      0,  16,   0,   2,   0,   0, 
      0, 246,  15,  16,   0,   2, 
      0,   0,   0,  70,   2,  16, 
      0,   2,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   0,   0,   0,   0,  70, 
     16,  16,   0,   1,   0,   0, 
      0,  70, 126,  16,   0,   1, 
      0,   0,   0,   0,  96,  16, 
      0,   1,   0,   0,   0,  56, 
      0,   0,   7, 242,  32,  16, 
      0,   0,   0,   0,   0, 246, 
     15,  16,   0,   0,   0,   0, 
      0,  70,  14,  16,   0,   2, 
      0,   0,   0,  62,   0,   0, 
      1,  83,  84,  65,  84, 116, 
      0,   0,   0,  33,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  19,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  82, 
     68,  69,  70, 100,   2,   0, 
      0,   1,   0,   0,   0, 228, 
      0,   0,   0,   5,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      4, 255, 255,   0,   1,   0, 
      0,  47,   2,   0,   0, 188, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0, 201,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 214,   0,   0, 
      0,   2,   0,   0,   0,   5, 
      0,   0,   0,   4,   0,   0, 
      0, 255, 255, 255, 255,   0, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   0,   0,   0, 218, 
      0,   0,   0,   2,   0,   0, 
      0,   5,   0,   0,   0,   4, 
      0,   0,   0, 255, 255, 255, 
    255,   1,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0, 223,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 115,  87, 114, 
     97, 112,  83,  97, 109, 112, 
    108, 101, 114,   0, 115,  77, 
     97, 115, 107,  83,  97, 109, 
    112, 108, 101, 114,   0, 116, 
    101, 120,   0, 109,  97, 115, 
    107,   0,  99,  98,  50,   0, 
    171, 223,   0,   0,   0,   7, 
      0,   0,   0, 252,   0,   0, 
      0, 112,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 164,   1,   0,   0,   0, 
      0,   0,   0,  44,   0,   0, 
      0,   0,   0,   0,   0, 188, 
      1,   0,   0,   0,   0,   0, 
      0, 204,   1,   0,   0,  48, 
      0,   0,   0,   8,   0,   0, 
      0,   0,   0,   0,   0, 216, 
      1,   0,   0,   0,   0,   0, 
      0, 232,   1,   0,   0,  64, 
      0,   0,   0,  12,   0,   0, 
      0,   2,   0,   0,   0, 240, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,  80, 
      0,   0,   0,   8,   0,   0, 
      0,   2,   0,   0,   0, 216, 
      1,   0,   0,   0,   0,   0, 
      0,   8,   2,   0,   0,  88, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  12, 
      2,   0,   0,   0,   0,   0, 
      0,  28,   2,   0,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  12, 
      2,   0,   0,   0,   0,   0, 
      0,  36,   2,   0,   0,  96, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  12, 
      2,   0,   0,   0,   0,   0, 
      0,  68, 101, 118, 105,  99, 
    101,  83, 112,  97,  99, 101, 
     84, 111,  85, 115, 101, 114, 
     83, 112,  97,  99, 101,   0, 
    171,   3,   0,   3,   0,   3, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 109, 101, 110, 115, 105, 
    111, 110, 115,   0, 171,   1, 
      0,   3,   0,   1,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 102, 
    102,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  99, 101, 110, 
    116, 101, 114,  49,   0,  65, 
      0, 171, 171,   0,   0,   3, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 114,  97, 100, 105, 117, 
    115,  49,   0, 115, 113,  95, 
    114,  97, 100, 105, 117, 115, 
     49,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0, 171, 171, 
    171,  73,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   3,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,  12,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,  79, 
     83,  71,  78,  44,   0,   0, 
      0,   1,   0,   0,   0,   8, 
      0,   0,   0,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  83,  86,  95, 
     84,  97, 114, 103, 101, 116, 
      0, 171, 171, 235, 133,   0, 
      0,   0,   0,   0,   0,  65, 
     48,  87, 114,  97, 112,   0, 
     44,   7,   0,   0,  68,  88, 
     66,  67, 172,  27, 205, 113, 
    176, 254,  27,  44,  22, 107, 
    179, 112, 127,  38, 148, 161, 
      1,   0,   0,   0,  44,   7, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 148,   1, 
      0,   0, 104,   3,   0,   0, 
    228,   3,   0,   0, 136,   6, 
      0,   0, 188,   6,   0,   0, 
     65, 111, 110,  57,  84,   1, 
      0,   0,  84,   1,   0,   0, 
      0,   2, 254, 255, 252,   0, 
      0,   0,  88,   0,   0,   0, 
      4,   0,  36,   0,   0,   0, 
     84,   0,   0,   0,  84,   0, 
      0,   0,  36,   0,   1,   0, 
     84,   0,   0,   0,   0,   0, 
      1,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      1,   0,   2,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   3,   0,   0,   0, 
      0,   0,   1,   0,   3,   0, 
      1,   0,   5,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   2, 254, 255,  81,   0, 
      0,   5,   6,   0,  15, 160, 
      0,   0, 128,  63,   0,   0, 
      0,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,  31,   0, 
      0,   2,   5,   0,   0, 128, 
      0,   0,  15, 144,   4,   0, 
      0,   4,   0,   0,   3, 224, 
      0,   0, 228, 144,   2,   0, 
    238, 160,   2,   0, 228, 160, 
      4,   0,   0,   4,   0,   0, 
      3, 128,   0,   0, 228, 144, 
      1,   0, 238, 160,   1,   0, 
    228, 160,   2,   0,   0,   3, 
      0,   0,   4, 128,   0,   0, 
      0, 128,   6,   0,   0, 160, 
      5,   0,   0,   3,   0,   0, 
      4, 128,   0,   0, 170, 128, 
      5,   0,   0, 160,   5,   0, 
      0,   3,   1,   0,   1, 128, 
      0,   0, 170, 128,   6,   0, 
     85, 160,   2,   0,   0,   3, 
      0,   0,   4, 128,   0,   0, 
     85, 129,   6,   0,   0, 160, 
      2,   0,   0,   3,   0,   0, 
      3, 192,   0,   0, 228, 128, 
      0,   0, 228, 160,   5,   0, 
      0,   3,   0,   0,   1, 128, 
      0,   0, 170, 128,   5,   0, 
     85, 160,   5,   0,   0,   3, 
      1,   0,   2, 128,   0,   0, 
      0, 128,   6,   0,  85, 160, 
      1,   0,   0,   2,   1,   0, 
      4, 128,   6,   0,   0, 160, 
      8,   0,   0,   3,   0,   0, 
      8, 224,   1,   0, 228, 128, 
      3,   0, 228, 160,   8,   0, 
      0,   3,   0,   0,   4, 224, 
      1,   0, 228, 128,   4,   0, 
    228, 160,   1,   0,   0,   2, 
      0,   0,  12, 192,   6,   0, 
     36, 160, 255, 255,   0,   0, 
     83,  72,  68,  82, 204,   1, 
      0,   0,  64,   0,   1,   0, 
    115,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   1,   0, 
      0,   0,   4,   0,   0,   0, 
     95,   0,   0,   3,  50,  16, 
     16,   0,   0,   0,   0,   0, 
    103,   0,   0,   4, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3,  50,  32,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 194,  32,  16,   0, 
      1,   0,   0,   0, 104,   0, 
      0,   2,   2,   0,   0,   0, 
     54,   0,   0,   8, 194,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  63,  50,   0,   0,  11, 
     50,   0,  16,   0,   0,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5,  50,  32,  16,   0, 
      0,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   7,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0, 128,  63,   0,   0, 
      0,   8,  34,   0,  16,   0, 
      0,   0,   0,   0,  26,   0, 
     16, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0, 128,  63, 
     56,   0,   0,   8,  50,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70, 128,  32,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,  56,   0,   0,  10, 
     50,   0,  16,   0,   1,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,  63, 
      0,   0,   0,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  66,   0, 
     16,   0,   1,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,  16,   0,   0,   8, 
     66,  32,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  70, 130, 
     32,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   8, 130,  32,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     70, 130,  32,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
     50,   0,   0,  11,  50,  32, 
     16,   0,   1,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,  12,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70, 156,   2,   0,   0, 
      2,   0,   0,   0, 100,   0, 
      0,   0,   2,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    254, 255,   0,   1,   0,   0, 
    103,   2,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     96,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  99,  98,  48,   0, 
     99,  98,  50,   0,  92,   0, 
      0,   0,   4,   0,   0,   0, 
    148,   0,   0,   0,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  96,   0, 
      0,   0,   7,   0,   0,   0, 
     52,   1,   0,   0, 112,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 244,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,  16,   1, 
      0,   0,  16,   0,   0,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,  26,   1, 
      0,   0,  32,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,  40,   1, 
      0,   0,  48,   0,   0,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,  81, 117, 
     97, 100,  68, 101, 115,  99, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     77,  97, 115, 107,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  84, 101, 120, 116, 
     67, 111, 108, 111, 114,   0, 
    171, 171, 220,   1,   0,   0, 
      0,   0,   0,   0,  44,   0, 
      0,   0,   2,   0,   0,   0, 
    244,   1,   0,   0,   0,   0, 
      0,   0,   4,   2,   0,   0, 
     48,   0,   0,   0,   8,   0, 
      0,   0,   2,   0,   0,   0, 
     16,   2,   0,   0,   0,   0, 
      0,   0,  32,   2,   0,   0, 
     64,   0,   0,   0,  12,   0, 
      0,   0,   0,   0,   0,   0, 
     40,   2,   0,   0,   0,   0, 
      0,   0,  56,   2,   0,   0, 
     80,   0,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   2,   0,   0,   0,   0, 
      0,   0,  64,   2,   0,   0, 
     88,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
     68,   2,   0,   0,   0,   0, 
      0,   0,  84,   2,   0,   0, 
     92,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
     68,   2,   0,   0,   0,   0, 
      0,   0,  92,   2,   0,   0, 
     96,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
     68,   2,   0,   0,   0,   0, 
      0,   0,  68, 101, 118, 105, 
     99, 101,  83, 112,  97,  99, 
    101,  84, 111,  85, 115, 101, 
    114,  83, 112,  97,  99, 101, 
      0, 171,   3,   0,   3,   0, 
      3,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 109, 101, 110, 115, 
    105, 111, 110, 115,   0, 171, 
      1,   0,   3,   0,   1,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 100, 105, 
    102, 102,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  99, 101, 
    110, 116, 101, 114,  49,   0, 
     65,   0, 171, 171,   0,   0, 
      3,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 114,  97, 100, 105, 
    117, 115,  49,   0, 115, 113, 
     95, 114,  97, 100, 105, 117, 
    115,  49,   0,  77, 105,  99, 
    114, 111, 115, 111, 102, 116, 
     32,  40,  82,  41,  32,  72, 
     76,  83,  76,  32,  83, 104, 
     97, 100, 101, 114,  32,  67, 
    111, 109, 112, 105, 108, 101, 
    114,  32,  54,  46,  51,  46, 
     57,  54,  48,  48,  46,  49, 
     54,  51,  56,  52,   0, 171, 
    171, 171,  73,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   7,   3,   0,   0, 
     80,  79,  83,  73,  84,  73, 
     79,  78,   0, 171, 171, 171, 
     79,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,  12,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   3,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171, 226, 143, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
    196,   7,   0,   0,  68,  88, 
     66,  67, 223, 174,  80, 104, 
    241,  52,  44, 173, 100, 134, 
     52, 219,  15, 210, 214, 245, 
      1,   0,   0,   0, 196,   7, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 196,   1, 
      0,   0,  56,   4,   0,   0, 
    180,   4,   0,   0,  32,   7, 
      0,   0, 144,   7,   0,   0, 
     65, 111, 110,  57, 132,   1, 
      0,   0, 132,   1,   0,   0, 
      0,   2, 255, 255,  76,   1, 
      0,   0,  56,   0,   0,   0, 
      1,   0,  44,   0,   0,   0, 
     56,   0,   0,   0,  56,   0, 
      2,   0,  36,   0,   0,   0, 
     56,   0,   0,   0,   0,   0, 
      1,   1,   1,   0,   0,   0, 
      4,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    255, 255,  81,   0,   0,   5, 
      2,   0,  15, 160,   0,   0, 
      0,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      0,   0,   0, 128,   0,   0, 
     15, 176,  31,   0,   0,   2, 
      0,   0,   0, 144,   0,   8, 
     15, 160,  31,   0,   0,   2, 
      0,   0,   0, 144,   1,   8, 
     15, 160,   5,   0,   0,   3, 
      0,   0,   8, 128,   1,   0, 
    255, 160,   1,   0, 255, 160, 
      2,   0,   0,   3,   0,   0, 
      3, 128,   0,   0, 235, 176, 
      1,   0, 228, 161,  90,   0, 
      0,   4,   0,   0,   8, 128, 
      0,   0, 228, 128,   0,   0, 
    228, 128,   0,   0, 255, 129, 
      5,   0,   0,   3,   0,   0, 
      8, 128,   0,   0, 255, 128, 
      2,   0,   0, 160,   1,   0, 
      0,   2,   0,   0,   4, 128, 
      1,   0, 255, 160,   8,   0, 
      0,   3,   0,   0,   1, 128, 
      0,   0, 228, 128,   0,   0, 
    228, 160,   6,   0,   0,   2, 
      0,   0,   1, 128,   0,   0, 
      0, 128,   5,   0,   0,   3, 
      0,   0,   1, 128,   0,   0, 
      0, 128,   0,   0, 255, 128, 
      1,   0,   0,   2,   0,   0, 
      2, 128,   2,   0,   0, 160, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   0,   0, 228, 176, 
      1,   8, 228, 160,  66,   0, 
      0,   3,   2,   0,  15, 128, 
      0,   0, 228, 128,   0,   8, 
    228, 160,   1,   0,   0,   2, 
      0,   0,   8, 128,   1,   0, 
    255, 160,   4,   0,   0,   4, 
      0,   0,   1, 128,   0,   0, 
      0, 128,   0,   0, 170, 161, 
      0,   0, 255, 129,   5,   0, 
      0,   3,   2,   0,   7, 128, 
      2,   0, 255, 128,   2,   0, 
    228, 128,   5,   0,   0,   3, 
      1,   0,  15, 128,   1,   0, 
    255, 128,   2,   0, 228, 128, 
     88,   0,   0,   4,   0,   0, 
     15, 128,   0,   0,   0, 128, 
      2,   0,  85, 160,   1,   0, 
    228, 128,   1,   0,   0,   2, 
      0,   8,  15, 128,   0,   0, 
    228, 128, 255, 255,   0,   0, 
     83,  72,  68,  82, 108,   2, 
      0,   0,  64,   0,   0,   0, 
    155,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0,  98,  16, 
      0,   3, 194,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 104,   0, 
      0,   2,   2,   0,   0,   0, 
      0,   0,   0,   9,  50,   0, 
     16,   0,   0,   0,   0,   0, 
    230,  26,  16,   0,   1,   0, 
      0,   0,  70, 128,  32, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     54,   0,   0,   6,  66,   0, 
     16,   0,   0,   0,   0,   0, 
     58, 128,  32,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     16,   0,   0,   8,  66,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   2,  16,   0,   0,   0, 
      0,   0,  70, 130,  32,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  15,   0,   0,   7, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  12,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     58, 128,  32, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  58, 128, 
     32,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,   7,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0,   0,  63,  14,   0, 
      0,   7,  18,   0,  16,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     42,   0,  16,   0,   0,   0, 
      0,   0,  56,   0,   0,   8, 
     66,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  42, 128, 
     32,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,  29,   0, 
      0,   9,  66,   0,  16,   0, 
      0,   0,   0,   0,  58, 128, 
     32, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  42,   0,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5,  34,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0,   0,  63, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     31,   0,   4,   3,  42,   0, 
     16,   0,   0,   0,   0,   0, 
     54,   0,   0,   8, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  62,   0,   0,   1, 
     21,   0,   0,   1,  56,   0, 
      0,   7, 114,   0,  16,   0, 
      1,   0,   0,   0, 246,  15, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,  16,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   1,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  56,   0,   0,   7, 
    242,  32,  16,   0,   0,   0, 
      0,   0, 246,  15,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   1,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
     19,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  10,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
    100,   2,   0,   0,   1,   0, 
      0,   0, 228,   0,   0,   0, 
      5,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 255, 255, 
      0,   1,   0,   0,  47,   2, 
      0,   0, 188,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 201,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    214,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 218,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   1,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 223,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    115,  87, 114,  97, 112,  83, 
     97, 109, 112, 108, 101, 114, 
      0, 115,  77,  97, 115, 107, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 116, 101, 120,   0, 
    109,  97, 115, 107,   0,  99, 
     98,  50,   0, 171, 223,   0, 
      0,   0,   7,   0,   0,   0, 
    252,   0,   0,   0, 112,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 164,   1, 
      0,   0,   0,   0,   0,   0, 
     44,   0,   0,   0,   0,   0, 
      0,   0, 188,   1,   0,   0, 
      0,   0,   0,   0, 204,   1, 
      0,   0,  48,   0,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0, 216,   1,   0,   0, 
      0,   0,   0,   0, 232,   1, 
      0,   0,  64,   0,   0,   0, 
     12,   0,   0,   0,   2,   0, 
      0,   0, 240,   1,   0,   0, 
      0,   0,   0,   0,   0,   2, 
      0,   0,  80,   0,   0,   0, 
      8,   0,   0,   0,   2,   0, 
      0,   0, 216,   1,   0,   0, 
      0,   0,   0,   0,   8,   2, 
      0,   0,  88,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  12,   2,   0,   0, 
      0,   0,   0,   0,  28,   2, 
      0,   0,  92,   0,   0,   0, 
      4,   0,   0,   0,   2,   0, 
      0,   0,  12,   2,   0,   0, 
      0,   0,   0,   0,  36,   2, 
      0,   0,  96,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  12,   2,   0,   0, 
      0,   0,   0,   0,  68, 101, 
    118, 105,  99, 101,  83, 112, 
     97,  99, 101,  84, 111,  85, 
    115, 101, 114,  83, 112,  97, 
     99, 101,   0, 171,   3,   0, 
      3,   0,   3,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 109, 101, 
    110, 115, 105, 111, 110, 115, 
      0, 171,   1,   0,   3,   0, 
      1,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 102, 102,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     99, 101, 110, 116, 101, 114, 
     49,   0,  65,   0, 171, 171, 
      0,   0,   3,   0,   1,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 114,  97, 
    100, 105, 117, 115,  49,   0, 
    115, 113,  95, 114,  97, 100, 
    105, 117, 115,  49,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  54,  46, 
     51,  46,  57,  54,  48,  48, 
     46,  49,  54,  51,  56,  52, 
      0, 171, 171, 171,  73,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,   3, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,  12, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,  79,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     83,  86,  95,  84,  97, 114, 
    103, 101, 116,   0, 171, 171, 
     38, 151,   0,   0,   0,   0, 
      0,   0,  65,  80, 111, 115, 
     77, 105, 114, 114, 111, 114, 
      0,  44,   7,   0,   0,  68, 
     88,  66,  67, 172,  27, 205, 
    113, 176, 254,  27,  44,  22, 
    107, 179, 112, 127,  38, 148, 
    161,   1,   0,   0,   0,  44, 
      7,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 148, 
      1,   0,   0, 104,   3,   0, 
      0, 228,   3,   0,   0, 136, 
      6,   0,   0, 188,   6,   0, 
      0,  65, 111, 110,  57,  84, 
      1,   0,   0,  84,   1,   0, 
      0,   0,   2, 254, 255, 252, 
      0,   0,   0,  88,   0,   0, 
      0,   4,   0,  36,   0,   0, 
      0,  84,   0,   0,   0,  84, 
      0,   0,   0,  36,   0,   1, 
      0,  84,   0,   0,   0,   0, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   2, 
      0,   1,   0,   2,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   2,   0,   3,   0,   0, 
      0,   0,   0,   1,   0,   3, 
      0,   1,   0,   5,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   2, 254, 255,  81, 
      0,   0,   5,   6,   0,  15, 
    160,   0,   0, 128,  63,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,  31, 
      0,   0,   2,   5,   0,   0, 
    128,   0,   0,  15, 144,   4, 
      0,   0,   4,   0,   0,   3, 
    224,   0,   0, 228, 144,   2, 
      0, 238, 160,   2,   0, 228, 
    160,   4,   0,   0,   4,   0, 
      0,   3, 128,   0,   0, 228, 
    144,   1,   0, 238, 160,   1, 
      0, 228, 160,   2,   0,   0, 
      3,   0,   0,   4, 128,   0, 
      0,   0, 128,   6,   0,   0, 
    160,   5,   0,   0,   3,   0, 
      0,   4, 128,   0,   0, 170, 
    128,   5,   0,   0, 160,   5, 
      0,   0,   3,   1,   0,   1, 
    128,   0,   0, 170, 128,   6, 
      0,  85, 160,   2,   0,   0, 
      3,   0,   0,   4, 128,   0, 
      0,  85, 129,   6,   0,   0, 
    160,   2,   0,   0,   3,   0, 
      0,   3, 192,   0,   0, 228, 
    128,   0,   0, 228, 160,   5, 
      0,   0,   3,   0,   0,   1, 
    128,   0,   0, 170, 128,   5, 
      0,  85, 160,   5,   0,   0, 
      3,   1,   0,   2, 128,   0, 
      0,   0, 128,   6,   0,  85, 
    160,   1,   0,   0,   2,   1, 
      0,   4, 128,   6,   0,   0, 
    160,   8,   0,   0,   3,   0, 
      0,   8, 224,   1,   0, 228, 
    128,   3,   0, 228, 160,   8, 
      0,   0,   3,   0,   0,   4, 
    224,   1,   0, 228, 128,   4, 
      0, 228, 160,   1,   0,   0, 
      2,   0,   0,  12, 192,   6, 
      0,  36, 160, 255, 255,   0, 
      0,  83,  72,  68,  82, 204, 
      1,   0,   0,  64,   0,   1, 
      0, 115,   0,   0,   0,  89, 
      0,   0,   4,  70, 142,  32, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   1, 
      0,   0,   0,   4,   0,   0, 
      0,  95,   0,   0,   3,  50, 
     16,  16,   0,   0,   0,   0, 
      0, 103,   0,   0,   4, 242, 
     32,  16,   0,   0,   0,   0, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3,  50,  32,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 194,  32,  16, 
      0,   1,   0,   0,   0, 104, 
      0,   0,   2,   2,   0,   0, 
      0,  54,   0,   0,   8, 194, 
     32,  16,   0,   0,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 128,  63,  50,   0,   0, 
     11,  50,   0,  16,   0,   0, 
      0,   0,   0,  70,  16,  16, 
      0,   0,   0,   0,   0, 230, 
    138,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  70, 
    128,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  50,  32,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   7,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0, 128,  63,   0, 
      0,   0,   8,  34,   0,  16, 
      0,   0,   0,   0,   0,  26, 
      0,  16, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   1, 
     64,   0,   0,   0,   0, 128, 
     63,  56,   0,   0,   8,  50, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,  70, 128,  32, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,  56,   0,   0, 
     10,  50,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
     63,   0,   0,   0,  63,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   5,  66, 
      0,  16,   0,   1,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,  16,   0,   0, 
      8,  66,  32,  16,   0,   1, 
      0,   0,   0,  70,   2,  16, 
      0,   1,   0,   0,   0,  70, 
    130,  32,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   8, 130,  32,  16, 
      0,   1,   0,   0,   0,  70, 
      2,  16,   0,   1,   0,   0, 
      0,  70, 130,  32,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,  50,   0,   0,  11,  50, 
     32,  16,   0,   1,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,  62,   0,   0, 
      1,  83,  84,  65,  84, 116, 
      0,   0,   0,  12,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,   8,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  82, 
     68,  69,  70, 156,   2,   0, 
      0,   2,   0,   0,   0, 100, 
      0,   0,   0,   2,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      4, 254, 255,   0,   1,   0, 
      0, 103,   2,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  96,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,  99,  98,  48, 
      0,  99,  98,  50,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0, 148,   0,   0,   0,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  96, 
      0,   0,   0,   7,   0,   0, 
      0,  52,   1,   0,   0, 112, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 244, 
      0,   0,   0,   0,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,  16, 
      1,   0,   0,  16,   0,   0, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,  26, 
      1,   0,   0,  32,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,  40, 
      1,   0,   0,  48,   0,   0, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,  81, 
    117,  97, 100,  68, 101, 115, 
     99,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  77,  97, 115, 107,  84, 
    101, 120,  67, 111, 111, 114, 
    100, 115,   0,  84, 101, 120, 
    116,  67, 111, 108, 111, 114, 
      0, 171, 171, 220,   1,   0, 
      0,   0,   0,   0,   0,  44, 
      0,   0,   0,   2,   0,   0, 
      0, 244,   1,   0,   0,   0, 
      0,   0,   0,   4,   2,   0, 
      0,  48,   0,   0,   0,   8, 
      0,   0,   0,   2,   0,   0, 
      0,  16,   2,   0,   0,   0, 
      0,   0,   0,  32,   2,   0, 
      0,  64,   0,   0,   0,  12, 
      0,   0,   0,   0,   0,   0, 
      0,  40,   2,   0,   0,   0, 
      0,   0,   0,  56,   2,   0, 
      0,  80,   0,   0,   0,   8, 
      0,   0,   0,   0,   0,   0, 
      0,  16,   2,   0,   0,   0, 
      0,   0,   0,  64,   2,   0, 
      0,  88,   0,   0,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,  68,   2,   0,   0,   0, 
      0,   0,   0,  84,   2,   0, 
      0,  92,   0,   0,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,  68,   2,   0,   0,   0, 
      0,   0,   0,  92,   2,   0, 
      0,  96,   0,   0,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,  68,   2,   0,   0,   0, 
      0,   0,   0,  68, 101, 118, 
    105,  99, 101,  83, 112,  97, 
     99, 101,  84, 111,  85, 115, 
    101, 114,  83, 112,  97,  99, 
    101,   0, 171,   3,   0,   3, 
      0,   3,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 100, 105, 109, 101, 110, 
    115, 105, 111, 110, 115,   0, 
    171,   1,   0,   3,   0,   1, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 102, 102,   0, 171, 171, 
    171,   1,   0,   3,   0,   1, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  99, 
    101, 110, 116, 101, 114,  49, 
      0,  65,   0, 171, 171,   0, 
      0,   3,   0,   1,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 114,  97, 100, 
    105, 117, 115,  49,   0, 115, 
    113,  95, 114,  97, 100, 105, 
    117, 115,  49,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  54,  46,  51, 
     46,  57,  54,  48,  48,  46, 
     49,  54,  51,  56,  52,   0, 
    171, 171, 171,  73,  83,  71, 
     78,  44,   0,   0,   0,   1, 
      0,   0,   0,   8,   0,   0, 
      0,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   7,   3,   0, 
      0,  80,  79,  83,  73,  84, 
     73,  79,  78,   0, 171, 171, 
    171,  79,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,  12,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   3,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,   1, 
    159,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0, 232,   9,   0,   0,  68, 
     88,  66,  67,  48, 133, 157, 
     76, 135, 209,  82, 153,  49, 
    138, 172,  57,  31,  63, 161, 
    231,   1,   0,   0,   0, 232, 
      9,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 128, 
      2,   0,   0,  88,   6,   0, 
      0, 212,   6,   0,   0,  68, 
      9,   0,   0, 180,   9,   0, 
      0,  65, 111, 110,  57,  64, 
      2,   0,   0,  64,   2,   0, 
      0,   0,   2, 255, 255,   8, 
      2,   0,   0,  56,   0,   0, 
      0,   1,   0,  44,   0,   0, 
      0,  56,   0,   0,   0,  56, 
      0,   2,   0,  36,   0,   0, 
      0,  56,   0,   0,   0,   0, 
      0,   1,   1,   1,   0,   0, 
      0,   4,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 255, 255,  81,   0,   0, 
      5,   3,   0,  15, 160,   0, 
      0,   0,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  81,   0,   0, 
      5,   4,   0,  15, 160,   0, 
      0, 128,  63,   0,   0, 128, 
    191,   0,   0,   0,   0,   0, 
      0,   0, 128,  31,   0,   0, 
      2,   0,   0,   0, 128,   0, 
      0,  15, 176,  31,   0,   0, 
      2,   0,   0,   0, 144,   0, 
      8,  15, 160,  31,   0,   0, 
      2,   0,   0,   0, 144,   1, 
      8,  15, 160,   2,   0,   0, 
      3,   0,   0,   3, 128,   0, 
      0, 235, 176,   1,   0, 228, 
    161,  90,   0,   0,   4,   0, 
      0,   8, 128,   0,   0, 228, 
    128,   0,   0, 228, 128,   2, 
      0,   0, 161,   5,   0,   0, 
      3,   0,   0,   8, 128,   0, 
      0, 255, 128,   1,   0, 170, 
    160,   1,   0,   0,   2,   0, 
      0,   4, 128,   1,   0, 255, 
    160,   8,   0,   0,   3,   0, 
      0,   1, 128,   0,   0, 228, 
    128,   0,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,   2, 
    128,   0,   0,   0, 128,   0, 
      0,   0, 128,   0,   0, 255, 
    129,  35,   0,   0,   2,   0, 
      0,   4, 128,   0,   0,  85, 
    128,   7,   0,   0,   2,   0, 
      0,   4, 128,   0,   0, 170, 
    128,   6,   0,   0,   2,   1, 
      0,   1, 128,   0,   0, 170, 
    128,   1,   0,   0,   2,   1, 
      0,   6, 128,   1,   0,   0, 
    129,   2,   0,   0,   3,   0, 
      0,  13, 128,   0,   0,   0, 
    128,   1,   0, 148, 128,   6, 
      0,   0,   2,   1,   0,   1, 
    128,   1,   0, 170, 160,   5, 
      0,   0,   3,   0,   0,  13, 
    128,   0,   0, 228, 128,   1, 
      0,   0, 128,   1,   0,   0, 
      2,   1,   0,   8, 128,   1, 
      0, 255, 160,   4,   0,   0, 
      4,   1,   0,   7, 128,   0, 
      0, 248, 128,   0,   0, 170, 
    160,   1,   0, 255, 128,  88, 
      0,   0,   4,   2,   0,   1, 
    128,   1,   0,   0, 128,   0, 
      0,   0, 128,   0,   0, 255, 
    128,  88,   0,   0,   4,   0, 
      0,  13, 128,   1,   0, 148, 
    128,   4,   0,  68, 160,   4, 
      0, 230, 160,   1,   0,   0, 
      2,   2,   0,   2, 128,   3, 
      0,   0, 160,  66,   0,   0, 
      3,   1,   0,  15, 128,   0, 
      0, 228, 176,   1,   8, 228, 
    160,  66,   0,   0,   3,   2, 
      0,  15, 128,   2,   0, 228, 
    128,   0,   8, 228, 160,   5, 
      0,   0,   3,   2,   0,   7, 
    128,   2,   0, 255, 128,   2, 
      0, 228, 128,   5,   0,   0, 
      3,   1,   0,  15, 128,   1, 
      0, 255, 128,   2,   0, 228, 
    128,   2,   0,   0,   3,   0, 
      0,   8, 128,   0,   0, 255, 
    128,   0,   0,   0, 128,  88, 
      0,   0,   4,   0,   0,   1, 
    128,   0,   0, 255, 128,   0, 
      0,   0, 128,   0,   0, 170, 
    128,  88,   0,   0,   4,   1, 
      0,  15, 128,   0,   0,   0, 
    129,   4,   0, 170, 160,   1, 
      0, 228, 128,  88,   0,   0, 
      4,   0,   0,  15, 128,   0, 
      0,  85, 128,   1,   0, 228, 
    128,   4,   0, 170, 160,   1, 
      0,   0,   2,   0,   8,  15, 
    128,   0,   0, 228, 128, 255, 
    255,   0,   0,  83,  72,  68, 
     82, 208,   3,   0,   0,  64, 
      0,   0,   0, 244,   0,   0, 
      0,  89,   0,   0,   4,  70, 
    142,  32,   0,   0,   0,   0, 
      0,   7,   0,   0,   0,  90, 
      0,   0,   3,   0,  96,  16, 
      0,   0,   0,   0,   0,  90, 
      0,   0,   3,   0,  96,  16, 
      0,   1,   0,   0,   0,  88, 
     24,   0,   4,   0, 112,  16, 
      0,   0,   0,   0,   0,  85, 
     85,   0,   0,  88,  24,   0, 
      4,   0, 112,  16,   0,   1, 
      0,   0,   0,  85,  85,   0, 
      0,  98,  16,   0,   3,  50, 
     16,  16,   0,   1,   0,   0, 
      0,  98,  16,   0,   3, 194, 
     16,  16,   0,   1,   0,   0, 
      0, 101,   0,   0,   3, 242, 
     32,  16,   0,   0,   0,   0, 
      0, 104,   0,   0,   2,   3, 
      0,   0,   0,   0,   0,   0, 
      9,  50,   0,  16,   0,   0, 
      0,   0,   0, 230,  26,  16, 
      0,   1,   0,   0,   0,  70, 
    128,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  54,   0,   0, 
      6,  66,   0,  16,   0,   0, 
      0,   0,   0,  58, 128,  32, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,  16,   0,   0, 
      8,  66,   0,  16,   0,   0, 
      0,   0,   0,  70,   2,  16, 
      0,   0,   0,   0,   0,  70, 
    130,  32,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,  15, 
      0,   0,   7,  18,   0,  16, 
      0,   0,   0,   0,   0,  70, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      9,  18,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  10, 
    128,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   6, 
      0,   0,   0,  56,   0,   0, 
      8,  18,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  42, 
    128,  32,   0,   0,   0,   0, 
      0,   5,   0,   0,   0,  50, 
      0,   0,  10,  18,   0,  16, 
      0,   0,   0,   0,   0,  42, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
    128,  65,   0,   0,   0,   0, 
      0,   0,   0,  49,   0,   0, 
      7,  34,   0,  16,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,   1, 
     64,   0,   0,   0,   0,   0, 
      0,  75,   0,   0,   6,  18, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16, 128, 129, 
      0,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   6,  34, 
      0,  16,   0,   1,   0,   0, 
      0,  10,   0,  16, 128,  65, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   7,  82, 
      0,  16,   0,   0,   0,   0, 
      0, 166,  10,  16,   0,   0, 
      0,   0,   0,   6,   1,  16, 
      0,   1,   0,   0,   0,  14, 
      0,   0,   8,  82,   0,  16, 
      0,   0,   0,   0,   0,   6, 
      2,  16,   0,   0,   0,   0, 
      0, 166, 138,  32,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  56,   0,   0,   8,  50, 
      0,  16,   0,   1,   0,   0, 
      0, 134,   0,  16,   0,   0, 
      0,   0,   0, 166, 138,  32, 
      0,   0,   0,   0,   0,   4, 
      0,   0,   0,  29,   0,   0, 
      9,  50,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   1,   0,   0,   0, 246, 
    143,  32, 128,  65,   0,   0, 
      0,   0,   0,   0,   0,   5, 
      0,   0,   0,   1,   0,   0, 
     10,  50,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   1,   0,   0,   0,   2, 
     64,   0,   0,   0,   0, 128, 
     63,   0,   0, 128,  63,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   8,  18, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16, 128,  65, 
      0,   0,   0,   0,   0,   0, 
      0,  10,   0,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
      9,  18,   0,  16,   0,   2, 
      0,   0,   0,  10,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16,   0,   0,   0,   0, 
      0,  42,   0,  16,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      5,  34,   0,  16,   0,   2, 
      0,   0,   0,   1,  64,   0, 
      0,   0,   0,   0,  63,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   2,   0,   0,   0,  70, 
      0,  16,   0,   2,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  31, 
      0,   4,   3,  26,   0,  16, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   8, 242,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  62,   0,   0,   1,  21, 
      0,   0,   1,  52,   0,   0, 
      7,  18,   0,  16,   0,   0, 
      0,   0,   0,  26,   0,  16, 
      0,   1,   0,   0,   0,  10, 
      0,  16,   0,   1,   0,   0, 
      0,  29,   0,   0,   7,  18, 
      0,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0,   0,   0,  10,   0,  16, 
      0,   0,   0,   0,   0,  31, 
      0,   4,   3,  10,   0,  16, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   8, 242,  32,  16, 
      0,   0,   0,   0,   0,   2, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  62,   0,   0,   1,  21, 
      0,   0,   1,  56,   0,   0, 
      7, 114,   0,  16,   0,   2, 
      0,   0,   0, 246,  15,  16, 
      0,   2,   0,   0,   0,  70, 
      2,  16,   0,   2,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   1, 
      0,   0,   0,  70, 126,  16, 
      0,   1,   0,   0,   0,   0, 
     96,  16,   0,   1,   0,   0, 
      0,  56,   0,   0,   7, 242, 
     32,  16,   0,   0,   0,   0, 
      0, 246,  15,  16,   0,   0, 
      0,   0,   0,  70,  14,  16, 
      0,   2,   0,   0,   0,  62, 
      0,   0,   1,  83,  84,  65, 
     84, 116,   0,   0,   0,  33, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,  19,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  82,  68,  69,  70, 104, 
      2,   0,   0,   1,   0,   0, 
      0, 232,   0,   0,   0,   5, 
      0,   0,   0,  28,   0,   0, 
      0,   0,   4, 255, 255,   0, 
      1,   0,   0,  51,   2,   0, 
      0, 188,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 203,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 216, 
      0,   0,   0,   2,   0,   0, 
      0,   5,   0,   0,   0,   4, 
      0,   0,   0, 255, 255, 255, 
    255,   0,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0, 220,   0,   0,   0,   2, 
      0,   0,   0,   5,   0,   0, 
      0,   4,   0,   0,   0, 255, 
    255, 255, 255,   1,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      0,   0,   0, 225,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 115, 
     77, 105, 114, 114, 111, 114, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 115,  77,  97, 115, 
    107,  83,  97, 109, 112, 108, 
    101, 114,   0, 116, 101, 120, 
      0, 109,  97, 115, 107,   0, 
     99,  98,  50,   0, 171, 171, 
    171, 225,   0,   0,   0,   7, 
      0,   0,   0,   0,   1,   0, 
      0, 112,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 168,   1,   0,   0,   0, 
      0,   0,   0,  44,   0,   0, 
      0,   0,   0,   0,   0, 192, 
      1,   0,   0,   0,   0,   0, 
      0, 208,   1,   0,   0,  48, 
      0,   0,   0,   8,   0,   0, 
      0,   0,   0,   0,   0, 220, 
      1,   0,   0,   0,   0,   0, 
      0, 236,   1,   0,   0,  64, 
      0,   0,   0,  12,   0,   0, 
      0,   2,   0,   0,   0, 244, 
      1,   0,   0,   0,   0,   0, 
      0,   4,   2,   0,   0,  80, 
      0,   0,   0,   8,   0,   0, 
      0,   2,   0,   0,   0, 220, 
      1,   0,   0,   0,   0,   0, 
      0,  12,   2,   0,   0,  88, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  32,   2,   0,   0,  92, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  40,   2,   0,   0,  96, 
      0,   0,   0,   4,   0,   0, 
      0,   2,   0,   0,   0,  16, 
      2,   0,   0,   0,   0,   0, 
      0,  68, 101, 118, 105,  99, 
    101,  83, 112,  97,  99, 101, 
     84, 111,  85, 115, 101, 114, 
     83, 112,  97,  99, 101,   0, 
    171,   3,   0,   3,   0,   3, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 100, 
    105, 109, 101, 110, 115, 105, 
    111, 110, 115,   0, 171,   1, 
      0,   3,   0,   1,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 100, 105, 102, 
    102,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  99, 101, 110, 
    116, 101, 114,  49,   0,  65, 
      0, 171, 171,   0,   0,   3, 
      0,   1,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 114,  97, 100, 105, 117, 
    115,  49,   0, 115, 113,  95, 
    114,  97, 100, 105, 117, 115, 
     49,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0, 171, 171, 
    171,  73,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   3,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,  12,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,  79, 
     83,  71,  78,  44,   0,   0, 
      0,   1,   0,   0,   0,   8, 
      0,   0,   0,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  83,  86,  95, 
     84,  97, 114, 103, 101, 116, 
      0, 171, 171,  69, 166,   0, 
      0,   0,   0,   0,   0,  65, 
     48,  77, 105, 114, 114, 111, 
    114,   0,  44,   7,   0,   0, 
     68,  88,  66,  67, 172,  27, 
    205, 113, 176, 254,  27,  44, 
     22, 107, 179, 112, 127,  38, 
    148, 161,   1,   0,   0,   0, 
     44,   7,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    148,   1,   0,   0, 104,   3, 
      0,   0, 228,   3,   0,   0, 
    136,   6,   0,   0, 188,   6, 
      0,   0,  65, 111, 110,  57, 
     84,   1,   0,   0,  84,   1, 
      0,   0,   0,   2, 254, 255, 
    252,   0,   0,   0,  88,   0, 
      0,   0,   4,   0,  36,   0, 
      0,   0,  84,   0,   0,   0, 
     84,   0,   0,   0,  36,   0, 
      1,   0,  84,   0,   0,   0, 
      0,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   1,   0,   2,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   3,   0, 
      0,   0,   0,   0,   1,   0, 
      3,   0,   1,   0,   5,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 254, 255, 
     81,   0,   0,   5,   6,   0, 
     15, 160,   0,   0, 128,  63, 
      0,   0,   0,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     31,   0,   0,   2,   5,   0, 
      0, 128,   0,   0,  15, 144, 
      4,   0,   0,   4,   0,   0, 
      3, 224,   0,   0, 228, 144, 
      2,   0, 238, 160,   2,   0, 
    228, 160,   4,   0,   0,   4, 
      0,   0,   3, 128,   0,   0, 
    228, 144,   1,   0, 238, 160, 
      1,   0, 228, 160,   2,   0, 
      0,   3,   0,   0,   4, 128, 
      0,   0,   0, 128,   6,   0, 
      0, 160,   5,   0,   0,   3, 
      0,   0,   4, 128,   0,   0, 
    170, 128,   5,   0,   0, 160, 
      5,   0,   0,   3,   1,   0, 
      1, 128,   0,   0, 170, 128, 
      6,   0,  85, 160,   2,   0, 
      0,   3,   0,   0,   4, 128, 
      0,   0,  85, 129,   6,   0, 
      0, 160,   2,   0,   0,   3, 
      0,   0,   3, 192,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      5,   0,   0,   3,   0,   0, 
      1, 128,   0,   0, 170, 128, 
      5,   0,  85, 160,   5,   0, 
      0,   3,   1,   0,   2, 128, 
      0,   0,   0, 128,   6,   0, 
     85, 160,   1,   0,   0,   2, 
      1,   0,   4, 128,   6,   0, 
      0, 160,   8,   0,   0,   3, 
      0,   0,   8, 224,   1,   0, 
    228, 128,   3,   0, 228, 160, 
      8,   0,   0,   3,   0,   0, 
      4, 224,   1,   0, 228, 128, 
      4,   0, 228, 160,   1,   0, 
      0,   2,   0,   0,  12, 192, 
      6,   0,  36, 160, 255, 255, 
      0,   0,  83,  72,  68,  82, 
    204,   1,   0,   0,  64,   0, 
      1,   0, 115,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      1,   0,   0,   0,   4,   0, 
      0,   0,  95,   0,   0,   3, 
     50,  16,  16,   0,   0,   0, 
      0,   0, 103,   0,   0,   4, 
    242,  32,  16,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    101,   0,   0,   3,  50,  32, 
     16,   0,   1,   0,   0,   0, 
    101,   0,   0,   3, 194,  32, 
     16,   0,   1,   0,   0,   0, 
    104,   0,   0,   2,   2,   0, 
      0,   0,  54,   0,   0,   8, 
    194,  32,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 128,  63,  50,   0, 
      0,  11,  50,   0,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  50,  32, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   7, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0, 128,  63, 
      0,   0,   0,   8,  34,   0, 
     16,   0,   0,   0,   0,   0, 
     26,   0,  16, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,  56,   0,   0,   8, 
     50,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  70, 128, 
     32,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,  56,   0, 
      0,  10,  50,   0,  16,   0, 
      1,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,  63,   0,   0,   0,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
     66,   0,  16,   0,   1,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0, 128,  63,  16,   0, 
      0,   8,  66,  32,  16,   0, 
      1,   0,   0,   0,  70,   2, 
     16,   0,   1,   0,   0,   0, 
     70, 130,  32,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   0,   0,   8, 130,  32, 
     16,   0,   1,   0,   0,   0, 
     70,   2,  16,   0,   1,   0, 
      0,   0,  70, 130,  32,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,  50,   0,   0,  11, 
     50,  32,  16,   0,   1,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,  12,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70, 156,   2, 
      0,   0,   2,   0,   0,   0, 
    100,   0,   0,   0,   2,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 254, 255,   0,   1, 
      0,   0, 103,   2,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  96,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  99,  98, 
     48,   0,  99,  98,  50,   0, 
     92,   0,   0,   0,   4,   0, 
      0,   0, 148,   0,   0,   0, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     96,   0,   0,   0,   7,   0, 
      0,   0,  52,   1,   0,   0, 
    112,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    244,   0,   0,   0,   0,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
     16,   1,   0,   0,  16,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
     26,   1,   0,   0,  32,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
     40,   1,   0,   0,  48,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
     81, 117,  97, 100,  68, 101, 
    115,  99,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  77,  97, 115, 107, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  84, 101, 
    120, 116,  67, 111, 108, 111, 
    114,   0, 171, 171, 220,   1, 
      0,   0,   0,   0,   0,   0, 
     44,   0,   0,   0,   2,   0, 
      0,   0, 244,   1,   0,   0, 
      0,   0,   0,   0,   4,   2, 
      0,   0,  48,   0,   0,   0, 
      8,   0,   0,   0,   2,   0, 
      0,   0,  16,   2,   0,   0, 
      0,   0,   0,   0,  32,   2, 
      0,   0,  64,   0,   0,   0, 
     12,   0,   0,   0,   0,   0, 
      0,   0,  40,   2,   0,   0, 
      0,   0,   0,   0,  56,   2, 
      0,   0,  80,   0,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,  16,   2,   0,   0, 
      0,   0,   0,   0,  64,   2, 
      0,   0,  88,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  68,   2,   0,   0, 
      0,   0,   0,   0,  84,   2, 
      0,   0,  92,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  68,   2,   0,   0, 
      0,   0,   0,   0,  92,   2, 
      0,   0,  96,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  68,   2,   0,   0, 
      0,   0,   0,   0,  68, 101, 
    118, 105,  99, 101,  83, 112, 
     97,  99, 101,  84, 111,  85, 
    115, 101, 114,  83, 112,  97, 
     99, 101,   0, 171,   3,   0, 
      3,   0,   3,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 109, 101, 
    110, 115, 105, 111, 110, 115, 
      0, 171,   1,   0,   3,   0, 
      1,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 102, 102,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     99, 101, 110, 116, 101, 114, 
     49,   0,  65,   0, 171, 171, 
      0,   0,   3,   0,   1,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 114,  97, 
    100, 105, 117, 115,  49,   0, 
    115, 113,  95, 114,  97, 100, 
    105, 117, 115,  49,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  54,  46, 
     51,  46,  57,  54,  48,  48, 
     46,  49,  54,  51,  56,  52, 
      0, 171, 171, 171,  73,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   7,   3, 
      0,   0,  80,  79,  83,  73, 
     84,  73,  79,  78,   0, 171, 
    171, 171,  79,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,  12,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,   3,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
     66, 176,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0, 200,   7,   0,   0, 
     68,  88,  66,  67, 238, 212, 
    160,  43, 129,  11,  44, 225, 
     62, 162, 102,  35,   9, 220, 
     80, 177,   1,   0,   0,   0, 
    200,   7,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    196,   1,   0,   0,  56,   4, 
      0,   0, 180,   4,   0,   0, 
     36,   7,   0,   0, 148,   7, 
      0,   0,  65, 111, 110,  57, 
    132,   1,   0,   0, 132,   1, 
      0,   0,   0,   2, 255, 255, 
     76,   1,   0,   0,  56,   0, 
      0,   0,   1,   0,  44,   0, 
      0,   0,  56,   0,   0,   0, 
     56,   0,   2,   0,  36,   0, 
      0,   0,  56,   0,   0,   0, 
      0,   0,   1,   1,   1,   0, 
      0,   0,   4,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   2, 255, 255,  81,   0, 
      0,   5,   2,   0,  15, 160, 
      0,   0,   0,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  31,   0, 
      0,   2,   0,   0,   0, 128, 
      0,   0,  15, 176,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      0,   8,  15, 160,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      1,   8,  15, 160,   5,   0, 
      0,   3,   0,   0,   8, 128, 
      1,   0, 255, 160,   1,   0, 
    255, 160,   2,   0,   0,   3, 
      0,   0,   3, 128,   0,   0, 
    235, 176,   1,   0, 228, 161, 
     90,   0,   0,   4,   0,   0, 
      8, 128,   0,   0, 228, 128, 
      0,   0, 228, 128,   0,   0, 
    255, 129,   5,   0,   0,   3, 
      0,   0,   8, 128,   0,   0, 
    255, 128,   2,   0,   0, 160, 
      1,   0,   0,   2,   0,   0, 
      4, 128,   1,   0, 255, 160, 
      8,   0,   0,   3,   0,   0, 
      1, 128,   0,   0, 228, 128, 
      0,   0, 228, 160,   6,   0, 
      0,   2,   0,   0,   1, 128, 
      0,   0,   0, 128,   5,   0, 
      0,   3,   0,   0,   1, 128, 
      0,   0,   0, 128,   0,   0, 
    255, 128,   1,   0,   0,   2, 
      0,   0,   2, 128,   2,   0, 
      0, 160,  66,   0,   0,   3, 
      1,   0,  15, 128,   0,   0, 
    228, 176,   1,   8, 228, 160, 
     66,   0,   0,   3,   2,   0, 
     15, 128,   0,   0, 228, 128, 
      0,   8, 228, 160,   1,   0, 
      0,   2,   0,   0,   8, 128, 
      1,   0, 255, 160,   4,   0, 
      0,   4,   0,   0,   1, 128, 
      0,   0,   0, 128,   0,   0, 
    170, 161,   0,   0, 255, 129, 
      5,   0,   0,   3,   2,   0, 
      7, 128,   2,   0, 255, 128, 
      2,   0, 228, 128,   5,   0, 
      0,   3,   1,   0,  15, 128, 
      1,   0, 255, 128,   2,   0, 
    228, 128,  88,   0,   0,   4, 
      0,   0,  15, 128,   0,   0, 
      0, 128,   2,   0,  85, 160, 
      1,   0, 228, 128,   1,   0, 
      0,   2,   0,   8,  15, 128, 
      0,   0, 228, 128, 255, 255, 
      0,   0,  83,  72,  68,  82, 
    108,   2,   0,   0,  64,   0, 
      0,   0, 155,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
      6,   0,   0,   0,  90,   0, 
      0,   3,   0,  96,  16,   0, 
      0,   0,   0,   0,  90,   0, 
      0,   3,   0,  96,  16,   0, 
      1,   0,   0,   0,  88,  24, 
      0,   4,   0, 112,  16,   0, 
      0,   0,   0,   0,  85,  85, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   1,   0, 
      0,   0,  85,  85,   0,   0, 
     98,  16,   0,   3,  50,  16, 
     16,   0,   1,   0,   0,   0, 
     98,  16,   0,   3, 194,  16, 
     16,   0,   1,   0,   0,   0, 
    101,   0,   0,   3, 242,  32, 
     16,   0,   0,   0,   0,   0, 
    104,   0,   0,   2,   2,   0, 
      0,   0,   0,   0,   0,   9, 
     50,   0,  16,   0,   0,   0, 
      0,   0, 230,  26,  16,   0, 
      1,   0,   0,   0,  70, 128, 
     32, 128,  65,   0,   0,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  54,   0,   0,   6, 
     66,   0,  16,   0,   0,   0, 
      0,   0,  58, 128,  32,   0, 
      0,   0,   0,   0,   5,   0, 
      0,   0,  16,   0,   0,   8, 
     66,   0,  16,   0,   0,   0, 
      0,   0,  70,   2,  16,   0, 
      0,   0,   0,   0,  70, 130, 
     32,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,  15,   0, 
      0,   7,  18,   0,  16,   0, 
      0,   0,   0,   0,  70,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  12, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  58, 128,  32, 128, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     58, 128,  32,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,  56,   0,   0,   7, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0,   0,  63, 
     14,   0,   0,   7,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,  42,   0,  16,   0, 
      0,   0,   0,   0,  56,   0, 
      0,   8,  66,   0,  16,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     42, 128,  32,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
     29,   0,   0,   9,  66,   0, 
     16,   0,   0,   0,   0,   0, 
     58, 128,  32, 128,  65,   0, 
      0,   0,   0,   0,   0,   0, 
      5,   0,   0,   0,  42,   0, 
     16,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  34,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,  63,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  70,   0,  16,   0, 
      0,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  31,   0,   4,   3, 
     42,   0,  16,   0,   0,   0, 
      0,   0,  54,   0,   0,   8, 
    242,  32,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  62,   0, 
      0,   1,  21,   0,   0,   1, 
     56,   0,   0,   7, 114,   0, 
     16,   0,   1,   0,   0,   0, 
    246,  15,  16,   0,   1,   0, 
      0,   0,  70,   2,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   1,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  56,   0, 
      0,   7, 242,  32,  16,   0, 
      0,   0,   0,   0, 246,  15, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   1,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,  19,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     10,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70, 104,   2,   0,   0, 
      1,   0,   0,   0, 232,   0, 
      0,   0,   5,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    255, 255,   0,   1,   0,   0, 
     51,   2,   0,   0, 188,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    203,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 216,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 220,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      1,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    225,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 115,  77, 105, 114, 
    114, 111, 114,  83,  97, 109, 
    112, 108, 101, 114,   0, 115, 
     77,  97, 115, 107,  83,  97, 
    109, 112, 108, 101, 114,   0, 
    116, 101, 120,   0, 109,  97, 
    115, 107,   0,  99,  98,  50, 
      0, 171, 171, 171, 225,   0, 
      0,   0,   7,   0,   0,   0, 
      0,   1,   0,   0, 112,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 168,   1, 
      0,   0,   0,   0,   0,   0, 
     44,   0,   0,   0,   0,   0, 
      0,   0, 192,   1,   0,   0, 
      0,   0,   0,   0, 208,   1, 
      0,   0,  48,   0,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0, 220,   1,   0,   0, 
      0,   0,   0,   0, 236,   1, 
      0,   0,  64,   0,   0,   0, 
     12,   0,   0,   0,   2,   0, 
      0,   0, 244,   1,   0,   0, 
      0,   0,   0,   0,   4,   2, 
      0,   0,  80,   0,   0,   0, 
      8,   0,   0,   0,   2,   0, 
      0,   0, 220,   1,   0,   0, 
      0,   0,   0,   0,  12,   2, 
      0,   0,  88,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  16,   2,   0,   0, 
      0,   0,   0,   0,  32,   2, 
      0,   0,  92,   0,   0,   0, 
      4,   0,   0,   0,   2,   0, 
      0,   0,  16,   2,   0,   0, 
      0,   0,   0,   0,  40,   2, 
      0,   0,  96,   0,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,  16,   2,   0,   0, 
      0,   0,   0,   0,  68, 101, 
    118, 105,  99, 101,  83, 112, 
     97,  99, 101,  84, 111,  85, 
    115, 101, 114,  83, 112,  97, 
     99, 101,   0, 171,   3,   0, 
      3,   0,   3,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 100, 105, 109, 101, 
    110, 115, 105, 111, 110, 115, 
      0, 171,   1,   0,   3,   0, 
      1,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    100, 105, 102, 102,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     99, 101, 110, 116, 101, 114, 
     49,   0,  65,   0, 171, 171, 
      0,   0,   3,   0,   1,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 114,  97, 
    100, 105, 117, 115,  49,   0, 
    115, 113,  95, 114,  97, 100, 
    105, 117, 115,  49,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  54,  46, 
     51,  46,  57,  54,  48,  48, 
     46,  49,  54,  51,  56,  52, 
      0, 171, 171, 171,  73,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,   3, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,  12, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,  79,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     83,  86,  95,  84,  97, 114, 
    103, 101, 116,   0, 171, 171, 
    134, 183,   0,   0,   0,   0, 
      0,   0,  83,  97, 109, 112, 
    108, 101,  77,  97, 115, 107, 
    101, 100,  84, 101, 120, 116, 
    117, 114, 101,   0,  68,   4, 
      0,   0,  68,  88,  66,  67, 
     77,  85, 167, 240,  56,  56, 
    155,  78, 125,  96,  49, 253, 
    103, 100,  22,  62,   1,   0, 
      0,   0,  68,   4,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 248,   0,   0,   0, 
    244,   1,   0,   0, 112,   2, 
      0,   0, 160,   3,   0,   0, 
    212,   3,   0,   0,  65, 111, 
    110,  57, 184,   0,   0,   0, 
    184,   0,   0,   0,   0,   2, 
    254, 255, 132,   0,   0,   0, 
     52,   0,   0,   0,   1,   0, 
     36,   0,   0,   0,  48,   0, 
      0,   0,  48,   0,   0,   0, 
     36,   0,   1,   0,  48,   0, 
      0,   0,   0,   0,   3,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    254, 255,  81,   0,   0,   5, 
      4,   0,  15, 160,   0,   0, 
      0,   0,   0,   0, 128,  63, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      5,   0,   0, 128,   0,   0, 
     15, 144,   4,   0,   0,   4, 
      0,   0,   3, 224,   0,   0, 
    228, 144,   2,   0, 238, 160, 
      2,   0, 228, 160,   4,   0, 
      0,   4,   0,   0,  12, 224, 
      0,   0,  20, 144,   3,   0, 
    180, 160,   3,   0,  20, 160, 
      4,   0,   0,   4,   0,   0, 
      3, 128,   0,   0, 228, 144, 
      1,   0, 238, 160,   1,   0, 
    228, 160,   2,   0,   0,   3, 
      0,   0,   3, 192,   0,   0, 
    228, 128,   0,   0, 228, 160, 
      1,   0,   0,   2,   0,   0, 
     12, 192,   4,   0,  68, 160, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 244,   0,   0,   0, 
     64,   0,   1,   0,  61,   0, 
      0,   0,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     95,   0,   0,   3,  50,  16, 
     16,   0,   0,   0,   0,   0, 
    103,   0,   0,   4, 242,  32, 
     16,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3,  50,  32,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 194,  32,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      0,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   8, 194,  32, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    128,  63,  50,   0,   0,  11, 
     50,  32,  16,   0,   1,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  11, 194,  32,  16,   0, 
      1,   0,   0,   0,   6,  20, 
     16,   0,   0,   0,   0,   0, 
    166, 142,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      6, 132,  32,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
      5,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
     40,   1,   0,   0,   1,   0, 
      0,   0,  64,   0,   0,   0, 
      1,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 254, 255, 
      0,   1,   0,   0, 246,   0, 
      0,   0,  60,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,  99,  98, 
     48,   0,  60,   0,   0,   0, 
      4,   0,   0,   0,  88,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 184,   0,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 212,   0,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 222,   0,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0, 236,   0,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    196,   0,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  54,  46,  51, 
     46,  57,  54,  48,  48,  46, 
     49,  54,  51,  56,  52,   0, 
     73,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   3,   0,   0,  80,  79, 
     83,  73,  84,  73,  79,  78, 
      0, 171, 171, 171,  79,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,  12, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,   3, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171, 110, 191,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0, 212,   3, 
      0,   0,  68,  88,  66,  67, 
     98, 136, 224, 212, 103, 235, 
    205,  77, 125, 241, 101, 150, 
    199,  56, 208,  85,   1,   0, 
      0,   0, 212,   3,   0,   0, 
      6,   0,   0,   0,  56,   0, 
      0,   0, 224,   0,   0,   0, 
    188,   1,   0,   0,  56,   2, 
      0,   0,  48,   3,   0,   0, 
    160,   3,   0,   0,  65, 111, 
    110,  57, 160,   0,   0,   0, 
    160,   0,   0,   0,   0,   2, 
    255, 255, 116,   0,   0,   0, 
     44,   0,   0,   0,   0,   0, 
     44,   0,   0,   0,  44,   0, 
      0,   0,  44,   0,   2,   0, 
     36,   0,   0,   0,  44,   0, 
      0,   0,   0,   0,   1,   1, 
      1,   0,   1,   2, 255, 255, 
     31,   0,   0,   2,   0,   0, 
      0, 128,   0,   0,  15, 176, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   0,   8,  15, 160, 
     31,   0,   0,   2,   0,   0, 
      0, 144,   1,   8,  15, 160, 
      1,   0,   0,   2,   0,   0, 
      3, 128,   0,   0, 235, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   0,   0, 228, 176, 
      0,   8, 228, 160,  66,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 228, 128,   1,   8, 
    228, 160,   5,   0,   0,   3, 
      0,   0,  15, 128,   0,   0, 
    255, 128,   1,   0, 228, 128, 
      1,   0,   0,   2,   0,   8, 
     15, 128,   0,   0, 228, 128, 
    255, 255,   0,   0,  83,  72, 
     68,  82, 212,   0,   0,   0, 
     64,   0,   0,   0,  53,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0,  98,  16, 
      0,   3, 194,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 104,   0, 
      0,   2,   2,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
    230,  26,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      1,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   7, 242,  32, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0, 246,  15,  16,   0, 
      1,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,   4,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70, 240,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 255, 255,   0,   1, 
      0,   0, 187,   0,   0,   0, 
    156,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 165,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 178,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    182,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   1,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 115,  83,  97, 109, 
    112, 108, 101, 114,   0, 115, 
     77,  97, 115, 107,  83,  97, 
    109, 112, 108, 101, 114,   0, 
    116, 101, 120,   0, 109,  97, 
    115, 107,   0,  77, 105,  99, 
    114, 111, 115, 111, 102, 116, 
     32,  40,  82,  41,  32,  72, 
     76,  83,  76,  32,  83, 104, 
     97, 100, 101, 114,  32,  67, 
    111, 109, 112, 105, 108, 101, 
    114,  32,  54,  46,  51,  46, 
     57,  54,  48,  48,  46,  49, 
     54,  51,  56,  52,   0, 171, 
    171, 171,  73,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,   3,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,  12,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
     79,  83,  71,  78,  44,   0, 
      0,   0,   1,   0,   0,   0, 
      8,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  83,  86, 
     95,  84,  97, 114, 103, 101, 
    116,   0, 171, 171, 202, 195, 
      0,   0,   0,   0,   0,   0, 
     83,  97, 109, 112, 108, 101, 
     84, 101, 120, 116, 117, 114, 
    101,  87, 105, 116, 104,  83, 
    104,  97, 100, 111, 119,   0, 
      4,   0,   0,   0,   1,   0, 
      0,   0,   0,   0, 128,  63, 
      1,   0,   0,   0,   0,   0, 
    128,  63,   1,   0,   0,   0, 
      0,   0, 128,  63,   1,   0, 
      0,   0,   0,   0, 128,  63, 
      1,   0,   0,   0,   3,   0, 
      0,   0, 255, 255, 255, 255, 
     68,   4,   0,   0,  68,  88, 
     66,  67,  77,  85, 167, 240, 
     56,  56, 155,  78, 125,  96, 
     49, 253, 103, 100,  22,  62, 
      1,   0,   0,   0,  68,   4, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 248,   0, 
      0,   0, 244,   1,   0,   0, 
    112,   2,   0,   0, 160,   3, 
      0,   0, 212,   3,   0,   0, 
     65, 111, 110,  57, 184,   0, 
      0,   0, 184,   0,   0,   0, 
      0,   2, 254, 255, 132,   0, 
      0,   0,  52,   0,   0,   0, 
      1,   0,  36,   0,   0,   0, 
     48,   0,   0,   0,  48,   0, 
      0,   0,  36,   0,   1,   0, 
     48,   0,   0,   0,   0,   0, 
      3,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   2, 254, 255,  81,   0, 
      0,   5,   4,   0,  15, 160, 
      0,   0,   0,   0,   0,   0, 
    128,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,  31,   0, 
      0,   2,   5,   0,   0, 128, 
      0,   0,  15, 144,   4,   0, 
      0,   4,   0,   0,   3, 224, 
      0,   0, 228, 144,   2,   0, 
    238, 160,   2,   0, 228, 160, 
      4,   0,   0,   4,   0,   0, 
     12, 224,   0,   0,  20, 144, 
      3,   0, 180, 160,   3,   0, 
     20, 160,   4,   0,   0,   4, 
      0,   0,   3, 128,   0,   0, 
    228, 144,   1,   0, 238, 160, 
      1,   0, 228, 160,   2,   0, 
      0,   3,   0,   0,   3, 192, 
      0,   0, 228, 128,   0,   0, 
    228, 160,   1,   0,   0,   2, 
      0,   0,  12, 192,   4,   0, 
     68, 160, 255, 255,   0,   0, 
     83,  72,  68,  82, 244,   0, 
      0,   0,  64,   0,   1,   0, 
     61,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,  95,   0,   0,   3, 
     50,  16,  16,   0,   0,   0, 
      0,   0, 103,   0,   0,   4, 
    242,  32,  16,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    101,   0,   0,   3,  50,  32, 
     16,   0,   1,   0,   0,   0, 
    101,   0,   0,   3, 194,  32, 
     16,   0,   1,   0,   0,   0, 
     50,   0,   0,  11,  50,  32, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   8, 
    194,  32,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 128,  63,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      1,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     50,   0,   0,  11, 194,  32, 
     16,   0,   1,   0,   0,   0, 
      6,  20,  16,   0,   0,   0, 
      0,   0, 166, 142,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   6, 132,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,   5,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70,  40,   1,   0,   0, 
      1,   0,   0,   0,  64,   0, 
      0,   0,   1,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    254, 255,   0,   1,   0,   0, 
    246,   0,   0,   0,  60,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     99,  98,  48,   0,  60,   0, 
      0,   0,   4,   0,   0,   0, 
     88,   0,   0,   0,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 184,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 212,   0, 
      0,   0,  16,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 222,   0, 
      0,   0,  32,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 236,   0, 
      0,   0,  48,   0,   0,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0,  81, 117, 
     97, 100,  68, 101, 115,  99, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     77,  97, 115, 107,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  84, 101, 120, 116, 
     67, 111, 108, 111, 114,   0, 
     77, 105,  99, 114, 111, 115, 
    111, 102, 116,  32,  40,  82, 
     41,  32,  72,  76,  83,  76, 
     32,  83, 104,  97, 100, 101, 
    114,  32,  67, 111, 109, 112, 
    105, 108, 101, 114,  32,  54, 
     46,  51,  46,  57,  54,  48, 
     48,  46,  49,  54,  51,  56, 
     52,   0,  73,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   7,   3,   0,   0, 
     80,  79,  83,  73,  84,  73, 
     79,  78,   0, 171, 171, 171, 
     79,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,  12,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   3,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171, 242, 199, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
    232,   9,   0,   0,  68,  88, 
     66,  67, 128, 131, 241,  85, 
    199,  21, 192,  89,  55, 255, 
     82,  94, 121, 175,  16, 184, 
      1,   0,   0,   0, 232,   9, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 248,   2, 
      0,   0,   8,   7,   0,   0, 
    132,   7,   0,   0,  68,   9, 
      0,   0, 180,   9,   0,   0, 
     65, 111, 110,  57, 184,   2, 
      0,   0, 184,   2,   0,   0, 
      0,   2, 255, 255, 120,   2, 
      0,   0,  64,   0,   0,   0, 
      2,   0,  40,   0,   0,   0, 
     64,   0,   0,   0,  64,   0, 
      1,   0,  36,   0,   0,   0, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   6,   0,   4,   0, 
      3,   0,   0,   0,   0,   0, 
      1,   2, 255, 255,  31,   0, 
      0,   2,   0,   0,   0, 128, 
      0,   0,  15, 176,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      0,   8,  15, 160,   2,   0, 
      0,   3,   0,   0,   1, 128, 
      0,   0,   0, 176,   0,   0, 
     85, 160,   1,   0,   0,   2, 
      0,   0,   2, 128,   0,   0, 
     85, 176,   2,   0,   0,   3, 
      1,   0,   1, 128,   0,   0, 
      0, 176,   0,   0,   0, 160, 
      1,   0,   0,   2,   1,   0, 
      2, 128,   0,   0,  85, 176, 
     66,   0,   0,   3,   0,   0, 
     15, 128,   0,   0, 228, 128, 
      0,   8, 228, 160,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      1,   0, 228, 128,   0,   8, 
    228, 160,   5,   0,   0,   3, 
      0,   0,   1, 128,   0,   0, 
    255, 128,   3,   0,  85, 160, 
      4,   0,   0,   4,   0,   0, 
      1, 128,   3,   0,   0, 160, 
      1,   0, 255, 128,   0,   0, 
      0, 128,   2,   0,   0,   3, 
      1,   0,   1, 128,   0,   0, 
      0, 176,   0,   0, 170, 160, 
      1,   0,   0,   2,   1,   0, 
      2, 128,   0,   0,  85, 176, 
      2,   0,   0,   3,   2,   0, 
      1, 128,   0,   0,   0, 176, 
      0,   0, 255, 160,   1,   0, 
      0,   2,   2,   0,   2, 128, 
      0,   0,  85, 176,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      1,   0, 228, 128,   0,   8, 
    228, 160,  66,   0,   0,   3, 
      2,   0,  15, 128,   2,   0, 
    228, 128,   0,   8, 228, 160, 
      4,   0,   0,   4,   0,   0, 
      1, 128,   3,   0, 170, 160, 
      1,   0, 255, 128,   0,   0, 
      0, 128,   4,   0,   0,   4, 
      0,   0,   1, 128,   3,   0, 
    255, 160,   2,   0, 255, 128, 
      0,   0,   0, 128,   2,   0, 
      0,   3,   1,   0,   1, 128, 
      0,   0,   0, 176,   1,   0, 
      0, 160,   1,   0,   0,   2, 
      1,   0,   2, 128,   0,   0, 
     85, 176,   2,   0,   0,   3, 
      2,   0,   1, 128,   0,   0, 
      0, 176,   1,   0,  85, 160, 
      1,   0,   0,   2,   2,   0, 
      2, 128,   0,   0,  85, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 228, 128, 
      0,   8, 228, 160,  66,   0, 
      0,   3,   2,   0,  15, 128, 
      2,   0, 228, 128,   0,   8, 
    228, 160,   4,   0,   0,   4, 
      0,   0,   1, 128,   4,   0, 
      0, 160,   1,   0, 255, 128, 
      0,   0,   0, 128,   4,   0, 
      0,   4,   0,   0,   1, 128, 
      4,   0,  85, 160,   2,   0, 
    255, 128,   0,   0,   0, 128, 
      2,   0,   0,   3,   1,   0, 
      1, 128,   0,   0,   0, 176, 
      1,   0, 170, 160,   1,   0, 
      0,   2,   1,   0,   2, 128, 
      0,   0,  85, 176,   2,   0, 
      0,   3,   2,   0,   1, 128, 
      0,   0,   0, 176,   1,   0, 
    255, 160,   1,   0,   0,   2, 
      2,   0,   2, 128,   0,   0, 
     85, 176,  66,   0,   0,   3, 
      1,   0,  15, 128,   1,   0, 
    228, 128,   0,   8, 228, 160, 
     66,   0,   0,   3,   2,   0, 
     15, 128,   2,   0, 228, 128, 
      0,   8, 228, 160,   4,   0, 
      0,   4,   0,   0,   1, 128, 
      4,   0, 170, 160,   1,   0, 
    255, 128,   0,   0,   0, 128, 
      4,   0,   0,   4,   0,   0, 
      1, 128,   4,   0, 255, 160, 
      2,   0, 255, 128,   0,   0, 
      0, 128,   2,   0,   0,   3, 
      1,   0,   1, 128,   0,   0, 
      0, 176,   2,   0,   0, 160, 
      1,   0,   0,   2,   1,   0, 
      2, 128,   0,   0,  85, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 228, 128, 
      0,   8, 228, 160,   4,   0, 
      0,   4,   0,   0,   1, 128, 
      5,   0,   0, 160,   1,   0, 
    255, 128,   0,   0,   0, 128, 
      5,   0,   0,   3,   0,   0, 
     15, 128,   0,   0,   0, 128, 
      6,   0, 228, 160,   1,   0, 
      0,   2,   0,   8,  15, 128, 
      0,   0, 228, 128, 255, 255, 
      0,   0,  83,  72,  68,  82, 
      8,   4,   0,   0,  64,   0, 
      0,   0,   2,   1,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
     10,   0,   0,   0,  90,   0, 
      0,   3,   0,  96,  16,   0, 
      0,   0,   0,   0,  88,  24, 
      0,   4,   0, 112,  16,   0, 
      0,   0,   0,   0,  85,  85, 
      0,   0,  98,  16,   0,   3, 
     50,  16,  16,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
    242,  32,  16,   0,   0,   0, 
      0,   0, 104,   0,   0,   2, 
      4,   0,   0,   0,   0,   0, 
      0,   8, 242,   0,  16,   0, 
      0,   0,   0,   0,   6,  16, 
     16,   0,   1,   0,   0,   0, 
     38, 135,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  82,   0, 
     16,   0,   1,   0,   0,   0, 
     86,   7,  16,   0,   0,   0, 
      0,   0,  54,   0,   0,   5, 
    162,   0,  16,   0,   1,   0, 
      0,   0,  86,  21,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      2,   0,   0,   0, 230,  10, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      0,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      1,   0,   0,   0,  70,   0, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      0,   0,   0,   0,  56,   0, 
      0,   8,  18,   0,  16,   0, 
      1,   0,   0,   0,  58,   0, 
     16,   0,   2,   0,   0,   0, 
     26, 128,  32,   0,   0,   0, 
      0,   0,   6,   0,   0,   0, 
     50,   0,   0,  10,  18,   0, 
     16,   0,   1,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   6,   0,   0,   0, 
     58,   0,  16,   0,   1,   0, 
      0,   0,  10,   0,  16,   0, 
      1,   0,   0,   0,  54,   0, 
      0,   5, 162,   0,  16,   0, 
      0,   0,   0,   0,  86,  21, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   2,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
    230,  10,  16,   0,   0,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  10,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     42, 128,  32,   0,   0,   0, 
      0,   0,   6,   0,   0,   0, 
     58,   0,  16,   0,   2,   0, 
      0,   0,  10,   0,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  10,  18,   0,  16,   0, 
      0,   0,   0,   0,  58, 128, 
     32,   0,   0,   0,   0,   0, 
      6,   0,   0,   0,  58,   0, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   8, 
    242,   0,  16,   0,   1,   0, 
      0,   0,   6,  16,  16,   0, 
      1,   0,   0,   0,  38, 135, 
     32,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  54,   0, 
      0,   5,  82,   0,  16,   0, 
      2,   0,   0,   0,  86,   7, 
     16,   0,   1,   0,   0,   0, 
     54,   0,   0,   5, 162,   0, 
     16,   0,   2,   0,   0,   0, 
     86,  21,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   3,   0, 
      0,   0,  70,   0,  16,   0, 
      2,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   2,   0, 
      0,   0, 230,  10,  16,   0, 
      2,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  10, 128,  32,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  58,   0,  16,   0, 
      3,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  10,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     26, 128,  32,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     58,   0,  16,   0,   2,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5, 162,   0,  16,   0, 
      1,   0,   0,   0,  86,  21, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   2,   0,   0,   0, 
     70,   0,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
    230,  10,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  10,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     42, 128,  32,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     58,   0,  16,   0,   2,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  50,   0, 
      0,  10,  18,   0,  16,   0, 
      0,   0,   0,   0,  58, 128, 
     32,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,  58,   0, 
     16,   0,   1,   0,   0,   0, 
     10,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   8, 
     18,   0,  16,   0,   1,   0, 
      0,   0,  10,  16,  16,   0, 
      1,   0,   0,   0,  10, 128, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  54,   0, 
      0,   5,  34,   0,  16,   0, 
      1,   0,   0,   0,  26,  16, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
     70,   0,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  10,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   8,   0,   0,   0, 
     58,   0,  16,   0,   1,   0, 
      0,   0,  10,   0,  16,   0, 
      0,   0,   0,   0,  56,   0, 
      0,   8, 242,  32,  16,   0, 
      0,   0,   0,   0,   6,   0, 
     16,   0,   0,   0,   0,   0, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   9,   0,   0,   0, 
     62,   0,   0,   1,  83,  84, 
     65,  84, 116,   0,   0,   0, 
     30,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  13,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   9,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  82,  68,  69,  70, 
    184,   1,   0,   0,   1,   0, 
      0,   0, 148,   0,   0,   0, 
      3,   0,   0,   0,  28,   0, 
      0,   0,   0,   4, 255, 255, 
      0,   1,   0,   0, 132,   1, 
      0,   0, 124,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 139,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    143,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 115,  83, 104,  97, 
    100, 111, 119,  83,  97, 109, 
    112, 108, 101, 114,   0, 116, 
    101, 120,   0,  99,  98,  49, 
      0, 171, 143,   0,   0,   0, 
      4,   0,   0,   0, 172,   0, 
      0,   0, 160,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  12,   1,   0,   0, 
      0,   0,   0,   0,  48,   0, 
      0,   0,   2,   0,   0,   0, 
     28,   1,   0,   0,   0,   0, 
      0,   0,  44,   1,   0,   0, 
     48,   0,   0,   0,  48,   0, 
      0,   0,   0,   0,   0,   0, 
     60,   1,   0,   0,   0,   0, 
      0,   0,  76,   1,   0,   0, 
     96,   0,   0,   0,  48,   0, 
      0,   0,   2,   0,   0,   0, 
     88,   1,   0,   0,   0,   0, 
      0,   0, 104,   1,   0,   0, 
    144,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    116,   1,   0,   0,   0,   0, 
      0,   0,  66, 108, 117, 114, 
     79, 102, 102, 115, 101, 116, 
    115,  72,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  66, 108, 
    117, 114,  79, 102, 102, 115, 
    101, 116, 115,  86,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     66, 108, 117, 114,  87, 101, 
    105, 103, 104, 116, 115,   0, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  83, 104, 
     97, 100, 111, 119,  67, 111, 
    108, 111, 114,   0,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0, 171, 171, 
     73,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   3,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  79,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  83,  86,  95,  84, 
     97, 114, 103, 101, 116,   0, 
    171, 171,  78, 204,   0,   0, 
      0,   0,   0,   0,  80,  49, 
      0,   4,   0,   0,   0,   1, 
      0,   0,   0,   0,   0, 128, 
     63,   1,   0,   0,   0,   0, 
      0, 128,  63,   1,   0,   0, 
      0,   0,   0, 128,  63,   1, 
      0,   0,   0,   0,   0, 128, 
     63,   1,   0,   0,   0,   3, 
      0,   0,   0, 255, 255, 255, 
    255,  68,   4,   0,   0,  68, 
     88,  66,  67,  77,  85, 167, 
    240,  56,  56, 155,  78, 125, 
     96,  49, 253, 103, 100,  22, 
     62,   1,   0,   0,   0,  68, 
      4,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 248, 
      0,   0,   0, 244,   1,   0, 
      0, 112,   2,   0,   0, 160, 
      3,   0,   0, 212,   3,   0, 
      0,  65, 111, 110,  57, 184, 
      0,   0,   0, 184,   0,   0, 
      0,   0,   2, 254, 255, 132, 
      0,   0,   0,  52,   0,   0, 
      0,   1,   0,  36,   0,   0, 
      0,  48,   0,   0,   0,  48, 
      0,   0,   0,  36,   0,   1, 
      0,  48,   0,   0,   0,   0, 
      0,   3,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   2, 254, 255,  81, 
      0,   0,   5,   4,   0,  15, 
    160,   0,   0,   0,   0,   0, 
      0, 128,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,  31, 
      0,   0,   2,   5,   0,   0, 
    128,   0,   0,  15, 144,   4, 
      0,   0,   4,   0,   0,   3, 
    224,   0,   0, 228, 144,   2, 
      0, 238, 160,   2,   0, 228, 
    160,   4,   0,   0,   4,   0, 
      0,  12, 224,   0,   0,  20, 
    144,   3,   0, 180, 160,   3, 
      0,  20, 160,   4,   0,   0, 
      4,   0,   0,   3, 128,   0, 
      0, 228, 144,   1,   0, 238, 
    160,   1,   0, 228, 160,   2, 
      0,   0,   3,   0,   0,   3, 
    192,   0,   0, 228, 128,   0, 
      0, 228, 160,   1,   0,   0, 
      2,   0,   0,  12, 192,   4, 
      0,  68, 160, 255, 255,   0, 
      0,  83,  72,  68,  82, 244, 
      0,   0,   0,  64,   0,   1, 
      0,  61,   0,   0,   0,  89, 
      0,   0,   4,  70, 142,  32, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,  95,   0,   0, 
      3,  50,  16,  16,   0,   0, 
      0,   0,   0, 103,   0,   0, 
      4, 242,  32,  16,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0, 101,   0,   0,   3,  50, 
     32,  16,   0,   1,   0,   0, 
      0, 101,   0,   0,   3, 194, 
     32,  16,   0,   1,   0,   0, 
      0,  50,   0,   0,  11,  50, 
     32,  16,   0,   0,   0,   0, 
      0,  70,  16,  16,   0,   0, 
      0,   0,   0, 230, 138,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  70, 128,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  54,   0,   0, 
      8, 194,  32,  16,   0,   0, 
      0,   0,   0,   2,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 128,  63,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   1,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,  50,   0,   0,  11, 194, 
     32,  16,   0,   1,   0,   0, 
      0,   6,  20,  16,   0,   0, 
      0,   0,   0, 166, 142,  32, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,   6, 132,  32, 
      0,   0,   0,   0,   0,   2, 
      0,   0,   0,  62,   0,   0, 
      1,  83,  84,  65,  84, 116, 
      0,   0,   0,   5,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,  82, 
     68,  69,  70,  40,   1,   0, 
      0,   1,   0,   0,   0,  64, 
      0,   0,   0,   1,   0,   0, 
      0,  28,   0,   0,   0,   0, 
      4, 254, 255,   0,   1,   0, 
      0, 246,   0,   0,   0,  60, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,  99,  98,  48,   0,  60, 
      0,   0,   0,   4,   0,   0, 
      0,  88,   0,   0,   0,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0, 184, 
      0,   0,   0,   0,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0, 196,   0,   0, 
      0,   0,   0,   0,   0, 212, 
      0,   0,   0,  16,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0, 196,   0,   0, 
      0,   0,   0,   0,   0, 222, 
      0,   0,   0,  32,   0,   0, 
      0,  16,   0,   0,   0,   2, 
      0,   0,   0, 196,   0,   0, 
      0,   0,   0,   0,   0, 236, 
      0,   0,   0,  48,   0,   0, 
      0,  16,   0,   0,   0,   0, 
      0,   0,   0, 196,   0,   0, 
      0,   0,   0,   0,   0,  81, 
    117,  97, 100,  68, 101, 115, 
     99,   0, 171, 171, 171,   1, 
      0,   3,   0,   1,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  77,  97, 115, 107,  84, 
    101, 120,  67, 111, 111, 114, 
    100, 115,   0,  84, 101, 120, 
    116,  67, 111, 108, 111, 114, 
      0,  77, 105,  99, 114, 111, 
    115, 111, 102, 116,  32,  40, 
     82,  41,  32,  72,  76,  83, 
     76,  32,  83, 104,  97, 100, 
    101, 114,  32,  67, 111, 109, 
    112, 105, 108, 101, 114,  32, 
     54,  46,  51,  46,  57,  54, 
     48,  48,  46,  49,  54,  51, 
     56,  52,   0,  73,  83,  71, 
     78,  44,   0,   0,   0,   1, 
      0,   0,   0,   8,   0,   0, 
      0,  32,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   7,   3,   0, 
      0,  80,  79,  83,  73,  84, 
     73,  79,  78,   0, 171, 171, 
    171,  79,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,  12,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   3,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171, 117, 
    214,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   2, 
      0,   0,   0,   0,   0,   0, 
      0, 172,   9,   0,   0,  68, 
     88,  66,  67,  67,  47,   1, 
    244,   0, 102, 246,  41,  38, 
    220,  84, 204, 156, 139,  96, 
     25,   1,   0,   0,   0, 172, 
      9,   0,   0,   6,   0,   0, 
      0,  56,   0,   0,   0, 220, 
      2,   0,   0, 204,   6,   0, 
      0,  72,   7,   0,   0,   8, 
      9,   0,   0, 120,   9,   0, 
      0,  65, 111, 110,  57, 156, 
      2,   0,   0, 156,   2,   0, 
      0,   0,   2, 255, 255, 104, 
      2,   0,   0,  52,   0,   0, 
      0,   1,   0,  40,   0,   0, 
      0,  52,   0,   0,   0,  52, 
      0,   1,   0,  36,   0,   0, 
      0,  52,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   6, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   2, 255, 255,  31, 
      0,   0,   2,   0,   0,   0, 
    128,   0,   0,  15, 176,  31, 
      0,   0,   2,   0,   0,   0, 
    144,   0,   8,  15, 160,   2, 
      0,   0,   3,   0,   0,   2, 
    128,   0,   0,  85, 176,   0, 
      0,  85, 160,   1,   0,   0, 
      2,   0,   0,   1, 128,   0, 
      0,   0, 176,   2,   0,   0, 
      3,   1,   0,   2, 128,   0, 
      0,  85, 176,   0,   0,   0, 
    160,   1,   0,   0,   2,   1, 
      0,   1, 128,   0,   0,   0, 
    176,  66,   0,   0,   3,   0, 
      0,  15, 128,   0,   0, 228, 
    128,   0,   8, 228, 160,  66, 
      0,   0,   3,   1,   0,  15, 
    128,   1,   0, 228, 128,   0, 
      8, 228, 160,   5,   0,   0, 
      3,   0,   0,  15, 128,   0, 
      0, 228, 128,   3,   0,  85, 
    160,   4,   0,   0,   4,   0, 
      0,  15, 128,   3,   0,   0, 
    160,   1,   0, 228, 128,   0, 
      0, 228, 128,   2,   0,   0, 
      3,   1,   0,   2, 128,   0, 
      0,  85, 176,   0,   0, 170, 
    160,   1,   0,   0,   2,   1, 
      0,   1, 128,   0,   0,   0, 
    176,   2,   0,   0,   3,   2, 
      0,   2, 128,   0,   0,  85, 
    176,   0,   0, 255, 160,   1, 
      0,   0,   2,   2,   0,   1, 
    128,   0,   0,   0, 176,  66, 
      0,   0,   3,   1,   0,  15, 
    128,   1,   0, 228, 128,   0, 
      8, 228, 160,  66,   0,   0, 
      3,   2,   0,  15, 128,   2, 
      0, 228, 128,   0,   8, 228, 
    160,   4,   0,   0,   4,   0, 
      0,  15, 128,   3,   0, 170, 
    160,   1,   0, 228, 128,   0, 
      0, 228, 128,   4,   0,   0, 
      4,   0,   0,  15, 128,   3, 
      0, 255, 160,   2,   0, 228, 
    128,   0,   0, 228, 128,   2, 
      0,   0,   3,   1,   0,   2, 
    128,   0,   0,  85, 176,   1, 
      0,   0, 160,   1,   0,   0, 
      2,   1,   0,   1, 128,   0, 
      0,   0, 176,   2,   0,   0, 
      3,   2,   0,   2, 128,   0, 
      0,  85, 176,   1,   0,  85, 
    160,   1,   0,   0,   2,   2, 
      0,   1, 128,   0,   0,   0, 
    176,  66,   0,   0,   3,   1, 
      0,  15, 128,   1,   0, 228, 
    128,   0,   8, 228, 160,  66, 
      0,   0,   3,   2,   0,  15, 
    128,   2,   0, 228, 128,   0, 
      8, 228, 160,   4,   0,   0, 
      4,   0,   0,  15, 128,   4, 
      0,   0, 160,   1,   0, 228, 
    128,   0,   0, 228, 128,   4, 
      0,   0,   4,   0,   0,  15, 
    128,   4,   0,  85, 160,   2, 
      0, 228, 128,   0,   0, 228, 
    128,   2,   0,   0,   3,   1, 
      0,   2, 128,   0,   0,  85, 
    176,   1,   0, 170, 160,   1, 
      0,   0,   2,   1,   0,   1, 
    128,   0,   0,   0, 176,   2, 
      0,   0,   3,   2,   0,   2, 
    128,   0,   0,  85, 176,   1, 
      0, 255, 160,   1,   0,   0, 
      2,   2,   0,   1, 128,   0, 
      0,   0, 176,  66,   0,   0, 
      3,   1,   0,  15, 128,   1, 
      0, 228, 128,   0,   8, 228, 
    160,  66,   0,   0,   3,   2, 
      0,  15, 128,   2,   0, 228, 
    128,   0,   8, 228, 160,   4, 
      0,   0,   4,   0,   0,  15, 
    128,   4,   0, 170, 160,   1, 
      0, 228, 128,   0,   0, 228, 
    128,   4,   0,   0,   4,   0, 
      0,  15, 128,   4,   0, 255, 
    160,   2,   0, 228, 128,   0, 
      0, 228, 128,   2,   0,   0, 
      3,   1,   0,   2, 128,   0, 
      0,  85, 176,   2,   0,   0, 
    160,   1,   0,   0,   2,   1, 
      0,   1, 128,   0,   0,   0, 
    176,  66,   0,   0,   3,   1, 
      0,  15, 128,   1,   0, 228, 
    128,   0,   8, 228, 160,   4, 
      0,   0,   4,   0,   0,  15, 
    128,   5,   0,   0, 160,   1, 
      0, 228, 128,   0,   0, 228, 
    128,   1,   0,   0,   2,   0, 
      8,  15, 128,   0,   0, 228, 
    128, 255, 255,   0,   0,  83, 
     72,  68,  82, 232,   3,   0, 
      0,  64,   0,   0,   0, 250, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   9,   0,   0, 
      0,  90,   0,   0,   3,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  88,  24,   0,   4,   0, 
    112,  16,   0,   0,   0,   0, 
      0,  85,  85,   0,   0,  98, 
     16,   0,   3,  50,  16,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 242,  32,  16, 
      0,   0,   0,   0,   0, 104, 
      0,   0,   2,   4,   0,   0, 
      0,  54,   0,   0,   5,  82, 
      0,  16,   0,   0,   0,   0, 
      0,   6,  16,  16,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      8, 242,   0,  16,   0,   1, 
      0,   0,   0,  86,  21,  16, 
      0,   1,   0,   0,   0, 134, 
    141,  32,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,  54, 
      0,   0,   5, 162,   0,  16, 
      0,   0,   0,   0,   0,   6, 
      8,  16,   0,   1,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   2,   0,   0, 
      0, 230,  10,  16,   0,   0, 
      0,   0,   0,  70, 126,  16, 
      0,   0,   0,   0,   0,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  69,   0,   0,   9, 242, 
      0,  16,   0,   0,   0,   0, 
      0,  70,   0,  16,   0,   0, 
      0,   0,   0,  70, 126,  16, 
      0,   0,   0,   0,   0,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  56,   0,   0,   8, 242, 
      0,  16,   0,   2,   0,   0, 
      0,  70,  14,  16,   0,   2, 
      0,   0,   0,  86, 133,  32, 
      0,   0,   0,   0,   0,   6, 
      0,   0,   0,  50,   0,   0, 
     10, 242,   0,  16,   0,   0, 
      0,   0,   0,   6, 128,  32, 
      0,   0,   0,   0,   0,   6, 
      0,   0,   0,  70,  14,  16, 
      0,   0,   0,   0,   0,  70, 
     14,  16,   0,   2,   0,   0, 
      0,  54,   0,   0,   5,  82, 
      0,  16,   0,   1,   0,   0, 
      0,   6,  16,  16,   0,   1, 
      0,   0,   0,  69,   0,   0, 
      9, 242,   0,  16,   0,   2, 
      0,   0,   0,  70,   0,  16, 
      0,   1,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  69,   0,   0, 
      9, 242,   0,  16,   0,   1, 
      0,   0,   0, 230,  10,  16, 
      0,   1,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
     10, 242,   0,  16,   0,   0, 
      0,   0,   0, 166, 138,  32, 
      0,   0,   0,   0,   0,   6, 
      0,   0,   0,  70,  14,  16, 
      0,   2,   0,   0,   0,  70, 
     14,  16,   0,   0,   0,   0, 
      0,  50,   0,   0,  10, 242, 
      0,  16,   0,   0,   0,   0, 
      0, 246, 143,  32,   0,   0, 
      0,   0,   0,   6,   0,   0, 
      0,  70,  14,  16,   0,   1, 
      0,   0,   0,  70,  14,  16, 
      0,   0,   0,   0,   0,  54, 
      0,   0,   5,  82,   0,  16, 
      0,   1,   0,   0,   0,   6, 
     16,  16,   0,   1,   0,   0, 
      0,   0,   0,   0,   8, 242, 
      0,  16,   0,   2,   0,   0, 
      0,  86,  21,  16,   0,   1, 
      0,   0,   0, 134, 141,  32, 
      0,   0,   0,   0,   0,   4, 
      0,   0,   0,  54,   0,   0, 
      5, 162,   0,  16,   0,   1, 
      0,   0,   0,   6,   8,  16, 
      0,   2,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   3,   0,   0,   0,  70, 
      0,  16,   0,   1,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  69, 
      0,   0,   9, 242,   0,  16, 
      0,   1,   0,   0,   0, 230, 
     10,  16,   0,   1,   0,   0, 
      0,  70, 126,  16,   0,   0, 
      0,   0,   0,   0,  96,  16, 
      0,   0,   0,   0,   0,  50, 
      0,   0,  10, 242,   0,  16, 
      0,   0,   0,   0,   0,   6, 
    128,  32,   0,   0,   0,   0, 
      0,   7,   0,   0,   0,  70, 
     14,  16,   0,   3,   0,   0, 
      0,  70,  14,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
     10, 242,   0,  16,   0,   0, 
      0,   0,   0,  86, 133,  32, 
      0,   0,   0,   0,   0,   7, 
      0,   0,   0,  70,  14,  16, 
      0,   1,   0,   0,   0,  70, 
     14,  16,   0,   0,   0,   0, 
      0,  54,   0,   0,   5,  82, 
      0,  16,   0,   2,   0,   0, 
      0,   6,  16,  16,   0,   1, 
      0,   0,   0,  69,   0,   0, 
      9, 242,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   2,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  69,   0,   0, 
      9, 242,   0,  16,   0,   2, 
      0,   0,   0, 230,  10,  16, 
      0,   2,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
     10, 242,   0,  16,   0,   0, 
      0,   0,   0, 166, 138,  32, 
      0,   0,   0,   0,   0,   7, 
      0,   0,   0,  70,  14,  16, 
      0,   1,   0,   0,   0,  70, 
     14,  16,   0,   0,   0,   0, 
      0,  50,   0,   0,  10, 242, 
      0,  16,   0,   0,   0,   0, 
      0, 246, 143,  32,   0,   0, 
      0,   0,   0,   7,   0,   0, 
      0,  70,  14,  16,   0,   2, 
      0,   0,   0,  70,  14,  16, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   8,  34,   0,  16, 
      0,   1,   0,   0,   0,  26, 
     16,  16,   0,   1,   0,   0, 
      0,  10, 128,  32,   0,   0, 
      0,   0,   0,   5,   0,   0, 
      0,  54,   0,   0,   5,  18, 
      0,  16,   0,   1,   0,   0, 
      0,  10,  16,  16,   0,   1, 
      0,   0,   0,  69,   0,   0, 
      9, 242,   0,  16,   0,   1, 
      0,   0,   0,  70,   0,  16, 
      0,   1,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  50,   0,   0, 
     10, 242,  32,  16,   0,   0, 
      0,   0,   0,   6, 128,  32, 
      0,   0,   0,   0,   0,   8, 
      0,   0,   0,  70,  14,  16, 
      0,   1,   0,   0,   0,  70, 
     14,  16,   0,   0,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,  29,   0,   0,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,   2,   0,   0,   0,  12, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   9,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   7, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70, 184,   1,   0,   0,   1, 
      0,   0,   0, 148,   0,   0, 
      0,   3,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 255, 
    255,   0,   1,   0,   0, 132, 
      1,   0,   0, 124,   0,   0, 
      0,   3,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0, 139, 
      0,   0,   0,   2,   0,   0, 
      0,   5,   0,   0,   0,   4, 
      0,   0,   0, 255, 255, 255, 
    255,   0,   0,   0,   0,   1, 
      0,   0,   0,  12,   0,   0, 
      0, 143,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 115,  83, 104, 
     97, 100, 111, 119,  83,  97, 
    109, 112, 108, 101, 114,   0, 
    116, 101, 120,   0,  99,  98, 
     49,   0, 171, 143,   0,   0, 
      0,   4,   0,   0,   0, 172, 
      0,   0,   0, 160,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  12,   1,   0, 
      0,   0,   0,   0,   0,  48, 
      0,   0,   0,   0,   0,   0, 
      0,  28,   1,   0,   0,   0, 
      0,   0,   0,  44,   1,   0, 
      0,  48,   0,   0,   0,  48, 
      0,   0,   0,   2,   0,   0, 
      0,  60,   1,   0,   0,   0, 
      0,   0,   0,  76,   1,   0, 
      0,  96,   0,   0,   0,  48, 
      0,   0,   0,   2,   0,   0, 
      0,  88,   1,   0,   0,   0, 
      0,   0,   0, 104,   1,   0, 
      0, 144,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0, 116,   1,   0,   0,   0, 
      0,   0,   0,  66, 108, 117, 
    114,  79, 102, 102, 115, 101, 
    116, 115,  72,   0, 171, 171, 
    171,   1,   0,   3,   0,   1, 
      0,   4,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  66, 
    108, 117, 114,  79, 102, 102, 
    115, 101, 116, 115,  86,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  66, 108, 117, 114,  87, 
    101, 105, 103, 104, 116, 115, 
      0,   1,   0,   3,   0,   1, 
      0,   4,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  83, 
    104,  97, 100, 111, 119,  67, 
    111, 108, 111, 114,   0,   1, 
      0,   3,   0,   1,   0,   4, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  77, 105,  99, 
    114, 111, 115, 111, 102, 116, 
     32,  40,  82,  41,  32,  72, 
     76,  83,  76,  32,  83, 104, 
     97, 100, 101, 114,  32,  67, 
    111, 109, 112, 105, 108, 101, 
    114,  32,  54,  46,  51,  46, 
     57,  54,  48,  48,  46,  49, 
     54,  51,  56,  52,   0, 171, 
    171,  73,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   3,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   0,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,  79, 
     83,  71,  78,  44,   0,   0, 
      0,   1,   0,   0,   0,   8, 
      0,   0,   0,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  83,  86,  95, 
     84,  97, 114, 103, 101, 116, 
      0, 171, 171, 209, 218,   0, 
      0,   0,   0,   0,   0,  80, 
     50,   0,   4,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
    128,  63,   1,   0,   0,   0, 
      0,   0, 128,  63,   1,   0, 
      0,   0,   0,   0, 128,  63, 
      1,   0,   0,   0,   0,   0, 
    128,  63,   1,   0,   0,   0, 
      3,   0,   0,   0, 255, 255, 
    255, 255,  68,   4,   0,   0, 
     68,  88,  66,  67,  77,  85, 
    167, 240,  56,  56, 155,  78, 
    125,  96,  49, 253, 103, 100, 
     22,  62,   1,   0,   0,   0, 
     68,   4,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
    248,   0,   0,   0, 244,   1, 
      0,   0, 112,   2,   0,   0, 
    160,   3,   0,   0, 212,   3, 
      0,   0,  65, 111, 110,  57, 
    184,   0,   0,   0, 184,   0, 
      0,   0,   0,   2, 254, 255, 
    132,   0,   0,   0,  52,   0, 
      0,   0,   1,   0,  36,   0, 
      0,   0,  48,   0,   0,   0, 
     48,   0,   0,   0,  36,   0, 
      1,   0,  48,   0,   0,   0, 
      0,   0,   3,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   2, 254, 255, 
     81,   0,   0,   5,   4,   0, 
     15, 160,   0,   0,   0,   0, 
      0,   0, 128,  63,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     31,   0,   0,   2,   5,   0, 
      0, 128,   0,   0,  15, 144, 
      4,   0,   0,   4,   0,   0, 
      3, 224,   0,   0, 228, 144, 
      2,   0, 238, 160,   2,   0, 
    228, 160,   4,   0,   0,   4, 
      0,   0,  12, 224,   0,   0, 
     20, 144,   3,   0, 180, 160, 
      3,   0,  20, 160,   4,   0, 
      0,   4,   0,   0,   3, 128, 
      0,   0, 228, 144,   1,   0, 
    238, 160,   1,   0, 228, 160, 
      2,   0,   0,   3,   0,   0, 
      3, 192,   0,   0, 228, 128, 
      0,   0, 228, 160,   1,   0, 
      0,   2,   0,   0,  12, 192, 
      4,   0,  68, 160, 255, 255, 
      0,   0,  83,  72,  68,  82, 
    244,   0,   0,   0,  64,   0, 
      1,   0,  61,   0,   0,   0, 
     89,   0,   0,   4,  70, 142, 
     32,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  95,   0, 
      0,   3,  50,  16,  16,   0, 
      0,   0,   0,   0, 103,   0, 
      0,   4, 242,  32,  16,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
     50,  32,  16,   0,   1,   0, 
      0,   0, 101,   0,   0,   3, 
    194,  32,  16,   0,   1,   0, 
      0,   0,  50,   0,   0,  11, 
     50,  32,  16,   0,   0,   0, 
      0,   0,  70,  16,  16,   0, 
      0,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  70, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   8, 194,  32,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 128,  63, 
     50,   0,   0,  11,  50,  32, 
     16,   0,   1,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  50,   0,   0,  11, 
    194,  32,  16,   0,   1,   0, 
      0,   0,   6,  20,  16,   0, 
      0,   0,   0,   0, 166, 142, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   6, 132, 
     32,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,   5,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70,  40,   1, 
      0,   0,   1,   0,   0,   0, 
     64,   0,   0,   0,   1,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 254, 255,   0,   1, 
      0,   0, 246,   0,   0,   0, 
     60,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,  99,  98,  48,   0, 
     60,   0,   0,   0,   4,   0, 
      0,   0,  88,   0,   0,   0, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    184,   0,   0,   0,   0,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    212,   0,   0,   0,  16,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    222,   0,   0,   0,  32,   0, 
      0,   0,  16,   0,   0,   0, 
      2,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
    236,   0,   0,   0,  48,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0, 196,   0, 
      0,   0,   0,   0,   0,   0, 
     81, 117,  97, 100,  68, 101, 
    115,  99,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  77,  97, 115, 107, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  84, 101, 
    120, 116,  67, 111, 108, 111, 
    114,   0,  77, 105,  99, 114, 
    111, 115, 111, 102, 116,  32, 
     40,  82,  41,  32,  72,  76, 
     83,  76,  32,  83, 104,  97, 
    100, 101, 114,  32,  67, 111, 
    109, 112, 105, 108, 101, 114, 
     32,  54,  46,  51,  46,  57, 
     54,  48,  48,  46,  49,  54, 
     51,  56,  52,   0,  73,  83, 
     71,  78,  44,   0,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   7,   3, 
      0,   0,  80,  79,  83,  73, 
     84,  73,  79,  78,   0, 171, 
    171, 171,  79,  83,  71,  78, 
    104,   0,   0,   0,   3,   0, 
      0,   0,   8,   0,   0,   0, 
     80,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,   3,  12,   0,   0, 
     92,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  12,   3,   0,   0, 
     83,  86,  95,  80, 111, 115, 
    105, 116, 105, 111, 110,   0, 
     84,  69,  88,  67,  79,  79, 
     82,  68,   0, 171, 171, 171, 
    188, 228,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0, 164,  10,   0,   0, 
     68,  88,  66,  67,  70, 166, 
    174, 156, 153, 145, 163, 116, 
    127,  37, 205, 162, 136, 116, 
     62, 222,   1,   0,   0,   0, 
    164,  10,   0,   0,   6,   0, 
      0,   0,  56,   0,   0,   0, 
     24,   3,   0,   0, 112,   7, 
      0,   0, 236,   7,   0,   0, 
      0,  10,   0,   0, 112,  10, 
      0,   0,  65, 111, 110,  57, 
    216,   2,   0,   0, 216,   2, 
      0,   0,   0,   2, 255, 255, 
    160,   2,   0,   0,  56,   0, 
      0,   0,   1,   0,  44,   0, 
      0,   0,  56,   0,   0,   0, 
     56,   0,   2,   0,  36,   0, 
      0,   0,  56,   0,   1,   0, 
      0,   0,   0,   1,   1,   0, 
      0,   0,   3,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   2, 255, 255,  31,   0, 
      0,   2,   0,   0,   0, 128, 
      0,   0,  15, 176,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      0,   8,  15, 160,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      1,   8,  15, 160,   2,   0, 
      0,   3,   0,   0,   2, 128, 
      0,   0,  85, 176,   0,   0, 
     85, 160,   1,   0,   0,   2, 
      0,   0,   1, 128,   0,   0, 
      0, 176,   2,   0,   0,   3, 
      1,   0,   2, 128,   0,   0, 
     85, 176,   0,   0,   0, 160, 
      1,   0,   0,   2,   1,   0, 
      1, 128,   0,   0,   0, 176, 
     66,   0,   0,   3,   0,   0, 
     15, 128,   0,   0, 228, 128, 
      1,   8, 228, 160,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      1,   0, 228, 128,   1,   8, 
    228, 160,   5,   0,   0,   3, 
      0,   0,  15, 128,   0,   0, 
    228, 128,   3,   0,  85, 160, 
      4,   0,   0,   4,   0,   0, 
     15, 128,   3,   0,   0, 160, 
      1,   0, 228, 128,   0,   0, 
    228, 128,   2,   0,   0,   3, 
      1,   0,   2, 128,   0,   0, 
     85, 176,   0,   0, 170, 160, 
      1,   0,   0,   2,   1,   0, 
      1, 128,   0,   0,   0, 176, 
      2,   0,   0,   3,   2,   0, 
      2, 128,   0,   0,  85, 176, 
      0,   0, 255, 160,   1,   0, 
      0,   2,   2,   0,   1, 128, 
      0,   0,   0, 176,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      1,   0, 228, 128,   1,   8, 
    228, 160,  66,   0,   0,   3, 
      2,   0,  15, 128,   2,   0, 
    228, 128,   1,   8, 228, 160, 
      4,   0,   0,   4,   0,   0, 
     15, 128,   3,   0, 170, 160, 
      1,   0, 228, 128,   0,   0, 
    228, 128,   4,   0,   0,   4, 
      0,   0,  15, 128,   3,   0, 
    255, 160,   2,   0, 228, 128, 
      0,   0, 228, 128,   2,   0, 
      0,   3,   1,   0,   2, 128, 
      0,   0,  85, 176,   1,   0, 
      0, 160,   1,   0,   0,   2, 
      1,   0,   1, 128,   0,   0, 
      0, 176,   2,   0,   0,   3, 
      2,   0,   2, 128,   0,   0, 
     85, 176,   1,   0,  85, 160, 
      1,   0,   0,   2,   2,   0, 
      1, 128,   0,   0,   0, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 228, 128, 
      1,   8, 228, 160,  66,   0, 
      0,   3,   2,   0,  15, 128, 
      2,   0, 228, 128,   1,   8, 
    228, 160,   4,   0,   0,   4, 
      0,   0,  15, 128,   4,   0, 
      0, 160,   1,   0, 228, 128, 
      0,   0, 228, 128,   4,   0, 
      0,   4,   0,   0,  15, 128, 
      4,   0,  85, 160,   2,   0, 
    228, 128,   0,   0, 228, 128, 
      2,   0,   0,   3,   1,   0, 
      2, 128,   0,   0,  85, 176, 
      1,   0, 170, 160,   1,   0, 
      0,   2,   1,   0,   1, 128, 
      0,   0,   0, 176,   2,   0, 
      0,   3,   2,   0,   2, 128, 
      0,   0,  85, 176,   1,   0, 
    255, 160,   1,   0,   0,   2, 
      2,   0,   1, 128,   0,   0, 
      0, 176,  66,   0,   0,   3, 
      1,   0,  15, 128,   1,   0, 
    228, 128,   1,   8, 228, 160, 
     66,   0,   0,   3,   2,   0, 
     15, 128,   2,   0, 228, 128, 
      1,   8, 228, 160,   4,   0, 
      0,   4,   0,   0,  15, 128, 
      4,   0, 170, 160,   1,   0, 
    228, 128,   0,   0, 228, 128, 
      4,   0,   0,   4,   0,   0, 
     15, 128,   4,   0, 255, 160, 
      2,   0, 228, 128,   0,   0, 
    228, 128,   2,   0,   0,   3, 
      1,   0,   2, 128,   0,   0, 
     85, 176,   2,   0,   0, 160, 
      1,   0,   0,   2,   1,   0, 
      1, 128,   0,   0,   0, 176, 
      1,   0,   0,   2,   2,   0, 
      3, 128,   0,   0, 235, 176, 
     66,   0,   0,   3,   1,   0, 
     15, 128,   1,   0, 228, 128, 
      1,   8, 228, 160,  66,   0, 
      0,   3,   2,   0,  15, 128, 
      2,   0, 228, 128,   0,   8, 
    228, 160,   4,   0,   0,   4, 
      0,   0,  15, 128,   5,   0, 
      0, 160,   1,   0, 228, 128, 
      0,   0, 228, 128,   5,   0, 
      0,   3,   0,   0,  15, 128, 
      2,   0, 255, 128,   0,   0, 
    228, 128,   1,   0,   0,   2, 
      0,   8,  15, 128,   0,   0, 
    228, 128, 255, 255,   0,   0, 
     83,  72,  68,  82,  80,   4, 
      0,   0,  64,   0,   0,   0, 
     20,   1,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   9,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0,  98,  16, 
      0,   3, 194,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 104,   0, 
      0,   2,   4,   0,   0,   0, 
     54,   0,   0,   5,  82,   0, 
     16,   0,   0,   0,   0,   0, 
      6,  16,  16,   0,   1,   0, 
      0,   0,   0,   0,   0,   8, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  86,  21,  16,   0, 
      1,   0,   0,   0, 134, 141, 
     32,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  54,   0, 
      0,   5, 162,   0,  16,   0, 
      0,   0,   0,   0,   6,   8, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   2,   0,   0,   0, 
    230,  10,  16,   0,   0,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   1,   0,   0,   0, 
     56,   0,   0,   8, 242,   0, 
     16,   0,   2,   0,   0,   0, 
     70,  14,  16,   0,   2,   0, 
      0,   0,  86, 133,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  50,   0,   0,  10, 
    242,   0,  16,   0,   0,   0, 
      0,   0,   6, 128,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   2,   0,   0,   0, 
     54,   0,   0,   5,  82,   0, 
     16,   0,   1,   0,   0,   0, 
      6,  16,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   2,   0, 
      0,   0,  70,   0,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0, 230,  10,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  50,   0,   0,  10, 
    242,   0,  16,   0,   0,   0, 
      0,   0, 166, 138,  32,   0, 
      0,   0,   0,   0,   6,   0, 
      0,   0,  70,  14,  16,   0, 
      2,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  10, 242,   0, 
     16,   0,   0,   0,   0,   0, 
    246, 143,  32,   0,   0,   0, 
      0,   0,   6,   0,   0,   0, 
     70,  14,  16,   0,   1,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,  54,   0, 
      0,   5,  82,   0,  16,   0, 
      1,   0,   0,   0,   6,  16, 
     16,   0,   1,   0,   0,   0, 
      0,   0,   0,   8, 242,   0, 
     16,   0,   2,   0,   0,   0, 
     86,  21,  16,   0,   1,   0, 
      0,   0, 134, 141,  32,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  54,   0,   0,   5, 
    162,   0,  16,   0,   1,   0, 
      0,   0,   6,   8,  16,   0, 
      2,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      3,   0,   0,   0,  70,   0, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      1,   0,   0,   0, 230,  10, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   0,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  50,   0, 
      0,  10, 242,   0,  16,   0, 
      0,   0,   0,   0,   6, 128, 
     32,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,  70,  14, 
     16,   0,   3,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  86, 133,  32,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  70,  14,  16,   0, 
      1,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     54,   0,   0,   5,  82,   0, 
     16,   0,   2,   0,   0,   0, 
      6,  16,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  70,   0,  16,   0, 
      2,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   2,   0, 
      0,   0, 230,  10,  16,   0, 
      2,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  50,   0,   0,  10, 
    242,   0,  16,   0,   0,   0, 
      0,   0, 166, 138,  32,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  70,  14,  16,   0, 
      1,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     50,   0,   0,  10, 242,   0, 
     16,   0,   0,   0,   0,   0, 
    246, 143,  32,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     70,  14,  16,   0,   2,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   8,  34,   0,  16,   0, 
      1,   0,   0,   0,  26,  16, 
     16,   0,   1,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   5,   0,   0,   0, 
     54,   0,   0,   5,  18,   0, 
     16,   0,   1,   0,   0,   0, 
     10,  16,  16,   0,   1,   0, 
      0,   0,  69,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  70,   0,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  50,   0,   0,  10, 
    242,   0,  16,   0,   0,   0, 
      0,   0,   6, 128,  32,   0, 
      0,   0,   0,   0,   8,   0, 
      0,   0,  70,  14,  16,   0, 
      1,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     69,   0,   0,   9, 242,   0, 
     16,   0,   1,   0,   0,   0, 
    230,  26,  16,   0,   1,   0, 
      0,   0,  70, 126,  16,   0, 
      1,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,   7, 242,  32, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0, 246,  15,  16,   0, 
      1,   0,   0,   0,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    116,   0,   0,   0,  31,   0, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,  13,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     10,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     82,  68,  69,  70,  12,   2, 
      0,   0,   1,   0,   0,   0, 
    232,   0,   0,   0,   5,   0, 
      0,   0,  28,   0,   0,   0, 
      0,   4, 255, 255,   0,   1, 
      0,   0, 216,   1,   0,   0, 
    188,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 201,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 216,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    220,   0,   0,   0,   2,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   1,   0,   0,   0, 
      1,   0,   0,   0,  12,   0, 
      0,   0, 225,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 115,  77, 
     97, 115, 107,  83,  97, 109, 
    112, 108, 101, 114,   0, 115, 
     83, 104,  97, 100, 111, 119, 
     83,  97, 109, 112, 108, 101, 
    114,   0, 116, 101, 120,   0, 
    109,  97, 115, 107,   0,  99, 
     98,  49,   0, 171, 171, 171, 
    225,   0,   0,   0,   4,   0, 
      0,   0,   0,   1,   0,   0, 
    160,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     96,   1,   0,   0,   0,   0, 
      0,   0,  48,   0,   0,   0, 
      0,   0,   0,   0, 112,   1, 
      0,   0,   0,   0,   0,   0, 
    128,   1,   0,   0,  48,   0, 
      0,   0,  48,   0,   0,   0, 
      2,   0,   0,   0, 144,   1, 
      0,   0,   0,   0,   0,   0, 
    160,   1,   0,   0,  96,   0, 
      0,   0,  48,   0,   0,   0, 
      2,   0,   0,   0, 172,   1, 
      0,   0,   0,   0,   0,   0, 
    188,   1,   0,   0, 144,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0, 200,   1, 
      0,   0,   0,   0,   0,   0, 
     66, 108, 117, 114,  79, 102, 
    102, 115, 101, 116, 115,  72, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  66, 108, 117, 114, 
     79, 102, 102, 115, 101, 116, 
    115,  86,   0, 171, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      4,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  66, 108, 
    117, 114,  87, 101, 105, 103, 
    104, 116, 115,   0,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  83, 104,  97, 100, 
    111, 119,  67, 111, 108, 111, 
    114,   0,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     77, 105,  99, 114, 111, 115, 
    111, 102, 116,  32,  40,  82, 
     41,  32,  72,  76,  83,  76, 
     32,  83, 104,  97, 100, 101, 
    114,  32,  67, 111, 109, 112, 
    105, 108, 101, 114,  32,  54, 
     46,  51,  46,  57,  54,  48, 
     48,  46,  49,  54,  51,  56, 
     52,   0, 171, 171,  73,  83, 
     71,  78, 104,   0,   0,   0, 
      3,   0,   0,   0,   8,   0, 
      0,   0,  80,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  92,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,   3,   3, 
      0,   0,  92,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  12,  12, 
      0,   0,  83,  86,  95,  80, 
    111, 115, 105, 116, 105, 111, 
    110,   0,  84,  69,  88,  67, 
     79,  79,  82,  68,   0, 171, 
    171, 171,  79,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,  15,   0,   0,   0, 
     83,  86,  95,  84,  97, 114, 
    103, 101, 116,   0, 171, 171, 
     24, 233,   0,   0,   0,   0, 
      0,   0,  83,  97, 109, 112, 
    108, 101,  84, 101, 120, 116, 
     84, 101, 120, 116, 117, 114, 
    101,   0,  85, 110, 109,  97, 
    115, 107, 101, 100,   0,   4, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0, 255, 255, 255, 255,  68, 
      4,   0,   0,  68,  88,  66, 
     67,  77,  85, 167, 240,  56, 
     56, 155,  78, 125,  96,  49, 
    253, 103, 100,  22,  62,   1, 
      0,   0,   0,  68,   4,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0, 248,   0,   0, 
      0, 244,   1,   0,   0, 112, 
      2,   0,   0, 160,   3,   0, 
      0, 212,   3,   0,   0,  65, 
    111, 110,  57, 184,   0,   0, 
      0, 184,   0,   0,   0,   0, 
      2, 254, 255, 132,   0,   0, 
      0,  52,   0,   0,   0,   1, 
      0,  36,   0,   0,   0,  48, 
      0,   0,   0,  48,   0,   0, 
      0,  36,   0,   1,   0,  48, 
      0,   0,   0,   0,   0,   3, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 254, 255,  81,   0,   0, 
      5,   4,   0,  15, 160,   0, 
      0,   0,   0,   0,   0, 128, 
     63,   0,   0,   0,   0,   0, 
      0,   0,   0,  31,   0,   0, 
      2,   5,   0,   0, 128,   0, 
      0,  15, 144,   4,   0,   0, 
      4,   0,   0,   3, 224,   0, 
      0, 228, 144,   2,   0, 238, 
    160,   2,   0, 228, 160,   4, 
      0,   0,   4,   0,   0,  12, 
    224,   0,   0,  20, 144,   3, 
      0, 180, 160,   3,   0,  20, 
    160,   4,   0,   0,   4,   0, 
      0,   3, 128,   0,   0, 228, 
    144,   1,   0, 238, 160,   1, 
      0, 228, 160,   2,   0,   0, 
      3,   0,   0,   3, 192,   0, 
      0, 228, 128,   0,   0, 228, 
    160,   1,   0,   0,   2,   0, 
      0,  12, 192,   4,   0,  68, 
    160, 255, 255,   0,   0,  83, 
     72,  68,  82, 244,   0,   0, 
      0,  64,   0,   1,   0,  61, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  95,   0,   0,   3,  50, 
     16,  16,   0,   0,   0,   0, 
      0, 103,   0,   0,   4, 242, 
     32,  16,   0,   0,   0,   0, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3,  50,  32,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 194,  32,  16, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11,  50,  32,  16, 
      0,   0,   0,   0,   0,  70, 
     16,  16,   0,   0,   0,   0, 
      0, 230, 138,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  70, 128,  32,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  54,   0,   0,   8, 194, 
     32,  16,   0,   0,   0,   0, 
      0,   2,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0, 128,  63,  50,   0,   0, 
     11,  50,  32,  16,   0,   1, 
      0,   0,   0,  70,  16,  16, 
      0,   0,   0,   0,   0, 230, 
    138,  32,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,  70, 
    128,  32,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,  50, 
      0,   0,  11, 194,  32,  16, 
      0,   1,   0,   0,   0,   6, 
     20,  16,   0,   0,   0,   0, 
      0, 166, 142,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,   6, 132,  32,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,  62,   0,   0,   1,  83, 
     84,  65,  84, 116,   0,   0, 
      0,   5,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   4,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  82,  68,  69, 
     70,  40,   1,   0,   0,   1, 
      0,   0,   0,  64,   0,   0, 
      0,   1,   0,   0,   0,  28, 
      0,   0,   0,   0,   4, 254, 
    255,   0,   1,   0,   0, 246, 
      0,   0,   0,  60,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,  99, 
     98,  48,   0,  60,   0,   0, 
      0,   4,   0,   0,   0,  88, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0, 184,   0,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 212,   0,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 222,   0,   0, 
      0,  32,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0, 236,   0,   0, 
      0,  48,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      0,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  77, 
     97, 115, 107,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  84, 101, 120, 116,  67, 
    111, 108, 111, 114,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  54,  46, 
     51,  46,  57,  54,  48,  48, 
     46,  49,  54,  51,  56,  52, 
      0,  73,  83,  71,  78,  44, 
      0,   0,   0,   1,   0,   0, 
      0,   8,   0,   0,   0,  32, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   7,   3,   0,   0,  80, 
     79,  83,  73,  84,  73,  79, 
     78,   0, 171, 171, 171,  79, 
     83,  71,  78, 104,   0,   0, 
      0,   3,   0,   0,   0,   8, 
      0,   0,   0,  80,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  92,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,   3, 
     12,   0,   0,  92,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  12, 
      3,   0,   0,  83,  86,  95, 
     80, 111, 115, 105, 116, 105, 
    111, 110,   0,  84,  69,  88, 
     67,  79,  79,  82,  68,   0, 
    171, 171, 171,  19, 244,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   0,   0,   0, 152, 
      4,   0,   0,  68,  88,  66, 
     67, 227,  84,  48, 176, 142, 
    231, 109,  63,  97,  30,   1, 
     57, 105, 137, 178, 120,   1, 
      0,   0,   0, 152,   4,   0, 
      0,   6,   0,   0,   0,  56, 
      0,   0,   0,   4,   1,   0, 
      0, 224,   1,   0,   0,  92, 
      2,   0,   0, 220,   3,   0, 
      0,  76,   4,   0,   0,  65, 
    111, 110,  57, 196,   0,   0, 
      0, 196,   0,   0,   0,   0, 
      2, 255, 255, 144,   0,   0, 
      0,  52,   0,   0,   0,   1, 
      0,  40,   0,   0,   0,  52, 
      0,   0,   0,  52,   0,   1, 
      0,  36,   0,   0,   0,  52, 
      0,   0,   0,   0,   0,   0, 
      0,   3,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      2, 255, 255,  81,   0,   0, 
      5,   1,   0,  15, 160,   0, 
      0, 128,  63,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,  31,   0,   0, 
      2,   0,   0,   0, 128,   0, 
      0,  15, 176,  31,   0,   0, 
      2,   0,   0,   0, 144,   0, 
      8,  15, 160,   1,   0,   0, 
      2,   0,   0,   7, 128,   0, 
      0, 228, 160,   4,   0,   0, 
      4,   0,   0,  15, 128,   0, 
      0,  36, 128,   1,   0,  64, 
    160,   1,   0,  21, 160,   1, 
      0,   0,   2,   0,   8,  15, 
    128,   0,   0, 228, 128,  66, 
      0,   0,   3,   0,   0,  15, 
    128,   0,   0, 228, 176,   0, 
      8, 228, 160,   5,   0,   0, 
      3,   0,   0,  15, 128,   0, 
      0,  70, 128,   0,   0, 255, 
    160,   1,   0,   0,   2,   1, 
      8,  15, 128,   0,   0, 228, 
    128, 255, 255,   0,   0,  83, 
     72,  68,  82, 212,   0,   0, 
      0,  64,   0,   0,   0,  53, 
      0,   0,   0,  89,   0,   0, 
      4,  70, 142,  32,   0,   0, 
      0,   0,   0,   4,   0,   0, 
      0,  90,   0,   0,   3,   0, 
     96,  16,   0,   0,   0,   0, 
      0,  88,  24,   0,   4,   0, 
    112,  16,   0,   0,   0,   0, 
      0,  85,  85,   0,   0,  98, 
     16,   0,   3,  50,  16,  16, 
      0,   1,   0,   0,   0, 101, 
      0,   0,   3, 242,  32,  16, 
      0,   0,   0,   0,   0, 101, 
      0,   0,   3, 242,  32,  16, 
      0,   1,   0,   0,   0, 104, 
      0,   0,   2,   1,   0,   0, 
      0,  54,   0,   0,   6, 114, 
     32,  16,   0,   0,   0,   0, 
      0,  70, 130,  32,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,  54,   0,   0,   5, 130, 
     32,  16,   0,   0,   0,   0, 
      0,   1,  64,   0,   0,   0, 
      0, 128,  63,  69,   0,   0, 
      9, 242,   0,  16,   0,   0, 
      0,   0,   0,  70,  16,  16, 
      0,   1,   0,   0,   0,  70, 
    126,  16,   0,   0,   0,   0, 
      0,   0,  96,  16,   0,   0, 
      0,   0,   0,  56,   0,   0, 
      8, 242,  32,  16,   0,   1, 
      0,   0,   0, 102,   4,  16, 
      0,   0,   0,   0,   0, 246, 
    143,  32,   0,   0,   0,   0, 
      0,   3,   0,   0,   0,  62, 
      0,   0,   1,  83,  84,  65, 
     84, 116,   0,   0,   0,   5, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   2,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  82,  68,  69,  70, 120, 
      1,   0,   0,   1,   0,   0, 
      0, 144,   0,   0,   0,   3, 
      0,   0,   0,  28,   0,   0, 
      0,   0,   4, 255, 255,   0, 
      1,   0,   0,  70,   1,   0, 
      0, 124,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0, 133,   0,   0, 
      0,   2,   0,   0,   0,   5, 
      0,   0,   0,   4,   0,   0, 
      0, 255, 255, 255, 255,   0, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   0,   0,   0, 137, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   1, 
      0,   0,   0,   0,   0,   0, 
      0, 115,  83,  97, 109, 112, 
    108, 101, 114,   0, 116, 101, 
    120,   0,  99,  98,  48,   0, 
    171, 171, 171, 137,   0,   0, 
      0,   4,   0,   0,   0, 168, 
      0,   0,   0,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   8,   1,   0, 
      0,   0,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,  20,   1,   0,   0,   0, 
      0,   0,   0,  36,   1,   0, 
      0,  16,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,  20,   1,   0,   0,   0, 
      0,   0,   0,  46,   1,   0, 
      0,  32,   0,   0,   0,  16, 
      0,   0,   0,   0,   0,   0, 
      0,  20,   1,   0,   0,   0, 
      0,   0,   0,  60,   1,   0, 
      0,  48,   0,   0,   0,  16, 
      0,   0,   0,   2,   0,   0, 
      0,  20,   1,   0,   0,   0, 
      0,   0,   0,  81, 117,  97, 
    100,  68, 101, 115,  99,   0, 
    171, 171, 171,   1,   0,   3, 
      0,   1,   0,   4,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,  84, 101, 120,  67, 111, 
    111, 114, 100, 115,   0,  77, 
     97, 115, 107,  84, 101, 120, 
     67, 111, 111, 114, 100, 115, 
      0,  84, 101, 120, 116,  67, 
    111, 108, 111, 114,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  54,  46, 
     51,  46,  57,  54,  48,  48, 
     46,  49,  54,  51,  56,  52, 
      0,  73,  83,  71,  78, 104, 
      0,   0,   0,   3,   0,   0, 
      0,   8,   0,   0,   0,  80, 
      0,   0,   0,   0,   0,   0, 
      0,   1,   0,   0,   0,   3, 
      0,   0,   0,   0,   0,   0, 
      0,  15,   0,   0,   0,  92, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,   3,   3,   0,   0,  92, 
      0,   0,   0,   1,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0,   0,   1,   0,   0, 
      0,  12,   0,   0,   0,  83, 
     86,  95,  80, 111, 115, 105, 
    116, 105, 111, 110,   0,  84, 
     69,  88,  67,  79,  79,  82, 
     68,   0, 171, 171, 171,  79, 
     83,  71,  78,  68,   0,   0, 
      0,   2,   0,   0,   0,   8, 
      0,   0,   0,  56,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   0,   0,   0,   0,  15, 
      0,   0,   0,  56,   0,   0, 
      0,   1,   0,   0,   0,   0, 
      0,   0,   0,   3,   0,   0, 
      0,   1,   0,   0,   0,  15, 
      0,   0,   0,  83,  86,  95, 
     84,  97, 114, 103, 101, 116, 
      0, 171, 171, 111, 248,   0, 
      0,   0,   0,   0,   0,  77, 
     97, 115, 107, 101, 100,   0, 
      4,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0, 255, 255, 255, 255, 
     68,   4,   0,   0,  68,  88, 
     66,  67,  77,  85, 167, 240, 
     56,  56, 155,  78, 125,  96, 
     49, 253, 103, 100,  22,  62, 
      1,   0,   0,   0,  68,   4, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0, 248,   0, 
      0,   0, 244,   1,   0,   0, 
    112,   2,   0,   0, 160,   3, 
      0,   0, 212,   3,   0,   0, 
     65, 111, 110,  57, 184,   0, 
      0,   0, 184,   0,   0,   0, 
      0,   2, 254, 255, 132,   0, 
      0,   0,  52,   0,   0,   0, 
      1,   0,  36,   0,   0,   0, 
     48,   0,   0,   0,  48,   0, 
      0,   0,  36,   0,   1,   0, 
     48,   0,   0,   0,   0,   0, 
      3,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   2, 254, 255,  81,   0, 
      0,   5,   4,   0,  15, 160, 
      0,   0,   0,   0,   0,   0, 
    128,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,  31,   0, 
      0,   2,   5,   0,   0, 128, 
      0,   0,  15, 144,   4,   0, 
      0,   4,   0,   0,   3, 224, 
      0,   0, 228, 144,   2,   0, 
    238, 160,   2,   0, 228, 160, 
      4,   0,   0,   4,   0,   0, 
     12, 224,   0,   0,  20, 144, 
      3,   0, 180, 160,   3,   0, 
     20, 160,   4,   0,   0,   4, 
      0,   0,   3, 128,   0,   0, 
    228, 144,   1,   0, 238, 160, 
      1,   0, 228, 160,   2,   0, 
      0,   3,   0,   0,   3, 192, 
      0,   0, 228, 128,   0,   0, 
    228, 160,   1,   0,   0,   2, 
      0,   0,  12, 192,   4,   0, 
     68, 160, 255, 255,   0,   0, 
     83,  72,  68,  82, 244,   0, 
      0,   0,  64,   0,   1,   0, 
     61,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,  95,   0,   0,   3, 
     50,  16,  16,   0,   0,   0, 
      0,   0, 103,   0,   0,   4, 
    242,  32,  16,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    101,   0,   0,   3,  50,  32, 
     16,   0,   1,   0,   0,   0, 
    101,   0,   0,   3, 194,  32, 
     16,   0,   1,   0,   0,   0, 
     50,   0,   0,  11,  50,  32, 
     16,   0,   0,   0,   0,   0, 
     70,  16,  16,   0,   0,   0, 
      0,   0, 230, 138,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  70, 128,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   8, 
    194,  32,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 128,  63,  50,   0, 
      0,  11,  50,  32,  16,   0, 
      1,   0,   0,   0,  70,  16, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     70, 128,  32,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     50,   0,   0,  11, 194,  32, 
     16,   0,   1,   0,   0,   0, 
      6,  20,  16,   0,   0,   0, 
      0,   0, 166, 142,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   6, 132,  32,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,   5,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70,  40,   1,   0,   0, 
      1,   0,   0,   0,  64,   0, 
      0,   0,   1,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    254, 255,   0,   1,   0,   0, 
    246,   0,   0,   0,  60,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     99,  98,  48,   0,  60,   0, 
      0,   0,   4,   0,   0,   0, 
     88,   0,   0,   0,  64,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 184,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 212,   0, 
      0,   0,  16,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 222,   0, 
      0,   0,  32,   0,   0,   0, 
     16,   0,   0,   0,   2,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0, 236,   0, 
      0,   0,  48,   0,   0,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0, 196,   0,   0,   0, 
      0,   0,   0,   0,  81, 117, 
     97, 100,  68, 101, 115,  99, 
      0, 171, 171, 171,   1,   0, 
      3,   0,   1,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     77,  97, 115, 107,  84, 101, 
    120,  67, 111, 111, 114, 100, 
    115,   0,  84, 101, 120, 116, 
     67, 111, 108, 111, 114,   0, 
     77, 105,  99, 114, 111, 115, 
    111, 102, 116,  32,  40,  82, 
     41,  32,  72,  76,  83,  76, 
     32,  83, 104,  97, 100, 101, 
    114,  32,  67, 111, 109, 112, 
    105, 108, 101, 114,  32,  54, 
     46,  51,  46,  57,  54,  48, 
     48,  46,  49,  54,  51,  56, 
     52,   0,  73,  83,  71,  78, 
     44,   0,   0,   0,   1,   0, 
      0,   0,   8,   0,   0,   0, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0,   7,   3,   0,   0, 
     80,  79,  83,  73,  84,  73, 
     79,  78,   0, 171, 171, 171, 
     79,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,  12,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   3,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  74, 253, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
    140,   5,   0,   0,  68,  88, 
     66,  67, 233, 167,   4, 110, 
     60, 182, 197,  16, 114, 252, 
     67, 184, 217, 172, 169, 241, 
      1,   0,   0,   0, 140,   5, 
      0,   0,   6,   0,   0,   0, 
     56,   0,   0,   0,  64,   1, 
      0,   0, 132,   2,   0,   0, 
      0,   3,   0,   0, 208,   4, 
      0,   0,  64,   5,   0,   0, 
     65, 111, 110,  57,   0,   1, 
      0,   0,   0,   1,   0,   0, 
      0,   2, 255, 255, 200,   0, 
      0,   0,  56,   0,   0,   0, 
      1,   0,  44,   0,   0,   0, 
     56,   0,   0,   0,  56,   0, 
      2,   0,  36,   0,   0,   0, 
     56,   0,   0,   0,   0,   0, 
      1,   1,   1,   0,   0,   0, 
      3,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   1,   2, 
    255, 255,  81,   0,   0,   5, 
      1,   0,  15, 160,   0,   0, 
    128,  63,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  31,   0,   0,   2, 
      0,   0,   0, 128,   0,   0, 
     15, 176,  31,   0,   0,   2, 
      0,   0,   0, 144,   0,   8, 
     15, 160,  31,   0,   0,   2, 
      0,   0,   0, 144,   1,   8, 
     15, 160,   1,   0,   0,   2, 
      0,   0,   7, 128,   0,   0, 
    228, 160,   4,   0,   0,   4, 
      0,   0,  15, 128,   0,   0, 
     36, 128,   1,   0,  64, 160, 
      1,   0,  21, 160,   1,   0, 
      0,   2,   0,   8,  15, 128, 
      0,   0, 228, 128,   1,   0, 
      0,   2,   0,   0,   3, 128, 
      0,   0, 235, 176,  66,   0, 
      0,   3,   1,   0,  15, 128, 
      0,   0, 228, 176,   0,   8, 
    228, 160,  66,   0,   0,   3, 
      0,   0,  15, 128,   0,   0, 
    228, 128,   1,   8, 228, 160, 
      5,   0,   0,   3,   1,   0, 
     15, 128,   1,   0,  70, 128, 
      0,   0, 255, 160,   5,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 255, 128,   1,   0, 
    228, 128,   1,   0,   0,   2, 
      1,   8,  15, 128,   0,   0, 
    228, 128, 255, 255,   0,   0, 
     83,  72,  68,  82,  60,   1, 
      0,   0,  64,   0,   0,   0, 
     79,   0,   0,   0,  89,   0, 
      0,   4,  70, 142,  32,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  90,   0,   0,   3, 
      0,  96,  16,   0,   1,   0, 
      0,   0,  88,  24,   0,   4, 
      0, 112,  16,   0,   0,   0, 
      0,   0,  85,  85,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   1,   0,   0,   0, 
     85,  85,   0,   0,  98,  16, 
      0,   3,  50,  16,  16,   0, 
      1,   0,   0,   0,  98,  16, 
      0,   3, 194,  16,  16,   0, 
      1,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      0,   0,   0,   0, 101,   0, 
      0,   3, 242,  32,  16,   0, 
      1,   0,   0,   0, 104,   0, 
      0,   2,   2,   0,   0,   0, 
     54,   0,   0,   6, 114,  32, 
     16,   0,   0,   0,   0,   0, 
     70, 130,  32,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
     54,   0,   0,   5, 130,  32, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
    128,  63,  69,   0,   0,   9, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,  16,  16,   0, 
      1,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  56,   0,   0,   8, 
    242,   0,  16,   0,   0,   0, 
      0,   0, 102,   4,  16,   0, 
      0,   0,   0,   0, 246, 143, 
     32,   0,   0,   0,   0,   0, 
      3,   0,   0,   0,  69,   0, 
      0,   9, 242,   0,  16,   0, 
      1,   0,   0,   0, 230,  26, 
     16,   0,   1,   0,   0,   0, 
     70, 126,  16,   0,   1,   0, 
      0,   0,   0,  96,  16,   0, 
      1,   0,   0,   0,  56,   0, 
      0,   7, 242,  32,  16,   0, 
      1,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
    246,  15,  16,   0,   1,   0, 
      0,   0,  62,   0,   0,   1, 
     83,  84,  65,  84, 116,   0, 
      0,   0,   7,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,  82,  68, 
     69,  70, 200,   1,   0,   0, 
      1,   0,   0,   0, 224,   0, 
      0,   0,   5,   0,   0,   0, 
     28,   0,   0,   0,   0,   4, 
    255, 255,   0,   1,   0,   0, 
    150,   1,   0,   0, 188,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    197,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 210,   0,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     12,   0,   0,   0, 214,   0, 
      0,   0,   2,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      1,   0,   0,   0,   1,   0, 
      0,   0,  12,   0,   0,   0, 
    219,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 115,  83,  97, 109, 
    112, 108, 101, 114,   0, 115, 
     77,  97, 115, 107,  83,  97, 
    109, 112, 108, 101, 114,   0, 
    116, 101, 120,   0, 109,  97, 
    115, 107,   0,  99,  98,  48, 
      0, 171, 219,   0,   0,   0, 
      4,   0,   0,   0, 248,   0, 
      0,   0,  64,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  88,   1,   0,   0, 
      0,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    100,   1,   0,   0,   0,   0, 
      0,   0, 116,   1,   0,   0, 
     16,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    100,   1,   0,   0,   0,   0, 
      0,   0, 126,   1,   0,   0, 
     32,   0,   0,   0,  16,   0, 
      0,   0,   0,   0,   0,   0, 
    100,   1,   0,   0,   0,   0, 
      0,   0, 140,   1,   0,   0, 
     48,   0,   0,   0,  16,   0, 
      0,   0,   2,   0,   0,   0, 
    100,   1,   0,   0,   0,   0, 
      0,   0,  81, 117,  97, 100, 
     68, 101, 115,  99,   0, 171, 
    171, 171,   1,   0,   3,   0, 
      1,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     84, 101, 120,  67, 111, 111, 
    114, 100, 115,   0,  77,  97, 
    115, 107,  84, 101, 120,  67, 
    111, 111, 114, 100, 115,   0, 
     84, 101, 120, 116,  67, 111, 
    108, 111, 114,   0,  77, 105, 
     99, 114, 111, 115, 111, 102, 
    116,  32,  40,  82,  41,  32, 
     72,  76,  83,  76,  32,  83, 
    104,  97, 100, 101, 114,  32, 
     67, 111, 109, 112, 105, 108, 
    101, 114,  32,  54,  46,  51, 
     46,  57,  54,  48,  48,  46, 
     49,  54,  51,  56,  52,   0, 
     73,  83,  71,  78, 104,   0, 
      0,   0,   3,   0,   0,   0, 
      8,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
     15,   0,   0,   0,  92,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
      3,   3,   0,   0,  92,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
     12,  12,   0,   0,  83,  86, 
     95,  80, 111, 115, 105, 116, 
    105, 111, 110,   0,  84,  69, 
     88,  67,  79,  79,  82,  68, 
      0, 171, 171, 171,  79,  83, 
     71,  78,  68,   0,   0,   0, 
      2,   0,   0,   0,   8,   0, 
      0,   0,  56,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,  15,   0, 
      0,   0,  56,   0,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      1,   0,   0,   0,  15,   0, 
      0,   0,  83,  86,  95,  84, 
     97, 114, 103, 101, 116,   0, 
    171, 171, 166,   1,   1,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,  46,   0, 
      0,   0,  18,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  54,   0,   0,   0, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,  93,   0,   0,   0, 
     65,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    102,   0,   0,   0,  65,   0, 
      0,   0,   0,   0,   0,   0, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 112,   0, 
      0,   0,  65,   0,   0,   0, 
      0,   0,   0,   0,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 126,   0,   0,   0, 
     65,   0,   0,   0,   0,   0, 
      0,   0,  48,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    136,   0,   0,   0, 160,   0, 
      0,   0,   0,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
    168,   0,   0,   0, 140,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 181,   0, 
      0,   0, 140,   0,   0,   0, 
      0,   0,   0,   0,  48,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 194,   0,   0,   0, 
    140,   0,   0,   0,   0,   0, 
      0,   0,  96,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    206,   0,   0,   0,  65,   0, 
      0,   0,   0,   0,   0,   0, 
    144,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 218,   0, 
      0,   0, 112,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,   3,   1, 
      0,   0, 231,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  61,   1,   0,   0, 
     33,   1,   0,   0,   0,   0, 
      0,   0,  48,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    107,   1,   0,   0,  79,   1, 
      0,   0,   0,   0,   0,   0, 
     64,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 112,   1, 
      0,   0,  33,   1,   0,   0, 
      0,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 154,   1,   0,   0, 
    126,   1,   0,   0,   0,   0, 
      0,   0,  88,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    156,   1,   0,   0, 126,   1, 
      0,   0,   0,   0,   0,   0, 
     92,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0, 164,   1, 
      0,   0, 126,   1,   0,   0, 
      0,   0,   0,   0,  96,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 213,   1,   0,   0, 
    185,   1,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0, 217,   1, 
      0,   0, 185,   1,   0,   0, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
    224,   1,   0,   0, 185,   1, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,  14,   2,   0,   0, 
    242,   1,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      4,   0,   0,   0,  45,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  23,   2, 
      0,   0,  55,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 213,   1,   0,   0, 
     46,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     35,   2,   0,   0,  47,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  47,   2, 
      0,   0,   0,   0,   0,   0, 
     59,   2,   0,   0, 242,   1, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   4,   0, 
      0,   0,  45,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  71,   2,   0,   0, 
     55,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    217,   1,   0,   0,  46,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  83,   2, 
      0,   0,  47,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  95,   2,   0,   0, 
      0,   0,   0,   0, 107,   2, 
      0,   0, 242,   1,   0,   0, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   4,   0,   0,   0, 
     45,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    120,   2,   0,   0,  55,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 213,   1, 
      0,   0,  46,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 132,   2,   0,   0, 
     47,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    144,   2,   0,   0,   0,   0, 
      0,   0, 156,   2,   0,   0, 
    242,   1,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      4,   0,   0,   0,  45,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 171,   2, 
      0,   0,  55,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 213,   1,   0,   0, 
     46,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    183,   2,   0,   0,  47,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 195,   2, 
      0,   0,   0,   0,   0,   0, 
    207,   2,   0,   0, 242,   1, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   4,   0, 
      0,   0,  45,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 220,   2,   0,   0, 
     55,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    224,   1,   0,   0,  46,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 232,   2, 
      0,   0,  47,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 244,   2,   0,   0, 
      0,   0,   0,   0,   0,   3, 
      0,   0, 242,   1,   0,   0, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   5,   0,   0,   0, 
     45,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     15,   3,   0,   0,  55,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 213,   1, 
      0,   0,  46,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  27,   3,   0,   0, 
     47,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     39,   3,   0,   0,  52,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  51,   3, 
      0,   0,   0,   0,   0,   0, 
    131,   3,   0,   0, 103,   3, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   2,   0, 
      0,   0,  19,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 143,   3,   0,   0, 
     13,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    155,   3,   0,   0,   0,   0, 
      0,   0, 206,   3,   0,   0, 
    178,   3,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      2,   0,   0,   0,  37,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 219,   3, 
      0,   0,  44,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 231,   3,   0,   0, 
      0,   0,   0,   0, 243,   3, 
      0,   0, 178,   3,   0,   0, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   8,   0,   0,   0, 
     37,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
      0,   4,   0,   0,  38,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  12,   4, 
      0,   0,  39,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  24,   4,   0,   0, 
     40,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     36,   4,   0,   0,  41,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  48,   4, 
      0,   0,  42,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  60,   4,   0,   0, 
     43,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     72,   4,   0,   0,  44,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  84,   4, 
      0,   0,   0,   0,   0,   0, 
     96,   4,   0,   0, 178,   3, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   9,   0, 
      0,   0,  36,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 107,   4,   0,   0, 
     37,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    119,   4,   0,   0,  38,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 131,   4, 
      0,   0,  39,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 143,   4,   0,   0, 
     40,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    155,   4,   0,   0,  41,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 167,   4, 
      0,   0,  42,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 179,   4,   0,   0, 
     43,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    191,   4,   0,   0,  44,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 203,   4, 
      0,   0,   0,   0,   0,   0, 
    215,   4,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    229,   4,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    131,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,  48,   9, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  56,   9,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     28,  12,   0,   0,  36,  12, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 229,   4, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 131,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 144,  16,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    152,  16,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 240,  29, 
      0,   0, 248,  29,   0,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   0, 229,   4,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 131,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    100,  34,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 108,  34, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 212,  51,   0,   0, 
    220,  51,   0,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
    229,   4,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    131,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0,  73,  56, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  81,  56,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     57,  94,   0,   0,  65,  94, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,  86,  94, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 131,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 139, 101,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    147, 101,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 131, 111, 
      0,   0, 139, 111,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 131,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    190, 118,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 198, 118, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 150, 126,   0,   0, 
    158, 126,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    131,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 215, 133, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 223, 133,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    211, 143,   0,   0, 219, 143, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 131,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  18, 151,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     26, 151,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 238, 158, 
      0,   0, 246, 158,   0,   0, 
      4,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 131,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     49, 166,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  57, 166, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  49, 176,   0,   0, 
     57, 176,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    131,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 114, 183, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 122, 183,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     82, 191,   0,   0,  90, 191, 
      0,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 229,   4, 
      0,   0,   4,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 131,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0, 182, 195,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    190, 195,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 162, 199, 
      0,   0, 170, 199,   0,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   0, 229,   4,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 131,   3,   0,   0, 
     10,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    194, 199,   0,   0,  11,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0, 230, 199, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 206,   3,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     58, 204,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  66, 204, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  58, 214,   0,   0, 
     66, 214,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    131,   3,   0,   0,  10,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  69, 214, 
      0,   0,  11,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 105, 214,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    243,   3,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 189, 218, 
      0,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 197, 218,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
    129, 228,   0,   0, 137, 228, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 131,   3, 
      0,   0,  10,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 140, 228,   0,   0, 
     11,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    176, 228,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      2,   0,   0,   0, 243,   3, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,   4, 233,   0,   0, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     12, 233,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 192, 243, 
      0,   0, 200, 243,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0, 218, 243,   0,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0, 131,   3,   0,   0, 
     10,   0,   0,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
    227, 243,   0,   0,  11,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   7, 244, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  96,   4,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     91, 248,   0,   0,   8,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  99, 248, 
      0,   0,   7,   0,   0,   0, 
      0,   0,   0,   0,   7,   0, 
      0,   0,  11, 253,   0,   0, 
     19, 253,   0,   0,   7,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
    131,   3,   0,   0,  10,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,  26, 253, 
      0,   0,  11,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  62, 253,   0,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
     96,   4,   0,   0,   6,   0, 
      0,   0,   0,   0,   0,   0, 
      7,   0,   0,   0, 146,   1, 
      1,   0,   8,   0,   0,   0, 
      0,   0,   0,   0,   1,   0, 
      0,   0, 154,   1,   1,   0, 
      7,   0,   0,   0,   0,   0, 
      0,   0,   7,   0,   0,   0, 
     54,   7,   1,   0
    // clang-format on
};
