// Copyright (C) 2016 the V8 project authors. All rights reserved.
// Copyright (C) 2017 Mozilla Corporation. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
description: >
  Return value from valid numeric index, with SharedArrayBuffer
includes: [testTypedArray.js]
---*/

var proto = TypedArray.prototype;
var throwDesc = {
  get: function() {
    throw new Test262Error("OrdinaryGet was called! Ref: 9.1.8.1 3.c");
  }
};
Object.defineProperty(proto, "0", throwDesc);
Object.defineProperty(proto, "1", throwDesc);

testWithTypedArrayConstructors(function(TA) {
  var sab = new SharedArrayBuffer(TA.BYTES_PER_ELEMENT * 2);
  var sample = new TA(sab);
  sample.set([42, 1]);

  assert.sameValue(sample["0"], 42);
  assert.sameValue(sample["1"], 1);
});

reportCompare(0, 0);
