// Copyright (C) 2017 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-math.min
description: >
  "length" property of Math.min
info: >
  Math.min ( value1, value2, ...values )

  17 ECMAScript Standard Built-in Objects:
    Every built-in Function object, including constructors, that is not
    identified as an anonymous function has a name property whose value
    is a String.

    Unless otherwise specified, the name property of a built-in Function
    object, if it exists, has the attributes { [[Writable]]: false,
    [[Enumerable]]: false, [[Configurable]]: true }.
includes: [propertyHelper.js]
---*/

assert.sameValue(Math.min.length, 2);

verifyNotEnumerable(Math.min, "length");
verifyNotWritable(Math.min, "length");
verifyConfigurable(Math.min, "length");

reportCompare(0, 0);
