# Security Policy

## Supported Versions

This table indicates the Netatalk release series that are current guaranteed to get security patches.

| Version | Supported          |
| ------- | ------------------ |
| 3.2.x   | :white_check_mark: |
| 3.1.x   | :white_check_mark: |
| 3.0.x   | :x:                |
| 2.4.x   | :white_check_mark: |
| < 2.4   | :x:                |

## Reporting a Vulnerability

If you think you have found an exploitable security vulnerability in Netatalk, the Netatalk Team would be eager to hear from you!

The best way to get in touch with us is by filing a report via the
[private security vulnerability reporting](https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing-information-about-vulnerabilities/privately-reporting-a-security-vulnerability#privately-reporting-a-security-vulnerability)
flow in GitHub. This allows us to collaborate in private and avoid putting end-users at potential risk in the meantime.

In order for us to take effective action on your report, please include as much context as possible, including steps to reproduction that we can use.

If we are able to reproduce and subsequently patch the vulnerability, we will publish an advisory on [netatalk.io](https://netatalk.io/support)
where you are credited as finder and reporter. If you also contribute a patch, you will be credited as patch developer.

Please be mindful that Netatalk is a volunteer driven project! We do this on our free time, so response times may vary.
That said, we will try to take action on your report as soon as possible.
