.TH classes 3U "12 June 1990" "Unidraw" "InterViews Reference Manual"
.SH NAME
classes \- unique identifiers for catalog-managed objects and component views
.SH SYNOPSIS
.B #include <Unidraw/classes.h>
.SH DESCRIPTION
Classes for catalog-managed objects, including components, commands,
tools, state variables, and transfer functions, must be associated
with mutually-unique class identifiers that can be written onto disk.
This allows a creator object to call the appropriate constructor as
part of recreating an object from disk.

Also, there must be a mechanism for creating an appropriate view given
a subject; that is, there must be an association between a subject
class and allowable view classes for that subject.  This association
is established by defining class identifiers for component views.
These identifiers are formed by concatenating the identifier for a
given component subject class with an identifier that specifies a
``view category.''  For example, the class identifier for the
PostScript external view of a line component is the concatenation of
the identifier for the line component subject class and
POSTSCRIPT_VIEW identifier, which specifies the category of external
views for generating PostScript.  This makes it possible to create an
instance of the appropriate PostScript external view subclass given a
line component subject.

The class identifiers for the Unidraw base and predefined derived
classes are specified in the \fIclasses.h\fP include file.
Applications that define new catalog-managed objects or component
views should define unique class identifiers in a similar manner.
Class identifiers for catalog-managed objects are simply integers with
mnemonic macro definitions, usually the class name in all-uppercase.
For example, the identifier for the LineComp component subject class
is
.sp
#define LINE_COMP 9030
.sp
View class identifiers are specified using the Combine macro, which
takes as its first argument the macro definition of the corresponding
component subject identifier; its second argument is an identifier for
the view category.  The Combine macro itself is then defined with a
mnemonic name.  For example, the identifier for the PostScript
external view class PSLine (which generates PostScript for the line
component subject) is defined as
.sp
#define PS_LINE Combine(LINE_COMP, POSTSCRIPT_VIEW)
.sp
where the POSTSCRIPT_VIEW view category identifier is defined as
.sp
#define POSTSCRIPT_VIEW 9103
.sp
N.B.: \fIAll\fP class identifiers in a given application must be
unique.
.SH SEE ALSO
Catalog(3U), Creator(3U)
