
/* This work is copyrighted. See COPYRIGHT.OLD & COPYRIGHT.NEW for   *
*  details. If they are missing then this copy is in violation of    *
*  the copyright conditions.                                        */

/*
**	lib_insdel.c
**
**	The routine winsdel(win, n).
**  positive n insert n lines above current line
**  negative n delete n lines starting from current line 
**
*/

#include <stdlib.h>
#include "curses.priv.h"
#include "terminfo.h"

int
winsdelln(WINDOW *win, int n)
{
int	line, i;
int touched = 0;
chtype	*ptr, *temp;
chtype  **saved;
chtype	blank = ' ';

	T(("winsdel(%x,%d) called", win, n));

	if (n == 0)
		return OK;
	if (n < 0 && win->_cury - n >= win->_maxy)
		/* request to delete too many lines */
		/* should we truncate to an appropriate number? */
		return ERR;

	/* as an optimization, if the window is COLS wide we can try
	   using idl assuming _idlok is true */

    	if (win->_maxx == columns-1 && win->_idlok == TRUE) {
	int x = win->_curx, y = win->_cury;

		T(("using idl capabilities"));
		if (n > 0) {
			mvcur(-1, -1, win->_cury, 0);
			if (parm_insert_line) {
				wrefresh(win);
				putp(tparm(parm_insert_line, n));
				touched = 1;
			} else if (insert_line) {
				wrefresh(win);
				while (n--)
					putp(insert_line);
				touched = 1;
			}
		}

		if (n < 0) {
		int m = abs(n);

			mvcur(-1, -1, win->_cury, 0);
			if (parm_delete_line) {
				wrefresh(win);
				putp(tparm(parm_delete_line, m));
				touched = 1;
		    	} else if (delete_line) {
				wrefresh(win);
		    		while (m--)
					putp(delete_line);
				touched = 1;
			}
		}
		mvcur(-1, -1, y, x);
	} 
	
    	saved = (chtype **)malloc(sizeof(chtype *) * abs(n));

    	if (n < 0) {
		/* save overwritten lines */
		
		for (i = 0; i < -n; i++) {
		    	saved[i] = win->_line[win->_regtop-i];
			T(("saving line %d", win->_regtop-i));
		}
		/* delete n lines */
		
		for (line = win->_cury; line <= win->_regbottom + n; line++) {
		    	win->_line[line] = win->_line[line-n];
			T(("line %d now points to the old %d", line, line-n));
		}
		/* restore saved lines and blank them */

		for (i = 0, line = win->_regbottom; i < -n; line--, i++) {
			T(("restoring line %d from saved %d", line, i));
		    	temp = win->_line[line] = saved[i]; 
		    	for (ptr = temp; ptr - temp <= win->_maxx; ptr++)
				*ptr = blank;
		}
    	}

    	if (n > 0) {
		/* save overwritten lines */
		
		for (i = 0; i < n; i++)
		    	saved[i] = win->_line[win->_regbottom-i];

		/* insert n lines */
		
		for (line = win->_regbottom; line < win->_regbottom - n; line++)
		    	win->_line[line] = win->_line[line-n];

		/* restore saved lines and blank them */

		for (i = 0, line = win->_cury; i < n; line--, i++) {
		    	temp = win->_line[line] = saved[i];
		    	for (ptr = temp; ptr - temp <= win->_maxx; ptr++)
				*ptr = blank;
		}
	}
	
	free(saved);

	touchline(win, win->_regtop, win->_regbottom - win->_regtop + 1);


    	return OK;
}
