/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/09/1998 - added vg_status checks
 *
 */

#include <liblvm.h>

int vg_check_consistency ( vg_t *vg) {
   uint size = 0;

#ifdef DEBUG
   debug ( "vg_check_consistency -- CALLED\n");
#endif

   if ( vg == NULL) return -LVM_EPARA;

   if ( vg_check_name ( vg->vg_name) != 0)
      return -LVM_EVG_CHECK_CONSISTENCY_VG_NAME;
   if ( vg->vg_access != VG_READ &&
        vg->vg_access != VG_WRITE &&
        vg->vg_access != ( VG_READ | VG_WRITE))
      return -LVM_EVG_CHECK_CONSISTENCY_VG_ACCESS;
   if ( vg->vg_status != 0 &&
        vg->vg_status != VG_ACTIVE &&
        vg->vg_status != VG_EXTENDABLE &&
        vg->vg_status != ( VG_ACTIVE | VG_EXTENDABLE))
      return -LVM_EVG_CHECK_CONSISTENCY_VG_STATUS;
   if ( vg->lv_cur > vg->lv_max)
      return -LVM_EVG_CHECK_CONSISTENCY_LV_CUR;
   if ( vg->pv_cur > vg->pv_max)
      return -LVM_EVG_CHECK_CONSISTENCY_PV_CUR;
   if ( vg->pv_act > vg->pv_cur)
      return -LVM_EVG_CHECK_CONSISTENCY_PV_ACT;
   size = vg->pe_size / LVM_MIN_PE_SIZE * LVM_MIN_PE_SIZE;
   if ( size != vg->pe_size ||
        size < LVM_MIN_PE_SIZE ||
        size > LVM_MAX_PE_SIZE)
      return -LVM_EVG_CHECK_CONSISTENCY_SIZE;
/* obsolete
   if ( vg->max_pe_per_pv % sizeof ( disk_pe_t) != 0)
      return -LVM_EVG_CHECK_CONSISTENCY_MAX_PE_PER_PV;
*/
   if ( vg->vgda != 0)
      return -LVM_EVG_CHECK_CONSISTENCY_VGDA;
   if ( vg->pe_allocated > vg->pe_total)
      return -LVM_EVG_CHECK_CONSISTENCY_PE_ALLOCATED;
/* obsolete
   if ( vg->pe_total > vg->max_pe_per_pv)
      return -LVM_EVG_CHECK_CONSISTENCY_PE_TOTAL;
*/
   if ( vg->pvg_total != 0)
      return -LVM_EVG_CHECK_CONSISTENCY_PVG_TOTAL;

#ifdef DEBUG
   debug ( "vg_check_consistency -- LEAVING with return 0\n");
#endif

   return 0;
}


int vg_check_consistency_with_pv_and_lv ( vg_t *vg) {
   int ret = 0;

#ifdef DEBUG
   debug ( "vg_check_consistency_with_pv_and_lv -- CALLED\n");
#endif

   if ( ( ret = vg_check_consistency ( vg)) < 0)        return ret;
   if ( ( ret = pv_check_consistency_all_pv ( vg)) < 0) return ret;
   if ( ( ret = lv_check_consistency_all_lv ( vg)) < 0) return ret;

#ifdef DEBUG
   debug ( "vg_check_consistency_with_pv_and_lv -- LEAVING with return 0\n");
#endif

   return 0;
}
