/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/03/1998 - added multiple device checking
 *               - changed checking to use MAJOR numbers instead of file names
 *    05/17/1998 - added /dev/dsk/ checking
 *
 */

#include <liblvm.h>

int pv_check_name ( char *pv_name) {
   int ret = 0;
   struct stat stat_b;

#ifdef DEBUG
   debug ( "pv_check_name -- CALLED\n");
#endif

   if ( pv_name == NULL) ret = -LVM_EPARA;
   else if ( strncmp ( pv_name, "/dev/", 5) != 0 &&
             strncmp ( pv_name, "/dev/dsk/", 9) != 0)
      ret =  -LVM_EPV_CHECK_NAME;
   else if ( stat ( pv_name, &stat_b) == -1) ret = -LVM_EPV_CHECK_NAME_STAT;
   else if ( lvm_check_dev ( &stat_b, TRUE) == TRUE) ret = 0;
   else ret = -LVM_EPV_CHECK_NAME;

#ifdef DEBUG
   if ( ret == 0) {
      debug ( "pv_check_name -- CALLED  pv_name: \"%s\"\n", pv_name);
   }
   debug ( "pv_check_name -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
