/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March-May,November 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

/*
 * setup structure for a logical volume size reduce
 */
int lv_setup_for_reduce ( char *vg_name, vg_t *vg, char *lv_name, uint size) {
   int l = 0;
   int ret = 0;
   uint pe = 0;
   disk_pe_t lv_pe = { 0, 0};

#ifdef DEBUG
   debug ( "lv_setup_for_reduce -- CALLED\n");
#endif
   if ( vg_name == NULL || vg == NULL || lv_name == NULL ||
        vg_check_name ( vg_name) < 0 || size == 0 ||
        lv_check_name ( lv_name) < 0) return -LVM_EPARA;

   if ( ( l = lv_get_index_by_name ( vg, lv_name)) < 0)
      return -LVM_ELV_SETUP_FOR_REDUCE_LV_INDEX;

#ifdef DEBUG
   debug ( "lv_setup_for_reduce -- size: %d  lv_current_le: %lu\n",
            size, vg->lv[l]->lv_current_le);
#endif

   pe = vg->lv[l]->lv_allocated_le - size / vg->pe_size;
   vg->pe_allocated -= pe;

#ifdef DEBUG
   debug ( "lv_setup_for_reduce -- pe: %d\n", pe);
#endif

   lv_pe.lv_num = l + 1;
   if ( ( ret = pv_release_pe ( vg, &lv_pe, &pe, vg->lv[l]->lv_stripes)) < 0 ||
        pe != 0)
      return -LVM_ESIZE;
#ifdef DEBUG
   debug ( "lv_setup_for_reduce -- AFTER pv_release_pe\n");
#endif

   vg->lv[l]->lv_allocated_le = vg->lv[l]->lv_current_le = size / vg->pe_size;
   vg->lv[l]->lv_size = size;

   if ( ( vg->lv[l]->lv_current_pe =
          realloc ( vg->lv[l]->lv_current_pe,
                    vg->lv[l]->lv_allocated_le *
                    sizeof ( pe_t))) == NULL) {
      fprintf ( stderr, "realloc error in %s [line %d]\n",
                        __FILE__, __LINE__);
      return -LVM_ELV_SETUP_FOR_REDUCE_MALLOC;
   }

#ifdef DEBUG
   if ( opt_d > 0) {
      printf ( "lv_setup_for_reduce -- AFTER  realloc\n");
      lv_show_current_pe_text ( vg->lv[l]);
      printf ( "*********************\n");
   }
#endif

   return 0;
}
