/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.35 from the
 * contents of GConfClient.xs. Do not edit this file, edit GConfClient.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/GConfClient.xs"
/*
 * Copyright (c) 2003, 2004 by Emmanuele Bassi (see the file AUTHORS)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, see
 * <https://www.gnu.org/licenses/>.
 */

#include "gconfperl.h"
#include <gperl_marshal.h>

/* Here's some magic.  In C, the notify function has the following parameters:
 * the GConfClient that is monitoring the keys, the connection id for notifier
 * handler and a GConfEntry, which is an opaque container for the key which is
 * being monitored and its value, stored as a GConfValue dynamic type (similar
 * to GValue).  Both GConfEntry and GConfValue should not be accessed directly
 * from the programmer (except for the "type" field of GConfValue, which is
 * used for type detection); so, these two objects do not have a type inside
 * Glib.  In order to expose the data contained inside those two objects, we
 * create an hashref and fill it with the key and the value; then, we pass it
 * to the notify marshaller.
 */
static GPerlCallback *
gconfperl_notify_func_create (SV * func, SV * data)
{
	GType param_types [] = {
		GCONF_TYPE_CLIENT,
		G_TYPE_INT,
		GPERL_TYPE_SV,
	};
	return gperl_callback_new (func, data,
			           G_N_ELEMENTS (param_types),
				   param_types, 0);
}

static void
gconfperl_notify_func (GConfClient * client,
		       guint cnxn_id,
		       GConfEntry * entry,
		       gpointer data)
{
	gperl_callback_invoke ((GPerlCallback*)data, NULL,
			       client,
			       cnxn_id,
			       newSVGConfEntry (entry));
}

/* the "error" and "unreturned_error" signals pass a GError to the callbacks
 * attached to them.  GError is an opaque struct which contains the error
 * message string.  Since GError is not a Glib type, we pass to the Perl
 * marshallers directly the message string.
 */
static void
gconfperl_client_error_marshal (GClosure * closure,
                                GValue * return_value,
                                guint n_param_values,
                                const GValue * param_values,
                                gpointer invocation_hint,
                                gpointer marshal_data)
{
	GError *err;
	dGPERL_CLOSURE_MARSHAL_ARGS;

	GPERL_CLOSURE_MARSHAL_INIT (closure, marshal_data);

	PERL_UNUSED_VAR (return_value);
	PERL_UNUSED_VAR (n_param_values);
	PERL_UNUSED_VAR (invocation_hint);

	ENTER;
	SAVETMPS;

	PUSHMARK (SP);

	GPERL_CLOSURE_MARSHAL_PUSH_INSTANCE (param_values);
	
	err = (GError *) g_value_get_pointer (param_values + 1);
	XPUSHs (sv_2mortal (gperl_sv_from_gerror (err)));

	GPERL_CLOSURE_MARSHAL_PUSH_DATA;
	
	PUTBACK;

	GPERL_CLOSURE_MARSHAL_CALL (G_DISCARD);
	
	FREETMPS;
	LEAVE;
}

#line 110 "xs/GConfClient.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 254 "xs/GConfClient.c"

XS_EUPXS(XS_Gnome2__GConf__Client_get_default); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_default)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	GConfClient_noinc *	RETVAL;

	RETVAL = gconf_client_get_default(/* void */);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfClient_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_for_engine); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_for_engine)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, engine");
    {
	GConfEngine *	engine = SvGConfEngine (ST(1))
;
	GConfClient_noinc *	RETVAL;

	RETVAL = gconf_client_get_for_engine(engine);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfClient_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_add_dir); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_add_dir)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, dir, preload, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	dir;
	GConfClientPreloadType	preload = SvGConfClientPreloadType (ST(2))
;
	gboolean	check_error;
#line 178 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 315 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 180 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
     		gconf_client_add_dir (client, dir, preload, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else
		gconf_client_add_dir (client, dir, preload, NULL);
#line 336 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_remove_dir); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_remove_dir)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, dir, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	dir;
	gboolean	check_error;
#line 194 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 355 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 196 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		gconf_client_remove_dir (client, dir, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else
		gconf_client_remove_dir (client, dir, NULL);
#line 376 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_notify_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_notify_add)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "client, namespace_section, func, data=NULL, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	namespace_section;
	SV *	func = ST(2)
;
	SV *	data;
	gboolean	check_error;
#line 212 "xs/GConfClient.xs"
     	GPerlCallback * callback;
	GError * err = NULL;
	guint cnxn_id = 0;
#line 400 "xs/GConfClient.c"
	guint	RETVAL;
	dXSTARG;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	namespace_section = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 4)
	    data = NULL;
	else {
	    data = ST(3)
;
	}

	if (items < 5)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(4))
;
	}
#line 216 "xs/GConfClient.xs"
     	callback = gconfperl_notify_func_create (func, data);
	if (TRUE == check_error) {
		cnxn_id = gconf_client_notify_add (client, namespace_section,
					gconfperl_notify_func,
					callback,
					(GFreeFunc) gperl_callback_destroy,
					&err);
		if (err)
			gperl_croak_gerror (NULL, err);

	}
	else {
		cnxn_id = gconf_client_notify_add (client, namespace_section,
					gconfperl_notify_func,
					callback,
					(GFreeFunc) gperl_callback_destroy,
					NULL);
	}
	RETVAL = cnxn_id;
#line 442 "xs/GConfClient.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_notify_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_notify_remove)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "client, cnxn_id");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	guint	cnxn_id = (guint)SvUV(ST(1))
;

	gconf_client_notify_remove(client, cnxn_id);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_set_error_handling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set_error_handling)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "client, mode");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	GConfClientErrorHandlingMode	mode = SvGConfClientErrorHandlingMode (ST(1))
;

	gconf_client_set_error_handling(client, mode);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_clear_cache); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_clear_cache)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "client");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;

	gconf_client_clear_cache(client);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_preload); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_preload)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, dirname, type, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	dirname;
	GConfClientPreloadType	type = SvGConfClientPreloadType (ST(2))
;
	gboolean	check_error;
#line 261 "xs/GConfClient.xs"
    	GError * err = NULL;
#line 516 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dirname = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 263 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		gconf_client_preload (client, dirname, type, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		gconf_client_preload (client, dirname, type, NULL);
	}
#line 538 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, value, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	GConfValue *	value = SvGConfValue (ST(2))
;
	gboolean	check_error;
#line 286 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 559 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 288 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		gconf_client_set (client, key, value, &err);
	}
	else {
		gconf_client_set (client, key, value, NULL);
	}
	gconf_value_free (value);	/* leaks otherwise */
	if (err)
		gperl_croak_gerror (NULL, err);
#line 582 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_get); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 309 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 601 "xs/GConfClient.c"
	GConfValue *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 311 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get (client, key, NULL);
	}
#line 624 "xs/GConfClient.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfValue (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_without_default); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_without_default)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 330 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 649 "xs/GConfClient.c"
	GConfValue *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 332 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_without_default (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_without_default (client, key, NULL);
	}
#line 672 "xs/GConfClient.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfValue (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_entry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_entry)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "client, key, locale, use_schema_default, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	const gchar *	locale;
	gboolean	use_schema_default = (bool)SvTRUE(ST(3))
;
	gboolean	check_error;
#line 352 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 700 "xs/GConfClient.c"
	GConfEntry *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	locale = (const gchar *)SvPV_nolen (ST(2))
;

	if (items < 5)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(4))
;
	}
#line 354 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_entry (client, key, locale, use_schema_default, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_entry (client, key, locale, use_schema_default, NULL);
	}
#line 728 "xs/GConfClient.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfEntry (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_default_from_schema); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_default_from_schema)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 372 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 753 "xs/GConfClient.c"
	GConfValue *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 374 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_default_from_schema (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_default_from_schema (client, key, NULL);
	}
#line 776 "xs/GConfClient.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfValue (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_unset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_unset)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 392 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 801 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 394 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_unset (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_unset (client, key, NULL);
	}
#line 824 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#if GCONF_CHECK_VERSION (2, 3, 3)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Gnome2__GConf__Client_recursive_unset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_recursive_unset)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "client, key, flags=0, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	GConfUnsetFlags	flags;
	gboolean	check_error;
#line 414 "xs/GConfClient.xs"
        GError * err = NULL;
#line 848 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = SvGConfUnsetFlags (ST(2))
;
	}

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 416 "xs/GConfClient.xs"
        if (TRUE == check_error) {
                RETVAL = gconf_client_recursive_unset (client, key, flags, &err);
                if (err)
                        gperl_croak_gerror (NULL, err);
        }
        else {
                RETVAL = gconf_client_recursive_unset (client, key, flags, NULL);
        }
#line 878 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif /* GCONF_CHECK_VERSION (2, 3, 3) */

XS_EUPXS(XS_Gnome2__GConf__Client_all_entries); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_all_entries)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, dir, check_error=TRUE");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	dir;
	gboolean	check_error;
#line 440 "xs/GConfClient.xs"
     	GError * err = NULL;
	GSList * l, * tmp;
#line 902 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 443 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		l = gconf_client_all_entries (client, dir, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		l = gconf_client_all_entries (client, dir, NULL);
	}
	for (tmp = l; tmp != NULL; tmp = tmp->next) {
		GConfEntry *entry = (GConfEntry *) tmp->data;
		XPUSHs (sv_2mortal (newSVGConfEntry (entry)));
	}
	g_slist_free (l);
#line 929 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gnome2__GConf__Client_all_dirs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_all_dirs)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, dir, check_error=TRUE");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	dir;
	gboolean	check_error;
#line 469 "xs/GConfClient.xs"
     	GError * err = NULL;
	GSList * l, * tmp;
#line 952 "xs/GConfClient.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 472 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		l = gconf_client_all_dirs (client, dir, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		l = gconf_client_all_dirs (client, dir, NULL);
	}
	for (tmp = l; tmp != NULL; tmp = tmp->next)
		XPUSHs (sv_2mortal (newSVGChar (tmp->data)));
	g_slist_free (l);
#line 977 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gnome2__GConf__Client_suggest_sync); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_suggest_sync)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "client, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	gboolean	check_error;
#line 490 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 996 "xs/GConfClient.c"

	if (items < 2)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(1))
;
	}
#line 492 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		gconf_client_suggest_sync (client, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		gconf_client_suggest_sync (client, NULL);
	}
#line 1013 "xs/GConfClient.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_dir_exists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_dir_exists)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, dir, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	dir;
	gboolean	check_error;
#line 508 "xs/GConfClient.xs"
	GError * err = NULL;
#line 1032 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	dir = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 510 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_dir_exists (client, dir, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_dir_exists (client, dir, NULL);
	}
#line 1055 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_key_is_writable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_key_is_writable)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 528 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1075 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 530 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_key_is_writable (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_key_is_writable (client, key, NULL);
	}
#line 1098 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_float); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_float)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 548 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1118 "xs/GConfClient.c"
	gdouble	RETVAL;
	dXSTARG;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 550 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_float (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_float (client, key, NULL);
	}
#line 1142 "xs/GConfClient.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_int)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 568 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1162 "xs/GConfClient.c"
	gint	RETVAL;
	dXSTARG;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 570 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_int (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_int (client, key, NULL);
	}
#line 1186 "xs/GConfClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_string)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 589 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1206 "xs/GConfClient.c"
	gchar_own *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 591 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_get_string (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_string (client, key, NULL);
	}
#line 1229 "xs/GConfClient.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    /* used when we can directly own the returned string. */
	    /* we have to copy in the case when perl's malloc != gtk's malloc,
	     * so best copy all the time. */
	    sv_setpv ((SV*)RETVALSV, RETVAL);
	    SvUTF8_on (RETVALSV);
	    g_free (RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_bool); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_bool)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;
#line 609 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1259 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 611 "xs/GConfClient.xs"
     	if (TRUE == check_error) {
		RETVAL = gconf_client_get_bool (client, key, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_get_bool (client, key, NULL);
	}
#line 1282 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_schema); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_schema)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "client, key");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
#line 629 "xs/GConfClient.xs"
	GError * err = NULL;
#line 1301 "xs/GConfClient.c"
	GConfSchema *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;
#line 631 "xs/GConfClient.xs"
	RETVAL = gconf_client_get_schema (client, key, &err);
	if (err)
		gperl_croak_gerror (NULL, err);
#line 1312 "xs/GConfClient.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfSchema (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
#line 637 "xs/GConfClient.xs"
	gconf_schema_free (RETVAL);
#line 1321 "xs/GConfClient.c"
    }
    XSRETURN(1);
}

#if 0
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Gnome2__GConf__Client_get_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_list)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}

	gconf_client_get_list(client, key, check_error);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__GConf__Client_get_pair); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_get_pair)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, key, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	check_error;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}

	gconf_client_get_pair(client, key, check_error);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gnome2__GConf__Client_set_float); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set_float)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, val, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gdouble	val = (double)SvNV(ST(2))
;
	gboolean	check_error;
#line 676 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1406 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 678 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_float (client, key, val, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_float (client, key, val, NULL);
	}
#line 1429 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_set_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set_int)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, val, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gint	val = (gint)SvIV(ST(2))
;
	gboolean	check_error;
#line 700 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1451 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 702 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_int (client, key, val, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_int (client, key, val, NULL);
	}
#line 1474 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_set_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set_string)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, val, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	const gchar *	val;
	gboolean	check_error;
#line 724 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1495 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	val = (const gchar *)SvPV_nolen (ST(2))
;

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 726 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_string (client, key, val, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_string (client, key, val, NULL);
	}
#line 1523 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_set_bool); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set_bool)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, val, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	gboolean	val = (bool)SvTRUE(ST(2))
;
	gboolean	check_error;
#line 748 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1545 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 750 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_bool (client, key, val, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_bool (client, key, val, NULL);
	}
#line 1568 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_set_schema); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set_schema)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, key, schema, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	GConfSchema *	schema = SvGConfSchema (ST(2))
;
	gboolean	check_error;
#line 770 "xs/GConfClient.xs"
	GError * err = NULL;
#line 1590 "xs/GConfClient.c"
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 772 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_set_schema (client, key, schema, &err);
		gconf_schema_free (schema);	/* leaks otherwise */
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_set_schema (client, key, schema, NULL);
		gconf_schema_free (schema);
	}
#line 1615 "xs/GConfClient.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#if 0
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Gnome2__GConf__Client_set_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set_list)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "client, key, list_type, list, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	const gchar *	list_type;
	SV *	list = ST(3)
;
	gboolean	check_error;
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	list_type = (const gchar *)SvPV_nolen (ST(2))
;

	if (items < 5)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(4))
;
	}

	RETVAL = gconf_client_set_list(client, key, list_type, list, check_error);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_set_pair); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_set_pair)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "client, key, car, cdr, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	GConfValue *	car = SvGConfValue (ST(2))
;
	GConfValue *	cdr = SvGConfValue (ST(3))
;
	gboolean	check_error;
	gboolean	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	if (items < 5)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(4))
;
	}

	RETVAL = gconf_client_set_pair(client, key, car, cdr, check_error);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Gnome2__GConf__Client_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_error)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "client, error");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	SV *	error = ST(1)
;
#line 832 "xs/GConfClient.xs"
	GError * err = NULL;
#line 1717 "xs/GConfClient.c"
#line 834 "xs/GConfClient.xs"
	gperl_gerror_from_sv (error, &err);
    	gconf_client_error (client, err);
	/* free err, otherwise we'd leak it. */
	g_error_free (err);
#line 1723 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gnome2__GConf__Client_unreturned_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_unreturned_error)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "client, error");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	SV *	error = ST(1)
;
#line 852 "xs/GConfClient.xs"
    	GError * err = NULL;
#line 1745 "xs/GConfClient.c"
#line 854 "xs/GConfClient.xs"
	gperl_gerror_from_sv (error, &err);
	gconf_client_unreturned_error (client, err);
	/* free err, otherwise we'd leak it. */
	g_error_free (err);
#line 1751 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gnome2__GConf__Client_value_changed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_value_changed)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "client, key, value");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	const gchar *	key;
	GConfValue *	value = SvGConfValue (ST(2))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;
#line 874 "xs/GConfClient.xs"
	gconf_client_value_changed (client, key, value);
	gconf_value_free (value);	/* leaks otherwise */
#line 1780 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gnome2__GConf__Client_commit_change_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_commit_change_set)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "client, cs, remove_committed, check_error=TRUE");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	GConfChangeSet *	cs = SvGConfChangeSet (ST(1))
;
	gboolean	remove_committed = (bool)SvTRUE(ST(2))
;
	gboolean	check_error;
#line 906 "xs/GConfClient.xs"
	GError * err = NULL;
	gboolean res;
#line 1806 "xs/GConfClient.c"

	if (items < 4)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(3))
;
	}
#line 909 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		res = gconf_client_commit_change_set (client, cs, remove_committed, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		res = gconf_client_commit_change_set (client, cs, remove_committed, NULL);
	}

	if ((GIMME_V != G_ARRAY) || (! remove_committed)) {
		/* push on the stack the returned boolean value if the user
		 * wants only that, or if the user does not want to remove
		 * the successfully committed keys. */
		XPUSHs (sv_2mortal (newSViv (res)));
		gconf_change_set_unref (cs);
	}
	else {
		/* push on the stack the returned value AND the reduced set. */
		XPUSHs (sv_2mortal (newSViv (res)));
		XPUSHs (sv_2mortal (newSVGConfChangeSet (cs)));
	}
#line 1836 "xs/GConfClient.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gnome2__GConf__Client_reverse_change_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_reverse_change_set)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "client, cs, check_error=TRUE");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	GConfChangeSet *	cs = SvGConfChangeSet (ST(1))
;
	gboolean	check_error;
#line 944 "xs/GConfClient.xs"
     	GError * err = NULL;
#line 1857 "xs/GConfClient.c"
	GConfChangeSet *	RETVAL;

	if (items < 3)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(2))
;
	}
#line 946 "xs/GConfClient.xs"
    	if (TRUE == check_error) {
		RETVAL = gconf_client_reverse_change_set (client, cs, &err);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_reverse_change_set (client, cs, NULL);
	}
#line 1875 "xs/GConfClient.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfChangeSet (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__GConf__Client_change_set_from_current); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__GConf__Client_change_set_from_current)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "client, check_error=TRUE, key, ...");
    {
	GConfClient *	client = SvGConfClient (ST(0))
;
	gboolean	check_error;
#line 980 "xs/GConfClient.xs"
     	char ** keys;
	int i;
	GError * err = NULL;
#line 1901 "xs/GConfClient.c"
	GConfChangeSet *	RETVAL;

	if (items < 2)
	    check_error = TRUE;
	else {
	    check_error = (bool)SvTRUE(ST(1))
;
	}
#line 984 "xs/GConfClient.xs"
    	keys = g_new0 (char *, items - 1);
	for (i = 2; i < items; i++)
		keys[i-1] = SvPV_nolen (ST (i));
	if (TRUE == check_error) {
		RETVAL = gconf_client_change_set_from_currentv (client, (const gchar **) keys, &err);
		g_free (keys);
		if (err)
			gperl_croak_gerror (NULL, err);
	}
	else {
		RETVAL = gconf_client_change_set_from_currentv (client, (const gchar **) keys, NULL);
		g_free (keys);
	}
#line 1924 "xs/GConfClient.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGConfChangeSet (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Gnome2__GConf__Client); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Gnome2__GConf__Client)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Gnome2::GConf::Client::get_default", XS_Gnome2__GConf__Client_get_default);
        newXS_deffile("Gnome2::GConf::Client::get_for_engine", XS_Gnome2__GConf__Client_get_for_engine);
        newXS_deffile("Gnome2::GConf::Client::add_dir", XS_Gnome2__GConf__Client_add_dir);
        newXS_deffile("Gnome2::GConf::Client::remove_dir", XS_Gnome2__GConf__Client_remove_dir);
        newXS_deffile("Gnome2::GConf::Client::notify_add", XS_Gnome2__GConf__Client_notify_add);
        newXS_deffile("Gnome2::GConf::Client::notify_remove", XS_Gnome2__GConf__Client_notify_remove);
        newXS_deffile("Gnome2::GConf::Client::set_error_handling", XS_Gnome2__GConf__Client_set_error_handling);
        newXS_deffile("Gnome2::GConf::Client::clear_cache", XS_Gnome2__GConf__Client_clear_cache);
        newXS_deffile("Gnome2::GConf::Client::preload", XS_Gnome2__GConf__Client_preload);
        newXS_deffile("Gnome2::GConf::Client::set", XS_Gnome2__GConf__Client_set);
        newXS_deffile("Gnome2::GConf::Client::get", XS_Gnome2__GConf__Client_get);
        newXS_deffile("Gnome2::GConf::Client::get_without_default", XS_Gnome2__GConf__Client_get_without_default);
        newXS_deffile("Gnome2::GConf::Client::get_entry", XS_Gnome2__GConf__Client_get_entry);
        newXS_deffile("Gnome2::GConf::Client::get_default_from_schema", XS_Gnome2__GConf__Client_get_default_from_schema);
        newXS_deffile("Gnome2::GConf::Client::unset", XS_Gnome2__GConf__Client_unset);
#if XSubPPtmpAAAA
        newXS_deffile("Gnome2::GConf::Client::recursive_unset", XS_Gnome2__GConf__Client_recursive_unset);
#endif
        newXS_deffile("Gnome2::GConf::Client::all_entries", XS_Gnome2__GConf__Client_all_entries);
        newXS_deffile("Gnome2::GConf::Client::all_dirs", XS_Gnome2__GConf__Client_all_dirs);
        newXS_deffile("Gnome2::GConf::Client::suggest_sync", XS_Gnome2__GConf__Client_suggest_sync);
        newXS_deffile("Gnome2::GConf::Client::dir_exists", XS_Gnome2__GConf__Client_dir_exists);
        newXS_deffile("Gnome2::GConf::Client::key_is_writable", XS_Gnome2__GConf__Client_key_is_writable);
        newXS_deffile("Gnome2::GConf::Client::get_float", XS_Gnome2__GConf__Client_get_float);
        newXS_deffile("Gnome2::GConf::Client::get_int", XS_Gnome2__GConf__Client_get_int);
        newXS_deffile("Gnome2::GConf::Client::get_string", XS_Gnome2__GConf__Client_get_string);
        newXS_deffile("Gnome2::GConf::Client::get_bool", XS_Gnome2__GConf__Client_get_bool);
        newXS_deffile("Gnome2::GConf::Client::get_schema", XS_Gnome2__GConf__Client_get_schema);
#if XSubPPtmpAAAB
        newXS_deffile("Gnome2::GConf::Client::get_list", XS_Gnome2__GConf__Client_get_list);
        newXS_deffile("Gnome2::GConf::Client::get_pair", XS_Gnome2__GConf__Client_get_pair);
#endif
        newXS_deffile("Gnome2::GConf::Client::set_float", XS_Gnome2__GConf__Client_set_float);
        newXS_deffile("Gnome2::GConf::Client::set_int", XS_Gnome2__GConf__Client_set_int);
        newXS_deffile("Gnome2::GConf::Client::set_string", XS_Gnome2__GConf__Client_set_string);
        newXS_deffile("Gnome2::GConf::Client::set_bool", XS_Gnome2__GConf__Client_set_bool);
        newXS_deffile("Gnome2::GConf::Client::set_schema", XS_Gnome2__GConf__Client_set_schema);
#if XSubPPtmpAAAC
        newXS_deffile("Gnome2::GConf::Client::set_list", XS_Gnome2__GConf__Client_set_list);
        newXS_deffile("Gnome2::GConf::Client::set_pair", XS_Gnome2__GConf__Client_set_pair);
#endif
        newXS_deffile("Gnome2::GConf::Client::error", XS_Gnome2__GConf__Client_error);
        newXS_deffile("Gnome2::GConf::Client::unreturned_error", XS_Gnome2__GConf__Client_unreturned_error);
        newXS_deffile("Gnome2::GConf::Client::value_changed", XS_Gnome2__GConf__Client_value_changed);
        newXS_deffile("Gnome2::GConf::Client::commit_change_set", XS_Gnome2__GConf__Client_commit_change_set);
        newXS_deffile("Gnome2::GConf::Client::reverse_change_set", XS_Gnome2__GConf__Client_reverse_change_set);
        newXS_deffile("Gnome2::GConf::Client::change_set_from_current", XS_Gnome2__GConf__Client_change_set_from_current);

    /* Initialisation Section */

#line 103 "xs/GConfClient.xs"
	gperl_signal_set_marshaller_for (GCONF_TYPE_CLIENT, "unreturned_error",
	                                 gconfperl_client_error_marshal);
	gperl_signal_set_marshaller_for (GCONF_TYPE_CLIENT, "error",
					 gconfperl_client_error_marshal);

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#line 2025 "xs/GConfClient.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

