/* This file is part of GQ
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2006  Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GQ_ADJUSTMENT_H
#define GQ_ADJUSTMENT_H

#include <gtk/gtkscrollbar.h>

G_BEGIN_DECLS

typedef GObject      GqAdjustment;
typedef GObjectClass GqAdjustmentClass;

#define GQ_TYPE_ADJUSTMENT         (gq_adjustment_get_type())
#define GQ_ADJUSTMENT(i)           (G_TYPE_CHECK_INSTANCE_CAST((i), GQ_TYPE_ADJUSTMENT, GqAdjustment))
#define GQ_ADJUSTMENT_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST((c), GQ_TYPE_ADJUSTMENT, GqAdjustmentClass))
#define GQ_IS_ADJUSTMENT(i)        (G_TYPE_CHECK_INSTANCE_TYPE((i), GQ_TYPE_ADJUSTMENT))
#define GQ_IS_ADJUSTMENT_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE((c), GQ_TYPE_ADJUSTMENT))
#define GQ_ADJUSTMENT_GET_CLASS(i) (G_TYPE_INSTANCE_GET_CLASS((i), GQ_TYPE_ADJUSTMENT, GqAdjustmentClass))

GType         gq_adjustment_get_type(void);
GqAdjustment* gq_adjustment_new     (GtkScrollbar* scrollbar1,
				     GtkScrollbar* scrollbar2);

G_END_DECLS

#endif /* !GQ_ADJUSTMENT_H */
